/**********************************************************************

  size.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:48 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "size.h"

VALUE
WxSize::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxSize::init(VALUE self,VALUE vwidth,VALUE vheight)
{
    int width = NUM2INT(vwidth);
    int height = NUM2INT(vheight);
    wxSize *ptr;
    Data_Get_Struct(self, wxSize, ptr);
    ptr = new wxSize(width,height);
    DATA_PTR(self) = ptr;

    return self;
}

void
WxSize::Set(VALUE self,VALUE vwidth,VALUE vheight)
{
    int width = NUM2INT(vwidth);
    int height = NUM2INT(vheight);
    wxSize *ptr;
    Data_Get_Struct(self, wxSize, ptr);
    ptr->Set(width,height);
}

void
WxSize::SetHeight(VALUE self,VALUE vheight)
{
    int height = NUM2INT(vheight);
    wxSize *ptr;
    Data_Get_Struct(self, wxSize, ptr);
    ptr->SetHeight(height);
}

void
WxSize::SetWidth(VALUE self,VALUE vwidth)
{
    int width = NUM2INT(vwidth);
    wxSize *ptr;
    Data_Get_Struct(self, wxSize, ptr);
    ptr->SetWidth(width);
}

VALUE
WxSize::GetWidth(VALUE self)
{
    wxSize *ptr;
    Data_Get_Struct(self, wxSize, ptr);
    return INT2NUM(ptr->GetWidth());
}

VALUE
WxSize::GetHeight(VALUE self)
{
    wxSize *ptr;
    Data_Get_Struct(self, wxSize, ptr);
    return INT2NUM(ptr->GetHeight());
}

VALUE
WxSize::init0(const wxSize &size)
{
    extern VALUE rb_cWxSize;
    static VALUE self = Data_Wrap_Struct(rb_cWxSize, 0, 0, 0);
    DATA_PTR(self) = new wxSize(size);
    return self;
}

VALUE
WxSize::x(VALUE self)
{
    wxSize *ptr;
    Data_Get_Struct(self, wxSize, ptr);
    return INT2NUM(ptr->x);
}

VALUE
WxSize::y(VALUE self)
{
    wxSize *ptr;
    Data_Get_Struct(self, wxSize, ptr);
    return INT2NUM(ptr->y);
}
