
require 'wx'
include Wx

LAYOUT_QUIT       = 100
LAYOUT_TEST       = 101
LAYOUT_ABOUT      = 102
LAYOUT_TEST_SIZER = 104
LAYOUT_TEST_NB    = 105


#-----------------------------------------------------------------
#  MySizerFrame
#-----------------------------------------------------------------
class MySizerFrame < WxFrame
    def initialize(frame,title,x,y)
        super(frame, -1, title, WxPoint.new(x, y) )

        # we want to get a dialog that is stretchable because it
        # has a text ctrl in the middle. at the bottom, we have
        # two buttons which.
        topsizer = WxBoxSizer.new( WxVERTICAL )

        # 1) top: create WxStaticText with minimum size equal to its default size
        topsizer.Add(
            WxStaticText.new( self, -1, "An explanation (WxALIGN_RIGHT)." ),
            0,                         # make vertically unstretchable
            WxALIGN_RIGHT |            # right align text
            WxTOP | WxLEFT | WxRIGHT,  # make border all around except WxBOTTOM
            5 )                      # set border width to 5

        # 2) top: create WxTextCtrl with minimum size (100x60)
        topsizer.Add(
            WxTextCtrl.new( self, -1, "My text (WxEXPAND).", WxDefaultPosition, WxSize.new(100,60), WxTE_MULTILINE),
            1,            # make vertically stretchable
            WxEXPAND |    # make horizontally stretchable
            WxALL,        #   and make border all around
            5 )         # set border width to 5

        # 2.5) Gratuitous test of WxStaticBoxSizers
        statsizer = WxStaticBoxSizer.new(
            WxStaticBox.new(self, -1, "A WxStaticBoxSizer"),
            WxVERTICAL )
        statsizer.Add(
            WxStaticText.new(self, -1, "And some TEXT inside it"),
            0,
            WxCENTER |
            WxALL,
            30)
        topsizer.Add(statsizer, 1, WxEXPAND | WxALL, 10)

        # 2.7) And a test of WxGridSizer
        gridsizer = WxGridSizer.new(2, 5, 5)
        gridsizer.Add(WxStaticText.new(self, -1, "Label"), 0,
                  WxALIGN_RIGHT | WxALIGN_CENTER_VERTICAL)
        gridsizer.Add(WxTextCtrl.new(self, -1, "Grid sizer demo"), 1,
                   WxGROW | WxALIGN_CENTER_VERTICAL)
        gridsizer.Add(WxStaticText.new(self, -1, "Another label"), 0,
                   WxALIGN_RIGHT | WxALIGN_CENTER_VERTICAL)
        gridsizer.Add(WxTextCtrl.new(self, -1, "More text"), 1,
                   WxGROW | WxALIGN_CENTER_VERTICAL)
        gridsizer.Add(WxStaticText.new(self, -1, "Final label"), 0,
                   WxALIGN_RIGHT | WxALIGN_CENTER_VERTICAL)
        gridsizer.Add(WxTextCtrl.new(self, -1, "And yet more text"), 1,
                   WxGROW | WxALIGN_CENTER_VERTICAL)
        topsizer.Add(gridsizer, 1, WxGROW | WxALL, 10)


        # 3) middle: create WxStaticLine with minimum size (3x3)
        topsizer.Add(
            WxStaticLine.new( self, -1, WxDefaultPosition, WxSize.new(3,3), WxHORIZONTAL),
            0,           # make vertically unstretchable
            WxEXPAND |   # make horizontally stretchable
            WxALL,       #   and make border all around
            5 )         # set border width to 5


        # 4) bottom: create two centred WxButtons
        button_box = WxBoxSizer.new( WxHORIZONTAL )
        button_box.Add(
            WxButton.new( self, -1, "Two buttons in a box" ),
            0,           # make horizontally unstretchable
            WxALL,       # make border all around
            7 )         # set border width to 7
        button_box.Add(
            WxButton.new( self, -1, "(WxCENTER)" ),
            0,           # make horizontally unstretchable
            WxALL,       # make border all around
            7 )         # set border width to 7

        topsizer.Add(
            button_box,
            0,          # make vertically unstretchable
            WxCENTER ) # no border and centre horizontally

        # don't allow frame to get smaller than what the sizers tell it and also set
        # the initial size as calculated by the sizers
        topsizer.SetSizeHints( self )

        SetSizer( topsizer )
    end

end

# Define a new text subwindow that can respond to drag-and-drop
class MyTextWindow < WxTextCtrl
    def initialize(frame, x=-1, y=-1, width=-1, height=-1, style=WxTE_MULTILINE)
        super(frame, -1, "", WxPoint.new(x, y), WxSize.new(width, height), style)

    end

end


# Define a new canvas which can receive some events
class MyWindow < WxWindow
    def initialize(frame, x, y, w, h, style)
        super(frame, -1, WxPoint.new(x, y), WxSize.new(w, h), style)

        EVT_PAINT(self,"OnPaint")
    end

    # Define the repainting behaviour
    def OnPaint(event)
        dc = WxPaintDC.new(self)
        dc.SetPen(WxGREEN_PEN)
        dc.DrawLine(0, 0, 200, 200)
        dc.DrawLine(200, 0, 0, 200)

        dc.SetBrush(WxCYAN_BRUSH)
        dc.SetPen(WxRED_PEN)

        dc.DrawRectangle(100, 100, 100, 50)
        dc.DrawRoundedRectangle(150, 150, 100, 50, 20)

        dc.DrawEllipse(250, 250, 100, 50)
        dc.DrawSpline([WxPoint.new(50, 200),WxPoint.new(50, 100),WxPoint.new(200, 10)])
        dc.DrawLine(50, 230, 200, 230)

        dc.SetPen(WxBLACK_PEN)
        dc.DrawArc(50, 300, 100, 250, 100, 300 )
        dc.free
    end

end

# Define a new frame
class MyFrame < WxFrame
    def initialize(frame,title,x,y,w,h)
        super(frame, -1, title, WxPoint.new(x, y), WxSize.new(w, h))

        EVT_MENU(self,LAYOUT_QUIT, "OnQuit")
        EVT_MENU(self,LAYOUT_TEST_SIZER, "TestSizers")
        EVT_MENU(self,LAYOUT_TEST_NB, "TestNotebookSizers")
        EVT_MENU(self,LAYOUT_ABOUT, "About")
    end

    def OnQuit(event)
        Close(TRUE)
    end

    def TestSizers(event)
        newFrame = MySizerFrame.new(nil, "Sizer Test Frame", 50, 50)
        newFrame.Show(TRUE)
    end

    def TestNotebookSizers(event)

        dialog = WxDialog.new( self, -1, "Notebook Sizer Test Dialog")

        # Begin with first hierarchy: a notebook at the top and
        # and OK button at the bottom.

        topsizer = WxBoxSizer.new( WxVERTICAL )

        notebook = WxNotebook.new( dialog, -1 )
        nbs = WxNotebookSizer.new( notebook )
        topsizer.Add( nbs, 1, WxGROW )

        button = WxButton.new( dialog, WxID_OK, "OK" )
        topsizer.Add( button, 0, WxALIGN_RIGHT | WxALL, 10 )

        # First page: one big text ctrl
        multi = WxTextCtrl.new( notebook, -1, "TextCtrl.", WxDefaultPosition, WxDefaultSize, WxTE_MULTILINE )
        notebook.AddPage( multi, "Page One" )

        # Second page: a text ctrl and a button
        panel = WxPanel.new( notebook, -1 )
        notebook.AddPage( panel, "Page Two" )

        panelsizer = WxBoxSizer.new( WxVERTICAL )

        text = WxTextCtrl.new( panel, -1, "TextLine 1.", WxDefaultPosition, WxSize.new(250,-1) )
        panelsizer.Add( text, 0, WxGROW|WxALL, 30 )
        text = WxTextCtrl.new( panel, -1, "TextLine 2.", WxDefaultPosition, WxSize.new(250,-1) )
        panelsizer.Add( text, 0, WxGROW|WxALL, 30 )
        button2 = WxButton.new( panel, -1, "Hallo" )
        panelsizer.Add( button2, 0, WxALIGN_RIGHT | WxLEFT|WxRIGHT|WxBOTTOM, 30 )

        panel.SetAutoLayout( TRUE )
        panel.SetSizer( panelsizer )

        # Tell dialog to use sizer

        dialog.SetAutoLayout( TRUE )
        dialog.SetSizer( topsizer )
        topsizer.Fit( dialog )
        topsizer.SetSizeHints( dialog )

        dialog.ShowModal()
    end

    def About(event)
        WxMessageBox("WxWindows GUI library layout demo\n",
                "About Layout Demo", WxOK|WxCENTRE)
    end

end

class MyApp < WxApp
    
    def OnInit()

        # Create the main frame window
        frame = MyFrame.new(nil, "WxWindows Layout Demo", -1, -1, 400, 300)

        frame.SetAutoLayout(TRUE)

        # Give it a status line
        frame.CreateStatusBar(2)

        # Make a menubar
        file_menu = WxMenu.new

        file_menu.Append(LAYOUT_TEST_SIZER, "&Test sizers",      "Test sizer")
        file_menu.Append(LAYOUT_TEST_NB, "&Test notebook sizers",      "Test notebook sizer")

        file_menu.AppendSeparator()
        file_menu.Append(LAYOUT_QUIT, "E&xit",                "Quit program")

        help_menu = WxMenu.new
        help_menu.Append(LAYOUT_ABOUT, "&About",              "About layout demo")

        menu_bar = WxMenuBar.new

        menu_bar.Append(file_menu, "&File")
        menu_bar.Append(help_menu, "&Help")

        # Associate the menu bar with the frame
        frame.SetMenuBar(menu_bar)

        # Make a panel
        panel = WxPanel.new(frame)

        # Create some panel items
        btn1 = WxButton.new(panel, -1, "A button (1)")

        b1 = WxLayoutConstraints.new
        b1.centreX.SameAs(panel, WxCentreX)
        b1.top.SameAs(panel, WxTop, 5)
        b1.width.PercentOf(panel, WxWidth, 80)
        b1.height.AsIs()
        btn1.SetConstraints(b1)

        list = WxListBox.new(panel, -1,
            WxPoint.new(-1, -1), WxSize.new(200, 100))
        list.Append("Apple")
        list.Append("Pear")
        list.Append("Orange")
        list.Append("Banana")
        list.Append("Fruit")

        b2 = WxLayoutConstraints.new
        b2.top.Below(btn1, 5)
        b2.left.SameAs(panel, WxLeft, 5)
        b2.width.PercentOf(panel, WxWidth, 40)
        b2.bottom.SameAs(panel, WxBottom, 5)
        list.SetConstraints(b2)

        mtext = WxTextCtrl.new(panel, -1, "Some text")

        b3 = WxLayoutConstraints.new
        b3.top.Below(btn1, 5)
        b3.left.RightOf(list, 5)
        b3.right.SameAs(panel, WxRight, 5)
        b3.bottom.SameAs(panel, WxBottom, 5)
        mtext.SetConstraints(b3)

        @canvas = MyWindow.new(frame, 0, 0, 400, 400, WxRETAINED)

        # Make a text window
        text_window = MyTextWindow.new(frame, 0, 250, 400, 150)

        # Set constraints for panel subwindow
        c1 = WxLayoutConstraints.new

        c1.left.SameAs(frame, WxLeft)
        c1.top.SameAs(frame, WxTop)
        c1.right.PercentOf(frame, WxWidth, 50)
        c1.height.PercentOf(frame, WxHeight, 50)

        panel.SetConstraints(c1)

        # Set constraints for canvas subwindow
        c2 = WxLayoutConstraints.new

        c2.left.SameAs(panel, WxRight)
        c2.top.SameAs(frame, WxTop)
        c2.right.SameAs(frame, WxRight)
        c2.height.PercentOf(frame, WxHeight, 50)

        @canvas.SetConstraints(c2)

        # Set constraints for text subwindow
        c3 = WxLayoutConstraints.new
        c3.left.SameAs(frame, WxLeft)
        c3.top.Below(panel)
        c3.right.SameAs(frame, WxRight)
        c3.bottom.SameAs(frame, WxBottom)

        text_window.SetConstraints(c3)

        frame.Show(TRUE)

        frame.SetStatusText("WxWindows layout demo")

        SetTopWindow(frame)

    end
end

a = MyApp.new
a.MainLoop()

