
require 'wx'
include Wx

ID_CALENDAR = 1000

class CalendarDlg < WxDialog
  def initialize
    super(nil, -1, "CalendarDialog", WxDefaultPosition, WxSize.new(185, 185))
    @m_pCalendar = WxCalendarCtrl.new(self, ID_CALENDAR, WxDefaultDateTime,
                                     WxDefaultPosition, WxDefaultSize,
                                     WxCAL_MONDAY_FIRST |
                                     WxCAL_SHOW_HOLIDAYS |
                                     WxRAISED_BORDER)

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    calendarSizer = WxBoxSizer.new(WxVERTICAL)
    calendarSizer.Add(@m_pCalendar, 1, WxGROW)
    dlgSizer.Add(calendarSizer, 1, WxGROW)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_CALENDAR(self,ID_CALENDAR, "OnCalendar")
    EVT_CLOSE(self,"OnClose")
  end

  def OnCalendar(event)
    day = event.GetDate.GetDay
    on = false
    attr = @m_pCalendar.GetAttr(day)
    if attr != nil
      if attr.GetBackgroundColour == WxRED
         on = true
      end
    end
    newAttr = WxCalendarDateAttr.new(WxBLACK, on ? WxWHITE : WxRED)
    @m_pCalendar.SetAttr(day, newAttr)
  end

  def OnClose(event)
     Destroy()
  end
end

class WxRbApp < WxApp
  def OnInit
    dlg = CalendarDlg.new
    SetTopWindow(dlg)
    dlg.Show
  end

end

a = WxRbApp.new
a.MainLoop()

