
require 'wx'
include Wx

MENU_FILE_OPEN,MENU_FILE_SAVE,MENU_FILE_QUIT,MENU_INFO_ABOUT,MENU_OPTION_BACKGROUNDCOLOR,MENU_OPTION_FONT,MENU_OPTION_DIRECTORY = 1,2,3,4,5,6,7

class AboutDialog < WxDialog
  def initialize(parent)
    super(parent, -1, "About Simple Text Editor", WxDefaultPosition,
               WxSize.new(200, 200), WxDEFAULT_DIALOG_STYLE)
    SetAutoLayout(TRUE)

    layout = WxLayoutConstraints.new
    layout.top.SameAs(self, WxTop, 10)
    layout.centreX.SameAs(self, WxCentreX)
    layout.width.AsIs
    layout.height.AsIs
    @m_pInfoText = WxStaticText.new(self, -1, "", WxPoint.new(-1, -1),
                                   WxDefaultSize, WxALIGN_CENTER);
    @m_pInfoText.SetConstraints(layout)

    layout = WxLayoutConstraints.new
    layout.top.Below(@m_pInfoText, 10)
    layout.centreX.SameAs(self, WxCentreX)
    layout.width.PercentOf(self, WxWidth, 80)
    layout.height.AsIs

    @m_pOkButton = WxButton.new(self, WxID_OK, "Ok", WxPoint.new(-1, -1))
    @m_pOkButton.SetConstraints(layout)

    Layout()
  end

  def SetText(text)
    @m_pInfoText.SetLabel(text)
    Layout()
  end
end


class TextFrame < WxFrame
  def initialize(title,xpos,ypos,width,height)
	super(nil, -1, title, WxPoint.new(xpos, ypos), WxSize.new(width, height))
	@m_pTextCtrl = WxTextCtrl.new(self, -1, "Type some text...",WxDefaultPosition, WxDefaultSize, WxTE_MULTILINE)
#	@m_pTextCtrl = NumTextCtrl.new(self, -1, "Type some text...",WxDefaultPosition, WxDefaultSize, WxTE_MULTILINE)
	@m_pMenuBar = WxMenuBar.new
	@m_pFileMenu = WxMenu.new
	@m_pFileMenu.Append(MENU_FILE_OPEN, "&Open", "Opens an existing file")
	@m_pFileMenu.Append(MENU_FILE_SAVE, "&Save", "Save the content")
	@m_pFileMenu.AppendSeparator()
	@m_pFileMenu.Append(MENU_FILE_QUIT, "&Quit", "Quit the application")
	@m_pMenuBar.Append(@m_pFileMenu, "&File")

	@m_pOptionMenu = WxMenu.new
	@m_pOptionMenu.Append(MENU_OPTION_BACKGROUNDCOLOR, "&Background Color")
	@m_pOptionMenu.Append(MENU_OPTION_FONT, "&Font")
	@m_pOptionMenu.Append(MENU_OPTION_DIRECTORY, "&Directory")
	@m_pMenuBar.Append(@m_pOptionMenu, "&Option")

	@m_pInfoMenu = WxMenu.new
	@m_pInfoMenu.Append(MENU_INFO_ABOUT, "&About", "Shows information about the application")
	@m_pMenuBar.Append(@m_pInfoMenu, "&Info")
	SetMenuBar(@m_pMenuBar)
	CreateStatusBar(3)
	SetStatusText("Ready", 0)
        EVT_CLOSE(self,"OnClose")
  end

  def OnMenuFileOpen(event)
	  dlg = WxFileDialog.new(self, "Open a text file",
	                                       "", "", "All files(*.*)|*.*|Text Files(*.txt)|*.txt",
	                                       WxOPEN, WxDefaultPosition)
	  if dlg.ShowModal() == WxID_OK
	    @m_pTextCtrl.LoadFile(dlg.GetFilename())
	    SetStatusText(dlg.GetFilename(), 0)
	  end
	  dlg.Destroy()
  end

  def OnMenuFileSave(event)
	  dlg = WxFileDialog.new(self, "Save a text file",
	                                       "", "", "All files(*.*)|*.*|Text Files(*.txt)|*.txt",
	                                       WxSAVE, WxDefaultPosition)
	  if dlg.ShowModal == WxID_OK
	    @m_pTextCtrl.SaveFile(dlg.GetPath)
	    SetStatusText(dlg.GetFilename, 0)
	  end
	  dlg.Destroy
  end

  def OnMenuFileQuit(event)
    Close(FALSE)
  end

  def OnMenuOptionBackgroundColor(event)
	  colour = @m_pTextCtrl.GetBackgroundColour
	  colourData = WxColourData.new
	  colourData.SetColour(colour)
	  colourData.SetChooseFull(TRUE)
	  c = colourData.GetColour
	  dlg = WxColourDialog.new(self, colourData)
	  if dlg.ShowModal == WxID_OK
	    colourData = dlg.GetColourData
	    @m_pTextCtrl.SetBackgroundColour(colourData.GetColour)
	    @m_pTextCtrl.Refresh
	  end
	  dlg.Destroy
  end

  def OnMenuOptionFont(event)
	  font = @m_pTextCtrl.GetFont
	  fontData = WxFontData.new
	  fontData.SetInitialFont(font)
	  colour = @m_pTextCtrl.GetForegroundColour
	  fontData.SetColour(colour)
	  fontData.SetShowHelp(TRUE)

	  dlg = WxFontDialog.new(self, fontData)
	  if dlg.ShowModal == WxID_OK
	    fontData = dlg.GetFontData
	    font = fontData.GetChosenFont
	    @m_pTextCtrl.SetFont(font)
	    @m_pTextCtrl.SetForegroundColour(fontData.GetColour)
	    @m_pTextCtrl.Refresh
	  end
	  dlg.Destroy
  end

  def OnMenuOptionDirectory(event)
	  dlg = WxDirDialog.new(self, "Select a new working directory", WxGetCwd())
	  if dlg.ShowModal == WxID_OK
	    WxSetWorkingDirectory(dlg.GetPath)
	  end
	  dlg.Destroy
  end

  def OnMenuInfoAbout(event)
      dlg = AboutDialog.new(self)
      dlg.SetText("(c) 2001 S.A.W. Franky Braem\nSimple Text Editor\n")
      dlg.ShowModal
  end

  def OnClose(event)
     destroy = true
     if event.CanVeto
       if @m_pTextCtrl.IsModified
          dlg =
               WxMessageDialog.new(self, "Text is changed!\nAre you sure you want to exit?",
                                   "Text changed!!!", WxYES_NO | WxNO_DEFAULT)
          result = dlg.ShowModal
          if result == WxID_NO
            event.Veto
            destroy = false
          end
      end
    end
    Destroy() if destroy
  end

end

class WxRbApp < WxApp
  def OnInit()
  	frame = TextFrame.new("Simple Text Editor", 100, 100, 400, 300)
	EVT_MENU(frame, MENU_FILE_OPEN,  "OnMenuFileOpen")
	EVT_MENU(frame, MENU_FILE_SAVE,  "OnMenuFileSave")
	EVT_MENU(frame, MENU_FILE_QUIT,  "OnMenuFileQuit")
	EVT_MENU(frame, MENU_INFO_ABOUT, "OnMenuInfoAbout")
	EVT_MENU(frame, MENU_OPTION_BACKGROUNDCOLOR, "OnMenuOptionBackgroundColor")
	EVT_MENU(frame, MENU_OPTION_FONT, "OnMenuOptionFont")
	EVT_MENU(frame, MENU_OPTION_DIRECTORY, "OnMenuOptionDirectory")
	frame.Show(TRUE)
  end

end


a = WxRbApp.new
a.MainLoop()

