
require 'wx'
include Wx

ID_TIMER = 1000

class GaugeDlg < WxDialog
  def initialize
    super(nil, -1, "GaugeDialog", WxDefaultPosition, WxSize.new(185, 185))

    @m_pGauge = WxGauge.new(self, -1, 100, WxDefaultPosition, WxSize.new(150, 20), WxGA_SMOOTH)

    @m_pTimer = WxTimer.new(self, ID_TIMER)
    @m_pTimer.Start(100)

    dlgSizer = WxBoxSizer.new(WxHORIZONTAL)
    gaugeSizer = WxBoxSizer.new(WxVERTICAL)
    gaugeSizer.Add(@m_pGauge, 1, WxALIGN_CENTER)
    dlgSizer.Add(gaugeSizer, 1, WxALIGN_CENTER)
    SetSizer(dlgSizer)
    SetAutoLayout(TRUE)
    Layout()

    EVT_TIMER(self,ID_TIMER, "OnTimer")
    EVT_CLOSE(self,"OnClose")
  end

  def OnTimer(event)
    value = @m_pGauge.GetValue
    if value == @m_pGauge.GetRange
      @m_pTimer.Stop()
    else
      @m_pGauge.SetValue(value + 1)
    end
  end

  def OnClose(event)
     Destroy()
  end
end

class WxRbApp < WxApp
  def OnInit
    dlg = GaugeDlg.new
    SetTopWindow(dlg)
    dlg.Show(TRUE)
  end

end

a = WxRbApp.new
a.MainLoop()

