require 'wx'
include Wx


Minimal_Quit = 1
Minimal_About = WxID_ABOUT

class WxRbApp < WxApp
  def OnInit
    frame = MyFrame.new("Hello wxRuby")
    EVT_MENU(frame, Minimal_Quit,  "OnQuit")
    EVT_MENU(frame, Minimal_About,  "OnAbout")
    frame.Show(TRUE)
  end
end

def labeledEntry(parent,sizer,label,default)
  sizer.Add(WxStaticText.new(parent,-1,label.to_s, WxDefaultPosition,WxDefaultSize,WxALIGN_RIGHT),1,WxALIGN_CENTER_VERTICAL)
  sizer.Add(r=WxTextCtrl.new(parent,-1,default.to_s, WxDefaultPosition,WxDefaultSize,WxALIGN_LEFT),1,WxALIGN_CENTER_VERTICAL)
  return r
end
class MyFrame < WxFrame
  def initialize(title)
    super(nil,-1,title)

    if WxRUBY_PLATFORM == "WXMSW"
      SetIcon(WxIcon.new("mondrian.ico",WxBITMAP_TYPE_ICO))
    else
      SetIcon(WxIcon.new("mondrian.xpm",WxBITMAP_TYPE_XPM))
    end

    menuFile = WxMenu.new
    helpMenu = WxMenu.new
    helpMenu.Append(Minimal_About, "&About...\tF1", "Show about dialog")
    menuFile.Append(Minimal_Quit, "E&xit\tAlt-X", "Quit this program")
    menuBar = WxMenuBar.new
    menuBar.Append(menuFile, "&File")
    menuBar.Append(helpMenu, "&Help")
    SetMenuBar(menuBar)

    CreateStatusBar(2)
    SetStatusText("Welcome to wxWindows!")

    topSizer = WxBoxSizer.new(WxHORIZONTAL)

    simulBox = WxStaticBox.new(self,-1,"Simulation area")
    sizer1 = WxStaticBoxSizer.new(simulBox,WxVERTICAL)

    sizer11 = WxFlexGridSizer.new(2,10,10)
    xsize=labeledEntry(self,sizer11,'X',1000)
    ysize=labeledEntry(self,sizer11,'Y',1000)
    sizer1.Add(sizer11)
    topSizer.Add(sizer1)
    WxMessageBox("X is: #{xsize.GetValue}","ho",WxOK, self)

    agentBox = WxStaticBox.new(self,-1,"Agent properties")
    sizer2 = WxStaticBoxSizer.new(agentBox,WxVERTICAL)

    sizer21 = WxFlexGridSizer.new(2,10,10)
    labeledEntry(self,sizer21,'Time to stay',10)

    sizer2.Add(sizer21)
    topSizer.Add(sizer2)


    SetSizerAndFit(topSizer)
  end

  def OnQuit(event)
    puts "OnQuit"
    Close(TRUE)
  end

  def OnAbout(event)
    puts "OnAbout"
    msg =  sprintf("This is the About dialog of the minimal sample.\n" \
    		   "Welcome to %s", WxVERSION_STRING)

    WxMessageBox(msg, "About Minimal", WxOK | WxICON_INFORMATION, self)

  end
end

a = WxRbApp.new
a.MainLoop()
