
require 'wx'
include Wx

DIALOGS_CHOOSE_COLOUR = 1
DIALOGS_CHOOSE_COLOUR_GENERIC = 2
DIALOGS_CHOOSE_FONT = 3
DIALOGS_CHOOSE_FONT_GENERIC = 4
DIALOGS_MESSAGE_BOX = 5
DIALOGS_SINGLE_CHOICE = 6
DIALOGS_MULTI_CHOICE = 7
DIALOGS_TEXT_ENTRY = 8
DIALOGS_PASSWORD_ENTRY = 9
DIALOGS_FILE_OPEN = 10
DIALOGS_FILE_OPEN2 = 11
DIALOGS_FILES_OPEN = 12
DIALOGS_FILE_SAVE = 13
DIALOGS_DIR_CHOOSE = 14
DIALOGS_GENERIC_DIR_CHOOSE = 15
DIALOGS_TIP = 16
DIALOGS_NUM_ENTRY = 17
DIALOGS_LOG_DIALOG = 18
DIALOGS_MODAL = 19
DIALOGS_MODELESS = 20
DIALOGS_MODELESS_BTN = 21
DIALOGS_PROGRESS = 22
DIALOGS_BUSYINFO = 23
DIALOGS_FIND = 24
DIALOGS_REPLACE = 25

$myCanvas = nil

class MyModalDialog < WxDialog
    def initialize(parent)
        super(parent, -1, "Modal dialog")

        sizerTop = WxBoxSizer.new(WxHORIZONTAL)

        @m_btnFocused = WxButton.new(self, -1, "Default button")
        @m_btnDelete = WxButton.new(self, -1, "&Delete button")
        btnOk = WxButton.new(self, WxID_CANCEL, "&Close")
        sizerTop.Add(@m_btnFocused, 0, WxALIGN_CENTER | WxALL, 5)
        sizerTop.Add(@m_btnDelete, 0, WxALIGN_CENTER | WxALL, 5)
        sizerTop.Add(btnOk, 0, WxALIGN_CENTER | WxALL, 5)

        SetAutoLayout(TRUE)
        SetSizer(sizerTop)

        sizerTop.SetSizeHints(self)
        sizerTop.Fit(self)

        @m_btnFocused.SetFocus()
        @m_btnFocused.SetDefault()

        EVT_BUTTON(self,-1, "OnButton")
    end

    def OnButton(event)

        if event.GetEventObject() == @m_btnDelete
            @m_btnFocused.free
            @m_btnFocused = nil

            @m_btnDelete.Disable()
        elsif event.GetEventObject() == @m_btnFocused
            WxGetTextFromUser("Dummy prompt",
                              "Modal dialog called from dialog",
                              "", self)
        else
            event.Skip()
        end
    end
end


class MyModelessDialog < WxDialog
    def initialize(parent)
        super(parent, -1, "Modeless dialog")

        sizerTop = WxBoxSizer.new(WxVERTICAL)

        btn = WxButton.new(self, DIALOGS_MODELESS_BTN, "Press me")
        check = WxCheckBox.new(self, -1, "Should be disabled")
        check.Disable()

        sizerTop.Add(btn, 1, WxEXPAND | WxALL, 5)
        sizerTop.Add(check, 1, WxEXPAND | WxALL, 5)

        SetAutoLayout(TRUE)
        SetSizer(sizerTop)

        sizerTop.SetSizeHints(self)
        sizerTop.Fit(self)

        EVT_BUTTON(self,DIALOGS_MODELESS_BTN, "OnButton")

        EVT_CLOSE(self,"OnClose")

    end

    def OnButton(event)
        WxMessageBox("Button pressed in modeless dialog", "Info",
                     WxOK | WxICON_INFORMATION, self)
    end

    def OnClose(event)
        if event.CanVeto()
            WxMessageBox("Use the menu item to close self dialog",
                         "Modeless dialog",
                         WxOK | WxICON_INFORMATION, self)

            event.Veto()
        end
    end
end


class MyCanvas < WxScrolledWindow
    def initialize(parent)
        super(parent,-1,WxDefaultPosition,WxDefaultSize,WxNO_FULL_REPAINT_ON_RESIZE)

        EVT_PAINT(self,"OnPaint")
    end

    def OnPaint(event)
        dc = WxPaintDC.new(self)
        dc.SetFont(WxGetApp().m_canvasFont)
        dc.SetTextForeground(WxGetApp().m_canvasTextColour)
        dc.SetBackgroundMode(WxTRANSPARENT)
        dc.DrawText("WxWindows common dialogs test application", 10, 10)
        dc.free
    end
end


class MyFrame < WxFrame
    def initialize(parent,
                 title,
                 pos,
                 size)
        super(parent, -1, title, pos, size)

        @m_dialog = nil

        @m_dlgFind = nil
        @m_dlgReplace = nil

        @m_findData = WxFindReplaceData.new

        @s_extDef = ""
        @s_index = -1

        @max = 10

        CreateStatusBar()

        EVT_MENU(self,DIALOGS_CHOOSE_COLOUR,                 "ChooseColour")
        EVT_MENU(self,DIALOGS_CHOOSE_FONT,                   "ChooseFont")
        EVT_MENU(self,DIALOGS_LOG_DIALOG,                    "LogDialog")
        EVT_MENU(self,DIALOGS_MESSAGE_BOX,                   "MessageBox")
        EVT_MENU(self,DIALOGS_TEXT_ENTRY,                    "TextEntry")
        EVT_MENU(self,DIALOGS_PASSWORD_ENTRY,                "PasswordEntry")
        EVT_MENU(self,DIALOGS_NUM_ENTRY,                     "NumericEntry")
        EVT_MENU(self,DIALOGS_SINGLE_CHOICE,                 "SingleChoice")
        EVT_MENU(self,DIALOGS_MULTI_CHOICE,                  "MultiChoice")
        EVT_MENU(self,DIALOGS_FILE_OPEN,                     "FileOpen")
        EVT_MENU(self,DIALOGS_FILE_OPEN2,                    "FileOpen2")
        EVT_MENU(self,DIALOGS_FILES_OPEN,                    "FilesOpen")
        EVT_MENU(self,DIALOGS_FILE_SAVE,                     "FileSave")
        EVT_MENU(self,DIALOGS_DIR_CHOOSE,                    "DirChoose")
        EVT_MENU(self,DIALOGS_MODAL,                         "ModalDlg")
        EVT_MENU(self,DIALOGS_MODELESS,                      "ModelessDlg")
        EVT_MENU(self,DIALOGS_TIP,                           "ShowTip")
        EVT_MENU(self,DIALOGS_PROGRESS,                      "ShowProgress")
        EVT_MENU(self,DIALOGS_BUSYINFO,                      "ShowBusyInfo")
        EVT_MENU(self,DIALOGS_FIND,                          "ShowFindDialog")
        EVT_MENU(self,DIALOGS_REPLACE,                       "ShowReplaceDialog")
        EVT_FIND(self,-1, "OnFindDialog")
        EVT_FIND_NEXT(self,-1, "OnFindDialog")
        EVT_FIND_REPLACE(self,-1, "OnFindDialog")
        EVT_FIND_REPLACE_ALL(self,-1, "OnFindDialog")
        EVT_FIND_CLOSE(self,-1, "OnFindDialog")
        EVT_MENU(self,WxID_EXIT,                             "OnExit")

    end

    def ChooseColour(event)

        col = $myCanvas.GetBackgroundColour()

        data = WxColourData.new
        data.SetColour(col)
        data.SetChooseFull(TRUE)
        for i in 0 ... 16
            colour = WxColour.new(i*16, i*16, i*16)
            data.SetCustomColour(i, colour)
        end

        dialog = WxColourDialog.new(self, data)
        dialog.SetTitle("Choose the background colour")
        if dialog.ShowModal() == WxID_OK
            retData = dialog.GetColourData()
            col = retData.GetColour()
            $myCanvas.SetBackgroundColour(col)
            $myCanvas.Clear()
            $myCanvas.Refresh()
        end
    end


    def ChooseFont(event)
        data = WxFontData.new
        data.SetInitialFont(WxGetApp().m_canvasFont)
        data.SetColour(WxGetApp().m_canvasTextColour)

        dialog = WxFontDialog.new(self, data)

        if dialog.ShowModal() == WxID_OK
            retData = dialog.GetFontData()
            WxGetApp().m_canvasFont = retData.GetChosenFont()
            WxGetApp().m_canvasTextColour = retData.GetColour()
            $myCanvas.Refresh()
        end
        #else: cancelled by the user, don't change the font
    end


    def LogDialog(event)

        # calling WxYield() (as ~WxBusyCursor does) shouldn't result in messages
        # being flushed -- test it

        bc = WxBusyCursor.new
        WxLogMessage("This is some message - everything is ok so far.")
        WxLogMessage("Another message...\n... self one is on multiple lines")
        WxLogWarning("And then something went wrong!")

        # and if ~WxBusyCursor doesn't do it, then call it manually
        WxYield()

        WxLogError("Intermediary error handler decided to abort.")
        WxLogError("The top level caller detected an unrecoverable error.")

        WxLog::FlushActive()

        WxLogMessage("And this is the same dialog but with only one message.")
        bc.free
    end

    def MessageBox(event)

      dialog = WxMessageDialog.new(nil, "This is a message box\nA long, long string to test out the message box properly",
          "Message box text", WxNO_DEFAULT|WxYES_NO|WxCANCEL|WxICON_INFORMATION)

      case dialog.ShowModal()
          when WxID_YES
              WxLogStatus("You pressed \"Yes\"")
          when WxID_NO
              WxLogStatus("You pressed \"No\"")
          when WxID_CANCEL
              WxLogStatus("You pressed \"Cancel\"")
          else
              WxLogError("Unexpected WxMessageDialog return code!")
      end
    end


    def NumericEntry(event)

        res = WxGetNumberFromUser( "This is some text, actually a lot of text.\n" +
                                        "Even two rows of text.",
                                        "Enter a number:", "Numeric input test",
                                         50, 0, 100, self )

        if res == -1
            msg = "Invalid number entered or dialog cancelled."
            icon = WxICON_HAND
        else
            msg = sprintf("You've entered %d", res )
            icon = WxICON_INFORMATION
        end

        WxMessageBox(msg, "Numeric test result", WxOK | icon, self)
    end

    def PasswordEntry(event)

        pwd = WxGetPasswordFromUser("Enter password:",
                                             "Password entry dialog",
                                             "",
                                             self)
        if !!pwd
            WxMessageBox(sprintf("Your password is '%s'", pwd),
                         "Got password", WxOK | WxICON_INFORMATION, self)
        end
    end


    def TextEntry(event)

        dialog = WxTextEntryDialog.new(self,
                               "This is a small sample\n" +
                               "A long, long string to test out the text entrybox",
                               "Please enter a string",
                               "Default value",
                               WxOK | WxCANCEL)

        if dialog.ShowModal() == WxID_OK
            dialog2 = WxMessageDialog.new(self, dialog.GetValue(), "Got string")
            dialog2.ShowModal()
        end
    end

    def SingleChoice(event)

        choices = ["One", "Two", "Three", "Four", "Five"]

        dialog = WxSingleChoiceDialog.new(self,
                                    "This is a small sample\n" +
                                    "A single-choice convenience dialog",
                                    "Please select a value",
                                    choices)

        dialog.SetSelection(2)

        if dialog.ShowModal() == WxID_OK
            dialog2 = WxMessageDialog.new(self, dialog.GetStringSelection(), "Got string")
            dialog2.ShowModal()
        end
    end


    def MultiChoice(event)

        choices = [
            "One", "Two", "Three", "Four", "Five",
            "Six", "Seven", "Eight", "Nine", "Ten",
            "Eleven", "Twelve", "Seventeen"]

        selections = WxGetMultipleChoices("This is a small sample\n" +
                                            "A multi-choice convenience dialog",
                                            "Please select a value",
                                            choices,
                                            self)
        if selections
            msg = sprintf("You selected %d items:\n", selections.length)
            for n in 0 ... selections.length
                msg += sprintf("\t%d: %d (%s)\n", n, selections[n],
                                        choices[selections[n]])
            end
            WxLogMessage(msg)
        end
        #else: cancelled or nothing selected
    end


    def FileOpen(event)

        dialog = WxFileDialog.new(
                        self,
                        "Testing open file dialog",
                        "",
                        "",
                        "C++ files (*.h;*.cpp)|*.h;*.cpp"
                     )

        dialog.SetDirectory(WxGetHomeDir())

        if dialog.ShowModal() == WxID_OK
            info = sprintf("Full file name: %s\n" +
                        "Path: %s\n" +
                        "Name: %s",
                        dialog.GetPath(),
                        dialog.GetDirectory(),
                        dialog.GetFilename())
            dialog2 = WxMessageDialog.new(self, info, "Selected file")
            dialog2.ShowModal()
        end
    end


    # this shows how to take advantage of specifying a default extension in the
    # call to WxFileSelector: it is remembered after each new call and the next
    # one will use it by default
    def FileOpen2(event)

        path = WxFileSelector(
                              "Select the file to load",
                              "", "",
                              @s_extDef,
                              "Waveform (*.wav)|*.wav|Plain text (*.txt)|*.txt|All files (*.*)|*.*",
                              WxCHANGE_DIR,
                              self
                              )

        if path == nil
            return nil
        end

        # it is just a sample, would use WxSplitPath in real program
        @s_extDef = path[/[^\.]*$/]

        WxLogMessage("You selected the file '%s', remembered extension '%s'",
                     path, @s_extDef)
    end


    def FilesOpen(event)

        dialog = WxFileDialog.new(self, "Testing open multiple file dialog",
                            "", "", WxFileSelectorDefaultWildcardStr,
                            WxMULTIPLE)

        if dialog.ShowModal() == WxID_OK

            paths = dialog.GetPaths()
            filenames = dialog.GetFilenames()

            count = paths.length
            msg = ""
            for n in 0 ... count
                s = sprintf("File %d: %s (%s)\n",
                         n, paths[n], filenames[n])
                msg += s
            end

            dialog2 = WxMessageDialog.new(self, msg, "Selected files")
            dialog2.ShowModal()
        end
    end


    def FileSave(event)

        dialog = WxFileDialog.new(self,
                            "Testing save file dialog",
                            "",
                            "myletter.doc",
                            "Text files (*.txt)|*.txt|Document files (*.doc)|*.doc",
                            WxSAVE|WxOVERWRITE_PROMPT)

        dialog.SetFilterIndex(1)

        if dialog.ShowModal() == WxID_OK

            WxLogMessage("%s, filter %d",
                         dialog.GetPath(), dialog.GetFilterIndex())
        end
    end

    def DirChoose(event)

        # pass some initial dir to WxDirDialog
        dirHome = WxGetHomeDir()

        dialog = WxDirDialog.new(self, "Testing directory picker", dirHome)

        if dialog.ShowModal() == WxID_OK
            WxLogMessage("Selected path: %s", dialog.GetPath())
        end
    end


    def ModalDlg(event)
        dlg = MyModalDialog.new(self)
        dlg.ShowModal()
    end

    def ModelessDlg(event)
        show = GetMenuBar().IsChecked(event.GetId())
        if show
            if !@m_dialog
                @m_dialog = MyModelessDialog.new(self)
            end
            @m_dialog.Show(TRUE)
        else # hide
            @m_dialog.Hide()
        end
    end


    def ShowTip(event)

        if @s_index == -1
            @s_index = rand(5)
        end

        tipProvider = WxCreateFileTipProvider("tips.txt", @s_index)

        showAtStartup = WxShowTip(self, tipProvider)

        if showAtStartup
            WxMessageBox("Will show tips on startup", "Tips dialog",
                         WxOK | WxICON_INFORMATION, self)
        end

        @s_index = tipProvider.GetCurrentTip()

    end

    def OnExit(event)
        Close(TRUE)
    end


    def ShowProgress(event)

        dialog = WxProgressDialog.new("Progress dialog example",
                                "An informative message",
                                @max,    # range
                                self,   # parent
                                WxPD_CAN_ABORT |
                                WxPD_APP_MODAL |
                                WxPD_ELAPSED_TIME |
                                WxPD_ESTIMATED_TIME |
                                WxPD_REMAINING_TIME)

        cont = TRUE
        for i in 0 .. @max

            sleep(1)
            if i == @max
                cont = dialog.Update(i, "That's all, folks!")
            elsif i == @max / 2
                cont = dialog.Update(i, "Only a half left (very long message)!")
            else
                cont = dialog.Update(i)
            end

            if !cont
                if WxMessageBox("Do you really want to cancel?",
                                  "Progress dialog question",  # caption
                                  WxYES_NO | WxICON_QUESTION) == WxYES
                    break
                end
                dialog.Resume()
            end
        end


        if !cont
            WxLogStatus("Progress dialog aborted!")
        else
            WxLogStatus("Countdown from %d finished", @max)
        end
	dialog.free
    end

    def ShowBusyInfo(event)
        disableAll = WxWindowDisabler.new
        info = WxBusyInfo.new("Working, please wait...", self)

        for i in 0 ... 18
            WxGetApp().Yield()
        end
        sleep(2)
        info.free
        disableAll.free
    end

    def ShowReplaceDialog(event)

        if @m_dlgReplace
            @m_dlgReplace.free
            @m_dlgReplace = nil
        else
            @m_dlgReplace = WxFindReplaceDialog.new(
                                self,
                                @m_findData,
                                "Find and replace dialog",
                                WxFR_REPLACEDIALOG
                               )

            @m_dlgReplace.Show(TRUE)
        end
    end

    def ShowFindDialog(event)

        if @m_dlgFind
            @m_dlgFind.free
            @m_dlgFind = nil
        else
            @m_dlgFind = WxFindReplaceDialog.new(
                                self,
                                @m_findData,
                                "Find dialog",  # just for testing
                                WxFR_NOWHOLEWORD
                            )

            @m_dlgFind.Show(TRUE)
        end
    end

    def DecodeFindDialogEventFlags(flags)
        str = ""
        str << ((flags & WxFR_DOWN) != 0 ? "down" : "up") << ", "  \
            << ((flags & WxFR_WHOLEWORD) != 0 ? "whole words only, " : "") \
            << ((flags & WxFR_MATCHCASE) != 0 ? "" : "not ")   \
            << "case sensitive"

        return str
    end

    def OnFindDialog(event)

        type = event.GetEventType()

        if type == WxEVT_COMMAND_FIND || type == WxEVT_COMMAND_FIND_NEXT
            WxLogMessage("Find %s'%s' (flags: %s)",
                         type == WxEVT_COMMAND_FIND_NEXT ? "next " : "",
                         event.GetFindString(),
                         DecodeFindDialogEventFlags(event.GetFlags()))
        elsif type == WxEVT_COMMAND_FIND_REPLACE || type == WxEVT_COMMAND_FIND_REPLACE_ALL
            WxLogMessage("Replace %s'%s' with '%s' (flags: %s)",
                         type == WxEVT_COMMAND_FIND_REPLACE_ALL ? "all " : "",
                         event.GetFindString(),
                         event.GetReplaceString(),
                         DecodeFindDialogEventFlags(event.GetFlags()))
        elsif type == WxEVT_COMMAND_FIND_CLOSE
            dlg = event.GetDialog()
            if dlg == @m_dlgFind
                txt = "Find"
                idMenu = DIALOGS_FIND
                @m_dlgFind = nil
            elsif dlg == @m_dlgReplace
                txt = "Replace"
                idMenu = DIALOGS_REPLACE
                @m_dlgReplace = nil
            else
                txt = "Unknown"
                idMenu = -1
                WxLogError("unexpected event")
            end

            WxLogMessage("%s dialog is being closed.", txt)

            if idMenu != -1
                GetMenuBar().Check(idMenu, FALSE)
            end

            dlg.Destroy()
        else
            WxLogError("Unknown find dialog event!")
        end
    end

end


class MyApp < WxApp
    attr_accessor :m_canvasTextColour,:m_canvasFont
    
    def OnInit()

      @m_canvasTextColour = WxColour.new("BLACK")
      @m_canvasFont = WxNORMAL_FONT

      # Create the main frame window
      frame = MyFrame.new(nil, "WxWindows dialogs example", WxPoint.new(20, 20), WxSize.new(400, 300))

      # Make a menubar
      file_menu = WxMenu.new

      file_menu.Append(DIALOGS_CHOOSE_COLOUR, "&Choose colour")
      file_menu.AppendSeparator()
      file_menu.Append(DIALOGS_CHOOSE_FONT, "Choose &font")
      file_menu.AppendSeparator()
      file_menu.Append(DIALOGS_LOG_DIALOG, "&Log dialog\tCtrl-L")
      file_menu.Append(DIALOGS_MESSAGE_BOX, "&Message box\tCtrl-M")
      file_menu.Append(DIALOGS_TEXT_ENTRY,  "Text &entry\tCtrl-E")
      file_menu.Append(DIALOGS_PASSWORD_ENTRY,  "&Password entry\tCtrl-P")
      file_menu.Append(DIALOGS_NUM_ENTRY, "&Numeric entry\tCtrl-N")
      file_menu.Append(DIALOGS_SINGLE_CHOICE,  "&Single choice\tCtrl-C")
      file_menu.Append(DIALOGS_MULTI_CHOICE,  "M&ultiple choice\tCtrl-U")
      file_menu.AppendSeparator()
      file_menu.Append(DIALOGS_TIP,  "&Tip of the day\tCtrl-T")
      file_menu.AppendSeparator()
      file_menu.Append(DIALOGS_FILE_OPEN,  "&Open file\tCtrl-O")
      file_menu.Append(DIALOGS_FILE_OPEN2,  "&Second open file\tCtrl-2")
      file_menu.Append(DIALOGS_FILES_OPEN,  "Open &files\tCtrl-Q")
      file_menu.Append(DIALOGS_FILE_SAVE,  "Sa&ve file\tCtrl-S")
      file_menu.Append(DIALOGS_DIR_CHOOSE,  "&Choose a directory\tCtrl-D")
      file_menu.Append(DIALOGS_PROGRESS, "Pro&gress dialog\tCtrl-G")
      file_menu.Append(DIALOGS_BUSYINFO, "&Busy info dialog\tCtrl-B")
      file_menu.Append(DIALOGS_FIND, "&Find dialog\tCtrl-F", "", WxITEM_CHECK)
      file_menu.Append(DIALOGS_REPLACE, "Find and &replace dialog\tShift-Ctrl-F", "", WxITEM_CHECK)
      file_menu.AppendSeparator()
      file_menu.Append(DIALOGS_MODAL, "Mo&dal dialog\tCtrl-W")
      file_menu.Append(DIALOGS_MODELESS, "Modeless &dialog\tCtrl-Z", "", WxITEM_CHECK)
      file_menu.AppendSeparator()
      file_menu.Append(WxID_EXIT, "E&xit\tAlt-X")
      menu_bar = WxMenuBar.new
      menu_bar.Append(file_menu, "&File")
      frame.SetMenuBar(menu_bar)

      $myCanvas = MyCanvas.new(frame)
      $myCanvas.SetBackgroundColour(WxWHITE)

      frame.Centre(WxBOTH)

      # Show the frame
      frame.Show(TRUE)

      SetTopWindow(frame)
    end
end

a = MyApp.new
a.MainLoop()

