/**********************************************************************

  menubar.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:48 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "menubar.h"

VALUE
WxMenuBar::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxMenuBar::init(int argc, VALUE *argv, VALUE self)
{
    long style = 0;
    if(argc>0) style = NUM2INT(argv[0]);
    wxMenuBar *ptr;
    Data_Get_Struct(self, wxMenuBar, ptr);
    ptr = new wxMenuBar(style);
    DATA_PTR(self) = ptr;

    return self;
}

void WxMenuBar::Append(int argc, VALUE *argv, VALUE self)
{
    wxMenu *menu;
    Data_Get_Struct(argv[0],wxMenu,menu);
    wxString title = StringValuePtr(argv[1]);
    wxMenuBar *ptr;
    Data_Get_Struct(self, wxMenuBar, ptr);
    ptr->Append(menu,title);
}

void
WxMenuBar::Check(VALUE self,VALUE vid,VALUE vcheck)
{
    int id = NUM2INT(vid);
    bool check = (vcheck==Qtrue);
    wxMenuBar *ptr;
    Data_Get_Struct(self, wxMenuBar, ptr);
    ptr->Check(id,check);
}

VALUE
WxMenuBar::init0(wxMenuBar *menubar)
{
    extern VALUE rb_cWxMenuBar;
    VALUE self = Data_Wrap_Struct(rb_cWxMenuBar, 0, 0, 0);
    DATA_PTR(self) = menubar;
    return self;
}

VALUE
WxMenuBar::IsChecked(VALUE self,VALUE vid)
{
    int id = NUM2INT(vid);
    wxMenuBar *ptr;
    Data_Get_Struct(self, wxMenuBar, ptr);
    return (ptr->IsChecked(id) ? Qtrue : Qfalse);
}
