/**********************************************************************

  frame.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:47 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "frame.h"
#include "statusbar.h"
#include "menubar.h"
#include "toolbar.h"

VALUE
WxFrame::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxFrame::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent  = NULL;
    wxWindowID id = -1;
    wxString title ;
    wxPoint pos = wxDefaultPosition ;
    wxSize size = wxDefaultSize ;
    long style = wxDEFAULT_FRAME_STYLE ;
    wxString name = wxFrameNameStr ;
    if(NIL_P(argv[0])) parent = NULL;
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_STRING)
      title = wxString(StringValuePtr(argv[2]));
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxPoint *ptr;
	Data_Get_Struct(argv[3], wxPoint, ptr);
	pos = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_DATA) {
        wxSize *ptr;
	Data_Get_Struct(argv[4], wxSize, ptr);
	size = *ptr;
    }

    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr = new wxFrame(parent,id,title,pos,size,style,name);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

void WxFrame::Show(VALUE self, VALUE vshow)
{
    bool show = (vshow == Qtrue);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->Show(show);
}

void WxFrame::SetMenuBar(VALUE self, VALUE vmenubar)
{
    wxMenuBar *menuBar;
    Data_Get_Struct(vmenubar, wxMenuBar, menuBar);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->SetMenuBar(menuBar);
}

void WxFrame::CreateStatusBar(int argc, VALUE *argv, VALUE self)
{
    int number = 1;
    long style = 0;
    wxWindowID id = -1;
    wxString name = "statusBar";

    if(argc>0) number = NUM2INT(argv[0]);
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      style = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_FIXNUM)
      id = NUM2INT(argv[2]);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->CreateStatusBar(number,style,id,name);
}

void WxFrame::SetStatusText(int argc, VALUE *argv, VALUE self)
{
    wxString text = StringValuePtr(argv[0]);
    int number = 0;

    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      number = NUM2INT(argv[1]);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->SetStatusText(text,number);
}

void WxFrame::SetIcon(VALUE self, VALUE vicon)
{
    wxIcon *icon;
    Data_Get_Struct(vicon, wxIcon, icon);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->SetIcon(*icon);
}

VALUE
WxFrame::GetMenuBar(VALUE self)
{
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    return WxMenuBar::init0(ptr->GetMenuBar());
}

VALUE
WxFrame::GetStatusBar(VALUE self)
{
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    return WxStatusBar::init0(ptr->GetStatusBar());
}

VALUE
WxFrame::init2(VALUE klass,VALUE vwindow)
{
    wxWindow *window;
    Data_Get_Struct(vwindow, wxWindow, window);
    extern VALUE rb_cWxFrame;
    static VALUE self = Data_Wrap_Struct(rb_cWxFrame, 0, 0, 0);
    DATA_PTR(self) = window;
    return self;
}

void
WxFrame::SetStatusBar(VALUE self,VALUE vstatBar)
{
    wxStatusBar *statBar;
    Data_Get_Struct(vstatBar, wxStatusBar, statBar);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->SetStatusBar(statBar);
}

void
WxFrame::SetStatusWidths(VALUE self,VALUE vwidths_field)
{
    int n = RARRAY(vwidths_field)->len;
    int *widths_field = new int[n];
    for(int i=0;i<n;i++)
      widths_field[i] = NUM2INT(RARRAY(vwidths_field)->ptr[i]);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->SetStatusWidths(n,widths_field);
}

void
WxFrame::PushStatusText(int argc, VALUE *argv, VALUE self)
{
    wxString text = StringValuePtr(argv[0]);
    int number = 0;
    if(argc>1) number = NUM2INT(argv[1]);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->PushStatusText(text,number);
}

void
WxFrame::PopStatusText(int argc, VALUE *argv, VALUE self)
{
    int number = 0;
    if(argc>0) number = NUM2INT(argv[0]);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->PopStatusText(number);
}

void
WxFrame::SetStatusBarPane(VALUE self,VALUE vn)
{
    int n = NUM2INT(vn);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->SetStatusBarPane(n);
}

VALUE
WxFrame::GetStatusBarPane(VALUE self)
{
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    return INT2NUM(ptr->GetStatusBarPane());
}

void
WxFrame::SendSizeEvent(VALUE self)
{
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->SendSizeEvent();
}

VALUE
WxFrame::GetToolBar(VALUE self)
{
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    return WxToolBar::init0(ptr->GetToolBar());
}

void
WxFrame::SetToolBar(VALUE self,VALUE vtoolBar)
{
    wxToolBar* toolBar = NULL;
    if(vtoolBar != Qnil)
        Data_Get_Struct(vtoolBar, wxToolBar, toolBar);
    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    ptr->SetToolBar(toolBar);
}

VALUE
WxFrame::CreateToolBar(int argc, VALUE *argv, VALUE self)
{
    long style = wxNO_BORDER|wxTB_HORIZONTAL;
    if(argc>0) style = NUM2INT(argv[0]);
    wxWindowID id = -1;
    if(argc>1) id = NUM2INT(argv[1]);
    wxString name = wxToolBarNameStr;
    if(argc>2) name = StringValuePtr(argv[2]);

    wxFrame *ptr;
    Data_Get_Struct(self, wxFrame, ptr);
    return WxToolBar::init0(ptr->CreateToolBar(style,id,name));
}

