/**********************************************************************

  fontdata.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:47 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "font.h"
#include "colour.h"
#include "fontdata.h"

VALUE
WxFontData::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxFontData::init(VALUE self)
{
    wxFontData *ptr;
    Data_Get_Struct(self, wxFontData, ptr);
    ptr = new wxFontData();
    DATA_PTR(self) = ptr;

    return self;
}

void
WxFontData::SetInitialFont(VALUE self,VALUE vfont)
{
    wxFont *font;
    Data_Get_Struct(vfont, wxFont, font);
    wxFontData *ptr;
    Data_Get_Struct(self, wxFontData, ptr);
    ptr->SetInitialFont(*font);
}

void
WxFontData::SetColour(VALUE self,VALUE vcolour)
{
    wxColour *colour;
    Data_Get_Struct(vcolour, wxColour, colour);
    wxFontData *ptr;
    Data_Get_Struct(self, wxFontData, ptr);
    ptr->SetColour(*colour);
}

void
WxFontData::SetShowHelp(VALUE self,VALUE vshowHelp)
{
    bool showHelp = (vshowHelp==Qtrue);
    wxFontData *ptr;
    Data_Get_Struct(self, wxFontData, ptr);
    ptr->SetShowHelp(showHelp);
}

VALUE
WxFontData::GetChosenFont(VALUE self)
{
    wxFontData *ptr;
    Data_Get_Struct(self, wxFontData, ptr);
    return WxFont::init0(ptr->GetChosenFont());
}

VALUE
WxFontData::GetColour(VALUE self)
{
    wxFontData *ptr;
    Data_Get_Struct(self, wxFontData, ptr);
    return WxColour::init0(ptr->GetColour());
}

VALUE
WxFontData::init0(const wxFontData &fontData)
{
    extern VALUE rb_cWxFontData;
    wxFontData *ptr;
    VALUE self = Data_Wrap_Struct(rb_cWxFontData, 0, 0, 0);
    ptr = new wxFontData();
    *ptr = fontData;
    DATA_PTR(self) = ptr;
    return self;
}
