/**********************************************************************

  event.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:47 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "wx/listctrl.h"
#include "wx/spinbutt.h"
#include "wx/fdrepdlg.h"
#include "event.h"
#include "date.h"
#include "size.h"
#include "point.h"
#include "calendar.h"
#include "notebook.h"
#include "listctrl.h"
#include "socket.h"
#include "treectrl.h"

VALUE
WxEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

void
WxEvent::Skip(int argc, VALUE *argv, VALUE self)
{
    bool skip = TRUE;
    if(argc>0 && argv[0]==Qfalse) skip = FALSE;
    wxEvent *ptr;
    Data_Get_Struct(self, wxEvent, ptr);
    ptr->Skip(skip);
}

VALUE
WxEvent::GetId(VALUE self)
{
    wxEvent *ptr;
    Data_Get_Struct(self, wxEvent, ptr);
    return INT2NUM(ptr->GetId());
}

VALUE
WxEvent::GetEventObject(VALUE self)
{
    wxEvent *ptr;
    Data_Get_Struct(self, wxEvent, ptr);
    wxEvtHandler *object = (wxEvtHandler *)ptr->GetEventObject();
    if(object) {
        void *data = object->GetClientData();
        if(data==NULL)
            return Qnil;
        else
            return rb_hash_aref((VALUE)data, rb_str_new2("self"));
    } else
        return Qnil;
}

VALUE
WxEvent::GetEventType(VALUE self)
{
    wxEvent *ptr;
    Data_Get_Struct(self, wxEvent, ptr);
    return INT2NUM(ptr->GetEventType());
}

//--------------------------------------------------------------------------------
VALUE
WxKeyEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxKeyEvent::init0(wxKeyEvent event)
{
    extern VALUE rb_cWxKeyEvent;
    static VALUE self = Data_Wrap_Struct(rb_cWxKeyEvent, 0, 0, 0);
    DATA_PTR(self) = new wxKeyEvent(event);
    return self;
}

VALUE
WxKeyEvent::GetKeyCode(VALUE self)
{
    wxKeyEvent *ptr;
    Data_Get_Struct(self, wxKeyEvent, ptr);
    return INT2NUM(ptr->GetKeyCode());
}

VALUE
WxKeyEvent::ControlDown(VALUE self)
{
    wxKeyEvent *ptr;
    Data_Get_Struct(self, wxKeyEvent, ptr);
    return (ptr->ControlDown() ? Qtrue : Qfalse);
}

VALUE
WxKeyEvent::MetaDown(VALUE self)
{
    wxKeyEvent *ptr;
    Data_Get_Struct(self, wxKeyEvent, ptr);
    return (ptr->MetaDown() ? Qtrue : Qfalse);
}

VALUE
WxKeyEvent::AltDown(VALUE self)
{
    wxKeyEvent *ptr;
    Data_Get_Struct(self, wxKeyEvent, ptr);
    return (ptr->AltDown() ? Qtrue : Qfalse);
}

VALUE
WxKeyEvent::ShiftDown(VALUE self)
{
    wxKeyEvent *ptr;
    Data_Get_Struct(self, wxKeyEvent, ptr);
    return (ptr->ShiftDown() ? Qtrue : Qfalse);
}

VALUE
WxKeyEvent::HasModifiers(VALUE self)
{
    wxKeyEvent *ptr;
    Data_Get_Struct(self, wxKeyEvent, ptr);
    return (ptr->HasModifiers() ? Qtrue : Qfalse);
}

//--------------------------------------------------------------------------------
VALUE
WxCloseEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxCloseEvent::CanVeto(VALUE self)
{
    wxCloseEvent *ptr;
    Data_Get_Struct(self, wxCloseEvent, ptr);
    return (ptr->CanVeto() ? Qtrue : Qfalse);
}

void
WxCloseEvent::Veto(int argc, VALUE *argv, VALUE self)
{
    bool veto = TRUE;
    if(argc>0 && argv[0]!=Qtrue) veto = FALSE;
    wxCloseEvent *ptr;
    Data_Get_Struct(self, wxCloseEvent, ptr);
    ptr->Veto(veto);

}

//--------------------------------------------------------------------------------
VALUE
WxCommandEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxCommandEvent::GetSelection(VALUE self)
{
    wxCommandEvent *ptr;
    Data_Get_Struct(self, wxCommandEvent, ptr);
    return INT2NUM(ptr->GetSelection());
}

VALUE
WxCommandEvent::GetString(VALUE self)
{
    wxCommandEvent *ptr;
    Data_Get_Struct(self, wxCommandEvent, ptr);
    return rb_str_new2(ptr->GetString());
}

VALUE
WxCommandEvent::IsChecked(VALUE self)
{
    wxCommandEvent *ptr;
    Data_Get_Struct(self, wxCommandEvent, ptr);
    return (ptr->IsChecked() ? Qtrue : Qfalse);
}

VALUE
WxCommandEvent::IsSelection(VALUE self)
{
    wxCommandEvent *ptr;
    Data_Get_Struct(self, wxCommandEvent, ptr);
    return (ptr->IsSelection() ? Qtrue : Qfalse);
}

VALUE
WxCommandEvent::GetClientData(VALUE self)
{
    wxCommandEvent *ptr;
    Data_Get_Struct(self, wxCommandEvent, ptr);
    void *data = ptr->GetClientData();
    if(data==NULL)
        return Qnil;
    else
        return rb_hash_aref((VALUE)data, rb_str_new2("data"));
}

VALUE
WxCommandEvent::GetExtraLong(VALUE self)
{
    wxCommandEvent *ptr;
    Data_Get_Struct(self, wxCommandEvent, ptr);
    return INT2NUM(ptr->GetExtraLong());
}

VALUE
WxCommandEvent::GetInt(VALUE self)
{
    wxCommandEvent *ptr;
    Data_Get_Struct(self, wxCommandEvent, ptr);
    return INT2NUM(ptr->GetInt());
}

//--------------------------------------------------------------------------------
VALUE
WxCalendarEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxCalendarEvent::GetDate(VALUE self)
{
    wxCalendarEvent *ptr;
    Data_Get_Struct(self, wxCalendarEvent, ptr);
    return WxDateTime::init0(ptr->GetDate());
}

//--------------------------------------------------------------------------------
VALUE
WxListEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxListEvent::GetData(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    VALUE v = ptr->GetData();
    if (v == Qfalse || v== Qnil) v = INT2NUM(0);
    return (v);
}

VALUE
WxListEvent::GetIndex(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return INT2NUM(ptr->GetIndex());
}

VALUE
WxListEvent::GetKeyCode(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return INT2NUM(ptr->GetKeyCode());
}

VALUE
WxListEvent::GetCacheFrom(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return INT2NUM(ptr->GetCacheFrom());
}

VALUE
WxListEvent::GetColumn(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return INT2NUM(ptr->GetColumn());
}

VALUE
WxListEvent::GetMask(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return INT2NUM(ptr->GetMask());
}

//VALUE
//WxListEvent::Cancelled(VALUE self)
//{
//    wxListEvent *ptr;
//    Data_Get_Struct(self, wxListEvent, ptr);
//    return (ptr->Cancelled() ? Qtrue : Qfalse);
//}

VALUE
WxListEvent::GetPoint(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return WxPoint::init0(ptr->GetPoint());
}

VALUE
WxListEvent::GetLabel(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return rb_str_new2(ptr->GetLabel());
}

VALUE
WxListEvent::GetText(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return rb_str_new2(ptr->GetText());
}

VALUE
WxListEvent::GetImage(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return INT2NUM(ptr->GetImage());
}

VALUE
WxListEvent::GetItem(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return WxListItem::init0((wxListItem *)&ptr->GetItem());
}


VALUE
WxListEvent::GetCacheTo(VALUE self)
{
    wxListEvent *ptr;
    Data_Get_Struct(self, wxListEvent, ptr);
    return INT2NUM(ptr->GetCacheTo());
}

//--------------------------------------------------------------------------------
VALUE
WxUpdateUIEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}


void
WxUpdateUIEvent::Enable(VALUE self,VALUE venable)
{
    bool enable = (venable == Qtrue);
    wxUpdateUIEvent *ptr;
    Data_Get_Struct(self, wxUpdateUIEvent, ptr);
    ptr->Enable(enable);
}

//---------------------------------------------------------------------------------
VALUE
WxSizeEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxSizeEvent::GetSize(VALUE self)
{
    wxSizeEvent *ptr;
    Data_Get_Struct(self, wxSizeEvent, ptr);
    return WxSize::init0(ptr->GetSize());
}

//---------------------------------------------------------------------------------
VALUE
WxMoveEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxMoveEvent::GetPosition(VALUE self)
{
    wxMoveEvent *ptr;
    Data_Get_Struct(self, wxMoveEvent, ptr);
    return WxPoint::init0(ptr->GetPosition());
}

//---------------------------------------------------------------------------------
VALUE
WxSpinEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxSpinEvent::GetPosition(VALUE self)
{
    wxSpinEvent *ptr;
    Data_Get_Struct(self, wxSpinEvent, ptr);
    return INT2NUM(ptr->GetPosition());
}

void
WxSpinEvent::SetPosition(VALUE self,VALUE vpos)
{
    int pos = NUM2INT(vpos);
    wxSpinEvent *ptr;
    Data_Get_Struct(self, wxSpinEvent, ptr);
    ptr->SetPosition(pos);
}

//---------------------------------------------------------------------------------
VALUE
WxNotifyEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

void
WxNotifyEvent::Allow(VALUE self)
{
    wxNotifyEvent *ptr;
    Data_Get_Struct(self, wxNotifyEvent, ptr);
    ptr->Allow();
}

VALUE
WxNotifyEvent::IsAllowed(VALUE self)
{
    wxNotifyEvent *ptr;
    Data_Get_Struct(self, wxNotifyEvent, ptr);
    return (ptr->IsAllowed() ? Qtrue : Qfalse);
}

void
WxNotifyEvent::Veto(VALUE self)
{
    wxNotifyEvent *ptr;
    Data_Get_Struct(self, wxNotifyEvent, ptr);
    ptr->Veto();
}


//---------------------------------------------------------------------------------
VALUE
WxNotebookEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxNotebookEvent::GetSelection(VALUE self)
{
    wxNotebookEvent *ptr;
    Data_Get_Struct(self, wxNotebookEvent, ptr);
    return INT2NUM(ptr->GetSelection());
}

void
WxNotebookEvent::SetSelection(VALUE self,VALUE vnSel)
{
    int nSel = NUM2INT(vnSel);
    wxNotebookEvent *ptr;
    Data_Get_Struct(self, wxNotebookEvent, ptr);
    ptr->SetSelection(nSel);
}

VALUE
WxNotebookEvent::GetOldSelection(VALUE self)
{
    wxNotebookEvent *ptr;
    Data_Get_Struct(self, wxNotebookEvent, ptr);
    return INT2NUM(ptr->GetOldSelection());
}

void
WxNotebookEvent::SetOldSelection(VALUE self,VALUE vnOldSel)
{
    int nOldSel = NUM2INT(vnOldSel);
    wxNotebookEvent *ptr;
    Data_Get_Struct(self, wxNotebookEvent, ptr);
    ptr->SetOldSelection(nOldSel);
}


//---------------------------------------------------------------------------------
VALUE
WxPaintEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

//---------------------------------------------------------------------------------
VALUE
WxFindDialogEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxFindDialogEvent::GetFlags(VALUE self)
{
    wxFindDialogEvent *ptr;
    Data_Get_Struct(self, wxFindDialogEvent, ptr);
    return INT2NUM(ptr->GetFlags());
}

VALUE
WxFindDialogEvent::GetFindString(VALUE self)
{
    wxFindDialogEvent *ptr;
    Data_Get_Struct(self, wxFindDialogEvent, ptr);
    return rb_str_new2(ptr->GetFindString());
}

VALUE
WxFindDialogEvent::GetReplaceString(VALUE self)
{
    wxFindDialogEvent *ptr;
    Data_Get_Struct(self, wxFindDialogEvent, ptr);
    return rb_str_new2(ptr->GetReplaceString());
}

VALUE
WxFindDialogEvent::GetDialog(VALUE self)
{
    wxFindDialogEvent *ptr;
    Data_Get_Struct(self, wxFindDialogEvent, ptr);
    return (long)(ptr->GetEventObject());
}

void
WxFindDialogEvent::SetFlags(VALUE self,VALUE vflags)
{
    int flags = NUM2INT(vflags);
    wxFindDialogEvent *ptr;
    Data_Get_Struct(self, wxFindDialogEvent, ptr);
    ptr->SetFlags(flags);
}

void
WxFindDialogEvent::SetFindString(VALUE self,VALUE vstr)
{
    wxString str = StringValuePtr(vstr);
    wxFindDialogEvent *ptr;
    Data_Get_Struct(self, wxFindDialogEvent, ptr);
    ptr->SetFindString(str);
}

void
WxFindDialogEvent::SetReplaceString(VALUE self,VALUE vstr)
{
    wxString str = StringValuePtr(vstr);
    wxFindDialogEvent *ptr;
    Data_Get_Struct(self, wxFindDialogEvent, ptr);
    ptr->SetReplaceString(str);
}

//---------------------------------------------------------------------------------
VALUE
WxSocketEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxSocketEvent::GetClientData(VALUE self)
{
    wxSocketEvent *ptr;
    Data_Get_Struct(self, wxSocketEvent, ptr);
    return (VALUE)(ptr->GetClientData());
}


VALUE
WxSocketEvent::GetSocket(VALUE self)
{
    wxSocketEvent *ptr;
    Data_Get_Struct(self, wxSocketEvent, ptr);
    return WxSocketBase::init0(ptr->GetSocket());
}

VALUE
WxSocketEvent::GetSocketEvent(VALUE self)
{
    wxSocketEvent *ptr;
    Data_Get_Struct(self, wxSocketEvent, ptr);
    return INT2NUM(ptr->GetSocketEvent());
}

//---------------------------------------------------------------------------------
VALUE
WxSplitterEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

void
WxSplitterEvent::SetSashPosition(VALUE self,VALUE vpos)
{
    int pos = NUM2INT(vpos);
    wxSplitterEvent *ptr;
    Data_Get_Struct(self, wxSplitterEvent, ptr);
    ptr->SetSashPosition(pos);
}

VALUE
WxSplitterEvent::GetSashPosition(VALUE self)
{
    wxSplitterEvent *ptr;
    Data_Get_Struct(self, wxSplitterEvent, ptr);
    return INT2NUM(ptr->GetSashPosition());
}

VALUE
WxSplitterEvent::GetX(VALUE self)
{
    wxSplitterEvent *ptr;
    Data_Get_Struct(self, wxSplitterEvent, ptr);
    return INT2NUM(ptr->GetX());
}

VALUE
WxSplitterEvent::GetY(VALUE self)
{
    wxSplitterEvent *ptr;
    Data_Get_Struct(self, wxSplitterEvent, ptr);
    return INT2NUM(ptr->GetY());
}

VALUE
WxSplitterEvent::GetWindowBeingRemoved(VALUE self)
{
    wxSplitterEvent *ptr;
    Data_Get_Struct(self, wxSplitterEvent, ptr);
    return WxWindow::init0(ptr->GetWindowBeingRemoved());
}

//--------------------------------------------------------------------------------
VALUE
WxTreeEvent::alloc(VALUE self)
{
   return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxTreeEvent::GetKeyCode(VALUE self)
{
    wxTreeEvent *ptr;
    Data_Get_Struct(self, wxTreeEvent, ptr);
    return INT2NUM(ptr->GetKeyCode());
}

VALUE
WxTreeEvent::GetKeyEvent(VALUE self)
{
    wxTreeEvent *ptr;
    Data_Get_Struct(self, wxTreeEvent, ptr);
    return WxKeyEvent::init0(ptr->GetKeyEvent());
}

VALUE
WxTreeEvent::GetItem(VALUE self)
{
    wxTreeEvent *ptr;
    Data_Get_Struct(self, wxTreeEvent, ptr);
    return INT2NUM(ptr->GetItem());
}

VALUE
WxTreeEvent::GetLabel(VALUE self)
{
    wxTreeEvent *ptr;
    Data_Get_Struct(self, wxTreeEvent, ptr);
    return rb_str_new2(ptr->GetLabel());
}

VALUE
WxTreeEvent::GetOldItem(VALUE self)
{
    wxTreeEvent *ptr;
    Data_Get_Struct(self, wxTreeEvent, ptr);
    return INT2NUM(ptr->GetOldItem());
}

VALUE
WxTreeEvent::GetPoint(VALUE self)
{
    wxTreeEvent *ptr;
    Data_Get_Struct(self, wxTreeEvent, ptr);
    return WxPoint::init0(ptr->GetPoint());
}

VALUE
WxTreeEvent::IsEditCancelled(VALUE self)
{
    wxTreeEvent *ptr;
    Data_Get_Struct(self, wxTreeEvent, ptr);
    return (ptr->IsEditCancelled() ? Qtrue : Qfalse);
}

