/**********************************************************************

  dialog.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:47 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "dialog.h"

VALUE
WxDialog::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxDialog::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow* parent = NULL;
    wxWindowID id;
    wxString title;
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    long style = wxDEFAULT_DIALOG_STYLE;
    wxString name = "dialogBox";

    if(argc>0 && TYPE(argv[0])==T_DATA) {
      Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_STRING)
      title = wxString(StringValuePtr(argv[2]));
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxPoint *ptr;
	Data_Get_Struct(argv[3], wxPoint, ptr);
	pos = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_DATA) {
        wxSize *ptr;
	Data_Get_Struct(argv[4], wxSize, ptr);
	size = *ptr;
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
      style = NUM2INT(argv[5]);
    if(argc>6 && TYPE(argv[6])==T_STRING)
      name = wxString(StringValuePtr(argv[6]));

    wxDialog *ptr;
    Data_Get_Struct(self, wxDialog, ptr);
    ptr = new wxDialog(parent,id,title,pos,size,style,name);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxDialog::ShowModal(VALUE self)
{
    wxDialog *ptr;
    Data_Get_Struct(self, wxDialog, ptr);
    return INT2NUM(ptr->ShowModal());
}

//-------------------------------------------------------------------------------
VALUE
WxProgressDialog::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxProgressDialog::init(int argc, VALUE *argv, VALUE self)
{
    wxString title = StringValuePtr(argv[0]);
    wxString message = StringValuePtr(argv[1]);
    int maximum = 100;
    if(argc>2) maximum = NUM2INT(argv[2]);
    wxWindow * parent = NULL;
    if(argc>3) {
        Data_Get_Struct(argv[3], wxWindow, parent);
    }
    int style = wxPD_AUTO_HIDE | wxPD_APP_MODAL;
    if(argc>4)
        style = NUM2INT(argv[4]);

    wxProgressDialog *ptr;
    Data_Get_Struct(self, wxProgressDialog, ptr);
    ptr = new wxProgressDialog(title,message,maximum,parent,style);
    DATA_PTR(self) = ptr;

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    return self;
}


VALUE
WxProgressDialog::Update(int argc, VALUE *argv, VALUE self)
{
    int value = NUM2INT(argv[0]);
    wxString newmsg = "";
    if(argc>1) newmsg = StringValuePtr(argv[1]);
    wxProgressDialog *ptr;
    Data_Get_Struct(self, wxProgressDialog, ptr);
    return (ptr->Update(value,newmsg) ? Qtrue : Qfalse);
}

void
WxProgressDialog::Resume(VALUE self)
{
    wxProgressDialog *ptr;
    Data_Get_Struct(self, wxProgressDialog, ptr);
    ptr->Resume();
}

//-------------------------------------------------------------------------------------
VALUE
WxFindReplaceData::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxFindReplaceData::init(int argc, VALUE *argv, VALUE self)
{
    wxUint32 flags = 0;
    if(argc>0) flags = NUM2INT(argv[0]);

    wxFindReplaceData *ptr;
    Data_Get_Struct(self, wxFindReplaceData, ptr);
    ptr = new wxFindReplaceData(flags);
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxFindReplaceData::GetFindString(VALUE self)
{
    wxFindReplaceData *ptr;
    Data_Get_Struct(self, wxFindReplaceData, ptr);
    return rb_str_new2(ptr->GetFindString());
}

VALUE
WxFindReplaceData::GetReplaceString(VALUE self)
{
    wxFindReplaceData *ptr;
    Data_Get_Struct(self, wxFindReplaceData, ptr);
    return rb_str_new2(ptr->GetReplaceString());
}

VALUE
WxFindReplaceData::GetFlags(VALUE self)
{
    wxFindReplaceData *ptr;
    Data_Get_Struct(self, wxFindReplaceData, ptr);
    return NUM2INT(ptr->GetFlags());
}

void
WxFindReplaceData::SetFlags(VALUE self,VALUE vflags)
{
    wxUint32 flags = NUM2INT(vflags);
    wxFindReplaceData *ptr;
    Data_Get_Struct(self, wxFindReplaceData, ptr);
    ptr->SetFlags(flags);
}

void
WxFindReplaceData::SetFindString(VALUE self,VALUE vstr)
{
    wxString str = StringValuePtr(vstr);
    wxFindReplaceData *ptr;
    Data_Get_Struct(self, wxFindReplaceData, ptr);
    ptr->SetFindString(str);
}

void
WxFindReplaceData::SetReplaceString(VALUE self,VALUE vstr)
{
    wxString str = StringValuePtr(vstr);
    wxFindReplaceData *ptr;
    Data_Get_Struct(self, wxFindReplaceData, ptr);
    ptr->SetReplaceString(str);
}

VALUE
WxFindReplaceData::init0(wxFindReplaceData *data)
{
    extern VALUE rb_cWxFindReplaceData;
    wxFindReplaceData *ptr;
    VALUE self = Data_Wrap_Struct(rb_cWxFindReplaceData, 0, 0, 0);
    ptr = data;
    DATA_PTR(self) = ptr;
    return self;
}

//-------------------------------------------------------------------------------
VALUE
WxTextEntryDialog::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxTextEntryDialog::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent = NULL;
    if(argc>0) {
        Data_Get_Struct(argv[0], wxWindow, parent);
    }
    wxString message = StringValuePtr(argv[1]);
    wxString caption = wxGetTextFromUserPromptStr;
    if(argc>2) caption = StringValuePtr(argv[2]);
    wxString value = wxEmptyString;
    if(argc>3) value = StringValuePtr(argv[3]);
    long style = wxTextEntryDialogStyle;
    if(argc>4) style = NUM2INT(argv[4]);
    wxPoint pos = wxDefaultPosition;
    if(argc>5) {
        wxPoint *ptr;
        Data_Get_Struct(argv[5], wxPoint, ptr);
        pos = *ptr;
    }

    wxTextEntryDialog *ptr;
    Data_Get_Struct(self, wxTextEntryDialog, ptr);
    ptr = new wxTextEntryDialog(parent,message,caption,value,style,pos);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

void
WxTextEntryDialog::SetValue(VALUE self,VALUE vval)
{
    wxString val = StringValuePtr(vval);
    wxTextEntryDialog *ptr;
    Data_Get_Struct(self, wxTextEntryDialog, ptr);
    ptr->SetValue(val);
}

VALUE
WxTextEntryDialog::GetValue(VALUE self)
{
    wxTextEntryDialog *ptr;
    Data_Get_Struct(self, wxTextEntryDialog, ptr);
    return rb_str_new2(ptr->GetValue());
}

//-------------------------------------------------------------------------------
VALUE
WxSingleChoiceDialog::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxSingleChoiceDialog::init(int argc, VALUE *argv, VALUE self)
{

    wxWindow *parent = NULL;
    if(argc>0) {
        Data_Get_Struct(argv[0], wxWindow, parent);
    }
    wxString message = StringValuePtr(argv[1]);
    wxString caption = StringValuePtr(argv[2]);
    int n = 0;
    wxString *choices;
    if(argc>3) {
        n = RARRAY(argv[3])->len;
        choices = new wxString[n];
        for (int i = 0; i < n; i++) {
            choices[i] = StringValuePtr(RARRAY(argv[3])->ptr[i]);
        }
    }
    char **clientData = (char **)NULL;
    long style = wxCHOICEDLG_STYLE;
    if(argc>5) style = NUM2INT(argv[5]);
    wxPoint pos = wxDefaultPosition;
    if(argc>6) {
        wxPoint *ptr;
        Data_Get_Struct(argv[6], wxPoint, ptr);
        pos = *ptr;
    }

    wxSingleChoiceDialog *ptr;
    Data_Get_Struct(self, wxSingleChoiceDialog, ptr);
    ptr = new wxSingleChoiceDialog(parent,message,caption,n,choices,clientData,style,pos);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

void
WxSingleChoiceDialog::SetSelection(VALUE self,VALUE vsel)
{
    int sel = NUM2INT(vsel);
    wxSingleChoiceDialog *ptr;
    Data_Get_Struct(self, wxSingleChoiceDialog, ptr);
    ptr->SetSelection(sel);
}

VALUE
WxSingleChoiceDialog::GetSelection(VALUE self)
{
    wxSingleChoiceDialog *ptr;
    Data_Get_Struct(self, wxSingleChoiceDialog, ptr);
    return INT2NUM(ptr->GetSelection());
}

VALUE
WxSingleChoiceDialog::GetStringSelection(VALUE self)
{
    wxSingleChoiceDialog *ptr;
    Data_Get_Struct(self, wxSingleChoiceDialog, ptr);
    return rb_str_new2(ptr->GetStringSelection());
}

//---------------------------------------------------------------------------------
VALUE
WxTipProvider::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxTipProvider::GetTip(VALUE self)
{
    wxTipProvider *ptr;
    Data_Get_Struct(self, wxTipProvider, ptr);
    return rb_str_new2(ptr->GetTip());
}


VALUE
WxTipProvider::PreprocessTip(VALUE self,VALUE vtip)
{
    wxString tip = StringValuePtr(vtip);
    wxTipProvider *ptr;
    Data_Get_Struct(self, wxTipProvider, ptr);
    return rb_str_new2(ptr->PreprocessTip(tip));
}

VALUE
WxTipProvider::GetCurrentTip(VALUE self)
{
    wxTipProvider *ptr;
    Data_Get_Struct(self, wxTipProvider, ptr);
    return INT2NUM(ptr->GetCurrentTip());
}

VALUE
WxTipProvider::init0(wxTipProvider *tipProvider)
{
    extern VALUE rb_cWxTipProvider;
    wxTipProvider *ptr;
    VALUE self = Data_Wrap_Struct(rb_cWxTipProvider, 0, 0, 0);
    DATA_PTR(self) = tipProvider;
    return self;
}


//-------------------------------------------------------------------------------
VALUE
WxWindowDisabler::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxWindowDisabler::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *winToSkip = (wxWindow *)NULL;
    if(argc>0) {
        Data_Get_Struct(argv[0], wxWindow, winToSkip);
    }

    wxWindowDisabler *ptr;
    Data_Get_Struct(self, wxWindowDisabler, ptr);
    ptr = new wxWindowDisabler(winToSkip);

    DATA_PTR(self) = ptr;

    return self;
}

void
WxWindowDisabler::free(VALUE self)
{
    wxWindowDisabler *ptr;
    Data_Get_Struct(self, wxWindowDisabler, ptr);
    delete ptr;
}

//-------------------------------------------------------------------------------
VALUE
WxBusyInfo::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxBusyInfo::init(int argc, VALUE *argv, VALUE self)
{
    wxString message = StringValuePtr(argv[0]);
    wxWindow *parent = NULL;
    if(argc>1) {
        Data_Get_Struct(argv[1], wxWindow, parent);
    }

    wxBusyInfo *ptr;
    Data_Get_Struct(self, wxBusyInfo, ptr);
    ptr = new wxBusyInfo(message,parent);
    DATA_PTR(self) = ptr;

    return self;
}

void
WxBusyInfo::free(VALUE self)
{
    wxBusyInfo *ptr;
    Data_Get_Struct(self, wxBusyInfo, ptr);
    delete ptr;
}

//-------------------------------------------------------------------------------
VALUE
WxFindReplaceDialog::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxFindReplaceDialog::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent;
    Data_Get_Struct(argv[0], wxWindow, parent);
    wxFindReplaceData *data;
    Data_Get_Struct(argv[1], wxFindReplaceData, data);
    wxString title = StringValuePtr(argv[2]);
    int style = 0;
    if(argc>3) style = NUM2INT(argv[3]);

    wxFindReplaceDialog *ptr;
    Data_Get_Struct(self, wxFindReplaceDialog, ptr);
    ptr = new wxFindReplaceDialog(parent,data,title,style);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxFindReplaceDialog::GetData(VALUE self)
{
    wxFindReplaceDialog *ptr;
    Data_Get_Struct(self, wxFindReplaceDialog, ptr);
    return WxFindReplaceData::init0((wxFindReplaceData*)ptr->GetData());
}

void
WxFindReplaceDialog::SetData(VALUE self,VALUE vdata)
{
    wxFindReplaceData *data;
    Data_Get_Struct(vdata, wxFindReplaceData, data);
    wxFindReplaceDialog *ptr;
    Data_Get_Struct(self, wxFindReplaceDialog, ptr);
    ptr->SetData(data);
}

