/**********************************************************************

  colourdialog.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "colourdata.h"
#include "colourdialog.h"

VALUE
WxColourDialog::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxColourDialog::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent;
    wxColourData *data = NULL;

    if(argc>0 && TYPE(argv[0])==T_DATA) {
      Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_DATA) {
      Data_Get_Struct(argv[1], wxColourData, data);
    }

    wxColourDialog *ptr;
    Data_Get_Struct(self, wxColourDialog, ptr);
    ptr = new wxColourDialog(parent,data);
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxColourDialog::ShowModal(VALUE self)
{
    wxColourDialog *ptr;
    Data_Get_Struct(self, wxColourDialog, ptr);
    return INT2NUM(ptr->ShowModal());
}


VALUE
WxColourDialog::GetColourData(VALUE self)
{
    wxColourDialog *ptr;
    Data_Get_Struct(self, wxColourDialog, ptr);
    return WxColourData::init0(ptr->GetColourData());
}
