/**********************************************************************

  colour.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "colour.h"

VALUE
WxColour::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxColour::init(int argc, VALUE *argv, VALUE self)
{
    wxColour *ptr;
    Data_Get_Struct(self, wxColour, ptr);
    if(argc==0) {
        ptr = new wxColour();
    } else if(argc==3) {
        unsigned char red = NUM2INT(argv[0]);
        unsigned char green = NUM2INT(argv[1]);
        unsigned char blue = NUM2INT(argv[2]);
        ptr = new wxColour(red,green,blue);
    } else {
        wxString colourNname = StringValuePtr(argv[0]);
        ptr = new wxColour(colourNname);
    }
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxColour::Blue(VALUE self)
{
    wxColour *ptr;
    Data_Get_Struct(self, wxColour, ptr);
    return INT2NUM(ptr->Blue());
}

VALUE
WxColour::Green(VALUE self)
{
    wxColour *ptr;
    Data_Get_Struct(self, wxColour, ptr);
    return INT2NUM(ptr->Green());
}

VALUE
WxColour::Red(VALUE self)
{
    wxColour *ptr;
    Data_Get_Struct(self, wxColour, ptr);
    return INT2NUM(ptr->Red());
}

VALUE
WxColour::Ok(VALUE self)
{
    wxColour *ptr;
    Data_Get_Struct(self, wxColour, ptr);
    return (ptr->Ok() ? Qtrue : Qfalse);
}

VALUE
WxColour::init0(const wxColour &colour)
{
    extern VALUE rb_cWxColour;
    VALUE self = Data_Wrap_Struct(rb_cWxColour, 0, 0, 0);
    DATA_PTR(self) = new wxColour(colour);
    return self;
}
