/**********************************************************************

  checkbox.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "checkbox.h"

VALUE
WxCheckBox::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxCheckBox::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow* parent;
    wxWindowID id;
    wxString label;
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    long style = 0;
//    wxValidator val wxDefaultValidator;
//    wxString name = "checkBox";

    if(argc>0 && TYPE(argv[0])==T_DATA) {
	Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_STRING)
      label = wxString(StringValuePtr(argv[2]));
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxPoint *ptr;
	Data_Get_Struct(argv[3], wxPoint, ptr);
	pos = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_DATA) {
        wxSize *ptr;
	Data_Get_Struct(argv[4], wxSize, ptr);
	size = *ptr;
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
      style = NUM2INT(argv[5]);

    wxCheckBox *ptr;
    Data_Get_Struct(self, wxCheckBox, ptr);
    ptr = new wxCheckBox(parent,id,label,pos,size,style);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

void
WxCheckBox::SetValue(VALUE self,VALUE vvalue)
{
    bool value = (vvalue == Qtrue);
    wxCheckBox *ptr;
    Data_Get_Struct(self, wxCheckBox, ptr);
    ptr->SetValue(value);
}

VALUE
WxCheckBox::GetValue(VALUE self)
{
    wxCheckBox *ptr;
    Data_Get_Struct(self, wxCheckBox, ptr);
    return (ptr->GetValue() ? Qtrue : Qfalse);
}


//--------------------------------------------------------------------------------------
VALUE
WxCheckListBox::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxCheckListBox::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow* parent;
    wxWindowID id;
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    int n;
    wxString *choices = NULL;
    long style = 0;
//    wxValidator validator = wxDefaultValidator;
//    wxString name = "listBox";

    if(argc>0 && TYPE(argv[0])==T_DATA) {
	Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_DATA) {
        wxPoint *ptr;
	Data_Get_Struct(argv[2], wxPoint, ptr);
	pos = *ptr;
    }
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxSize *ptr;
	Data_Get_Struct(argv[3], wxSize, ptr);
	size = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_ARRAY) {
      n = RARRAY(argv[4])->len;
      choices = new wxString[n];
      for (int i = 0; i < RARRAY(argv[4])->len; i++) {
        choices[i] = wxString(StringValuePtr(RARRAY(argv[4])->ptr[i]));
      }
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
      style = NUM2INT(argv[5]);

    wxCheckListBox *ptr;
    Data_Get_Struct(self, wxCheckListBox, ptr);
    ptr = new wxCheckListBox(parent,id,pos,size,n,choices,style);
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxCheckListBox::IsChecked(VALUE self,VALUE vitem)
{
    int item = NUM2INT(vitem);
    wxCheckListBox *ptr;
    Data_Get_Struct(self, wxCheckListBox, ptr);

    return (ptr->IsChecked(item) ? Qtrue : Qfalse);
}

void
WxCheckListBox::Check(int argc, VALUE *argv, VALUE self)
{
    int item = NUM2INT(argv[0]);
    bool check = TRUE;
    if(argc>1 && argv[1]==Qfalse) check = FALSE;
    wxCheckListBox *ptr;
    Data_Get_Struct(self, wxCheckListBox, ptr);
    ptr->Check(item,check);
}

