/**********************************************************************

  button.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "button.h"
#include "size.h"
#include "bitmap.h"

VALUE
WxButton::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxButton::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent;
    wxWindowID id;
    wxString label;
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    long style = 0;
//    wxValidator validator = wxDefaultValidator;
//    wxString name = wxButtonNameStr;


    if(argc>0 && TYPE(argv[0])==T_DATA) {
	Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_STRING)
      label = wxString(StringValuePtr(argv[2]));
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxPoint *ptr;
	Data_Get_Struct(argv[3], wxPoint, ptr);
	pos = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_DATA) {
        wxSize *ptr;
	Data_Get_Struct(argv[4], wxSize, ptr);
	size = *ptr;
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
      style = NUM2INT(argv[5]);

    wxButton *ptr;
    Data_Get_Struct(self, wxButton, ptr);
    ptr = new wxButton(parent,id,label,pos,size,style);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxButton::GetLabel(VALUE self)
{
    wxButton *ptr;
    Data_Get_Struct(self, wxButton, ptr);
    return rb_str_new2(ptr->GetLabel());
}

VALUE
WxButton::GetDefaultSize(VALUE self)
{
    wxButton *ptr;
    Data_Get_Struct(self, wxButton, ptr);
    return WxSize::init0(ptr->GetDefaultSize());
}

void
WxButton::SetDefault(VALUE self)
{
    wxButton *ptr;
    Data_Get_Struct(self, wxButton, ptr);
    ptr->SetDefault();
}


void
WxButton::SetLabel(VALUE self,VALUE vlabel)
{
    wxString label = StringValuePtr(vlabel);
    wxButton *ptr;
    Data_Get_Struct(self, wxButton, ptr);
    ptr->SetLabel(label);
}

VALUE
WxButton::init0(wxButton *btn)
{
    extern VALUE rb_cWxButton;
    static VALUE self = Data_Wrap_Struct(rb_cWxButton, 0, 0, 0);
    DATA_PTR(self) = (void*)btn;
    return self;
}

//-------------------------------------------------------

VALUE
WxBitmapButton::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxBitmapButton::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent;
    wxWindowID id;
    wxBitmap bitmap;
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    long style = wxBU_AUTODRAW;
//    wxValidator validator = wxDefaultValidator;
//    wxString name = wxButtonNameStr;

    if(argc>0 && TYPE(argv[0])==T_DATA) {
	Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_DATA) {
        wxBitmap *ptr;
	Data_Get_Struct(argv[2], wxBitmap, ptr);
	bitmap = *ptr;
    }
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxPoint *ptr;
	Data_Get_Struct(argv[3], wxPoint, ptr);
	pos = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_DATA) {
        wxSize *ptr;
	Data_Get_Struct(argv[4], wxSize, ptr);
	size = *ptr;
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
      style = NUM2INT(argv[5]);

    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    ptr = new wxBitmapButton(parent,id,bitmap,pos,size,style);
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxBitmapButton::GetBitmapDisabled(VALUE self)
{
    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    return WxBitmap::init0(ptr->GetBitmapDisabled());
}

VALUE
WxBitmapButton::GetBitmapFocus(VALUE self)
{
    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    return WxBitmap::init0(ptr->GetBitmapFocus());
}

VALUE
WxBitmapButton::GetBitmapLabel(VALUE self)
{
    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    return WxBitmap::init0(ptr->GetBitmapLabel());
}

VALUE
WxBitmapButton::GetBitmapSelected(VALUE self)
{
    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    return WxBitmap::init0(ptr->GetBitmapSelected());
}

void
WxBitmapButton::SetBitmapDisabled(VALUE self,VALUE vbitmap)
{
    wxBitmap *bitmap;
    Data_Get_Struct(self, wxBitmap, bitmap);
    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    ptr->SetBitmapDisabled(*bitmap);
}

void
WxBitmapButton::SetBitmapFocus(VALUE self,VALUE vbitmap)
{
    wxBitmap *bitmap;
    Data_Get_Struct(self, wxBitmap, bitmap);
    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    ptr->SetBitmapFocus(*bitmap);
}

void
WxBitmapButton::SetBitmapLabel(VALUE self,VALUE vbitmap)
{
    wxBitmap *bitmap;
    Data_Get_Struct(self, wxBitmap, bitmap);
    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    ptr->SetBitmapLabel(*bitmap);
}

void
WxBitmapButton::SetBitmapSelected(VALUE self,VALUE vbitmap)
{
    wxBitmap *bitmap;
    Data_Get_Struct(self, wxBitmap, bitmap);
    wxBitmapButton *ptr;
    Data_Get_Struct(self, wxBitmapButton, ptr);
    ptr->SetBitmapSelected(*bitmap);
}

//--------------------------------------------------------------------
VALUE
WxToggleButton::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxToggleButton::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow *parent;
    wxWindowID id;
    wxString label;
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    long style = wxBU_AUTODRAW;
//    wxValidator validator = wxDefaultValidator;
//    wxString name = "checkBox";

    if(argc>0 && TYPE(argv[0])==T_DATA) {
	    Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_STRING)
        label = StringValuePtr(argv[2]);
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxPoint *ptr;
	    Data_Get_Struct(argv[3], wxPoint, ptr);
	    pos = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_DATA) {
        wxSize *ptr;
	    Data_Get_Struct(argv[4], wxSize, ptr);
	    size = *ptr;
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
      style = NUM2INT(argv[5]);

    wxToggleButton *ptr;
    Data_Get_Struct(self, wxToggleButton, ptr);
    ptr = new wxToggleButton(parent,id,label,pos,size,style);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxToggleButton::GetValue(VALUE self)
{
    wxToggleButton *ptr;
    Data_Get_Struct(self, wxToggleButton, ptr);
    return (ptr->GetValue() ? Qtrue : Qfalse);
}

void
WxToggleButton::SetValue(VALUE self,VALUE vstate)
{
    bool state = (vstate == Qtrue);
    wxToggleButton *ptr;
    Data_Get_Struct(self, wxToggleButton, ptr);
    ptr->SetValue(state);
}

