/**********************************************************************

  bitmap.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "bitmap.h"
#include "mask.h"
#include "image.h"

VALUE
WxBitmap::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxBitmap::init(int argc, VALUE *argv, VALUE self)
{
    wxBitmap *ptr;
    Data_Get_Struct(self, wxBitmap, ptr);
    if(TYPE(argv[0])==T_FIXNUM) {
        int width = NUM2INT(argv[0]);
        int height = NUM2INT(argv[1]);
        int depth = -1;
        if(argc>2) depth = NUM2INT(argv[2]);
        ptr = new wxBitmap(width,height,depth);
    } else if(TYPE(argv[0])==T_DATA && strstr(rb_class2name(CLASS_OF(argv[0])),"Image")) {
        wxImage *image;
        int depth = -1;
        Data_Get_Struct(argv[0], wxImage, image);
        if(argc>1) depth = NUM2INT(argv[1]);
        ptr = new wxBitmap(*image,depth);
    } else if(TYPE(argv[0])==T_DATA) {
        wxBitmap *bmp;
        Data_Get_Struct(argv[0], wxBitmap, bmp);
        ptr = new wxBitmap(*bmp);
    } else {
        wxString name = StringValuePtr(argv[0]);
        wxBitmapType type;
        if(argc>1 && TYPE(argv[1])==T_FIXNUM)
          type = (wxBitmapType)NUM2INT(argv[1]);
        else if(strstr(StringValuePtr(argv[0]),".xpm"))
          type = wxBITMAP_TYPE_XPM;
        else if(strstr(StringValuePtr(argv[0]),".ico"))
          type = wxBITMAP_TYPE_ICO;
        ptr = new wxBitmap(name,type);
    }
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxBitmap::init0(const wxBitmap &bitmap)
{
    extern VALUE rb_cWxBitmap;
    VALUE self = Data_Wrap_Struct(rb_cWxBitmap, 0, 0, 0);
    if(bitmap==wxNullBitmap)
      DATA_PTR(self) = &wxNullBitmap;
    else
      DATA_PTR(self) = new wxBitmap(bitmap);
    return self;
}

VALUE
WxBitmap::GetWidth(VALUE self)
{
    wxBitmap *ptr;
    Data_Get_Struct(self, wxBitmap, ptr);
    return INT2NUM(ptr->GetWidth());
}

VALUE
WxBitmap::GetHeight(VALUE self)
{
    wxBitmap *ptr;
    Data_Get_Struct(self, wxBitmap, ptr);
    return INT2NUM(ptr->GetHeight());
}

VALUE
WxBitmap::Ok(VALUE self)
{
    wxBitmap *ptr;
    Data_Get_Struct(self, wxBitmap, ptr);
    return (ptr->Ok() ? Qtrue : Qfalse);
}

void
WxBitmap::SetMask(VALUE self,VALUE vmask)
{
    wxMask* mask;
    Data_Get_Struct(vmask, wxMask, mask);
    wxBitmap *ptr;
    Data_Get_Struct(self, wxBitmap, ptr);
    ptr->SetMask(mask);
}

VALUE
WxBitmap::GetMask(VALUE self)
{
    wxBitmap *ptr;
    Data_Get_Struct(self, wxBitmap, ptr);
    return WxMask::init0(ptr->GetMask());
}

VALUE
WxBitmap::ConvertToImage(VALUE self)
{
    wxBitmap *ptr;
    Data_Get_Struct(self, wxBitmap, ptr);
    wxImage *image = new wxImage(ptr->ConvertToImage());
    return WxImage::init0(*image);
}

//--------------------------------------------------------------------------------
VALUE
WxStaticBitmap::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxStaticBitmap::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow* parent = NULL;
    wxWindowID id;
    wxBitmap label;
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    long style = 0;
    wxString name = "staticBitmap";

    if(argc>0 && TYPE(argv[0])==T_DATA) {
	    Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
        id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_DATA) {
        wxBitmap *ptr;
	    Data_Get_Struct(argv[2], wxBitmap, ptr);
	    label = *ptr;
    }
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxPoint *ptr;
	    Data_Get_Struct(argv[3], wxPoint, ptr);
	    pos = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_DATA) {
        wxSize *ptr;
	    Data_Get_Struct(argv[4], wxSize, ptr);
	    size = *ptr;
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
        style = NUM2INT(argv[5]);
    if(argc>6 && TYPE(argv[6])==T_STRING)
        name = wxString(StringValuePtr(argv[6]));

    wxStaticBitmap *ptr;
    Data_Get_Struct(self, wxStaticBitmap, ptr);
    ptr = new wxStaticBitmap(parent,id,label,pos,size,style,name);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

void
WxStaticBitmap::SetBitmap(VALUE self,VALUE vlabel)
{
    wxBitmap *label;
    Data_Get_Struct(vlabel, wxBitmap, label);
    wxStaticBitmap *ptr;
    Data_Get_Struct(self, wxStaticBitmap, ptr);
    ptr->SetBitmap(*label);
}

