/**********************************************************************

  app.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:46 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#if defined(__cplusplus)
extern "C" {
#endif
#include "intern.h"
#include "rubysig.h"
#if defined(__cplusplus)
}
#endif
#include "app.h"

BEGIN_EVENT_TABLE(wxRbApp, wxEvtHandler)
    EVT_IDLE(wxRbApp::OnIdle)
END_EVENT_TABLE()

int  wxEntryInitGui();

bool wxRbApp::OnInit()
{
    wxApp::OnInit();
    return FALSE;
}

void wxRbApp::OnIdle(wxIdleEvent& event)
{
    struct timeval wait;

    wait.tv_sec  = 0;
    wait.tv_usec = 100000; /* 100ms */

    CHECK_INTS;
    if (!rb_thread_critical) rb_thread_wait_for(wait);

    wxApp::OnIdle(event);
}

int wxRbApp::MainLoop()
{
    int retval = 0;

    DeletePendingObjects();
#ifdef __WXGTK__
    m_initialized = wxTopLevelWindows.GetCount() != 0;
#endif

    if( Initialized() )
    {
        if( m_exitOnFrameDelete == Later )
            m_exitOnFrameDelete = Yes;
        retval = wxApp::MainLoop();
        OnExit();
    }

    return retval;
}

int wxRbApp::OnExit()
{
  return wxApp::OnExit();
}

void
WxRbApp::free(wxRbApp *ptr)
{
    if (ptr) {
	delete(ptr);
    }
}

VALUE
WxRbApp::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, WxRbApp::free, 0);
}

VALUE
WxRbApp::init(VALUE self)
{
    extern VALUE rb_cRbApp;
    wxRbApp *ptr;

    Data_Get_Struct(self, wxRbApp, ptr);
    ptr = new wxRbApp();
    DATA_PTR(self) = ptr;
    rb_cRbApp = self;
    ptr->SetAppName("wxruby");

    wxEntryInitGui();
    if(rb_respond_to(self,rb_intern("OnInit")))
      rb_funcall(self,rb_intern("OnInit"),0);

    return self;
}


VALUE
WxRbApp::MainLoop(VALUE self)
{
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    return INT2NUM(ptr->MainLoop());
}

void
WxRbApp::SetTopWindow(VALUE self,VALUE vwin)
{
    wxWindow *win;
    Data_Get_Struct(vwin, wxWindow, win);
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    ptr->SetTopWindow(win);
}

VALUE
WxRbApp::GetAppName(VALUE self)
{
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    return rb_str_new2(ptr->GetAppName());
}

void
WxRbApp::SetAppName(VALUE self,VALUE vname)
{
    wxString name = StringValuePtr(vname);
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    ptr->SetAppName(name);
}

VALUE
WxRbApp::GetClassName(VALUE self)
{
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    return rb_str_new2(ptr->GetClassName());
}

void
WxRbApp::SetClassName(VALUE self,VALUE vname)
{
    wxString name = StringValuePtr(vname);
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    ptr->SetClassName(name);
}

VALUE
WxRbApp::GetVendorName(VALUE self)
{
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    return rb_str_new2(ptr->GetVendorName());
}

void
WxRbApp::SetVendorName(VALUE self,VALUE vname)
{
    wxString name = StringValuePtr(vname);
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    ptr->SetVendorName(name);
}

void
WxRbApp::Yield(VALUE self)
{
    wxRbApp *ptr;
    Data_Get_Struct(self, wxRbApp, ptr);
    ptr->Yield();
}
