/*
 * Decompiled with CFR 0.152.
 */
package lll.Loc;

import lll.Loc.Loc;
import lll.Loc.Rod;
import lll.Loc.Vec;

public class Tag {
    protected Rod keel;
    protected Loc star;
    protected Loc normal;
    protected float width;

    protected Tag() {
    }

    public Tag(Loc s, Loc b, Loc r) {
        this.keel = new Rod(s, b);
        Loc diff = r.sub(s);
        this.star = diff.unit();
        this.width = diff.norm();
        this.normal = this.star.cross(this.keel.fore);
    }

    public Tag(Loc s, Loc normal) {
        this.keel = new Rod(s, new Loc(s.y, s.z, s.x));
        this.star = normal.cross(this.keel.fore).unit();
        this.width = 1.0f;
        this.normal = normal;
    }

    public Tag(Tag frm) {
        this.keel = new Rod(frm.keel);
        this.star = new Loc(frm.star);
        this.width = frm.width;
        this.normal = new Loc(frm.normal);
    }

    public Object clone() {
        return new Tag(this);
    }

    public Loc at(float f, float s) {
        return this.keel.fore.mul(f).shift(this.star.mul(s)).shift(this.keel.stern);
    }

    public Tag move(Loc to) {
        this.keel.move(to);
        return this;
    }

    public Tag shift(Loc diff) {
        this.keel.shift(diff);
        return this;
    }

    public Tag shiftI(Loc diff) {
        this.keel.shiftI(diff);
        return this;
    }

    public Tag scale(float factor) {
        this.keel.scale(factor);
        this.width *= factor;
        return this;
    }

    public Tag scaleI(float factor) {
        this.keel.scaleI(factor);
        this.width /= factor;
        return this;
    }

    public Tag rotate(Loc ax, float angle) {
        this.star.rotate(ax, angle);
        this.keel.rotate(ax, angle);
        this.normal = this.star.cross(this.keel.fore);
        return this;
    }

    public Tag rotate(Rod ax, float angle) {
        this.star.rotate(ax.fore.sub(ax.stern), angle);
        this.keel.rotate(ax, angle);
        this.normal = this.star.cross(this.keel.fore);
        return this;
    }

    public Rod intersect(Tag to) {
        Loc dir = this.normal.cross(to.normal).unit();
        float d1 = -this.keel.stern.dot(this.normal);
        float d2 = -to.keel.stern.dot(to.normal);
        Loc p = new Loc(dir.z * (this.normal.y * d2 - to.normal.y * d1) - dir.y * (this.normal.z * d2 - to.normal.z * d1), dir.x * (this.normal.z * d2 - to.normal.z * d1) - dir.z * (this.normal.x * d2 - to.normal.x * d1), dir.y * (this.normal.x * d2 - to.normal.x * d1) - dir.x * (this.normal.y * d2 - to.normal.y * d1));
        return new Rod(p, dir.shift(p));
    }

    public float angle(Tag to) {
        return this.normal.angle(to.normal);
    }

    public Loc intersect(Rod ln) {
        float t = this.keel.stern().sub(ln.stern()).dot(this.normal) / ln.fore().dot(this.normal);
        return ln.at(t);
    }

    public Rod ortho(Loc pt) {
        float t = this.keel.stern.sub(pt).dot(this.normal);
        return new Rod(pt, this.normal.mul(t).shift(pt));
    }

    public float dist(Loc pt) {
        float t = this.keel.stern.sub(pt).dot(this.normal);
        return t;
    }

    public boolean having(Loc pt) {
        return (double)this.dist(pt) < Vec.ENOUGH_SMALL;
    }

    public float length() {
        return this.keel.length;
    }

    public Loc stern() {
        return this.keel.stern();
    }

    public Loc bow() {
        return this.keel.bow();
    }

    public Loc fore() {
        return this.keel.fore();
    }

    public float width() {
        return this.width;
    }

    public Loc starBoard() {
        return this.star.mul(this.width).shift(this.keel.stern);
    }

    public Loc star() {
        return new Loc(this.star);
    }

    public Rod keel() {
        return new Rod(this.keel);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Tag)) {
            return false;
        }
        Tag m = (Tag)object;
        if (!this.keel.equals(m.keel)) {
            return false;
        }
        if (!this.star.equals(m.star)) {
            return false;
        }
        return this.normal.equals(m.normal);
    }

    public String toString() {
        return "Tag[" + this.keel.stern + " - " + this.bow() + " | " + this.starBoard() + "]";
    }
}

