/*
 * Decompiled with CFR 0.152.
 */
package lll.Loc;

import lll.Loc.Loc;
import lll.Loc.Rod;
import lll.Loc.Tag;

public class Ship {
    protected Loc bridge;
    protected float height;
    protected Tag sea;

    public Ship(Loc s, Loc b, Loc r, Loc h) {
        this.sea = new Tag(s, b, r);
        Loc diff = h.sub(s);
        this.bridge = diff.unit();
        this.height = diff.norm();
    }

    public Ship(Tag frm, Loc h) {
        this.sea = new Tag(frm);
        this.bridge = new Loc(h);
        this.height = this.bridge.norm();
    }

    public Ship(Ship frm) {
        this.sea = new Tag(frm.sea);
        this.bridge = new Loc(frm.bridge);
        this.height = this.bridge.norm();
    }

    public Object clone() {
        return new Ship(this);
    }

    public Loc at(float f, float s, float h) {
        return this.sea.keel.fore.mul(f).shift(this.sea.star.mul(s)).shift(this.bridge.mul(h)).shift(this.sea.keel.stern);
    }

    public Ship move(Loc to) {
        this.sea.keel.move(to);
        return this;
    }

    public Ship shift(Loc diff) {
        this.sea.keel.shift(diff);
        return this;
    }

    public Ship shiftI(Loc diff) {
        this.sea.keel.shiftI(diff);
        return this;
    }

    public Ship scale(float factor) {
        this.sea.keel.scale(factor);
        this.sea.width *= factor;
        return this;
    }

    public Ship scaleI(float factor) {
        this.sea.keel.scaleI(factor);
        this.sea.width /= factor;
        return this;
    }

    public Ship rotate(Loc ax, float angle) {
        this.bridge.rotate(ax, angle);
        this.sea.rotate(ax, angle);
        return this;
    }

    public Ship rotate(Rod ax, float angle) {
        this.bridge.rotate(ax.fore.sub(ax.stern), angle);
        this.sea.rotate(ax, angle);
        return this;
    }

    public float length() {
        return this.sea.keel.length;
    }

    public float width() {
        return this.sea.width;
    }

    public float height() {
        return this.height;
    }

    public Loc stern() {
        return this.sea.keel.stern();
    }

    public Loc bow() {
        return this.sea.bow();
    }

    public Loc starBoard() {
        return this.sea.starBoard();
    }

    public Loc bridgeTop() {
        return this.bridge.mul(this.height).shift(this.sea.keel.stern);
    }

    public Loc fore() {
        return this.sea.keel.fore();
    }

    public Loc star() {
        return this.sea.star();
    }

    public Loc up() {
        return new Loc(this.bridge);
    }

    public Rod keel() {
        return this.sea.keel();
    }

    public Tag sea() {
        return new Tag(this.sea);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Ship)) {
            return false;
        }
        Ship m = (Ship)object;
        if (Float.floatToIntBits(this.sea.keel.length) != Float.floatToIntBits(m.sea.keel.length)) {
            return false;
        }
        if (!this.sea.equals(m.sea)) {
            return false;
        }
        return this.bridge.equals(m.bridge);
    }

    public String toString() {
        return "Ship[" + this.sea.keel.stern + " - " + this.bow() + "|" + this.starBoard() + "|" + this.bridge + "]";
    }
}

