/*
 * Decompiled with CFR 0.152.
 */
package lll.Loc;

public class Loc {
    public float x;
    public float y;
    public float z;
    public double TOL = 1.0E-5;

    public Loc() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Loc(float lx, float ly, float lz) {
        this.x = lx;
        this.y = ly;
        this.z = lz;
    }

    public Loc(Loc l) {
        this.x = l.x;
        this.y = l.y;
        this.z = l.z;
    }

    public Loc(float lng, float ltt) {
        float clt = (float)Math.cos(ltt);
        float slt = (float)Math.sin(ltt);
        float cln = (float)Math.cos(lng);
        float sln = (float)Math.sin(lng);
        this.x = cln * clt;
        this.y = cln * slt;
        this.z = sln;
    }

    static Loc newLoc(float x, float y, float z) {
        return new Loc(x, y, z);
    }

    static Loc newPolar(float r, float lng, float ltt) {
        float clt = (float)Math.cos(ltt);
        float slt = (float)Math.sin(ltt);
        float cln = (float)Math.cos(lng);
        float sln = (float)Math.sin(lng);
        return new Loc(r * cln * clt, r * cln * slt, r * sln);
    }

    public Loc movePolar(float r, float lng, float ltt) {
        float clt = (float)Math.cos(ltt);
        float slt = (float)Math.sin(ltt);
        float cln = (float)Math.cos(lng);
        float sln = (float)Math.sin(lng);
        this.x = r * cln * clt;
        this.y = r * cln * slt;
        this.z = r * sln;
        return this;
    }

    public Loc shiftPolar(float r, float lng, float ltt) {
        float clt = (float)Math.cos(ltt);
        float slt = (float)Math.sin(ltt);
        float cln = (float)Math.cos(lng);
        float sln = (float)Math.sin(lng);
        this.x += r * cln * clt;
        this.y += r * cln * slt;
        this.z += r * sln;
        return this;
    }

    public float longitude() {
        float r = this.norm();
        return (double)r > this.TOL ? (float)Math.asin(this.z / r) : 0.0f;
    }

    public float latitude() {
        return (double)Math.abs(this.x) > this.TOL ? (float)Math.atan2(this.y, this.x) : 0.0f;
    }

    public Loc getPolar() {
        return new Loc(this.norm(), this.longitude(), this.latitude());
    }

    public Loc getPolarDiff(Loc p) {
        return this.getPolar().shiftI(p.getPolar());
    }

    public Loc getPolarDiff(float tx, float ty, float tz) {
        return this.getPolarDiff(new Loc(tx, ty, tz));
    }

    public boolean isWithin(Loc another, float tol) {
        if (Math.abs(this.x - another.x) > tol) {
            return false;
        }
        if (Math.abs(this.y - another.y) > tol) {
            return false;
        }
        if (Math.abs(this.z - another.z) > tol) {
            return false;
        }
        return !(this.dist(another) > tol);
    }

    public Loc move(float dx, float dy, float dz) {
        this.x = dx;
        this.y = dy;
        this.z = dz;
        return this;
    }

    public Loc move(Loc pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        return this;
    }

    public Loc shift(float dx, float dy, float dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
        return this;
    }

    public Loc shift(Loc dlt) {
        this.x += dlt.x;
        this.y += dlt.y;
        this.z += dlt.z;
        return this;
    }

    public Loc scale(float fact) {
        this.x *= fact;
        this.y *= fact;
        this.z *= fact;
        return this;
    }

    public Loc scale(Loc fact) {
        this.x *= fact.x;
        this.y *= fact.y;
        this.z *= fact.z;
        return this;
    }

    public Loc shiftI(Loc dlt) {
        this.x -= dlt.x;
        this.y -= dlt.y;
        this.z -= dlt.z;
        return this;
    }

    public Loc scaleI(Loc fact) {
        this.x /= fact.x;
        this.y /= fact.y;
        this.z /= fact.z;
        return this;
    }

    public Loc scaleI(float fact) {
        this.x /= fact;
        this.y /= fact;
        this.z /= fact;
        return this;
    }

    public Loc rotate(Loc shaft, float angle) {
        float cs = (float)Math.cos(angle);
        float ic = 1.0f - cs;
        float sn = (float)Math.sin(angle);
        Loc sh = shaft.unit();
        float nx = this.x * (cs + ic * Loc.sq(sh.x)) + this.y * (ic * sh.y * sh.x + sn * sh.z) + this.z * (ic * sh.z * sh.x - sn * sh.y);
        float ny = this.x * (ic * sh.x * sh.y - sn * sh.z) + this.y * (cs + ic * Loc.sq(sh.y)) + this.z * (ic * sh.z * sh.y + sn * sh.x);
        float nz = this.x * (ic * sh.x * sh.z + sn * sh.y) + this.y * (ic * sh.y * sh.z - sn * sh.x) + this.z * (cs + ic * Loc.sq(sh.z));
        this.x = nx;
        this.y = ny;
        this.z = nz;
        return this;
    }

    public Loc rotate(float pan, float swing, float tilt) {
        float cp = (float)Math.cos(pan);
        float sp = (float)Math.sin(pan);
        float cs = (float)Math.cos(swing);
        float ss = (float)Math.sin(swing);
        float ct = (float)Math.cos(tilt);
        float st = (float)Math.sin(tilt);
        float nx = this.x * cs * ct + this.y * cs * st - this.z * ss;
        float ny = this.x * (st * ss * cp - ct * sp) + this.y * (st * ss * sp + ct * cp) + this.z * st * cs;
        float nz = this.x * (ct * ss * cp + st * sp) + this.y * (ct * ss * sp - st * cp) + this.z * ct * cs;
        this.x = nx;
        this.y = ny;
        this.z = nz;
        return this;
    }

    public Loc rotateZ(float pan) {
        float ct = (float)Math.cos(pan);
        float st = (float)Math.sin(pan);
        float nx = this.x * ct + this.y * st;
        float ny = -this.x * st + this.y * ct;
        this.x = nx;
        this.y = ny;
        return this;
    }

    public Loc rotateY(float swing) {
        float ct = (float)Math.cos(swing);
        float st = (float)Math.sin(swing);
        float nx = this.x * ct - this.z * st;
        float nz = this.x * st + this.z * ct;
        this.x = nx;
        this.z = nz;
        return this;
    }

    public Loc rotateX(float tilt) {
        float ct = (float)Math.cos(tilt);
        float st = (float)Math.sin(tilt);
        float ny = this.y * ct + this.z * st;
        float nz = -this.y * st + this.z * ct;
        this.y = ny;
        this.z = nz;
        return this;
    }

    public float dist(float tx, float ty, float tz) {
        return Loc.dist(this.x, this.y, this.z, tx, ty, tz);
    }

    public float dist(Loc loc) {
        return Loc.dist(this.x, this.y, this.z, loc.x, loc.y, loc.z);
    }

    public float dist0(Loc loc) {
        return Math.max(Math.max(Math.abs(this.x - loc.x), Math.abs(this.y - loc.y)), Math.abs(this.z - loc.z));
    }

    public float dist1(Loc loc) {
        return Math.abs(this.x - loc.x) + Math.abs(this.y - loc.y) + Math.abs(this.z - loc.z);
    }

    public float dist2(Loc loc) {
        return (this.x - loc.x) * (this.x - loc.x) + (this.y - loc.y) * (this.y - loc.y) + (this.z - loc.z) * (this.z - loc.z);
    }

    protected Object clone() {
        return new Loc(this.x, this.y, this.z);
    }

    public Loc add(Loc off) {
        return this.add(off.x, off.y, off.z);
    }

    public Loc add(float dx, float dy, float dz) {
        return new Loc(this.x + dx, this.y + dy, this.z + dz);
    }

    public Loc sub(Loc off) {
        return this.sub(off.x, off.y, off.z);
    }

    public Loc sub(float dx, float dy, float dz) {
        return new Loc(this.x - dx, this.y - dy, this.z - dz);
    }

    public Loc inv() {
        return new Loc(-this.x, -this.y, -this.z);
    }

    public Loc mul(float fact) {
        return new Loc(this.x * fact, this.y * fact, this.z * fact);
    }

    public Loc mul(Loc fact) {
        return new Loc(this.x * fact.x, this.y * fact.y, this.z * fact.z);
    }

    public Loc div(float fact) {
        return new Loc(this.x / fact, this.y / fact, this.z / fact);
    }

    public Loc div(Loc fact) {
        return new Loc(this.x / fact.x, this.y / fact.y, this.z / fact.z);
    }

    public Loc projection(Loc dx, Loc dy, Loc dz) {
        return new Loc(this.dot(dx), this.dot(dy), this.dot(dz));
    }

    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float norm0() {
        return Math.max(Math.max(Math.abs(this.x), Math.abs(this.y)), Math.abs(this.z));
    }

    public float norm1() {
        return Math.abs(this.x) + Math.abs(this.y) + Math.abs(this.z);
    }

    public float innerP(Loc l) {
        return this.dot(l);
    }

    public float dot(Loc to) {
        return this.x * to.x + this.y * to.y + this.z * to.z;
    }

    public float cosine(Loc l) {
        float norm2 = this.norm() * l.norm();
        return (double)norm2 < this.TOL ? 1.0f : this.dot(l) / norm2;
    }

    public float angle(Loc l) {
        return (float)Math.acos(this.cosine(l));
    }

    public float antiClockwiseAngle(Loc l) {
        double ang = Math.acos(this.cosine(l));
        float x = l.dot(this.cross(l).cross(this));
        return (float)((double)Math.abs(x) < this.TOL ? 0.0 : (x > 0.0f ? ang : Math.PI * 2 - ang));
    }

    public float angle(float tx, float ty, float tz) {
        return (float)Math.acos(this.cosine(new Loc(tx, ty, tz)));
    }

    public Loc outerP(Loc l) {
        return this.cross(l);
    }

    public Loc cross(Loc to) {
        return new Loc(this.y * to.z - this.z * to.y, this.z * to.x - this.x * to.z, this.x * to.y - this.y * to.x);
    }

    public Loc unit() {
        float nr = this.norm();
        return (double)nr < this.TOL ? new Loc(this) : this.div(nr);
    }

    public Loc dir(Loc l) {
        return l.sub(this).unit();
    }

    public Loc ortho(Loc l) {
        return l.sub(this.mul(this.innerP(l))).unit();
    }

    public Loc turned(Loc shaft, float angle) {
        return new Loc(this).rotate(shaft, angle);
    }

    public Loc turned(float pan, float swing, float tilt) {
        return new Loc(this).rotate(pan, swing, tilt);
    }

    public Loc turnedZ(float pan) {
        return new Loc(this).rotateZ(pan);
    }

    public Loc turnedY(float swing) {
        return new Loc(this).rotateY(swing);
    }

    public Loc turnedX(float tilt) {
        return new Loc(this).rotateX(tilt);
    }

    public boolean isSameGrid(Loc to) {
        return Math.round(this.x) == Math.round(to.x) && Math.round(this.y) == Math.round(to.y) && Math.round(this.z) == Math.round(to.z);
    }

    public boolean isEqualTo(Loc to) {
        return this.x == to.x && this.y == to.y && this.z == to.z;
    }

    public boolean isNearTo(Loc to) {
        return (double)this.dist(to) < this.TOL;
    }

    public boolean isNearTo(Loc to, float tol) {
        return this.dist(to) < tol;
    }

    public boolean isNearTo(int toX, int toY) {
        return (double)this.dist(toX, toY, 0.0f) < this.TOL;
    }

    public boolean isNearTo(int toX, int toY, float tol) {
        return this.dist(toX, toY, 0.0f) < tol;
    }

    public boolean isNear1To(Loc to) {
        return (double)this.dist1(to) < this.TOL;
    }

    public boolean isNear1To(Loc to, float tol) {
        return this.dist1(to) < tol;
    }

    public int whichDir(Loc to) {
        float t = this.cosine(to);
        return Math.abs(1.0 - (double)Math.abs(t)) > this.TOL ? 0 : (t > 0.0f ? 1 : -1);
    }

    private static float dist(float x0, float y0, float z0, float x1, float y1, float z1) {
        return (float)Math.sqrt((x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1) + (z0 - z1) * (z0 - z1));
    }

    private static float sq(float x) {
        return x * x;
    }

    public String toString() {
        return "Loc(" + this.x + "," + this.y + "," + this.z + ") ";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Loc)) {
            return false;
        }
        Loc m = (Loc)object;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(m.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(m.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(m.z);
    }
}

