/*
 * Decompiled with CFR 0.152.
 */
package lll.Loc;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import lll.Loc.Mat;
import lll.Loc.Vec;

public abstract class EqSys {
    protected int dom;
    protected int rng;

    int domDim() {
        return this.dom;
    }

    int rngDim() {
        return this.rng;
    }

    public EqSys(int dom, int rng) {
        this.dom = dom;
        this.rng = rng;
    }

    public abstract Vec valueAt(Vec var1);

    public abstract Mat jacobAt(Vec var1);

    public Mat diffAt(Vec x, Vec d) {
        if (x.length() != d.length()) {
            return Mat.NaN.copy();
        }
        Mat ret = new Mat(this.dom, this.rng);
        double[][] retRef = ret.arrayRef();
        double[] xRef = x.arrayRef();
        double[] dRef = d.arrayRef();
        Vec b = this.valueAt(x);
        int i = 0;
        while (i < this.dom) {
            double bk = xRef[i];
            int n = i;
            xRef[n] = xRef[n] + dRef[i];
            int j = 0;
            while (j < this.rng) {
                retRef[i] = this.valueAt(x).sub(b).div(d).arrayRef();
                ++j;
            }
            xRef[i] = bk;
            ++i;
        }
        return ret;
    }

    public Vec solveByNewton(Vec x0) {
        Vec dlt;
        Vec xk = new Vec(x0);
        Vec dltOld = new Vec(Double.MAX_VALUE, this.dom);
        while (!((dlt = this.jacobAt(xk).inverse().operate(this.valueAt(xk))).isNaN() || dlt.dist(dltOld) < Vec.ENOUGH_SMALL || dlt.norm() < Vec.ENOUGH_SMALL)) {
            dltOld = dlt;
            xk = xk.sub(dlt);
        }
        return dlt.isNaN() ? Vec.NaN.copy() : xk;
    }

    public Vec solveBySimplex(Vec x0, int limit) {
        SimplexMethod smplx = new SimplexMethod(this);
        SimplexMethod.Vertices vv = smplx.minimize(limit, x0, x0.add(1.0).mul(-1.0));
        return vv.getPoint();
    }

    public Vec solveBySimplex(Vec x0, int limit, int trial) {
        SimplexMethod smplx = new SimplexMethod(this);
        SimplexMethod.Vertices vv = smplx.minimize(limit, x0, x0.add(1.0).mul(-1.0), trial, (long)(9.223372036854776E18 * Math.random()));
        return vv.getPoint();
    }

    protected class SimplexMethod {
        private double rho;
        private double khi;
        private double gamma;
        private double sigma;
        protected Vertices[] simplex;
        protected Vertices[] prevStartSimplex;
        private int evaluations;
        private int starts;
        private EqSys eqSys;
        private Random rgen = new Random();
        private Vertices[] minima;
        private Comparator VerticesComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                double cost2;
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                if (o2 == null) {
                    return -1;
                }
                double cost1 = ((Vertices)o1).getCost();
                return cost1 < (cost2 = ((Vertices)o2).getCost()) ? -1 : (o1 == o2 ? 0 : 1);
            }
        };

        protected double evaluateCost(Vec x) {
            ++this.evaluations;
            return this.eqSys.valueAt(x).norm();
        }

        private boolean converged(Vertices[] simplex) {
            Vertices smallest = simplex[0];
            Vertices largest = simplex[simplex.length - 1];
            return largest.getCost() - smallest.getCost() < Vec.TOO_SMALL;
        }

        public SimplexMethod(EqSys eqs) {
            this.eqSys = eqs;
            this.rho = 1.0;
            this.khi = 2.0;
            this.gamma = 0.5;
            this.sigma = 0.5;
        }

        protected void iterateSimplex() {
            int j;
            int n = this.simplex.length - 1;
            double smallest = this.simplex[0].getCost();
            double secondLargest = this.simplex[n - 1].getCost();
            double largest = this.simplex[n].getCost();
            Vec xLargest = this.simplex[n].getPoint();
            Vec centroid = new Vec(n);
            double[] cent = centroid.arrayRef();
            int i = 0;
            while (i < n) {
                Vec x = this.simplex[i].getPoint();
                j = 0;
                while (j < n) {
                    int n2 = j;
                    cent[n2] = cent[n2] + x.elem(j);
                    ++j;
                }
                ++i;
            }
            double scaling = 1.0 / (double)n;
            j = 0;
            while (j < n) {
                int n3 = j++;
                cent[n3] = cent[n3] * scaling;
            }
            Vec xR = new Vec(n);
            double[] xRR = xR.arrayRef();
            int j2 = 0;
            while (j2 < n) {
                xRR[j2] = cent[j2] + this.rho * (cent[j2] - xLargest.elem(j2));
                ++j2;
            }
            double costR = this.evaluateCost(xR);
            if (smallest <= costR && costR < secondLargest) {
                this.replaceWorstPoint(new Vertices(xR, costR));
            } else if (costR < smallest) {
                Vec xE = new Vec(n);
                double[] xER = xE.arrayRef();
                int j3 = 0;
                while (j3 < n) {
                    xER[j3] = cent[j3] + this.khi * (xRR[j3] - cent[j3]);
                    ++j3;
                }
                double costE = this.evaluateCost(xE);
                if (costE < costR) {
                    this.replaceWorstPoint(new Vertices(xE, costE));
                } else {
                    this.replaceWorstPoint(new Vertices(xR, costR));
                }
            } else {
                double costC;
                double[] xCR;
                Vec xC;
                if (costR < largest) {
                    xC = new Vec(n);
                    xCR = xC.arrayRef();
                    int j4 = 0;
                    while (j4 < n) {
                        xCR[j4] = cent[j4] + this.gamma * (xRR[j4] - cent[j4]);
                        ++j4;
                    }
                    costC = this.evaluateCost(xC);
                    if (costC <= costR) {
                        this.replaceWorstPoint(new Vertices(xC, costC));
                        return;
                    }
                } else {
                    xC = new Vec(n);
                    xCR = xC.arrayRef();
                    int j5 = 0;
                    while (j5 < n) {
                        xCR[j5] = cent[j5] - this.gamma * (cent[j5] - xLargest.elem(j5));
                        ++j5;
                    }
                    costC = this.evaluateCost(xC);
                    if (costC < largest) {
                        this.replaceWorstPoint(new Vertices(xC, costC));
                        return;
                    }
                }
                Vec xSmallest = this.simplex[0].getPoint();
                int i2 = 1;
                while (i2 < this.simplex.length) {
                    Vec x = this.simplex[i2].getPoint();
                    double[] xxR = x.arrayRef();
                    int j6 = 0;
                    while (j6 < n) {
                        xxR[j6] = xSmallest.elem(j6) + this.sigma * (xxR[j6] - xSmallest.elem(j6));
                        ++j6;
                    }
                    this.simplex[i2] = new Vertices(x, Double.NaN);
                    ++i2;
                }
                this.evaluateSimplex();
            }
        }

        public Vertices minimize(int maxEvaluations, Vec vertexA, Vec vertexB) {
            this.buildSimplex(vertexA, vertexB);
            this.setSingleStart();
            return this.minimize(maxEvaluations);
        }

        public Vertices minimize(int maxEvaluations, Vec vertexA, Vec vertexB, int starts, long seed) {
            this.buildSimplex(vertexA, vertexB);
            this.rgen.setSeed(seed);
            this.setMultiStart(starts);
            return this.minimize(maxEvaluations);
        }

        private void buildSimplex(Vec vertexA, Vec vertexB) {
            int n = vertexA.length();
            this.simplex = new Vertices[n + 1];
            int i = 0;
            while (i <= n) {
                Vec vertex = new Vec(n);
                if (i > 0) {
                    System.arraycopy(vertexB.arrayRef(), 0, vertex.arrayRef(), 0, i);
                }
                if (i < n) {
                    System.arraycopy(vertexA.arrayRef(), i, vertex.arrayRef(), i, n - i);
                }
                this.simplex[i] = new Vertices(vertex, Double.NaN);
                ++i;
            }
            this.prevStartSimplex = (Vertices[])this.simplex.clone();
        }

        private void buildAnotherSimplex() {
            int n = this.prevStartSimplex[0].getPoint().length();
            Vec point = new Vec(n);
            double[] pRef = point.arrayRef();
            this.simplex = new Vertices[n + 1];
            int j = 0;
            while (j < n) {
                pRef[j] = (1.0 + this.rgen.nextDouble() - 0.5) * this.prevStartSimplex[0].getPoint().elem(j);
                ++j;
            }
            this.simplex[0] = new Vertices(point, Double.NaN);
            int i = 1;
            while (i <= n) {
                int j2 = 0;
                while (j2 < n) {
                    pRef[j2] = (1.0 + this.rgen.nextDouble() - 0.5) * this.prevStartSimplex[i].getPoint().elem(j2);
                    ++j2;
                }
                this.simplex[i] = new Vertices(point, Double.NaN);
                ++i;
            }
        }

        private void setSingleStart() {
            this.starts = 1;
            this.minima = null;
        }

        private void setMultiStart(int starts) {
            if (starts < 2) {
                this.starts = 1;
                this.minima = null;
            } else {
                this.starts = starts;
                this.minima = null;
            }
        }

        public Vertices[] getMinima() {
            return (Vertices[])this.minima.clone();
        }

        private Vertices minimize(int maxEvaluations) {
            this.minima = new Vertices[this.starts];
            int i = 0;
            while (i < this.starts) {
                this.evaluations = 0;
                this.evaluateSimplex();
                boolean loop = true;
                while (loop) {
                    if (this.converged(this.simplex)) {
                        this.minima[i] = this.simplex[0];
                        loop = false;
                        continue;
                    }
                    if (this.evaluations >= maxEvaluations) {
                        this.minima[i] = null;
                        loop = false;
                        continue;
                    }
                    this.iterateSimplex();
                }
                if (i < this.starts - 1) {
                    this.buildAnotherSimplex();
                }
                ++i;
            }
            Arrays.sort(this.minima, this.VerticesComparator);
            if (this.minima[0] == null) {
                return new Vertices(Vec.NaN.copy(), Double.NaN);
            }
            return this.minima[0];
        }

        protected void evaluateSimplex() {
            int i = 0;
            while (i < this.simplex.length) {
                Vertices pair = this.simplex[i];
                if (Double.isNaN(pair.getCost())) {
                    this.simplex[i] = new Vertices(pair.getPoint(), this.evaluateCost(pair.getPoint()));
                }
                ++i;
            }
            Arrays.sort(this.simplex, this.VerticesComparator);
        }

        protected void replaceWorstPoint(Vertices vertices) {
            int n = this.simplex.length - 1;
            int i = 0;
            while (i < n) {
                if (this.simplex[i].getCost() > vertices.getCost()) {
                    Vertices tmp = this.simplex[i];
                    this.simplex[i] = vertices;
                    vertices = tmp;
                }
                ++i;
            }
            this.simplex[n] = vertices;
        }

        public class Vertices {
            private final Vec point;
            private final double cost;

            public Vertices(Vec point, double cost) {
                this.point = point.copy();
                this.cost = cost;
            }

            public Vec getPoint() {
                return this.point.copy();
            }

            public double getCost() {
                return this.cost;
            }
        }
    }
}

