import lll.Loc.*;
//model of equation, tj^2 - 2*cij*tj*ti + ti^2 - Lij^2 = 0
public class Triangular extends EqSys {
	private double[] l2ij;
	private double[] cij;
	public Triangular(double[] l2, double[] c) {
		super(3,3);
		l2ij = l2;
		cij = c;
	}
	public Vec valueAt(Vec t) {	// fij(t) = tj^2 - 2*cij*tj*ti + ti^2 - Lij^2
		return new Vec(new double[]{
			t.elem(0) * (t.elem(0)-2*cij[0]*t.elem(1)) + t.elem(1)*t.elem(1) - l2ij[0],
			t.elem(1) * (t.elem(1)-2*cij[1]*t.elem(2)) + t.elem(2)*t.elem(2) - l2ij[1],
			t.elem(2) * (t.elem(2)-2*cij[2]*t.elem(0)) + t.elem(0)*t.elem(0) - l2ij[2]});
	}
	public Mat jacobAt(Vec t) {	// Jacobian of f(X)={f0(X), f1(X), f2(X)}
		double[][] jacobi =	{
// { {		dxf0(X),						 dyf0(X),						 dzf0(X)}
	{2*t.elem(0)-2*cij[0]*t.elem(1), -2*cij[0]*t.elem(0)+2*t.elem(1),			0		  },
//   {		dxf1(X),						 dyf1(X),						 dzf1(X)}
	{		0,			2*t.elem(1)-2*cij[1]*t.elem(2),    -2*cij[1]*t.elem(1)+2*t.elem(2)},
//   {		dxf2(X),						 dyf2(X),						 dzf2(X)} }
	{-2*cij[2]*t.elem(2)+2*t.elem(0),			0,		  2*t.elem(2)-2*cij[2]*t.elem(0)    } };
		return new Mat(jacobi);
	}
	public Mat gradParamAt(Vec x) {
		return Mat.NaN.copy();
	}
}
