//
//  Beta Test for Vfunc, EqSys, Mat, Vec, and their solver methods.
//    5. multi-value nonlinear equation test
//		<Formulation@for 3D triangulation with two wiiremotes>
//		 [Pi]Fthe i-th reference point
//		and
//		 |[Pj-Pi]|=Lij, (i!=j)
//		and
//		@[di]Fthe directional vector to [Pi]
//		then each reference point is on the line
//		 [Pi]=ti*[di]
//		and
//		 Lij^2 = ([Pj]-{Pi])*(same)
//			   = (tj*dj-ti*di)*(same)
//			   = tj^2 - 2*tj*ti*([dj]*[di]) +ti^2
//		let cij=([dj]*[di]), then we get the followings
//		@tj^2 - 2*cij*tj*ti + ti^2 - Lij^2 = 0
//@UD`PAW̐
//@VD`AW̐
//@WD`֐̊ϑɊÂp[^
//  Created by Classiclll on 06/03/19.
//

import lll.Loc.*;
import processing.core.*;

public class TestImpl extends PApplet {
	
	static final long serialVersionUID = 1;

	public void setup() {

// 5. multi-value nonlinear equation test
	  //	<Formulation@for 3D triangulation with two wiiremotes>
	  //		 [Pi]Fthe i-th reference point
	  Loc[] pts
	  	= new Loc[]{new Loc(.2f,.5f,.1f), new Loc(.12f,.44f,.2f), new Loc(.6f,.3f,.4f)};
	  //		 |[Pj-Pi]|=Lij, (i!=j)
	  double[] l2ij
	  	= new double[]{pts[0].dist2(pts[1]), pts[0].dist2(pts[2]), pts[1].dist2(pts[2])};
	  //		@[di]Fthe directional vector to [Pi]
	  Loc[] dir = new Loc[]{pts[0].unit(), pts[1].unit(), pts[2].unit()};
	  //		then each reference point is on the line
	  //		     [Pi]=ti*[di]
	  //		let cij=([dj]*[di]), then we get the followings
	  double[] cij
	  	= new double[]{dir[0].dot(dir[1]), dir[0].dot(dir[2]), dir[1].dot(dir[2])};
	  //		@tj^2 - 2*cij*tj*ti + ti^2 - Lij^2 = 0
	  Triangular trig = new Triangular(l2ij,cij);
	  Vec x0 = new Vec(new double[]{1,1,1});
	  Vec root;

	  println("[ nonlinear equation system Test ]");
	  println(">>by Newton\n"+ trig.jacobAt(x0));
	  println(">>by Newton\n"+ (root=trig.solveByNewton(x0)));
	  println(">>   F(x) = "+ trig.valueAt(root));
	  println(">>by Simplex\n"+ (root=trig.solveBySimplex(x0,1000)));
	  println(">>   F(x) = "+ trig.valueAt(root));

// 6. estimate uni-variated linear regression coeficient, ax+b
	  Vec obs = new Vec(100);
	  Mat samples = new Mat(100,1);
	  UniCorr f6 = new UniCorr(); // f1(x) = ax + b
	  Vec trueParam = new Vec(new double[]{3,5});
	  Vec p0 = new Vec(new double[]{10,10});
	  for (int i=0;i<100;i++) { // generate the random samples
		  double[] smpl = { (Math.random()-0.5)*100 };
		  samples.setRowVec(new Vec(smpl),i);
		  obs.arrayRef()[i]
		     = f6.valueAt(samples.rowVec(i), trueParam) + (Math.random()-0.5)*2;
	  }
	  
	  println("\n[ uni-variated regression Test ]");
	  println(">> f6(2,(3,5)), value of f1 at x=2,a=3,b=5 is  "
			  + f6.valueAt(new Vec(new double[]{2}), trueParam));
	  println(">>true param is" + trueParam);
	  println(">>estimated param by Newton "+f6.bestPrmByNewton(p0, obs, samples));
	  println(">>estimated param by Simplex "+f6.bestPrmBySimplex(p0, obs, samples, 1000));
  
//	 7. estimate multi-variated linear regression coeficient, ax+by+cz+d
	  obs = new Vec(100);
	  samples = new Mat(100,4);
	  MulCorr f7 = new MulCorr(); // f7(x) = ax + by + cz + d
	  trueParam = new Vec(new double[]{3,5,2,1});
	  for (int i=0;i<100;i++) { // generate the random samples
		  double[] smpl 
		  	= { (Math.random()-0.5)*100, (Math.random()-0.5)*100, (Math.random()-0.5)*100};
		  samples.setRowVec(new Vec(smpl),i);
		  obs.arrayRef()[i]
		     = f7.valueAt(samples.rowVec(i), trueParam) + (Math.random()-0.5)*1;
	  }
	  p0 = new Vec(new double[]{10,10,10,10});
  
	  println("\n[ multi-variated linear regression Test ]");
	  println(">> f7(1,1,1), value of f1 at x=1,y=1,z=1,a=3,b=5,c=2,d=1 is "
			  + f7.valueAt(new Vec(new double[]{1,1,1}), trueParam));
	  println(">>true param is" + trueParam);
	  println(">>estimated param by Newton "+f7.bestPrmByNewton(p0, obs, samples));
	  println(">>estimated param by Simplex "+f7.bestPrmBySimplex(p0, obs, samples, 2000));

//	 8. estimate multi-variated non-linear regression coeficient, 
//			f8(x) = a / (b + c^x + d^y) - modified Logistic curve 
	  obs = new Vec(100);
	  samples = new Mat(100,2);
	  ModifiedLogistic f8 = new ModifiedLogistic(); // f8(x) = a / (b + c^x + d^y)
	  trueParam = new Vec(new double[]{3,5,1});
	  for (int i=0;i<100;i++) { // generate the random samples
		  double[] smpl 
		  	= { (Math.random()-0.5)*5, (Math.random()-0.5)*5};
		  samples.setRowVec(new Vec(smpl),i);
		  obs.arrayRef()[i]
		     = f8.valueAt(samples.rowVec(i), trueParam) + (Math.random()-0.5)*1;
	  }
	  p0 = new Vec(new double[]{5,5,5});
	  
	  println("\n[ multi-variated non-linear regression Test ]");
	  println(">> f8(1,1), value of f1 at x=1,y=1,a=3,b=5,c=2,d=1 is "
			  + f8.valueAt(new Vec(new double[]{1}), trueParam));
	  println(">>true param is" + trueParam);
	  println(">>estimated param by Newton "+f8.bestPrmByNewton(p0, obs, samples));
	  println(">>estimated param by Simplex "+f8.bestPrmBySimplex(p0, obs, samples, 5000));

	} 
}