//
//  Alpha Test for Vfunc, EqSys, Mat, Vec, and their solver methods.
//@PDMatLU
//@QDꌳꎟ(2x-5=0)łVecAMat̉Vfunc(Newton/Simplex)̉̔r
//@RDꌳOix^3+3x^2+4x+2=0łVec̉Vfunc̉(Newton/Simplex)̔r
//@SDOꎟAiLjłMat̉EqSys̉(Newton/Simplex)̔r
//@@@ x+y+z-1=0 & y+z-1=0 & x+z-1=0
//  Created by Classiclll on 06/03/19.
//

import lll.Loc.*;
import processing.core.*;

public class TestImpl extends PApplet {
	
	static final long serialVersionUID = 1;

	public void setup() {
	// Mat test
	  Mat m = new Mat( new double[][] { {1,1,1}, {0,1,1}, {1,0,1} } );

	  println("[ Mat Test ]\n"+ m);
	  println(">>singularity\n"+ m.isSingular());
	  println(">>LU\n"+ m.luDecompose());
	  println(">>Inverce of m\n"+ m.inverse());
	  println(">>Identity check\n"+ m.inverse().mul(m));
	  println(">>counter Identity\n"+ m.mul(m.inverse()));

	// simple, first order linear equation, 2x-5=0
	  
	  Vec svec = new Vec(new double[]{2});
	  Mat smat = new Mat(new double[][]{{2}});
	  SimpleFunc simple = new SimpleFunc() ;//sample implementation of Vfunc
	  Vec x0 = new Vec(new double[]{3});
	  Vec k = new Vec(new double[]{5});

	  println("\n[ 1st order eq, 2x-5=0 ]");
	  println(">>DKA Method\n"+ svec.solve(5));
	  println(">>real only - DKA Method\n"+ svec.realRoots(5));
	  println(">>LU Method\n"+ smat.solve(k));
	  println(">>Newton Method\n"+ simple.solveByNewton(x0, null));
	  println(">>Simplex Method\n"+ simple.solveBySimplex(x0, null, 1000));
	  
	// Polynomial Equation test, sample implementation of Vfunc
	  
	  PolyFunc poly = new PolyFunc() ;		//sample implementation of Vfunc
	  Vec f = new Vec( new double[] {1,3,4} );

	  println("\n[ Polynomial equation, x^3+3x^2+4x+2=0 ]");
	  println(">>DKA Method of Vec\n"+ f.solve(-2));
	  println(">>real only - DKA Method\n"+ f.realRoots(-2));
	  println(">>Newton Method of Vfunc\n"+poly.solveByNewton(x0,null));
	  println(">>Simplex Method of Vfunc\n"+poly.solveBySimplex(x0,null,1000));

	// Linear Equation System test, sample implementation of EqSys
	  
	  LinearFunc linear = new LinearFunc() ;//sample implementation of EqSys
	  Vec x1 = new Vec(new double[]{0,1,1});
	  Vec b = new Vec(new double[]{1,1,1});

	  println("\n[ linear eqs, x+y+z-1=0 & y+z-1=0 & x+z-1=0 ]");
	  println(">>LU Method of Mat\n"+ m.solve(b));
	  println(">>NewtonMethod of EqSys\n"+linear.solveByNewton(x1));
	  println(">>SimplexMethod of EqSys\n"+linear.solveBySimplex(x1,1000));
	} 
}