import lll.Loc.*;

public class LinearFunc extends EqSys {
	public LinearFunc() {
		super(3,3);
	}
	public Vec valueAt(Vec x) {	// f(X) = { x+y+z-1, y+z-1, x+z-1 }
		double xx=x.elem(0), yy=x.elem(1), zz=x.elem(2);
		return new Vec(new double[]{xx+yy+zz-1, yy+zz-1, xx+zz-1});
	}
	public Mat jacobAt(Vec x) {	// Jacobian of f(X)={f0(X), f1(X), f2(X)}
		double[][] jacobi =	{ {1, 1, 1},		// { {dxf0(X), dyf0(X), dzf0(X)}
							  {0, 1, 1},		//   {dxf1(X), dyf1(X), dzf1(X)}
							  {1, 0, 1} };	//   {dxf2(X), dyf2(X), dzf2(X)} }
		return new Mat(jacobi);
	}
	public Mat gradParamAt(Vec x) {
		return Mat.NaN.copy();
	}
}
