/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.WrapperInfo;
import org.tanukisoftware.wrapper.WrapperJNIError;
import org.tanukisoftware.wrapper.WrapperLicenseError;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.WrapperProperties;
import org.tanukisoftware.wrapper.WrapperResources;
import org.tanukisoftware.wrapper.WrapperServiceException;
import org.tanukisoftware.wrapper.WrapperShuttingDownException;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;
import org.tanukisoftware.wrapper.WrapperUser;
import org.tanukisoftware.wrapper.WrapperWin32Service;
import org.tanukisoftware.wrapper.event.WrapperControlEvent;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.event.WrapperLogFileChangedEvent;
import org.tanukisoftware.wrapper.event.WrapperPingEvent;
import org.tanukisoftware.wrapper.event.WrapperSecondInvocationEvent;
import org.tanukisoftware.wrapper.event.WrapperServiceActionEvent;
import org.tanukisoftware.wrapper.event.WrapperServiceControlEvent;
import org.tanukisoftware.wrapper.event.WrapperServiceEvent;
import org.tanukisoftware.wrapper.event.WrapperServicePauseEvent;
import org.tanukisoftware.wrapper.event.WrapperServiceResumeEvent;
import org.tanukisoftware.wrapper.event.WrapperTickEvent;
import org.tanukisoftware.wrapper.jmx.WrapperManagerTesting;
import org.tanukisoftware.wrapper.security.WrapperEventPermission;
import org.tanukisoftware.wrapper.security.WrapperPermission;
import org.tanukisoftware.wrapper.security.WrapperServicePermission;
import org.tanukisoftware.wrapper.security.WrapperUserEventPermission;

public final class WrapperManager
implements Runnable {
    private static final String WRAPPER_CONNECTION_THREAD_NAME = "Wrapper-Connection";
    private static final int DEFAULT_PORT = 15003;
    private static final int DEFAULT_CPU_TIMEOUT = 10000;
    private static final int TICK_MS = 100;
    private static final int TIMER_FAST_THRESHOLD = 1728000;
    private static final int TIMER_SLOW_THRESHOLD = 1728000;
    private static final int BACKEND_TYPE_UNKNOWN = 0;
    private static final int BACKEND_TYPE_SOCKET_V4 = 1;
    private static final int BACKEND_TYPE_SOCKET_V6 = 2;
    private static final int BACKEND_TYPE_PIPE = 4;
    private static final byte WRAPPER_MSG_START = 100;
    private static final byte WRAPPER_MSG_STOP = 101;
    private static final byte WRAPPER_MSG_RESTART = 102;
    private static final byte WRAPPER_MSG_PING = 103;
    private static final byte WRAPPER_MSG_STOP_PENDING = 104;
    private static final byte WRAPPER_MSG_START_PENDING = 105;
    private static final byte WRAPPER_MSG_STARTED = 106;
    private static final byte WRAPPER_MSG_STOPPED = 107;
    private static final byte WRAPPER_MSG_KEY = 110;
    private static final byte WRAPPER_MSG_BADKEY = 111;
    private static final byte WRAPPER_MSG_LOW_LOG_LEVEL = 112;
    private static final byte WRAPPER_MSG_PING_TIMEOUT = 113;
    private static final byte WRAPPER_MSG_SERVICE_CONTROL_CODE = 114;
    private static final byte WRAPPER_MSG_PROPERTIES = 115;
    private static final byte WRAPPER_MSG_LOG = 116;
    private static final byte WRAPPER_MSG_CHILD_LAUNCH = -124;
    private static final byte WRAPPER_MSG_CHILD_TERM = -123;
    private static final byte WRAPPER_MSG_LOGFILE = -122;
    private static final byte WRAPPER_MSG_CHECK_DEADLOCK = -121;
    private static final byte WRAPPER_MSG_DEADLOCK = -120;
    private static final byte WRAPPER_MSG_APPEAR_ORPHAN = -119;
    private static final byte WRAPPER_MSG_PAUSE = -118;
    private static final byte WRAPPER_MSG_RESUME = -117;
    private static final byte WRAPPER_MSG_GC = -116;
    private static final byte WRAPPER_MSG_FIRE_USER_EVENT = -115;
    private static final byte WRAPPER_MSG_SECOND_INVOCATION_EVENT = -114;
    public static final int WRAPPER_CTRL_C_EVENT = 200;
    public static final int WRAPPER_CTRL_CLOSE_EVENT = 201;
    public static final int WRAPPER_CTRL_LOGOFF_EVENT = 202;
    public static final int WRAPPER_CTRL_SHUTDOWN_EVENT = 203;
    public static final int WRAPPER_CTRL_TERM_EVENT = 204;
    public static final int WRAPPER_CTRL_HUP_EVENT = 205;
    public static final int WRAPPER_CTRL_USR1_EVENT = 206;
    public static final int WRAPPER_CTRL_USR2_EVENT = 207;
    public static final int WRAPPER_LOG_LEVEL_DEBUG = 1;
    public static final int WRAPPER_LOG_LEVEL_INFO = 2;
    public static final int WRAPPER_LOG_LEVEL_STATUS = 3;
    public static final int WRAPPER_LOG_LEVEL_WARN = 4;
    public static final int WRAPPER_LOG_LEVEL_ERROR = 5;
    public static final int WRAPPER_LOG_LEVEL_FATAL = 6;
    public static final int WRAPPER_LOG_LEVEL_ADVICE = 7;
    public static final int WRAPPER_LOG_LEVEL_NOTICE = 8;
    public static final int SERVICE_CONTROL_CODE_START = 65536;
    public static final int SERVICE_CONTROL_CODE_STOP = 1;
    public static final int SERVICE_CONTROL_CODE_PAUSE = 2;
    public static final int SERVICE_CONTROL_CODE_CONTINUE = 3;
    public static final int SERVICE_CONTROL_CODE_INTERROGATE = 4;
    public static final int SERVICE_CONTROL_CODE_SHUTDOWN = 5;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_QUERYSUSPEND = 3328;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_QUERYSUSPENDFAILED = 3330;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_SUSPEND = 3332;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_RESUMECRITICAL = 3334;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_RESUMESUSPEND = 3335;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_BATTERYLOW = 3337;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_POWERSTATUSCHANGE = 3338;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_OEMEVENT = 3339;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_RESUMEAUTOMATIC = 3346;
    private static PrintStream m_out;
    private static PrintStream m_err;
    private static WrapperPrintStream m_outInfo;
    private static WrapperPrintStream m_outError;
    private static WrapperPrintStream m_outDebug;
    private static boolean m_windows;
    private static boolean m_macosx;
    private static boolean m_aix;
    private static boolean m_securityManagerChecked;
    private static boolean m_disposed;
    private static boolean m_starting;
    private static boolean m_started;
    private static WrapperManager m_instance;
    private static Thread m_hook;
    private static boolean m_hookTriggered;
    private static boolean m_hookRemoveFailed;
    private static boolean m_shutdownJVMComplete;
    private static Map m_shutdownLockMap;
    private static int m_shutdownLocks;
    private static int m_runningExecs;
    private static String[] m_args;
    private static int m_backendType;
    private static boolean m_backendConnected;
    private static OutputStream m_backendOS;
    private static InputStream m_backendIS;
    private static int m_port;
    private static int m_jvmPort;
    private static int m_jvmPortMin;
    private static int m_jvmPortMax;
    private static String m_wrapperPortAddress;
    private static String m_key;
    private static int m_soTimeout;
    private static long m_cpuTimeout;
    private static int m_startedTicks;
    private static int m_lowLogLevel;
    private static boolean m_ignoreSignals;
    private static boolean m_detachStarted;
    private static Thread m_commRunner;
    private static boolean m_commRunnerStarted;
    private static Thread m_eventRunner;
    private static int m_eventRunnerTicks;
    private static Thread m_startupRunner;
    private static boolean m_useSystemTime;
    private static int m_timerFastThreshold;
    private static int m_timerSlowThreshold;
    private static boolean m_disableTests;
    private static boolean m_listenerForceStop;
    private static int m_jvmBits;
    private static volatile int m_ticks;
    private static WrapperListener m_listener;
    private static int m_lastPingTicks;
    private static Socket m_backendSocket;
    private static boolean m_appearHung;
    private static int m_slowSeconds;
    private static boolean m_ignoreUserLogoffs;
    private static boolean m_service;
    private static boolean m_debug;
    private static boolean m_logFinalizer;
    private static int m_jvmId;
    private static boolean m_stoppingInit;
    private static boolean m_stopping;
    private static Thread m_stoppingThread;
    private static boolean m_stopped;
    private static String m_pendingStopMessage;
    private static int m_exitCode;
    private static boolean m_libraryOK;
    private static byte[] m_commandBuffer;
    private static File m_logFile;
    private static WrapperProperties m_properties;
    private static List m_wrapperEventListenerMaskList;
    private static WrapperEventListenerMask[] m_wrapperEventListenerMasks;
    private static boolean m_produceCoreEvents;
    private static WrapperResources m_res;
    private static boolean m_professionalEdition;
    private static boolean m_standardEdition;
    private static char PROPERTY_SEPARATOR;
    private static byte[] m_backendReadBuffer;

    public static WrapperResources getRes() {
        return m_res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logPackageInfo(Class clazz) {
        if (m_debug) {
            Package pkg = WrapperManager.class.getPackage();
            if (pkg == null) {
                m_outDebug.println(WrapperManager.getRes().getString("{0} package not found.", clazz.getName()));
            } else {
                m_outDebug.println(WrapperManager.getRes().getString("{0} package information:", clazz.getName()));
                m_outDebug.println(WrapperManager.getRes().getString("  Implementation Title: {0}", pkg.getImplementationTitle()));
                m_outDebug.println(WrapperManager.getRes().getString("  Implementation Vendor: {0}", pkg.getImplementationVendor()));
                m_outDebug.println(WrapperManager.getRes().getString("  Implementation Version: {0}", pkg.getImplementationVersion()));
                m_outDebug.println(WrapperManager.getRes().getString("  Is Sealed?: {0}", pkg.isSealed() ? WrapperManager.getRes().getString("True") : WrapperManager.getRes().getString("False")));
            }
            ProtectionDomain proDom = clazz.getProtectionDomain();
            m_outDebug.println(WrapperManager.getRes().getString("{0} protection domain:", clazz.getName()));
            CodeSource codeSource = proDom.getCodeSource();
            URL jarLocation = codeSource.getLocation();
            m_outDebug.println(WrapperManager.getRes().getString("  Location: {0}", jarLocation));
            try {
                InputStream is = jarLocation.openStream();
                try {
                    int data;
                    int jarSize = 0;
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    while ((data = is.read()) >= 0) {
                        ++jarSize;
                        md.update((byte)(data & 0xFF));
                    }
                    m_outDebug.println(WrapperManager.getRes().getString("    Size: {0}", new Integer(jarSize)));
                    byte[] bytes = md.digest();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < bytes.length; ++i) {
                        String val = Integer.toString(bytes[i] & 0xFF, 16).toLowerCase();
                        if (val.length() == 1) {
                            sb.append("0");
                        }
                        sb.append(val);
                    }
                    m_outDebug.println(WrapperManager.getRes().getString("    MD5: {0}", sb));
                }
                finally {
                    is.close();
                }
            }
            catch (NoSuchAlgorithmException e) {
                m_outDebug.println(WrapperManager.getRes().getString("    Unable to calculate MD5: {0}", e));
            }
            catch (IOException e) {
                m_outDebug.println(WrapperManager.getRes().getString("    Unable to access location: {0}", e));
            }
        }
    }

    private static void privilegedClassInit() {
        block30: {
            m_out = System.out;
            m_err = System.err;
            m_outInfo = new WrapperPrintStream(m_out, "WrapperManager: ");
            m_outError = new WrapperPrintStream(m_out, "WrapperManager Error: ");
            m_outDebug = new WrapperPrintStream(m_out, "WrapperManager Debug: ");
            m_properties = new WrapperProperties();
            m_properties.lock();
            m_res = new WrapperResources();
            WrapperManager.checkSecurityManager();
            m_debug = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.debug", false);
            if (m_debug) {
                m_outDebug.println("WrapperManager class initialized by thread: " + Thread.currentThread().getName() + "   Using classloader: " + WrapperManager.class.getClassLoader().toString());
            }
            m_outInfo.println("Initializing...");
            m_key = System.getProperty("wrapper.key");
            WrapperManager.verifyWrapperVersion();
            m_logFinalizer = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.logFinalizers", false);
            m_jvmId = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvmid", 1);
            if (m_debug) {
                m_outDebug.println("JVM #" + m_jvmId);
            }
            if ((m_jvmBits = WrapperSystemPropertyUtil.getIntProperty("sun.arch.data.model", -1)) == -1) {
                m_jvmBits = WrapperSystemPropertyUtil.getIntProperty("com.ibm.vm.bitmode", -1);
            }
            if (m_debug) {
                if (m_jvmBits > 0) {
                    m_outDebug.println("Running a " + m_jvmBits + "-bit JVM.");
                } else {
                    m_outDebug.println("The bit depth of this JVM could not be determined.");
                }
            }
            WrapperManager.logPackageInfo(WrapperManager.class);
            m_detachStarted = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.detachStarted", false);
            m_ticks = 0x7FFFFF37;
            m_useSystemTime = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.use_system_time", false);
            m_timerFastThreshold = WrapperSystemPropertyUtil.getIntProperty("wrapper.timer_fast_threshold", 1728000) * 1000 / 100;
            m_timerSlowThreshold = WrapperSystemPropertyUtil.getIntProperty("wrapper.timer_slow_threshold", 1728000) * 1000 / 100;
            m_disableTests = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.disable_tests", false);
            boolean disableShutdownHook = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.disable_shutdown_hook", false);
            m_listenerForceStop = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.listener.force_stop", false);
            m_soTimeout = WrapperSystemPropertyUtil.getIntProperty("wrapper.backend.so_timeout", -1) * 1000;
            if (!disableShutdownHook) {
                if (m_debug) {
                    m_outDebug.println("Registering shutdown hook");
                }
                m_hook = new Thread("Wrapper-Shutdown-Hook"){

                    public void run() {
                        m_hookTriggered = true;
                        if (m_debug) {
                            m_outDebug.println(WrapperManager.getRes().getString("ShutdownHook started"));
                        }
                        m_startupRunner = null;
                        WrapperManager.stop(0);
                        if (m_debug) {
                            m_outDebug.println(WrapperManager.getRes().getString("ShutdownHook complete"));
                        }
                        if (m_debug) {
                            m_outDebug.println(WrapperManager.getRes().getString("WrapperManger stopped due to {0}", WrapperManager.getRes().getString("Shutdown Hook")));
                        }
                        m_stopped = true;
                    }
                };
                Runtime.getRuntime().addShutdownHook(m_hook);
            }
            m_backendType = 0;
            m_port = 0;
            m_jvmPort = 0;
            m_jvmPortMin = 0;
            m_jvmPortMax = 0;
            if (m_key == null) {
                if (m_debug) {
                    m_outDebug.println("Not using wrapper.  (key not specified)");
                }
                m_service = false;
                m_cpuTimeout = 31557600000L;
            } else {
                String backendType;
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Using wrapper"));
                }
                if (WrapperSystemPropertyUtil.getBooleanProperty("wrapper.disable_console_input", false)) {
                    System.setIn(new WrapperInputStream());
                }
                if ((backendType = WrapperSystemPropertyUtil.getStringProperty("wrapper.backend", "SOCKET")).equalsIgnoreCase("PIPE")) {
                    m_backendType = 4;
                } else {
                    String sPort;
                    m_backendType = backendType.equalsIgnoreCase("SOCKET") ? 1 : 2;
                    m_wrapperPortAddress = System.getProperty("wrapper.port.address");
                    if (m_wrapperPortAddress == null) {
                        m_wrapperPortAddress = m_backendType == 1 ? "127.0.0.1" : "::1";
                    }
                    if ((sPort = System.getProperty("wrapper.port")) == null) {
                        String msg = "The 'wrapper.port' system property was not set.";
                        m_outError.println(msg);
                        throw new ExceptionInInitializerError(msg);
                    }
                    try {
                        m_port = Integer.parseInt(sPort);
                    }
                    catch (NumberFormatException e) {
                        String msg = "'" + sPort + "' is not a valid value for 'wrapper.port'.";
                        m_outError.println(msg);
                        throw new ExceptionInInitializerError(msg);
                    }
                    m_jvmPort = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port", -1);
                    m_jvmPortMin = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port.min", 31000);
                    m_jvmPortMax = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port.max", 31999);
                }
                m_ignoreSignals = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.ignore_signals", false);
                m_service = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.service", false);
                String sCPUTimeout = System.getProperty("wrapper.cpu.timeout");
                if (sCPUTimeout == null) {
                    m_cpuTimeout = 10000L;
                } else {
                    try {
                        m_cpuTimeout = (long)Integer.parseInt(sCPUTimeout) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        String msg = "'" + sCPUTimeout + "' is not a valid value for 'wrapper.cpu.timeout'.";
                        m_outError.println(msg);
                        throw new ExceptionInInitializerError(msg);
                    }
                }
            }
            if (WrapperSystemPropertyUtil.getBooleanProperty(WrapperManager.class.getName() + ".mbean", true)) {
                WrapperManager.registerMBean(new org.tanukisoftware.wrapper.jmx.WrapperManager(), "org.tanukisoftware.wrapper:type=WrapperManager");
            }
            if (WrapperSystemPropertyUtil.getBooleanProperty(WrapperManager.class.getName() + ".mbean.testing", false)) {
                WrapperManager.registerMBean(new WrapperManagerTesting(), "org.tanukisoftware.wrapper:type=WrapperManagerTesting");
            }
            WrapperManager.initializeNativeLibrary();
            if (WrapperManager.isNativeLibraryOk()) {
                WrapperManager.verifyNativeLibraryVersion();
                try {
                    System.setProperty("wrapper.java.pid", Integer.toString(WrapperManager.nativeGetJavaPID()));
                }
                catch (Throwable e) {
                    if (!m_debug) break block30;
                    m_outDebug.println(WrapperManager.getRes().getString("Call to nativeGetJavaPID() failed: {0}", e));
                }
            }
        }
        m_eventRunnerTicks = WrapperManager.getTicks();
        m_eventRunner = new Thread("Wrapper-Control-Event-Monitor"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Control event monitor thread started."));
                }
                try {
                    WrapperTickEventImpl tickEvent = new WrapperTickEventImpl();
                    int lastTickOffset = 0;
                    boolean first = true;
                    boolean stoppingLogged = false;
                    while (!m_stopped) {
                        int offsetDiff;
                        if (!m_useSystemTime) {
                            int sysTicks = WrapperManager.getSystemTicks();
                            m_ticks++;
                            int tickOffset = sysTicks - m_ticks;
                            offsetDiff = tickOffset - lastTickOffset;
                            if (first) {
                                first = false;
                            } else if (offsetDiff > m_timerSlowThreshold) {
                                m_outInfo.println(WrapperManager.getRes().getString("The timer fell behind the system clock by {0} ms.", new Integer(offsetDiff * 100)));
                            } else if (offsetDiff < -m_timerFastThreshold) {
                                m_outInfo.println(WrapperManager.getRes().getString("The system clock fell behind the timer by {0} ms.", new Integer(-1 * offsetDiff * 100)));
                            }
                            lastTickOffset = tickOffset;
                        } else {
                            offsetDiff = 0;
                        }
                        int nowTicks = WrapperManager.getTicks();
                        long age = WrapperManager.getTickAge(m_eventRunnerTicks, nowTicks);
                        if (m_cpuTimeout > 0L && age > m_cpuTimeout) {
                            m_outInfo.println(WrapperManager.getRes().getString("JVM Process has not received any CPU time for {0} seconds.  Extending timeouts.", new Long(age / 1000L)));
                            m_lastPingTicks = nowTicks;
                        }
                        m_eventRunnerTicks = nowTicks;
                        if (m_produceCoreEvents) {
                            tickEvent.m_ticks = nowTicks;
                            tickEvent.m_tickOffset = offsetDiff;
                            WrapperManager.fireWrapperEvent(tickEvent);
                        }
                        if (WrapperManager.isNativeLibraryOk()) {
                            if (!WrapperManager.isShuttingDown()) {
                                int event = 0;
                                do {
                                    if ((event = WrapperManager.nativeGetControlEvent()) == 0) continue;
                                    WrapperManager.controlEvent(event);
                                } while (event != 0);
                            } else if (!stoppingLogged) {
                                stoppingLogged = true;
                                if (m_debug) {
                                    m_outDebug.println(WrapperManager.getRes().getString("Stopped checking for control events."));
                                }
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {}
                    }
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Control event monitor thread stopped."));
                    }
                    throw throwable;
                }
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Control event monitor thread stopped."));
                }
            }
        };
        m_eventRunner.setDaemon(true);
        m_eventRunner.start();
        String fullVersion = System.getProperty("java.fullversion");
        String vendor = System.getProperty("java.vm.vendor", "");
        String os = System.getProperty("os.name", "").toLowerCase();
        if (fullVersion == null) {
            fullVersion = System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name");
        }
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("Java PID       : {0}", Integer.toString(WrapperManager.getJavaPID())));
            m_outDebug.println(WrapperManager.getRes().getString("Java Version   : {0}", fullVersion));
            m_outDebug.println(WrapperManager.getRes().getString("Java VM Vendor : {0}", vendor));
            m_outDebug.println(WrapperManager.getRes().getString("OS Name        : {0}", System.getProperty("os.name", "")));
            m_outDebug.println(WrapperManager.getRes().getString("OS Arch        : {0}", System.getProperty("os.arch", "")));
            m_outDebug.println();
        }
        m_startupRunner = new Thread("Wrapper-Startup-Runner"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.currentThread().setPriority(10);
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Startup runner thread started."));
                }
                try {
                    while (m_startupRunner != null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Startup runner thread stopped."));
                    }
                    throw throwable;
                }
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Startup runner thread stopped."));
                }
            }
        };
        m_startupRunner.setDaemon(false);
        m_startupRunner.start();
        m_instance = new WrapperManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (WrapperManager.isLoggingFinalizers()) {
                System.out.println("WrapperManager.finalize");
            }
        }
        finally {
            super.finalize();
        }
    }

    private static native void nativeInit(boolean var0);

    private static native String nativeGetLibraryVersion();

    private static native int nativeGetJavaPID();

    private static native boolean nativeIsProfessionalEdition();

    private static native boolean nativeIsStandardEdition();

    private static native int nativeGetControlEvent();

    private static native int nativeRedirectPipes();

    private static native void nativeRequestThreadDump();

    private static native void accessViolationInner();

    private static native void nativeSetConsoleTitle(String var0);

    private static native WrapperUser nativeGetUser(boolean var0);

    private static native WrapperUser nativeGetInteractiveUser(boolean var0);

    private static native WrapperWin32Service[] nativeListServices();

    private static native WrapperWin32Service nativeSendServiceControlCode(String var0, int var1);

    private static native WrapperProcess nativeExec(String[] var0, String var1, WrapperProcessConfig var2, boolean var3);

    private static native String nativeWrapperGetEnv(String var0) throws NullPointerException;

    private static native WrapperResources nativeLoadWrapperResources(String var0, String var1, boolean var2);

    private static native boolean nativeCheckDeadLocks();

    private static native int nativeGetPortStatus(int var0, String var1, int var2);

    public static native int nativeGetDpiScale();

    private static int getSystemTicks() {
        return (int)(System.currentTimeMillis() / 100L);
    }

    private static int getTicks() {
        if (m_useSystemTime) {
            return WrapperManager.getSystemTicks();
        }
        return m_ticks;
    }

    private static long getTickAge(int start, int end) {
        return (long)(end - start) * 100L;
    }

    private static String loadNativeLibrary(String name, String file) {
        try {
            WrapperManager.checkOldLibraryOnAix(file);
            System.loadLibrary(name);
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("  Attempt to load native library with name: {0}  Result: {1}", file, WrapperManager.getRes().getString("Success!")));
            }
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            String error;
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("  Attempt to load native library with name: {0}  Result: {1}", file, e.getMessage()));
            }
            if ((error = e.getMessage()) == null) {
                error = e.toString();
            }
            return error;
        }
        catch (Throwable e) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("  Attempt to load native library with name: {0}  Result: {1}", file, e.getMessage()));
            }
            String error = e.toString();
            return error;
        }
    }

    private static void registerMBean(Object mbean, String name) {
        Class<?> classObjectName;
        Class<?> classMBeanServer;
        Class<?> classManagementFactory;
        try {
            classManagementFactory = Class.forName("java.lang.management.ManagementFactory");
            classMBeanServer = Class.forName("javax.management.MBeanServer");
            classObjectName = Class.forName("javax.management.ObjectName");
        }
        catch (ClassNotFoundException e) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Registering MBeans not supported by current JVM: {0}", name));
            }
            return;
        }
        try {
            Method methodGetPlatformMBeanServer = classManagementFactory.getMethod("getPlatformMBeanServer", null);
            Constructor<?> constructorObjectName = classObjectName.getConstructor(String.class);
            Method methodRegisterMBean = classMBeanServer.getMethod("registerMBean", Object.class, classObjectName);
            Object mbs = methodGetPlatformMBeanServer.invoke((Object)null, (Object[])null);
            Object oName = constructorObjectName.newInstance(name);
            methodRegisterMBean.invoke(mbs, mbean, oName);
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Registered MBean with Platform MBean Server: {0}", name));
            }
        }
        catch (Throwable t) {
            if (t instanceof ClassNotFoundException) {
                m_outError.println("Using MBean requires at least a JVM version 1.5.");
            }
            m_outError.println("Unable to register the " + name + " MBean.");
            t.printStackTrace(m_outError);
        }
    }

    private static File locateFileOnPath(String file, String path) {
        String pathSep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(path, pathSep);
        while (st.hasMoreTokens()) {
            File libFile = new File(new File(st.nextToken()), file);
            if (!libFile.exists()) continue;
            return libFile;
        }
        return null;
    }

    private static String generateDetailedNativeLibraryBaseName(String baseName, int jvmBits) {
        String arch;
        String os = System.getProperty("os.name", "").toLowerCase();
        if (os.startsWith("windows")) {
            os = "windows";
            m_windows = true;
        } else if (os.equals("sunos")) {
            os = "solaris";
        } else if (os.equals("hp-ux") || os.equals("hp-ux64")) {
            os = "hpux";
        } else if (os.equals("mac os x")) {
            os = "macosx";
            m_macosx = true;
        } else if (os.equals("unix_sv")) {
            os = "unixware";
        } else if (os.equals("os/400")) {
            os = "os400";
        } else if (os.equals("z/os")) {
            os = "zos";
        } else if (os.indexOf("aix") > -1) {
            m_aix = true;
        }
        if (m_macosx) {
            arch = "universal";
        } else {
            arch = System.getProperty("os.arch", "").toLowerCase();
            if (arch.equals("amd64") || arch.equals("athlon") || arch.equals("x86_64") || arch.equals("i686") || arch.equals("i586") || arch.equals("i486") || arch.equals("i386")) {
                arch = "x86";
            } else if (arch.startsWith("ia32") || arch.startsWith("ia64")) {
                arch = "ia";
            } else if (arch.startsWith("sparc")) {
                arch = "sparc";
            } else if (arch.startsWith("ppc64le")) {
                arch = "ppcle";
            } else if (arch.equals("power") || arch.equals("powerpc") || arch.equals("ppc64")) {
                arch = m_aix ? "ppc" : "ppcbe";
            } else if (arch.startsWith("pa_risc") || arch.startsWith("pa-risc")) {
                arch = "parisc";
            } else if (arch.startsWith("arm")) {
                arch = System.getProperty("wrapper.arch");
            } else if (arch.equals("s390") || arch.equals("s390x")) {
                arch = "390";
            }
        }
        return baseName + "-" + os + "-" + arch + "-" + jvmBits;
    }

    private static String mapSharedLibraryName(String name) {
        String result = System.mapLibraryName(name);
        if (WrapperManager.isAIX() && result.endsWith(".a")) {
            result = result.substring(0, result.length() - 2).concat(".so");
        }
        return result;
    }

    private static void checkOldLibraryOnAix(String libName) {
        if (WrapperManager.isAIX()) {
            if (libName.endsWith(".so")) {
                libName = libName.substring(0, libName.length() - 3).concat(".a");
            }
            String pathSep = System.getProperty("path.separator");
            String[] libPaths = System.getProperty("java.library.path").split(pathSep);
            for (int j = 0; j < libPaths.length; ++j) {
                File libFile = WrapperManager.locateFileOnPath(libName, libPaths[j]);
                if (libFile == null) continue;
                m_outInfo.println(WrapperManager.getRes().getString("WARNING - {0} was found in {1}.", libName, libPaths[j]));
                m_outInfo.println(WrapperManager.getRes().getString("          Recent Wrapper''s native libraries have a ''.so'' suffix."));
                m_outInfo.println(WrapperManager.getRes().getString("          Depending on the version of Java that is used, {0}", libName));
                m_outInfo.println(WrapperManager.getRes().getString("          may be loaded instead of a more recent library."));
                m_outInfo.println(WrapperManager.getRes().getString("          Please remove {0} and make sure that the latest version", libName));
                m_outInfo.println(WrapperManager.getRes().getString("          of the Wrapper''s native library is in the lib folder."));
            }
        }
    }

    private static void initializeNativeLibrary() {
        String baseName = System.getProperty("wrapper.native_library");
        if (baseName == null) {
            m_outInfo.println("WARNING - The wrapper.native_library system property was not");
            m_outInfo.println("          set. Using the default value, 'wrapper'.");
            baseName = "wrapper";
        }
        String[] detailedNames = new String[4];
        if (m_jvmBits > 0) {
            detailedNames[0] = WrapperManager.generateDetailedNativeLibraryBaseName(baseName, m_jvmBits);
        } else {
            detailedNames[0] = WrapperManager.generateDetailedNativeLibraryBaseName(baseName, 32);
            detailedNames[1] = WrapperManager.generateDetailedNativeLibraryBaseName(baseName, 64);
        }
        String file = WrapperManager.mapSharedLibraryName(baseName);
        String[] detailedFiles = new String[detailedNames.length];
        for (int i = 0; i < detailedNames.length; ++i) {
            if (detailedNames[i] == null) continue;
            detailedFiles[i] = WrapperManager.mapSharedLibraryName(detailedNames[i]);
        }
        String[] detailedErrors = new String[detailedNames.length];
        String baseError = null;
        if (m_debug) {
            m_outDebug.println("Load native library.  There are multiple possible file names and the first to be found will be used.  Errors loading non-existing files is normal and is only a problem if they all fail.");
        }
        m_libraryOK = false;
        for (int i = 0; i < detailedNames.length; ++i) {
            if (detailedNames[i] == null) continue;
            detailedErrors[i] = WrapperManager.loadNativeLibrary(detailedNames[i], detailedFiles[i]);
            if (detailedErrors[i] != null) continue;
            m_libraryOK = true;
            break;
        }
        if (!m_libraryOK && (baseError = WrapperManager.loadNativeLibrary(baseName, file)) == null) {
            m_libraryOK = true;
        }
        if (m_libraryOK) {
            if (m_debug) {
                m_outDebug.println("  Successfully loaded native library.");
            }
            try {
                m_professionalEdition = WrapperManager.nativeIsProfessionalEdition();
            }
            catch (Throwable e) {
                if (m_debug) {
                    m_outDebug.println("Call to nativeIsProfessionalEdition() failed: " + e);
                }
                m_professionalEdition = false;
            }
            try {
                m_standardEdition = WrapperManager.nativeIsStandardEdition();
            }
            catch (Throwable e) {
                if (m_debug) {
                    m_outDebug.println("Call to nativeIsStandardEdition() failed: " + e);
                }
                m_standardEdition = false;
            }
            m_res = WrapperManager.loadWrapperResourcesInner(System.getProperty("wrapper.lang.domain") + "jni", WrapperSystemPropertyUtil.getStringProperty("wrapper.lang.folder", "../lang"), true);
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Loaded localized resources."));
            }
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Calling native initialization method."));
            }
            WrapperManager.nativeInit(m_debug);
            if (m_stoppingInit) {
                m_libraryOK = false;
            }
        } else {
            String libPath = System.getProperty("java.library.path");
            m_outInfo.println();
            if (libPath.equals("")) {
                m_outInfo.println("WARNING - Unable to load the Wrapper's native library because the");
                m_outInfo.println("          java.library.path was set to ''.  Please see the");
                m_outInfo.println("          documentation for the wrapper.java.library.path");
                m_outInfo.println("          configuration property.");
            } else {
                int i;
                String error = null;
                File libFile = null;
                for (i = 0; i < detailedNames.length; ++i) {
                    if (detailedFiles[i] == null || (libFile = WrapperManager.locateFileOnPath(detailedFiles[i], libPath)) == null) continue;
                    error = detailedErrors[i];
                    break;
                }
                if (libFile == null && (libFile = WrapperManager.locateFileOnPath(file, libPath)) != null) {
                    error = baseError;
                }
                if (libFile == null) {
                    m_outInfo.println("WARNING - Unable to load the Wrapper's native library because none of the");
                    m_outInfo.println("          following files:");
                    for (i = 0; i < detailedNames.length; ++i) {
                        if (detailedFiles[i] == null) continue;
                        m_outInfo.println("            " + detailedFiles[i]);
                    }
                    m_outInfo.println("            " + file);
                    m_outInfo.println("          could be located on the following java.library.path:");
                    String pathSep = System.getProperty("path.separator");
                    StringTokenizer st = new StringTokenizer(libPath, pathSep);
                    while (st.hasMoreTokens()) {
                        File pathElement = new File(st.nextToken());
                        m_outInfo.println("            " + pathElement.getAbsolutePath());
                    }
                    m_outInfo.println("          Please see the documentation for the wrapper.java.library.path");
                    m_outInfo.println("          configuration property.");
                } else {
                    m_outInfo.println("WARNING - Unable to load the Wrapper's native library '" + libFile.getName() + "'.");
                    m_outInfo.println("          The file is located on the path at the following location but");
                    m_outInfo.println("          could not be loaded:");
                    m_outInfo.println("            " + libFile.getAbsolutePath());
                    m_outInfo.println("          Please verify that the file is both readable and executable by the");
                    m_outInfo.println("          current user and that the file has not been corrupted in any way.");
                    m_outInfo.println("          One common cause of this problem is running a 32-bit version");
                    m_outInfo.println("          of the Wrapper with a 64-bit version of Java, or vica versa.");
                    if (m_jvmBits > 0) {
                        m_outInfo.println("          This is a " + m_jvmBits + "-bit JVM.");
                    } else {
                        m_outInfo.println("          The bit depth of this JVM could not be determined.");
                    }
                    m_outInfo.println("          Reported cause:");
                    m_outInfo.println("            " + error);
                }
            }
            m_outInfo.println("          System signals will not be handled correctly.");
            m_outInfo.println();
        }
    }

    private static void verifyWrapperVersion() {
        if (!WrapperManager.isControlledByNativeWrapper()) {
            return;
        }
        String wrapperVersion = System.getProperty("wrapper.version");
        if (wrapperVersion == null) {
            wrapperVersion = WrapperManager.getRes().getString("unknown");
        }
        if (wrapperVersion.endsWith("-pro")) {
            wrapperVersion = wrapperVersion.substring(0, wrapperVersion.length() - 4);
        } else if (wrapperVersion.endsWith("-st")) {
            wrapperVersion = wrapperVersion.substring(0, wrapperVersion.length() - 3);
        }
        if (!WrapperInfo.getVersion().equals(wrapperVersion)) {
            m_outInfo.println("WARNING - The Wrapper jar file currently in use is version \"" + WrapperInfo.getVersion() + "\"");
            m_outInfo.println("          while the version of the Wrapper which launched this JVM is");
            m_outInfo.println("          \"" + wrapperVersion + "\".");
            m_outInfo.println("          The Wrapper may appear to work correctly but some features may");
            m_outInfo.println("          not function correctly.  This configuration has not been tested");
            m_outInfo.println("          and is not supported.");
            m_outInfo.println();
        }
    }

    private static void verifyNativeLibraryVersion() {
        String jniVersion;
        try {
            jniVersion = WrapperManager.nativeGetLibraryVersion();
        }
        catch (Throwable e) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Call to nativeGetLibraryVersion() failed: {0}", e));
            }
            jniVersion = WrapperManager.getRes().getString("unknown");
        }
        String wrapperVersion = System.getProperty("wrapper.version");
        if (wrapperVersion == null) {
            wrapperVersion = WrapperManager.getRes().getString("unknown");
        }
        if (!wrapperVersion.equals(jniVersion)) {
            m_outInfo.println(WrapperManager.getRes().getString("WARNING - The version of the Wrapper which launched this JVM is\n          \"{0}\" while the version of the native library\n          is \"{1}\".", wrapperVersion, jniVersion));
            m_outInfo.println(WrapperManager.getRes().getString("          The Wrapper may appear to work correctly but some features may\n          not function correctly.  This configuration has not been tested\n          and is not supported."));
            m_outInfo.println();
        }
    }

    private static void checkTmpDir() {
        boolean tmpDirCheck;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("Java temporary directory: {0}", tmpDir));
        }
        if (!(tmpDirCheck = WrapperManager.getProperties().getProperty("wrapper.java.tmpdir.check", "TRUE").equalsIgnoreCase("TRUE"))) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Validation of temporary directory disabled."));
            }
            return;
        }
        boolean tmpDirRequired = WrapperManager.getProperties().getProperty("wrapper.java.tmpdir.required", "FALSE").equalsIgnoreCase("TRUE");
        boolean tmpDirWarnSilently = WrapperManager.getProperties().getProperty("wrapper.java.tmpdir.warn_silently", "TRUE").equalsIgnoreCase("TRUE");
        Exception ex = null;
        try {
            tmpDir = tmpDir.getCanonicalFile();
            File tempFile = new File(tmpDir, "wrapper-" + System.currentTimeMillis() + "-" + WrapperManager.getJavaPID());
            if (tempFile.createNewFile()) {
                if (!tempFile.delete()) {
                    m_outError.println("Unable to delete temporary file: " + tempFile);
                }
            } else if (m_debug) {
                m_outDebug.println("Unable to create temporary file: " + tempFile);
            }
        }
        catch (IOException e) {
            ex = e;
        }
        catch (SecurityException e) {
            ex = e;
        }
        if (ex != null) {
            if (tmpDirRequired) {
                m_outError.println(WrapperManager.getRes().getString("Unable to write to the configured Java temporary directory: {0} : {1}", tmpDir, ex.toString()));
                m_outError.println(WrapperManager.getRes().getString("Shutting down."));
                System.exit(1);
            } else {
                if (tmpDirWarnSilently) {
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Unable to write to the configured Java temporary directory: {0} : {1}", tmpDir, ex.toString()));
                    }
                } else {
                    m_outInfo.println(WrapperManager.getRes().getString("Unable to write to the configured Java temporary directory: {0} : {1}", tmpDir, ex.toString()));
                }
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("  The lack of a temp directory could lead to problems with features that store temporary data, including remote jar class loading."));
                    m_outDebug.println(WrapperManager.getRes().getString("  The Java temporary directory can be redefined with the java.io.tmpdir system property."));
                }
            }
        }
    }

    private static WrapperResources loadWrapperResourcesInner(String domain, String folder, boolean makeActive) {
        if (WrapperManager.isStandardEdition() && WrapperManager.isNativeLibraryOk()) {
            if (folder == null) {
                folder = WrapperSystemPropertyUtil.getStringProperty("wrapper.lang.folder", "../lang");
            }
            return WrapperManager.nativeLoadWrapperResources(domain, folder, makeActive);
        }
        return new WrapperResources();
    }

    public static WrapperResources loadWrapperResources(String domain, String folder) {
        return WrapperManager.loadWrapperResourcesInner(domain, folder, false);
    }

    public static String getVersion() {
        return WrapperInfo.getVersion();
    }

    public static String getBuildTime() {
        return WrapperInfo.getBuildTime();
    }

    public static int getJVMId() {
        return m_jvmId;
    }

    private static String[] parseCommandLine(String cmdLine) {
        ArrayList<String> argList = new ArrayList<String>();
        StringBuffer arg = new StringBuffer();
        boolean quoteMode = false;
        boolean escapeNextCharIfQuote = false;
        char[] c = cmdLine.toCharArray();
        for (int i = 0; i < cmdLine.length(); ++i) {
            if (c[i] == '\\' && !escapeNextCharIfQuote) {
                escapeNextCharIfQuote = true;
                continue;
            }
            if (Character.isWhitespace(c[i]) && !quoteMode) {
                if (arg.length() <= 0) continue;
                argList.add(arg.toString());
                arg.setLength(0);
                continue;
            }
            if (c[i] == '\"') {
                if (!escapeNextCharIfQuote) {
                    quoteMode = !quoteMode;
                    escapeNextCharIfQuote = false;
                    continue;
                }
                escapeNextCharIfQuote = false;
                arg.append(c[i]);
                continue;
            }
            if (c[i] == '\\') {
                if (escapeNextCharIfQuote) {
                    escapeNextCharIfQuote = false;
                }
                arg.append('\\');
                continue;
            }
            if (escapeNextCharIfQuote) {
                arg.append('\\');
                escapeNextCharIfQuote = false;
            }
            arg.append(c[i]);
        }
        if (arg.length() > 0) {
            argList.add(arg.toString());
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        return args;
    }

    public static WrapperProcess exec(String command) throws SecurityException, IOException, NullPointerException, IllegalArgumentException, WrapperJNIError, WrapperLicenseError, UnsatisfiedLinkError {
        WrapperProcess proc = WrapperManager.exec(command, new WrapperProcessConfig());
        return proc;
    }

    public static WrapperProcess exec(String command, WrapperProcessConfig config) throws SecurityException, IOException, NullPointerException, IllegalArgumentException, WrapperJNIError, WrapperLicenseError, UnsatisfiedLinkError {
        if (command == null || command.length() == 0) {
            throw new IllegalArgumentException(WrapperManager.getRes().getString("No command specified."));
        }
        return WrapperManager.exec(null, command, config);
    }

    public static WrapperProcess exec(String[] cmdArray) throws SecurityException, IOException, NullPointerException, IndexOutOfBoundsException, IllegalArgumentException, WrapperJNIError, UnsatisfiedLinkError, WrapperLicenseError {
        WrapperProcess proc = WrapperManager.exec(cmdArray, new WrapperProcessConfig());
        return proc;
    }

    public static WrapperProcess exec(String[] cmdArray, WrapperProcessConfig config) throws SecurityException, IOException, NullPointerException, IndexOutOfBoundsException, IllegalArgumentException, WrapperJNIError, WrapperLicenseError, UnsatisfiedLinkError {
        return WrapperManager.exec(cmdArray, null, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WrapperProcess exec(String[] cmdArray, String cmdLine, WrapperProcessConfig config) throws SecurityException, IOException, NullPointerException, IndexOutOfBoundsException, IllegalArgumentException, WrapperJNIError, WrapperLicenseError, UnsatisfiedLinkError {
        block26: {
            Class clazz;
            WrapperProcess wrapperProcess;
            WrapperManager.assertProfessionalEdition();
            if (cmdArray == null && cmdLine == null) {
                throw new NullPointerException(WrapperManager.getRes().getString("No command specified"));
            }
            if (cmdArray != null && cmdArray.length == 0) {
                throw new IndexOutOfBoundsException(WrapperManager.getRes().getString("cmdArray is empty"));
            }
            if (cmdArray == null && cmdLine != null) {
                cmdArray = WrapperManager.parseCommandLine(cmdLine);
            }
            if (config == null) {
                throw new NullPointerException(WrapperManager.getRes().getString("config is null"));
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkExec(cmdArray[0]);
            }
            Class clazz2 = WrapperManager.class;
            synchronized (clazz2) {
                ++m_runningExecs;
            }
            try {
                if (!WrapperManager.isNativeLibraryOk()) break block26;
                for (int i = 0; i < cmdArray.length; ++i) {
                    if (cmdArray[i] != null) continue;
                    throw new NullPointerException(WrapperManager.getRes().getString("cmdarray[{0}]: Invalid element (isNull).", new Integer(i)));
                }
                if (!m_windows && !new File(cmdArray[0]).exists()) {
                    boolean found = false;
                    String path = WrapperManager.nativeWrapperGetEnv("PATH");
                    if (path != null) {
                        String[] paths = path.split(File.pathSeparator);
                        for (int i = 0; i < paths.length; ++i) {
                            File file = new File(paths[i] + File.separator + cmdArray[0]);
                            if (!file.exists()) continue;
                            cmdArray[0] = file.getPath();
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        throw new IOException(WrapperManager.getRes().getString("''{0}'' not found.", cmdArray[0]));
                    }
                }
                if (m_debug) {
                    for (int j = 0; j < cmdArray.length; ++j) {
                        m_outDebug.println("args[" + j + "] = " + cmdArray[j]);
                    }
                }
                wrapperProcess = WrapperManager.nativeExec(cmdArray, cmdLine, config.setEnvironment(config.getEnvironment()), WrapperSystemPropertyUtil.getBooleanProperty("wrapper.child.allowCWDOnSpawn", false));
                Object var10_12 = null;
                clazz = WrapperManager.class;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                Class clazz3 = WrapperManager.class;
                synchronized (clazz3) {
                    if (--m_runningExecs <= 0) {
                        WrapperManager.class.notifyAll();
                    }
                }
                throw throwable;
            }
            synchronized (clazz) {
                if (--m_runningExecs <= 0) {
                    WrapperManager.class.notifyAll();
                }
            }
            return wrapperProcess;
        }
        if (m_stopped) {
            throw new WrapperJNIError("Wrapper native library shutting down.");
        }
        throw new WrapperJNIError("Wrapper native library not loaded.");
    }

    public static boolean isNativeLibraryOk() {
        return m_libraryOK && !m_stopped;
    }

    static void assertProfessionalEdition() throws WrapperLicenseError {
        if (!m_libraryOK) {
            throw new WrapperLicenseError(WrapperManager.getRes().getString("Requires that the Professional Edition native library be loaded.  Please check for errors earlier in the log."));
        }
        if (m_stopped) {
            throw new WrapperLicenseError(WrapperManager.getRes().getString("Requires that the Professional Edition native library be loaded, but it has already been unloaded as part of the shutdown process."));
        }
        if (!WrapperManager.isProfessionalEdition()) {
            throw new WrapperLicenseError(WrapperManager.getRes().getString("Requires the Professional Edition."));
        }
    }

    public static boolean isWindows() {
        return m_windows;
    }

    public static boolean isMacOSX() {
        return m_macosx;
    }

    public static boolean isAIX() {
        return m_aix;
    }

    public static boolean isProfessionalEdition() {
        return m_professionalEdition;
    }

    public static boolean isStandardEdition() {
        return m_standardEdition;
    }

    public static void fireUserEvent(int eventNr) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperUserEventPermission("fireUserEvent", String.valueOf(eventNr)));
        }
        if (eventNr <= 0 || eventNr > Short.MAX_VALUE) {
            throw new IllegalArgumentException(WrapperManager.getRes().getString("The user-event number must be in the range of 1-32767."));
        }
        WrapperManager.assertProfessionalEdition();
        WrapperManager.sendCommand((byte)-115, String.valueOf(eventNr));
    }

    public static void setConsoleTitle(String title) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("setConsoleTitle"));
        }
        if (WrapperManager.isNativeLibraryOk()) {
            WrapperManager.nativeSetConsoleTitle(title);
        }
    }

    public static WrapperUser getUser(boolean groups) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getUser"));
        }
        WrapperUser user = null;
        if (WrapperManager.isNativeLibraryOk()) {
            user = WrapperManager.nativeGetUser(groups);
        }
        return user;
    }

    public static WrapperUser getInteractiveUser(boolean groups) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getInteractiveUser"));
        }
        WrapperUser user = null;
        if (WrapperManager.isNativeLibraryOk()) {
            user = WrapperManager.nativeGetInteractiveUser(groups);
        }
        return user;
    }

    public static Properties getProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getProperties"));
        }
        return m_properties;
    }

    public static int getWrapperPID() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getWrapperPID"));
        }
        return WrapperSystemPropertyUtil.getIntProperty("wrapper.pid", 0);
    }

    public static int getJavaPID() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getJavaPID"));
        }
        return WrapperSystemPropertyUtil.getIntProperty("wrapper.java.pid", 0);
    }

    public static void requestThreadDump() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("requestThreadDump"));
        }
        if (WrapperManager.isNativeLibraryOk()) {
            WrapperManager.nativeRequestThreadDump();
        } else {
            m_outInfo.println(WrapperManager.getRes().getString("  wrapper library not loaded."));
        }
    }

    public static void appearHung() {
        if (m_disableTests) {
            throw new IllegalStateException(WrapperManager.getRes().getString("Test methods have been disabled."));
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("test.appearHung"));
        }
        m_outInfo.println(WrapperManager.getRes().getString("WARNING: Making JVM appear to be hung..."));
        m_appearHung = true;
    }

    public static void appearSlow(int slowSeconds) {
        if (m_disableTests) {
            throw new IllegalStateException(WrapperManager.getRes().getString("Test methods have been disabled."));
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("test.appearSlow"));
        }
        if (slowSeconds > 0) {
            m_outInfo.println(WrapperManager.getRes().getString("WARNING: Making JVM appear to be slow using a delay of {0} seconds...", new Integer(slowSeconds)));
            m_slowSeconds = slowSeconds;
        } else if (m_slowSeconds > 0) {
            m_outInfo.println(WrapperManager.getRes().getString("Resetting the JVM delayed response to normal..."));
            m_slowSeconds = 0;
        }
    }

    public static void appearOrphan() {
    }

    public static void accessViolation() {
        block5: {
            if (m_disableTests) {
                throw new IllegalStateException(WrapperManager.getRes().getString("Test methods have been disabled."));
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new WrapperPermission("test.accessViolation"));
            }
            m_outInfo.println(WrapperManager.getRes().getString("WARNING: Attempting to cause an access violation..."));
            try {
                Class<?> c = Class.forName("java.lang.String");
                Method method = c.getDeclaredMethod(null, null);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Exception ex) {
                if (ex instanceof NoSuchFieldException) break block5;
                ex.printStackTrace(m_outError);
            }
        }
        m_outInfo.println(WrapperManager.getRes().getString("  Attempt to cause access violation failed.  JVM is still alive."));
    }

    public static void accessViolationNative() {
        if (m_disableTests) {
            throw new IllegalStateException(WrapperManager.getRes().getString("Test methods have been disabled."));
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("test.accessViolationNative"));
        }
        m_outInfo.println(WrapperManager.getRes().getString("WARNING: Attempting to cause an access violation..."));
        if (WrapperManager.isNativeLibraryOk()) {
            WrapperManager.accessViolationInner();
            m_outInfo.println(WrapperManager.getRes().getString("  Attempt to cause access violation failed.  JVM is still alive."));
        } else {
            m_outInfo.println(WrapperManager.getRes().getString("  wrapper library not loaded."));
        }
    }

    public static boolean isControlledByNativeWrapper() {
        return m_key != null;
    }

    public static boolean isLaunchedAsService() {
        return m_service;
    }

    public static boolean isIgnoreUserLogoffs() {
        return m_ignoreUserLogoffs;
    }

    public static boolean isDebugEnabled() {
        return m_debug;
    }

    static boolean isLoggingFinalizers() {
        return m_logFinalizer;
    }

    public static void start(final WrapperListener listener, final String[] args) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStart(listener, args);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void privilegedStart(WrapperListener listener, String[] args) {
        WrapperManager.checkSecurityManager();
        if (args == null) {
            args = new String[]{};
        }
        if (m_debug) {
            StringBuffer sb = new StringBuffer();
            sb.append("args[");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"");
                sb.append(args[i]);
                sb.append("\"");
            }
            sb.append("]");
            m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1}", "WrapperManager.start(a " + listener.getClass().getName() + ", " + sb.toString() + ")", Thread.currentThread().getName()));
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_disposed) {
                throw new IllegalStateException(WrapperManager.getRes().getString("WrapperManager has already been disposed."));
            }
            if (m_listener != null) {
                throw new IllegalStateException(WrapperManager.getRes().getString("WrapperManager has already been started with a WrapperListener."));
            }
            if (listener == null) {
                throw new IllegalStateException(WrapperManager.getRes().getString("A WrapperListener must be specified."));
            }
            m_listener = listener;
            m_args = args;
            if (m_debug) {
                Thread thisThread = Thread.currentThread();
                m_outDebug.println(WrapperManager.getRes().getString("Initial thread: {0} Priority: {1}", thisThread.getName(), new Integer(thisThread.getPriority())));
            }
            WrapperManager.startRunner();
            if (!WrapperManager.isControlledByNativeWrapper()) {
                WrapperManager.startInner(true);
            }
        }
    }

    public static boolean isShuttingDown() {
        return m_stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestShutdownLock() throws WrapperShuttingDownException {
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_stopping) {
                throw new WrapperShuttingDownException();
            }
            Thread thisThread = Thread.currentThread();
            ShutdownLock lock = (ShutdownLock)m_shutdownLockMap.get(thisThread);
            if (lock == null) {
                lock = new ShutdownLock(thisThread);
                m_shutdownLockMap.put(thisThread, lock);
            }
            lock.m_count++;
            ++m_shutdownLocks;
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1} (New thread lock count: {2}, total lock count: {3})", "WrapperManager.requestShutdownLock()", thisThread.getName(), new Integer(lock.m_count), new Integer(m_shutdownLocks)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseShutdownLock() throws IllegalStateException {
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            Thread thisThread = Thread.currentThread();
            ShutdownLock lock = (ShutdownLock)m_shutdownLockMap.get(thisThread);
            if (lock == null) {
                throw new IllegalStateException(WrapperManager.getRes().getString("requestShutdownLock was not called from this thread."));
            }
            lock.m_count--;
            --m_shutdownLocks;
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1} (New thread lock count: {2}, total lock count: {3})", "WrapperManager.releaseShutdownLock()", thisThread.getName(), new Integer(lock.m_count), new Integer(m_shutdownLocks)));
            }
            if (lock.m_count <= 0) {
                m_shutdownLockMap.remove(thisThread);
            }
            WrapperManager.class.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForShutdownLocks() {
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("wait for {0} shutdown locks to be released.", new Integer(m_shutdownLocks)));
            }
            while (m_shutdownLocks > 0) {
                try {
                    (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (m_shutdownLocks <= 0) continue;
                m_outInfo.println(WrapperManager.getRes().getString("Waiting for {0} shutdown locks to be released...", new Integer(m_shutdownLocks)));
            }
        }
    }

    public static void restart() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("restart"));
        }
        m_stoppingInit = true;
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1}", "WrapperManager.restart()", Thread.currentThread().getName()));
        }
        WrapperManager.restartInner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartAndReturn() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("restart"));
        }
        m_stoppingInit = true;
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_stopping) {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1} (already stopping)", "WrapperManager.restartAndReturn()", Thread.currentThread().getName()));
                }
                return;
            }
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1}", "WrapperManager.restartAndReturn()", Thread.currentThread().getName()));
            }
        }
        Thread restarter = new Thread("Wrapper-Restarter"){

            public void run() {
                WrapperManager.restartInner();
            }
        };
        restarter.setDaemon(false);
        restarter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restartInner() {
        boolean stopping;
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            stopping = m_stopping;
            if (!stopping) {
                m_stopping = true;
            }
        }
        if (!stopping) {
            WrapperManager.sendCommand((byte)102, "restart");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStopInner(0);
                return null;
            }
        });
    }

    public static void stop(final int exitCode) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("stop"));
        }
        m_stoppingInit = true;
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1}", "WrapperManager.stop(" + exitCode + ")", Thread.currentThread().getName()));
        }
        WrapperManager.stopCommon(exitCode, 1000);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStopInner(exitCode);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAndReturn(final int exitCode) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("stop"));
        }
        m_stoppingInit = true;
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_stopping) {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1} (already stopping)", "WrapperManager.stopAndReturn(" + exitCode + ")", Thread.currentThread().getName()));
                }
                return;
            }
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1}", "WrapperManager.stopAndReturn(" + exitCode + ")", Thread.currentThread().getName()));
            }
        }
        Thread stopper = new Thread("Wrapper-Stopper"){

            public void run() {
                WrapperManager.stopCommon(exitCode, 1000);
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 9 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        WrapperManager.access$2900(9.access$3100(this.this$0));
                        return null;
                    }
                });
            }

            static /* synthetic */ int access$3100(9 x0) {
                return x0.exitCode;
            }
        };
        stopper.setDaemon(false);
        stopper.start();
    }

    public static void stopImmediate(int exitCode) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("stopImmediate"));
        }
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("{0} called by thread: {1}", "WrapperManager.stopImmediate(" + exitCode + ")", Thread.currentThread().getName()));
        }
        WrapperManager.stopCommon(exitCode, 250);
        WrapperManager.signalStopped(exitCode);
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("WrapperManger stopped due to {0}", WrapperManager.getRes().getString("Halt")));
        }
        m_stopped = true;
        Runtime.getRuntime().halt(exitCode);
    }

    public static void signalStarting(int waitHint) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("signalStarting"));
        }
        WrapperManager.sendCommand((byte)105, Integer.toString(waitHint));
    }

    public static void signalStopping(int waitHint) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("signalStopping"));
        }
        m_stopping = true;
        WrapperManager.sendCommand((byte)104, Integer.toString(waitHint));
    }

    public static void signalStopped(int exitCode) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("signalStopped"));
        }
        m_stopping = true;
        WrapperManager.sendCommand((byte)107, Integer.toString(exitCode));
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean hasShutdownHookBeenTriggered() {
        return m_hookTriggered;
    }

    public static void log(int logLevel, String message) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("log"));
        }
        if (logLevel < 1 || logLevel > 8) {
            throw new IllegalArgumentException(WrapperManager.getRes().getString("The specified logLevel is not valid."));
        }
        if (message == null) {
            throw new IllegalArgumentException(WrapperManager.getRes().getString("The message parameter can not be null."));
        }
        if (m_lowLogLevel <= logLevel) {
            WrapperManager.sendCommand((byte)(116 + logLevel), message);
        }
    }

    public static WrapperWin32Service[] listServices() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            throw new SecurityException(WrapperManager.getRes().getString("A SecurityManager has not yet been set."));
        }
        sm.checkPermission(new WrapperPermission("listServices"));
        if (WrapperManager.isNativeLibraryOk()) {
            return WrapperManager.nativeListServices();
        }
        return null;
    }

    public static WrapperWin32Service sendServiceControlCode(String serviceName, int controlCode) throws WrapperServiceException, SecurityException {
        String action;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            throw new SecurityException(WrapperManager.getRes().getString("A SecurityManager has not yet been set."));
        }
        switch (controlCode) {
            case 65536: {
                action = WrapperServicePermission.ACTION_START;
                break;
            }
            case 1: {
                action = WrapperServicePermission.ACTION_STOP;
                break;
            }
            case 2: {
                action = WrapperServicePermission.ACTION_PAUSE;
                break;
            }
            case 3: {
                action = WrapperServicePermission.ACTION_CONTINUE;
                break;
            }
            case 4: {
                action = WrapperServicePermission.ACTION_INTERROGATE;
                break;
            }
            default: {
                if (controlCode >= 128 && controlCode <= 255) {
                    action = WrapperServicePermission.ACTION_USER_CODE;
                    break;
                }
                throw new IllegalArgumentException(WrapperManager.getRes().getString("The specified controlCode is invalid."));
            }
        }
        sm.checkPermission(new WrapperServicePermission(serviceName, action));
        WrapperWin32Service service = null;
        if (WrapperManager.isNativeLibraryOk()) {
            service = WrapperManager.nativeSendServiceControlCode(serviceName, controlCode);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWrapperEventListener(WrapperEventListener listener, long mask) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            if ((mask & 1L) != 0L) {
                first = false;
                sb.append(WrapperEventPermission.EVENT_TYPE_SERVICE);
            }
            if ((mask & 2L) != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(WrapperEventPermission.EVENT_TYPE_CONTROL);
            }
            if ((mask & 8L) != 0L) {
                first = false;
                sb.append(WrapperEventPermission.EVENT_TYPE_REMOTE_CONTROL);
            }
            if ((mask & 0xF000000000000000L) != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(WrapperEventPermission.EVENT_TYPE_CORE);
            }
            sm.checkPermission(new WrapperEventPermission(sb.toString()));
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            WrapperEventListenerMask listenerMask = new WrapperEventListenerMask();
            listenerMask.m_listener = listener;
            listenerMask.m_mask = mask;
            m_wrapperEventListenerMaskList.add(listenerMask);
            m_wrapperEventListenerMasks = null;
        }
        WrapperManager.updateWrapperEventListenerFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWrapperEventListener(WrapperEventListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("removeWrapperEventListener"));
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            Iterator iter = m_wrapperEventListenerMaskList.iterator();
            while (iter.hasNext()) {
                WrapperEventListenerMask listenerMask = (WrapperEventListenerMask)iter.next();
                if (listenerMask.m_listener != listener) continue;
                iter.remove();
                m_wrapperEventListenerMasks = null;
                break;
            }
        }
        WrapperManager.updateWrapperEventListenerFlags();
    }

    public static File getWrapperLogFile() {
        File logFile = m_logFile;
        if (logFile == null) {
            throw new IllegalStateException(WrapperManager.getRes().getString("Not yet initialized."));
        }
        return logFile;
    }

    private WrapperManager() {
    }

    private static void checkSecurityManager() {
        if (m_securityManagerChecked) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Detected a SecurityManager: {0} ", securityManager.getClass().getName()));
            }
            try {
                securityManager.checkPermission(new AllPermission());
            }
            catch (SecurityException e) {
                m_outDebug.println();
                m_outDebug.println(WrapperManager.getRes().getString("WARNING - Detected that a SecurityManager has been installed but the "));
                m_outDebug.println(WrapperManager.getRes().getString("          wrapper.jar has not been granted the java.security.AllPermission"));
                m_outDebug.println(WrapperManager.getRes().getString("          permission.  This will most likely result in SecurityExceptions"));
                m_outDebug.println(WrapperManager.getRes().getString("          being thrown by the Wrapper."));
                m_outDebug.println();
            }
            m_securityManagerChecked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WrapperEventListenerMask[] getWrapperEventListenerMasks() {
        WrapperEventListenerMask[] listenerMasks = m_wrapperEventListenerMasks;
        if (listenerMasks == null) {
            Class clazz = WrapperManager.class;
            synchronized (clazz) {
                if (listenerMasks == null) {
                    listenerMasks = new WrapperEventListenerMask[m_wrapperEventListenerMaskList.size()];
                    m_wrapperEventListenerMaskList.toArray(listenerMasks);
                    m_wrapperEventListenerMasks = listenerMasks;
                }
            }
        }
        return listenerMasks;
    }

    private static void updateWrapperEventListenerFlags() {
        boolean core = false;
        WrapperEventListenerMask[] listenerMasks = WrapperManager.getWrapperEventListenerMasks();
        for (int i = 0; i < listenerMasks.length; ++i) {
            long mask = listenerMasks[i].m_mask;
            core |= (mask & 0xF000000000000000L) != 0L;
        }
        m_produceCoreEvents = core;
    }

    private static void fireWrapperEvent(WrapperEvent event) {
        long eventMask = event.getFlags();
        WrapperEventListenerMask[] listenerMasks = WrapperManager.getWrapperEventListenerMasks();
        for (int i = 0; i < listenerMasks.length; ++i) {
            long listenerMask = listenerMasks[i].m_mask;
            if ((listenerMask & eventMask) == 0L) continue;
            WrapperEventListener listener = listenerMasks[i].m_listener;
            try {
                listener.fired(event);
                continue;
            }
            catch (Throwable t) {
                m_outError.println(WrapperManager.getRes().getString("Encountered an uncaught exception while notifying WrapperEventListener of an event:"));
                t.printStackTrace(m_outError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopCommon(int exitCode, int delay) {
        boolean stopping;
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            stopping = m_stopping;
            if (!stopping) {
                m_stopping = true;
            }
        }
        if (!stopping) {
            WrapperManager.sendCommand((byte)101, Integer.toString(exitCode));
            if (delay > 0) {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Pausing for {0}ms to allow a clean shutdown...", new Integer(delay)));
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispose() {
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            m_disposed = true;
            WrapperManager.closeBackend();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void startCompleted() {
        m_startedTicks = WrapperManager.getTicks();
        m_startupRunner = null;
        WrapperManager.checkSecurityManager();
        WrapperManager.signalStarted();
        WrapperManager.class.notifyAll();
    }

    private static void startInner(boolean block) {
        m_starting = true;
        WrapperManager.checkTmpDir();
        if (m_listener == null) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("No WrapperListener has been set.  Nothing to start."));
            }
            WrapperManager.startCompleted();
        } else {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("calling WrapperListener.start()"));
            }
            final Integer[] resultF = new Integer[1];
            final Throwable[] tF = new Throwable[1];
            Thread startRunner = new Thread("WrapperListener_start_runner"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("WrapperListener.start runner thread started."));
                    }
                    Thread thisThread = Thread.currentThread();
                    thisThread.setPriority(5);
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Application start main thread: {0} Priority: {1}", thisThread.getName(), new Integer(thisThread.getPriority())));
                    }
                    try {
                        try {
                            resultF[0] = m_listener.start(m_args);
                        }
                        catch (Throwable t) {
                            tF[0] = t;
                        }
                        Object var4_3 = null;
                        thisThread.setPriority(10);
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        thisThread.setPriority(10);
                        if (tF[0] != null) {
                            m_outError.println(WrapperManager.getRes().getString("Error in WrapperListener.start callback.  {0}", tF[0]));
                            tF[0].printStackTrace(m_outError);
                            WrapperManager.privilegedStopInner(1);
                            return;
                        }
                        if (m_debug) {
                            m_outDebug.println(WrapperManager.getRes().getString("returned from WrapperListener.start()"));
                        }
                        if (resultF[0] != null) {
                            int exitCode = resultF[0];
                            if (m_debug) {
                                m_outDebug.println(WrapperManager.getRes().getString("WrapperListener.start() returned an exit code of {0}.", new Integer(exitCode)));
                            }
                            WrapperManager.stop(exitCode);
                            return;
                        }
                        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
                        synchronized (clazz) {
                            WrapperManager.startCompleted();
                        }
                        if (m_debug) {
                            m_outDebug.println(WrapperManager.getRes().getString("WrapperListener.start runner thread stopped."));
                        }
                        throw throwable;
                    }
                    if (tF[0] != null) {
                        m_outError.println(WrapperManager.getRes().getString("Error in WrapperListener.start callback.  {0}", tF[0]));
                        tF[0].printStackTrace(m_outError);
                        WrapperManager.privilegedStopInner(1);
                        return;
                    }
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("returned from WrapperListener.start()"));
                    }
                    if (resultF[0] != null) {
                        int exitCode = resultF[0];
                        if (m_debug) {
                            m_outDebug.println(WrapperManager.getRes().getString("WrapperListener.start() returned an exit code of {0}.", new Integer(exitCode)));
                        }
                        WrapperManager.stop(exitCode);
                        return;
                    }
                    Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
                    synchronized (clazz) {
                        WrapperManager.startCompleted();
                    }
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("WrapperListener.start runner thread stopped."));
                    }
                }
            };
            startRunner.setDaemon(false);
            startRunner.start();
            if (block) {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Waiting for WrapperListener.start runner thread to complete."));
                }
                while (startRunner != null && startRunner.isAlive()) {
                    try {
                        (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    private static void shutdownJVM(int exitCode) {
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("shutdownJVM({0}) Thread: {1}", new Integer(exitCode), Thread.currentThread().getName()));
        }
        WrapperManager.waitForShutdownLocks();
        WrapperManager.signalStopped(exitCode);
        WrapperManager.dispose();
        m_shutdownJVMComplete = true;
        if (Thread.currentThread() != m_hook) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("calling System.exit({0})", new Integer(exitCode)));
            }
            WrapperManager.safeSystemExit(exitCode);
        }
    }

    private static void safeSystemExit(int exitCode) {
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("WrapperManger stopped due to {0}", WrapperManager.getRes().getString("System Exit")));
        }
        m_stopped = true;
        try {
            System.exit(exitCode);
        }
        catch (IllegalThreadStateException e) {
            m_outError.println(WrapperManager.getRes().getString("Attempted System.exit({0}) call failed: {1}", new Integer(exitCode), e.toString()));
            m_outError.println(WrapperManager.getRes().getString("   Trying Runtime.halt({0})", new Integer(exitCode)));
            Runtime.getRuntime().halt(exitCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void privilegedStopInner(int exitCode) {
        boolean block;
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            m_stopping = true;
            if (m_stoppingThread == null) {
                m_stoppingThread = Thread.currentThread();
                block = false;
            } else {
                if (Thread.currentThread() == m_stoppingThread) {
                    throw new IllegalStateException(WrapperManager.getRes().getString("WrapperManager.stop() can not be called recursively."));
                }
                block = true;
            }
        }
        if (block) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Thread, {0}, waiting for the JVM to exit.", Thread.currentThread().getName()));
                if (Thread.currentThread() == m_hook && !m_hookRemoveFailed) {
                    m_outDebug.println(WrapperManager.getRes().getString("System.exit appears to have been called from within the\n  WrapperListener.stop() method.  If possible the application\n  should be modified to avoid this behavior.\n  To avoid a deadlock, this thread will only wait 5 seconds\n  for the application to shutdown.  This may result in the\n  application failing to shutdown completely before the JVM\n  exits.  Removing the offending System.exit call will\n  resolve this."));
                }
            }
            int loops = 0;
            int wait = 50;
            while (true) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (Thread.currentThread() == m_hook && (m_shutdownJVMComplete || loops > 5000 / wait)) {
                    if (!m_shutdownJVMComplete && m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Thread, {0}, continuing after 5 seconds.", Thread.currentThread().getName()));
                    }
                    WrapperManager.signalStopped(m_exitCode);
                    return;
                }
                ++loops;
            }
        }
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("Thread, {0}, handling the shutdown process.", Thread.currentThread().getName()));
        }
        m_exitCode = exitCode;
        if (Thread.currentThread() != m_hook && !m_hookTriggered && m_hook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(m_hook);
            }
            catch (AccessControlException e) {
                m_outError.println(WrapperManager.getRes().getString("Unable to remove the Wrapper''s shudownhook: {0}", e));
                m_hookRemoveFailed = true;
            }
        }
        int code = exitCode;
        if (m_listenerForceStop && m_starting || m_started) {
            if (m_listener == null) {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("No WrapperListener has been set.  Nothing to stop."));
                }
            } else {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("calling listener.stop()"));
                }
                if (Thread.currentThread().isDaemon()) {
                    final Integer[] codeF = new Integer[]{new Integer(code)};
                    Thread stopRunner = new Thread("WrapperListener_stop_runner"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (m_debug) {
                                m_outDebug.println(WrapperManager.getRes().getString("WrapperListener.stop runner thread started."));
                            }
                            Thread thisThread = Thread.currentThread();
                            thisThread.setPriority(5);
                            if (m_debug) {
                                m_outDebug.println(WrapperManager.getRes().getString("Application stop main thread: {0} Priority: {1}", thisThread.getName(), new Integer(thisThread.getPriority())));
                            }
                            try {
                                try {
                                    codeF[0] = new Integer(m_listener.stop(codeF[0]));
                                }
                                catch (Throwable t) {
                                    m_outError.println(WrapperManager.getRes().getString("Error in WrapperListener.stop callback."));
                                    t.printStackTrace(m_outError);
                                }
                                Object var4_3 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                if (m_debug) {
                                    m_outDebug.println(WrapperManager.getRes().getString("WrapperListener.stop runner thread stopped."));
                                }
                                throw throwable;
                            }
                            if (m_debug) {
                                m_outDebug.println(WrapperManager.getRes().getString("WrapperListener.stop runner thread stopped."));
                            }
                        }
                    };
                    stopRunner.setDaemon(false);
                    stopRunner.start();
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Waiting for WrapperListener.stop runner thread to complete."));
                    }
                    while (stopRunner != null && stopRunner.isAlive()) {
                        try {
                            stopRunner.join();
                            stopRunner = null;
                        }
                        catch (InterruptedException e) {}
                    }
                    code = codeF[0];
                } else {
                    try {
                        code = m_listener.stop(code);
                    }
                    catch (Throwable t) {
                        m_outError.println(WrapperManager.getRes().getString("Error in WrapperListener.stop callback."));
                        t.printStackTrace(m_outError);
                    }
                }
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("returned from listener.stop() -> {0}", new Integer(code)));
                }
            }
        }
        WrapperManager.shutdownJVM(code);
    }

    private static void signalStarted() {
        WrapperManager.sendCommand((byte)106, "");
        m_started = true;
    }

    private static void controlEvent(int event) {
        boolean ignore;
        String eventName;
        switch (event) {
            case 200: {
                eventName = "WRAPPER_CTRL_C_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 201: {
                eventName = "WRAPPER_CTRL_CLOSE_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 202: {
                eventName = "WRAPPER_CTRL_LOGOFF_EVENT";
                ignore = false;
                break;
            }
            case 203: {
                eventName = "WRAPPER_CTRL_SHUTDOWN_EVENT";
                ignore = false;
                break;
            }
            case 204: {
                eventName = "WRAPPER_CTRL_TERM_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 205: {
                eventName = "WRAPPER_CTRL_HUP_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 206: {
                eventName = "WRAPPER_CTRL_USR1_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 207: {
                eventName = "WRAPPER_CTRL_USR2_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            default: {
                eventName = WrapperManager.getRes().getString("Unexpected event: {0}", new Integer(event));
                ignore = false;
            }
        }
        WrapperControlEvent controlEvent = new WrapperControlEvent(event, eventName);
        if (ignore) {
            controlEvent.consume();
        }
        WrapperManager.fireWrapperEvent(controlEvent);
        if (ignore) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Ignoring control event({0})", eventName));
            }
        } else if (controlEvent.isConsumed()) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Control event({0}) was consumed by user listener.", eventName));
            }
        } else {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Processing control event({0})", eventName));
            }
            if (m_listener != null) {
                try {
                    m_listener.controlEvent(event);
                }
                catch (Throwable t) {
                    m_outError.println(WrapperManager.getRes().getString("Error in WrapperListener.controlEvent callback."));
                    t.printStackTrace(m_outError);
                }
            } else {
                WrapperManager.stop(0);
            }
        }
    }

    private static void readProperties(String rawProps) {
        WrapperProperties properties = new WrapperProperties();
        int len = rawProps.length();
        int first = 0;
        while (first < len) {
            StringBuffer sb = new StringBuffer();
            boolean foundEnd = false;
            do {
                int pos;
                if ((pos = rawProps.indexOf(PROPERTY_SEPARATOR, first)) >= 0) {
                    if (pos > 0) {
                        sb.append(rawProps.substring(first, pos));
                    }
                    if (pos < len - 1) {
                        if (rawProps.charAt(pos + 1) == PROPERTY_SEPARATOR) {
                            sb.append(PROPERTY_SEPARATOR);
                            first = pos + 2;
                            continue;
                        }
                        foundEnd = true;
                        first = pos + 1;
                        continue;
                    }
                    foundEnd = true;
                    first = pos + 1;
                    continue;
                }
                sb.append(rawProps.substring(first));
                foundEnd = true;
                first = len;
            } while (!foundEnd);
            String property = sb.toString();
            int pos = property.indexOf(61);
            if (pos <= 0) continue;
            String key = property.substring(0, pos);
            String value = pos < property.length() - 1 ? property.substring(pos + 1) : "";
            properties.setProperty(key, value);
            if (!key.equals("wrapper.ignore_user_logoffs")) continue;
            m_ignoreUserLogoffs = value.equalsIgnoreCase("true");
        }
        properties.lock();
        m_properties = properties;
    }

    private static synchronized void openBackendSocket() {
        boolean fixedPort;
        int tryPort;
        InetAddress iNetAddress;
        if (m_debug) {
            m_outDebug.println(WrapperManager.getRes().getString("Open socket to wrapper...{0}", Thread.currentThread().getName()));
        }
        try {
            iNetAddress = InetAddress.getByName(m_wrapperPortAddress);
        }
        catch (UnknownHostException e) {
            m_outError.println(WrapperManager.getRes().getString("Unable to resolve localhost name: {0}", e));
            m_outError.println(WrapperManager.getRes().getString("Exiting JVM..."));
            WrapperManager.stop(1);
            return;
        }
        boolean connected = false;
        if (m_jvmPort >= 0) {
            tryPort = m_jvmPort;
            fixedPort = true;
        } else {
            tryPort = m_jvmPortMin;
            fixedPort = false;
        }
        SocketException causeException = null;
        do {
            block30: {
                int portStatus;
                if (WrapperManager.isNativeLibraryOk()) {
                    try {
                        portStatus = WrapperManager.nativeGetPortStatus(tryPort, m_wrapperPortAddress, m_backendType == 2 ? 1 : 0);
                    }
                    catch (UnsatisfiedLinkError e) {
                        m_outError.println(WrapperManager.getRes().getString("Unable to precheck status of port {0} due to: {1}", new Integer(tryPort), e.toString()));
                        portStatus = -1;
                    }
                } else {
                    portStatus = -1;
                }
                if (portStatus <= 0) {
                    try {
                        m_backendSocket = new Socket(iNetAddress, m_port, iNetAddress, tryPort);
                        if (m_debug) {
                            m_outDebug.println(WrapperManager.getRes().getString("Opened Socket from {0} to {1}", new Integer(tryPort), new Integer(m_port)));
                        }
                        connected = true;
                        break;
                    }
                    catch (SocketException e) {
                        String eMessage = e.getMessage();
                        if (e instanceof ConnectException) {
                            m_outError.println(WrapperManager.getRes().getString("Failed to connect to the Wrapper at port {0}. Cause: {1}", new Integer(m_port), e));
                            m_outError.println("Exiting JVM...");
                            WrapperManager.stopImmediate(1);
                            m_backendSocket = null;
                            return;
                        }
                        if (e instanceof BindException || eMessage != null && (eMessage.indexOf("errno: 48") >= 0 || eMessage.indexOf("Address already in use") >= 0) || eMessage.indexOf("Unrecognized Windows Sockets error: 0: JVM_Bind") >= 0) {
                            if (m_debug) {
                                m_outDebug.println(WrapperManager.getRes().getString("Unable to open socket to Wrapper from port {0}, already in use.", new Integer(tryPort)));
                            }
                            if (causeException == null) {
                                causeException = e;
                            }
                            break block30;
                        }
                        m_outError.println(WrapperManager.getRes().getString("Unexpected exception opening backend socket: {0}", e));
                        m_backendSocket = null;
                        return;
                    }
                    catch (IOException e) {
                        m_outError.println(WrapperManager.getRes().getString("Unable to open backend socket: {0}", e));
                        m_backendSocket = null;
                        return;
                    }
                }
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Unable to open socket to Wrapper from port {0}, already in use. ({1})", new Integer(tryPort), Integer.toString(portStatus)));
                }
            }
            if (fixedPort) {
                tryPort = m_jvmPortMin;
                fixedPort = false;
                continue;
            }
            ++tryPort;
        } while (tryPort <= m_jvmPortMax);
        if (connected) {
            if (m_jvmPort >= 0 && m_jvmPort != tryPort) {
                m_outInfo.println(WrapperManager.getRes().getString("Port {0} already in use, using port {1} instead.", new Integer(m_jvmPort), new Integer(tryPort)));
            }
        } else {
            if (m_jvmPortMax > m_jvmPortMin) {
                m_outError.println(WrapperManager.getRes().getString("Failed to connect to the Wrapper at port {0} by binding to any ports in the range {1} to {2}.  Cause: {3}", new Integer(m_port), new Integer(m_jvmPortMin), new Integer(m_jvmPortMax), causeException));
            } else {
                m_outError.println(WrapperManager.getRes().getString("Failed to connect to the Wrapper at port {0} by binding to port {1}.  Cause: {2}", new Integer(m_port), new Integer(m_jvmPortMin), causeException));
            }
            m_outError.println(WrapperManager.getRes().getString("Exiting JVM..."));
            WrapperManager.stopImmediate(1);
        }
        try {
            m_backendSocket.setTcpNoDelay(true);
            if (m_soTimeout >= 0) {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Setting backend socket SO_TIMEOUT to {0}ms from {1}ms.", new Integer(m_soTimeout), new Integer(m_backendSocket.getSoTimeout())));
                }
                m_backendSocket.setSoTimeout(m_soTimeout);
            }
            m_backendOS = m_backendSocket.getOutputStream();
            m_backendIS = m_backendSocket.getInputStream();
        }
        catch (IOException e) {
            m_outError.println(e);
            WrapperManager.closeBackend();
            return;
        }
        m_backendConnected = true;
    }

    private static synchronized void openBackendPipe() {
        String s = WrapperManager.isWindows() ? "\\\\.\\pipe\\wrapper-" + WrapperManager.getWrapperPID() + "-" + WrapperManager.getJVMId() : "/tmp/wrapper-" + WrapperManager.getWrapperPID() + "-" + WrapperManager.getJVMId();
        try {
            m_backendIS = new FileInputStream(new File(s + "-out"));
            m_backendOS = new FileOutputStream(new File(s + "-in"));
        }
        catch (IOException e) {
            m_outInfo.println("write error " + e);
            e.printStackTrace();
            WrapperManager.closeBackend();
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            WrapperManager.closeBackend();
            return;
        }
        m_backendConnected = true;
    }

    private static synchronized void openBackend() {
        m_backendConnected = false;
        if (m_backendType == 4) {
            WrapperManager.openBackendPipe();
        } else {
            WrapperManager.openBackendSocket();
        }
        if (!m_backendConnected) {
            m_outError.println(WrapperManager.getRes().getString("The backend could not be initialized.  Restart to resync with the Wrapper."));
            WrapperManager.restart();
            return;
        }
        WrapperManager.sendCommand((byte)110, m_key);
        if (m_pendingStopMessage != null) {
            m_outDebug.println(WrapperManager.getRes().getString("Resend pending packet {0} : {1}", WrapperManager.getPacketCodeName((byte)101), m_pendingStopMessage));
            WrapperManager.sendCommand((byte)101, m_pendingStopMessage);
            m_pendingStopMessage = null;
        }
    }

    private static synchronized void closeBackend() {
        if (m_backendConnected) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Closing backend connection."));
            }
            long start = System.currentTimeMillis();
            while (m_runningExecs > 0) {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Waiting for {0} threads to finish launching child processes...", new Integer(m_runningExecs)));
                }
                try {
                    (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start <= 30000L) continue;
                m_outError.println(WrapperManager.getRes().getString("Timed out waiting for {0} threads to finish launching child processes.", new Integer(m_runningExecs)));
                break;
            }
            m_backendConnected = false;
            Thread commRunner = m_commRunner;
            if (commRunner != null) {
                try {
                    commRunner.interrupt();
                }
                catch (SecurityException e) {
                    m_outError.println(WrapperManager.getRes().getString("Failed to interrupt communications thread: {0}", e.getMessage()));
                }
            }
        }
        if (m_backendOS != null) {
            block16: {
                try {
                    m_backendOS.close();
                }
                catch (IOException e) {
                    if (!m_debug) break block16;
                    m_outDebug.println(WrapperManager.getRes().getString("Unable to close backend output stream: {0}", e.toString()));
                }
            }
            m_backendOS = null;
        }
        if (m_backendIS != null) {
            m_backendIS = null;
        }
        if (m_backendSocket != null) {
            block17: {
                try {
                    m_backendSocket.close();
                }
                catch (IOException e) {
                    if (!m_debug) break block17;
                    m_outDebug.println(WrapperManager.getRes().getString("Unable to close backend socket: {0}", e.toString()));
                }
            }
            m_backendSocket = null;
        }
    }

    private static String getPacketCodeName(byte code) {
        String name;
        switch (code) {
            case 100: {
                name = "START";
                break;
            }
            case 101: {
                name = "STOP";
                break;
            }
            case 102: {
                name = "RESTART";
                break;
            }
            case 103: {
                name = "PING";
                break;
            }
            case 104: {
                name = "STOP_PENDING";
                break;
            }
            case 105: {
                name = "START_PENDING";
                break;
            }
            case 106: {
                name = "STARTED";
                break;
            }
            case 107: {
                name = "STOPPED";
                break;
            }
            case 110: {
                name = "KEY";
                break;
            }
            case 111: {
                name = "BADKEY";
                break;
            }
            case 112: {
                name = "LOW_LOG_LEVEL";
                break;
            }
            case 113: {
                name = "PING_TIMEOUT";
                break;
            }
            case 114: {
                name = "SERVICE_CONTROL_CODE";
                break;
            }
            case 115: {
                name = "PROPERTIES";
                break;
            }
            case 117: {
                name = "LOG(DEBUG)";
                break;
            }
            case 118: {
                name = "LOG(INFO)";
                break;
            }
            case 119: {
                name = "LOG(STATUS)";
                break;
            }
            case 120: {
                name = "LOG(WARN)";
                break;
            }
            case 121: {
                name = "LOG(ERROR)";
                break;
            }
            case 122: {
                name = "LOG(FATAL)";
                break;
            }
            case 123: {
                name = "LOG(ADVICE)";
                break;
            }
            case 124: {
                name = "LOG(NOTICE)";
                break;
            }
            case -124: {
                name = "CHILD_LAUNCH";
                break;
            }
            case -123: {
                name = "CHILD_TERM";
                break;
            }
            case -122: {
                name = "LOGFILE";
                break;
            }
            case -121: {
                name = "CHECK_DEADLOCK";
                break;
            }
            case -120: {
                name = "DEADLOCK";
                break;
            }
            case -119: {
                name = "APPEAR_ORPHAN";
                break;
            }
            case -118: {
                name = "PAUSE";
                break;
            }
            case -117: {
                name = "RESUME";
                break;
            }
            case -116: {
                name = "GC";
                break;
            }
            case -115: {
                name = "FIRE_USER_EVENT";
                break;
            }
            case -114: {
                name = "SECOND_INVOCATION_EVENT";
                break;
            }
            default: {
                name = "UNKNOWN(" + code + ")";
            }
        }
        return name;
    }

    private static synchronized void sendCommand(byte code, String message) {
        if (m_debug && (code != 103 || !message.startsWith("silent"))) {
            if (!m_backendConnected) {
                m_outDebug.println(WrapperManager.getRes().getString("Backend not connected, not sending packet {0} : {1}", WrapperManager.getPacketCodeName(code), message));
                if (code == 101) {
                    m_pendingStopMessage = message;
                }
            } else {
                m_outDebug.println(WrapperManager.getRes().getString("Send a packet {0} : {1}", WrapperManager.getPacketCodeName(code), message));
            }
        }
        boolean sentCommand = false;
        if (!m_appearHung) {
            if (code == 105 || code == 106) {
                m_lastPingTicks = WrapperManager.getTicks();
            }
            if (m_backendConnected) {
                try {
                    byte[] messageBytes = message.getBytes();
                    if (m_commandBuffer.length < messageBytes.length + 2) {
                        m_commandBuffer = new byte[messageBytes.length + 2];
                    }
                    WrapperManager.m_commandBuffer[0] = code;
                    System.arraycopy(messageBytes, 0, m_commandBuffer, 1, messageBytes.length);
                    int len = messageBytes.length + 2;
                    WrapperManager.m_commandBuffer[len - 1] = 0;
                    m_backendOS.write(m_commandBuffer, 0, len);
                    m_backendOS.flush();
                    sentCommand = true;
                }
                catch (IOException e) {
                    m_outError.println(e);
                    e.printStackTrace(m_outError);
                    WrapperManager.closeBackend();
                }
            }
        }
        if (!sentCommand) {
            switch (code) {
                case -124: {
                    m_outError.println(WrapperManager.getRes().getString("Failed to notify the Wrapper process that child with PID={0} was launched.  The Wrapper will not be able to make sure it is terminated when the Java process exits.", message));
                    break;
                }
                case -123: {
                    if (!m_debug) break;
                    m_outDebug.println(WrapperManager.getRes().getString("Failed to notify the Wrapper process that child with PID={0} completed.  The Wrapper will recover on its own.", message));
                    break;
                }
            }
        }
    }

    private static void handleBackend() {
        WrapperPingEvent pingEvent = new WrapperPingEvent();
        try {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("handleBackend()"));
            }
            DataInputStream is = new DataInputStream(m_backendIS);
            block33: while (!m_disposed) {
                try {
                    byte b;
                    byte code = is.readByte();
                    int i = 0;
                    do {
                        if ((b = is.readByte()) == 0) continue;
                        if (i >= m_backendReadBuffer.length) {
                            byte[] tmp = m_backendReadBuffer;
                            m_backendReadBuffer = new byte[tmp.length + 256];
                            System.arraycopy(tmp, 0, m_backendReadBuffer, 0, tmp.length);
                        }
                        WrapperManager.m_backendReadBuffer[i] = b;
                        ++i;
                    } while (b != 0);
                    String msg = new String(m_backendReadBuffer, 0, i);
                    if (m_appearHung) continue;
                    if (m_debug) {
                        String logMsg = code == 115 ? WrapperManager.getRes().getString("(Property Values, Size={0})", Integer.toString(i)) : msg;
                        if (code != 103 || !msg.startsWith("silent")) {
                            m_outDebug.println(WrapperManager.getRes().getString("Received a packet {0} : {1}", WrapperManager.getPacketCodeName(code), logMsg));
                        }
                    }
                    if (m_slowSeconds > 0) {
                        if (m_debug) {
                            m_outDebug.println(WrapperManager.getRes().getString("  Delay packet processing by {0} seconds.", new Integer(m_slowSeconds)));
                        }
                        try {
                            Thread.sleep(m_slowSeconds * 1000);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    switch (code) {
                        case 100: {
                            if (m_stoppingInit) {
                                if (!m_debug) continue block33;
                                m_outDebug.println(WrapperManager.getRes().getString("Java stop initiated.  Skipping application startup."));
                                break;
                            }
                            WrapperManager.startInner(false);
                            break;
                        }
                        case 101: {
                            if (m_stopping) continue block33;
                            WrapperManager.privilegedStopInner(0);
                            break;
                        }
                        case 103: {
                            m_lastPingTicks = WrapperManager.getTicks();
                            WrapperManager.sendCommand((byte)103, msg);
                            if (!m_produceCoreEvents) continue block33;
                            WrapperManager.fireWrapperEvent(pingEvent);
                            break;
                        }
                        case -121: {
                            boolean deadLocked = WrapperManager.checkDeadlocks();
                            if (!deadLocked) continue block33;
                            WrapperManager.sendCommand((byte)-120, "deadLock");
                            break;
                        }
                        case 111: {
                            m_outError.println(WrapperManager.getRes().getString("Authorization key rejected by Wrapper."));
                            m_outError.println(WrapperManager.getRes().getString("Exiting JVM..."));
                            WrapperManager.closeBackend();
                            WrapperManager.privilegedStopInner(1);
                            break;
                        }
                        case 112: {
                            try {
                                m_lowLogLevel = Integer.parseInt(msg);
                                m_debug = m_lowLogLevel <= 1;
                                if (!m_debug) continue block33;
                                m_outDebug.println(WrapperManager.getRes().getString("LowLogLevel from Wrapper is {0}", new Integer(m_lowLogLevel)));
                            }
                            catch (NumberFormatException e) {
                                m_outError.println(WrapperManager.getRes().getString("Encountered an Illegal LowLogLevel from the Wrapper: {0}", msg));
                            }
                            break;
                        }
                        case 113: {
                            break;
                        }
                        case 114: {
                            WrapperServiceEvent event;
                            try {
                                int serviceControlCode = Integer.parseInt(msg);
                                if (m_debug) {
                                    m_outDebug.println(WrapperManager.getRes().getString("ServiceControlCode from Wrapper with code {0}", new Integer(serviceControlCode)));
                                }
                                event = new WrapperServiceControlEvent(serviceControlCode);
                                WrapperManager.fireWrapperEvent(event);
                            }
                            catch (NumberFormatException e) {
                                m_outError.println(WrapperManager.getRes().getString("Encountered an Illegal ServiceControlCode from the Wrapper: {0}", msg));
                            }
                            break;
                        }
                        case -118: {
                            WrapperServiceEvent event;
                            try {
                                int actionSourceCode = Integer.parseInt(msg);
                                if (m_debug) {
                                    m_outDebug.println(WrapperManager.getRes().getString("Pause from Wrapper with action source: {0}", WrapperServicePauseEvent.getSourceCodeName(actionSourceCode)));
                                }
                                event = new WrapperServicePauseEvent(actionSourceCode);
                                WrapperManager.fireWrapperEvent(event);
                            }
                            catch (NumberFormatException e) {
                                m_outError.println(WrapperManager.getRes().getString("Encountered an Illegal action source code from the Wrapper: {0}", msg));
                            }
                            break;
                        }
                        case -117: {
                            WrapperServiceEvent event;
                            try {
                                int actionSourceCode = Integer.parseInt(msg);
                                if (m_debug) {
                                    m_outDebug.println(WrapperManager.getRes().getString("Resume from Wrapper with action source: {0}", WrapperServiceResumeEvent.getSourceCodeName(actionSourceCode)));
                                }
                                event = new WrapperServiceResumeEvent(actionSourceCode);
                                WrapperManager.fireWrapperEvent(event);
                            }
                            catch (NumberFormatException e) {
                                m_outError.println(WrapperManager.getRes().getString("Encountered an Illegal action source code from the Wrapper: {0}", msg));
                            }
                            break;
                        }
                        case -116: {
                            try {
                                int actionSourceCode = Integer.parseInt(msg);
                                if (m_debug) {
                                    m_outDebug.println(WrapperManager.getRes().getString("Garbage Collection request from Wrapper with action source: {0}", WrapperServiceActionEvent.getSourceCodeName(actionSourceCode)));
                                }
                                System.gc();
                            }
                            catch (NumberFormatException e) {
                                m_outError.println(WrapperManager.getRes().getString("Encountered an Illegal action source code from the Wrapper: {0}", msg));
                            }
                            break;
                        }
                        case 115: {
                            WrapperManager.readProperties(msg);
                            break;
                        }
                        case -122: {
                            m_logFile = new File(msg);
                            WrapperLogFileChangedEvent event = new WrapperLogFileChangedEvent(m_logFile);
                            WrapperManager.fireWrapperEvent(event);
                            break;
                        }
                        case -114: {
                            WrapperSecondInvocationEvent secondInvocationEvent = new WrapperSecondInvocationEvent();
                            WrapperManager.fireWrapperEvent(secondInvocationEvent);
                            WrapperManager.sendCommand((byte)-114, "");
                            break;
                        }
                        default: {
                            m_outInfo.println(WrapperManager.getRes().getString("Wrapper code received an unknown packet type: {0}", new Integer(code)));
                        }
                    }
                }
                catch (SocketTimeoutException e) {
                    if (!m_debug) continue;
                    m_outDebug.println(WrapperManager.getRes().getString("Backend socket timed out.  Attempting to continue.  (SO_TIMEOUT={0}ms.)", new Integer(m_backendSocket.getSoTimeout())));
                }
            }
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Backend handler loop completed.  Disposed: {0}", m_disposed ? "True" : "False"));
            }
            return;
        }
        catch (SocketException e) {
            if (m_debug) {
                if (m_backendSocket == null) {
                    m_outDebug.println(WrapperManager.getRes().getString("Closed backend socket (Normal): {0}", e));
                } else {
                    m_outDebug.println(WrapperManager.getRes().getString("Closed backend socket: {0}", e));
                }
            }
            return;
        }
        catch (IOException e) {
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Closed backend (Normal): {0}", e));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startRunner() {
        if (WrapperManager.isControlledByNativeWrapper()) {
            if (m_commRunner == null) {
                m_commRunner = new Thread((Runnable)m_instance, WRAPPER_CONNECTION_THREAD_NAME);
                m_commRunner.setDaemon(true);
                m_commRunner.start();
            }
            Class clazz = WrapperManager.class;
            synchronized (clazz) {
                while (!m_commRunnerStarted) {
                    try {
                        (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            m_commRunnerStarted = true;
            WrapperManager.class.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Class clazz;
        block38: {
            if (Thread.currentThread() != m_commRunner) {
                throw new IllegalStateException(WrapperManager.getRes().getString("Only the communications runner thread is allowed to call this method."));
            }
            if (m_debug) {
                m_outDebug.println(WrapperManager.getRes().getString("Communications runner thread started."));
            }
            Thread.currentThread().setPriority(10);
            m_lastPingTicks = WrapperManager.getTicks();
            try {
                try {
                    WrapperManager.openBackend();
                    if (!m_commRunnerStarted) {
                        clazz = WrapperManager.class;
                        synchronized (clazz) {
                            m_commRunnerStarted = true;
                            WrapperManager.class.notifyAll();
                        }
                    }
                    if (m_backendSocket != null || m_backendConnected) {
                        WrapperManager.handleBackend();
                    } else {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                        }
                    }
                    Object var4_5 = null;
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Returned from backend handler."));
                    }
                }
                catch (ThreadDeath td) {
                    m_outError.println(WrapperManager.getRes().getString("Server daemon killed"));
                    Object var4_6 = null;
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Returned from backend handler."));
                    }
                    WrapperManager.closeBackend();
                    if (WrapperManager.isShuttingDown()) break block38;
                    if (m_detachStarted && m_started) {
                        m_outInfo.println(WrapperManager.getRes().getString("The backend was closed as expected."));
                        if (WrapperManager.isNativeLibraryOk()) {
                            WrapperManager.nativeRedirectPipes();
                            break block38;
                        } else {
                            m_outError.println(WrapperManager.getRes().getString("Failed to redirect stdout and stderr before the Wrapper exits.\nOutput from the JVM may block.\nPlease make sure the native library has been properly initialized."));
                        }
                        break block38;
                    }
                    m_outError.println(WrapperManager.getRes().getString("The backend was closed unexpectedly.  Restart to resync with the Wrapper."));
                    WrapperManager.restart();
                    break block38;
                }
                catch (Throwable t) {
                    if (!WrapperManager.isShuttingDown()) {
                        m_outError.println(WrapperManager.getRes().getString("Server daemon died!"));
                        t.printStackTrace(m_outError);
                    } else if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Server daemon died!"));
                        t.printStackTrace(m_outDebug);
                    }
                    Object var4_7 = null;
                    if (m_debug) {
                        m_outDebug.println(WrapperManager.getRes().getString("Returned from backend handler."));
                    }
                    WrapperManager.closeBackend();
                    if (WrapperManager.isShuttingDown()) break block38;
                    if (m_detachStarted && m_started) {
                        m_outInfo.println(WrapperManager.getRes().getString("The backend was closed as expected."));
                        if (WrapperManager.isNativeLibraryOk()) {
                            WrapperManager.nativeRedirectPipes();
                            break block38;
                        } else {
                            m_outError.println(WrapperManager.getRes().getString("Failed to redirect stdout and stderr before the Wrapper exits.\nOutput from the JVM may block.\nPlease make sure the native library has been properly initialized."));
                        }
                        break block38;
                    }
                    m_outError.println(WrapperManager.getRes().getString("The backend was closed unexpectedly.  Restart to resync with the Wrapper."));
                    WrapperManager.restart();
                    break block38;
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Returned from backend handler."));
                }
                WrapperManager.closeBackend();
                if (WrapperManager.isShuttingDown()) throw throwable;
                if (m_detachStarted && m_started) {
                    m_outInfo.println(WrapperManager.getRes().getString("The backend was closed as expected."));
                    if (WrapperManager.isNativeLibraryOk()) {
                        WrapperManager.nativeRedirectPipes();
                        throw throwable;
                    }
                    m_outError.println(WrapperManager.getRes().getString("Failed to redirect stdout and stderr before the Wrapper exits.\nOutput from the JVM may block.\nPlease make sure the native library has been properly initialized."));
                    throw throwable;
                }
                m_outError.println(WrapperManager.getRes().getString("The backend was closed unexpectedly.  Restart to resync with the Wrapper."));
                WrapperManager.restart();
                throw throwable;
            }
            WrapperManager.closeBackend();
            if (!WrapperManager.isShuttingDown()) {
                if (m_detachStarted && m_started) {
                    m_outInfo.println(WrapperManager.getRes().getString("The backend was closed as expected."));
                    if (WrapperManager.isNativeLibraryOk()) {
                        WrapperManager.nativeRedirectPipes();
                    } else {
                        m_outError.println(WrapperManager.getRes().getString("Failed to redirect stdout and stderr before the Wrapper exits.\nOutput from the JVM may block.\nPlease make sure the native library has been properly initialized."));
                    }
                } else {
                    m_outError.println(WrapperManager.getRes().getString("The backend was closed unexpectedly.  Restart to resync with the Wrapper."));
                    WrapperManager.restart();
                }
            }
        }
        clazz = WrapperManager.class;
        synchronized (clazz) {
            if (!m_commRunnerStarted) {
                m_commRunnerStarted = true;
                WrapperManager.class.notifyAll();
            }
        }
        if (!m_debug) return;
        m_outDebug.println(WrapperManager.getRes().getString("Server daemon shut down"));
    }

    private static boolean checkDeadlocks() throws WrapperLicenseError {
        if (WrapperManager.isStandardEdition()) {
            boolean result = false;
            if (WrapperManager.isNativeLibraryOk()) {
                result = WrapperManager.nativeCheckDeadLocks();
            } else {
                if (m_debug) {
                    m_outDebug.println(WrapperManager.getRes().getString("Deadlock check skipped.  Native call unavailable."));
                }
                result = false;
            }
            return result;
        }
        return false;
    }

    static {
        m_windows = false;
        m_macosx = false;
        m_aix = false;
        m_securityManagerChecked = false;
        m_disposed = false;
        m_starting = false;
        m_started = false;
        m_instance = null;
        m_hook = null;
        m_hookTriggered = false;
        m_hookRemoveFailed = false;
        m_shutdownJVMComplete = false;
        m_shutdownLockMap = new HashMap();
        m_shutdownLocks = 0;
        m_runningExecs = 0;
        m_backendType = 0;
        m_backendConnected = false;
        m_backendOS = null;
        m_backendIS = null;
        m_port = 15003;
        m_wrapperPortAddress = null;
        m_soTimeout = -1;
        m_cpuTimeout = 10000L;
        m_lowLogLevel = 9;
        m_ignoreSignals = false;
        m_detachStarted = false;
        m_commRunnerStarted = false;
        m_appearHung = false;
        m_slowSeconds = 0;
        m_ignoreUserLogoffs = false;
        m_service = false;
        m_debug = false;
        m_logFinalizer = false;
        m_jvmId = 0;
        m_stoppingInit = false;
        m_stopping = false;
        m_stopped = false;
        m_pendingStopMessage = null;
        m_libraryOK = false;
        m_commandBuffer = new byte[512];
        m_logFile = null;
        m_wrapperEventListenerMaskList = new ArrayList();
        m_wrapperEventListenerMasks = null;
        m_produceCoreEvents = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedClassInit();
                return null;
            }
        });
        PROPERTY_SEPARATOR = (char)9;
        m_backendReadBuffer = new byte[256];
    }

    private static class WrapperInputStream
    extends InputStream {
        private WrapperInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            m_outInfo.println(WrapperManager.getRes().getString("WARNING - System.in has been disabled by the wrapper.disable_console_input property.  Calls will block indefinitely."));
            while (true) {
                WrapperInputStream wrapperInputStream = this;
                synchronized (wrapperInputStream) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class WrapperTickEventImpl
    extends WrapperTickEvent {
        private int m_ticks;
        private int m_tickOffset;

        private WrapperTickEventImpl() {
        }

        public int getTicks() {
            return this.m_ticks;
        }

        public int getTickOffset() {
            return this.m_tickOffset;
        }
    }

    private static class WrapperEventListenerMask {
        private WrapperEventListener m_listener;
        private long m_mask;

        private WrapperEventListenerMask() {
        }
    }

    private static class ShutdownLock {
        private final Thread m_thread;
        private int m_count;

        private ShutdownLock(Thread thread) {
            this.m_thread = thread;
        }
    }
}

