/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import [Ljava.lang.String;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;

public class WrapperStartStopApp
implements WrapperListener,
Runnable {
    private static WrapperPrintStream m_outInfo;
    private static WrapperPrintStream m_outError;
    private static WrapperPrintStream m_outDebug;
    private Method m_startMainMethod;
    private String[] m_startMainArgs;
    private Method m_stopMainMethod;
    private boolean m_stopWait;
    private String[] m_stopMainArgs;
    private boolean m_mainStarted;
    private boolean m_mainComplete;
    private Integer m_mainExitCode;
    private boolean m_ignoreMainExceptions;
    private boolean m_startComplete;
    private boolean m_initFailed;
    private String m_initError;
    private boolean m_initShowUsage;
    private Throwable m_initException;
    private final String PASSTHROUGH_MODE_IGNORE = "ignore";
    private final String PASSTHROUGH_MODE_BOTH = "both";
    private final String PASSTHROUGH_MODE_START = "start";
    private final String PASSTHROUGH_MODE_STOP = "stop";

    protected WrapperStartStopApp(String[] args) {
        String[] startArgs;
        Class wmClass = WrapperManager.class;
        m_outInfo = new WrapperPrintStream(System.out, "WrapperStartStopApp: ");
        m_outError = new WrapperPrintStream(System.out, "WrapperStartStopApp Error: ");
        m_outDebug = new WrapperPrintStream(System.out, "WrapperStartStopApp Debug: ");
        if (args.length < 5) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Not enough argments.  Minimum {0} required.", "5");
            this.m_initShowUsage = true;
            startArgs = new String[]{};
        } else {
            this.m_startMainMethod = this.getMainMethod(args[0]);
            int argCount = this.getArgCount(args, 1);
            if (argCount < 0) {
                startArgs = new String[]{};
            } else {
                startArgs = this.getArgs(args, 1, argCount);
                if (startArgs == null) {
                    startArgs = new String[]{};
                } else {
                    int stopArgBase = 2 + startArgs.length;
                    if (args.length < stopArgBase + 3) {
                        this.m_initFailed = true;
                        this.m_initError = WrapperManager.getRes().getString("Not enough argments. Minimum 3 after start arguments.");
                        this.m_initShowUsage = true;
                    } else {
                        this.m_stopMainMethod = this.getMainMethod(args[stopArgBase]);
                        if (args[stopArgBase + 1].equalsIgnoreCase("true")) {
                            this.m_stopWait = true;
                        } else if (args[stopArgBase + 1].equalsIgnoreCase("false")) {
                            this.m_stopWait = false;
                        } else {
                            this.m_initFailed = true;
                            this.m_initError = WrapperManager.getRes().getString("The stop_wait argument must be either true or false.");
                            this.m_initShowUsage = true;
                        }
                        if (!this.m_initFailed && (argCount = this.getArgCount(args, stopArgBase + 2)) >= 0) {
                            int expectedSize;
                            this.m_stopMainArgs = this.getArgs(args, stopArgBase + 2, argCount);
                            if (this.m_stopMainArgs != null && (expectedSize = stopArgBase + 2 + argCount + 1) < args.length) {
                                String passthroughMode = WrapperSystemPropertyUtil.getStringProperty(WrapperStartStopApp.class.getName() + ".passthroughMode", "ignore");
                                if (passthroughMode.equalsIgnoreCase("both")) {
                                    startArgs = this.addPassthroughParams(startArgs, args, expectedSize);
                                    this.m_stopMainArgs = this.addPassthroughParams(this.m_stopMainArgs, args, expectedSize);
                                } else if (passthroughMode.equalsIgnoreCase("start")) {
                                    startArgs = this.addPassthroughParams(startArgs, args, expectedSize);
                                } else if (passthroughMode.equalsIgnoreCase("stop")) {
                                    this.m_stopMainArgs = this.addPassthroughParams(this.m_stopMainArgs, args, expectedSize);
                                }
                            }
                        }
                    }
                }
            }
        }
        WrapperManager.start(this, startArgs);
    }

    protected WrapperStartStopApp(Method startMainMethod, Method stopMainMethod, boolean stopWait, String[] stopMainArgs) {
        this.m_startMainMethod = startMainMethod;
        this.m_stopMainMethod = stopMainMethod;
        this.m_stopWait = stopWait;
        this.m_stopMainArgs = stopMainArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Throwable t;
        block24: {
            WrapperStartStopApp wrapperStartStopApp = this;
            synchronized (wrapperStartStopApp) {
                this.m_mainStarted = true;
                this.notifyAll();
            }
            t = null;
            try {
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println(WrapperManager.getRes().getString("invoking start main method"));
                }
                try {
                    try {
                        this.m_startMainMethod.invoke(null, new Object[]{this.m_startMainArgs});
                    }
                    catch (IllegalArgumentException iae) {
                        this.m_startMainMethod.invoke(null, new Object[0]);
                    }
                }
                finally {
                    Thread.currentThread().setPriority(10);
                }
                if (WrapperManager.isDebugEnabled()) {
                    m_outDebug.println(WrapperManager.getRes().getString("start main method completed"));
                }
                WrapperStartStopApp iae = this;
                synchronized (iae) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            catch (IllegalAccessException e) {
                t = e;
            }
            catch (IllegalArgumentException e) {
                t = e;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                if (t != null) break block24;
                t = e;
            }
        }
        m_outInfo.println();
        m_outError.println(WrapperManager.getRes().getString("Encountered an error running start main: {0}", t));
        t.printStackTrace(m_outError);
        WrapperStartStopApp wrapperStartStopApp = this;
        synchronized (wrapperStartStopApp) {
            if (this.m_ignoreMainExceptions) {
                if (!this.m_startComplete) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            if (this.m_startComplete) {
                WrapperManager.stop(1);
                return;
            }
            this.m_mainComplete = true;
            this.m_mainExitCode = new Integer(1);
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start(String[] args) {
        int maxLoops;
        if (this.m_initFailed) {
            if (this.m_initError != null) {
                m_outError.println(this.m_initError);
            }
            if (this.m_initException != null) {
                this.m_initException.printStackTrace(m_outError);
            }
            if (this.m_initShowUsage) {
                this.showUsage();
            }
            return new Integer(1);
        }
        boolean waitForStartMain = WrapperSystemPropertyUtil.getBooleanProperty(WrapperStartStopApp.class.getName() + ".waitForStartMain", false);
        this.m_ignoreMainExceptions = WrapperSystemPropertyUtil.getBooleanProperty(WrapperStartStopApp.class.getName() + ".ignoreMainExceptions", false);
        int maxStartMainWait = WrapperSystemPropertyUtil.getIntProperty(WrapperStartStopApp.class.getName() + ".maxStartMainWait", 2);
        maxStartMainWait = Math.max(1, maxStartMainWait);
        if (waitForStartMain) {
            maxLoops = Integer.MAX_VALUE;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) Will wait indefinitely for the main method to complete."));
            }
        } else {
            maxLoops = maxStartMainWait;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) Will wait up to {0} seconds for the main method to complete.", new Integer(maxLoops)));
            }
        }
        Thread mainThread = new Thread((Runnable)this, "WrapperStartStopAppMain");
        WrapperStartStopApp wrapperStartStopApp = this;
        synchronized (wrapperStartStopApp) {
            this.m_startMainArgs = args;
            mainThread.start();
            Thread.currentThread().setPriority(10);
            while (!this.m_mainStarted) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {}
            }
            for (int loops = 0; loops < maxLoops && !this.m_mainComplete; ++loops) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.m_mainComplete) continue;
                WrapperManager.signalStarting(5000);
            }
            this.m_startComplete = true;
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("start(args) end.  Main Completed={0}, exitCode={1}", new Boolean(this.m_mainComplete), this.m_mainExitCode));
            }
            return this.m_mainExitCode;
        }
    }

    public int stop(int exitCode) {
        if (WrapperManager.isDebugEnabled()) {
            m_outDebug.println(WrapperManager.getRes().getString("stop({0})", new Integer(exitCode)));
        }
        Exception t = null;
        try {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("invoking stop main method"));
            }
            try {
                this.m_stopMainMethod.invoke(null, new Object[]{this.m_stopMainArgs});
            }
            catch (IllegalArgumentException iae) {
                this.m_stopMainMethod.invoke(null, new Object[0]);
            }
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("stop main method completed"));
            }
            if (this.m_stopWait) {
                int threadCnt;
                int systemThreadCount = WrapperSystemPropertyUtil.getIntProperty(WrapperStartStopApp.class.getName() + ".systemThreadCount", 1);
                systemThreadCount = Math.max(0, systemThreadCount);
                while ((threadCnt = this.getNonDaemonThreadCount()) > systemThreadCount) {
                    if (WrapperManager.isDebugEnabled()) {
                        m_outDebug.println(WrapperManager.getRes().getString("stopping.  Waiting for {0} threads to complete.", new Integer(threadCnt - systemThreadCount)));
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            return exitCode;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        catch (IllegalArgumentException e) {
            t = e;
        }
        catch (InvocationTargetException e) {
            t = e;
        }
        m_outError.println(WrapperManager.getRes().getString("Encountered an error running stop main: {0}", t));
        t.printStackTrace(m_outError);
        return 1;
    }

    public void controlEvent(int event) {
        if (event == 202 && (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs())) {
            m_outInfo.println(WrapperManager.getRes().getString("User logged out.  Ignored."));
        } else {
            if (WrapperManager.isDebugEnabled()) {
                m_outDebug.println(WrapperManager.getRes().getString("controlEvent({0}) Stopping", new Integer(event)));
            }
            WrapperManager.stop(0);
        }
    }

    private int getNonDaemonThreadCount() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        while (topGroup.getParent() != null) {
            topGroup = topGroup.getParent();
        }
        Thread[] threads = new Thread[topGroup.activeCount() * 2];
        topGroup.enumerate(threads, true);
        int liveCount = 0;
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null || !threads[i].isAlive() || Thread.currentThread() == threads[i] || threads[i].isDaemon()) continue;
            ++liveCount;
        }
        return liveCount;
    }

    private Method getMainMethod(String className) {
        Class<?> mainClass;
        String methodName = "main";
        String[] arr = className.split("/");
        if (arr.length > 1) {
            className = arr[0];
            methodName = arr[1];
        }
        try {
            mainClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Unable to locate the class {0}: {1}", className, e);
            this.m_initShowUsage = true;
            return null;
        }
        catch (ExceptionInInitializerError e) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Class {0} found but could not be initialized due to:", className);
            this.m_initException = e;
            return null;
        }
        catch (LinkageError e) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Class {0} found but could not be initialized: {1}", className, e);
            return null;
        }
        Method mainMethod = null;
        try {
            mainMethod = mainClass.getMethod(methodName, String;.class);
        }
        catch (NoSuchMethodException e) {
            try {
                mainMethod = mainClass.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
            if (mainMethod == null) {
                this.m_initFailed = true;
                this.m_initError = WrapperManager.getRes().getString("Unable to locate a public static {2} method in class {0}: {1}", className, e, methodName);
                return null;
            }
        }
        catch (SecurityException e) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Unable to locate a public static {2} method in class {0}: {1}", className, e, methodName);
            return null;
        }
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("The {1} method in class {0} must be declared public and static.", className, methodName);
            return null;
        }
        return mainMethod;
    }

    private String[] getArgs(String[] args, int argBase, int argCount) {
        if (argCount < 0) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Illegal argument count: {0}", args[argBase]);
            this.m_initShowUsage = true;
            return null;
        }
        if (args.length < argBase + 1 + argCount) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Not enough argments.  Argument count of {0} was specified.", new Integer(argCount));
            this.m_initShowUsage = true;
            return null;
        }
        String[] mainArgs = new String[argCount];
        System.arraycopy(args, argBase + 1, mainArgs, 0, argCount);
        return mainArgs;
    }

    private int getArgCount(String[] args, int argBase) {
        int argCount;
        try {
            argCount = Integer.parseInt(args[argBase]);
        }
        catch (NumberFormatException e) {
            this.m_initFailed = true;
            this.m_initError = WrapperManager.getRes().getString("Illegal argument count: {0}", args[argBase]);
            this.m_initShowUsage = true;
            return -1;
        }
        return argCount;
    }

    private String[] addPassthroughParams(String[] source, String[] extra, int position) {
        int i;
        if (extra == null || extra.length == 0 || position >= extra.length) {
            if (source == null) {
                return new String[0];
            }
            return source;
        }
        int numberExtraElements = extra.length - position;
        int sizeSource = 0;
        if (source != null) {
            sizeSource = source.length;
        }
        String[] result = new String[sizeSource + numberExtraElements];
        for (i = 0; i < sizeSource; ++i) {
            result[i] = source[i];
        }
        for (i = 0; i < numberExtraElements; ++i) {
            result[sizeSource + i] = extra[position + i];
        }
        return result;
    }

    protected void showUsage() {
        System.out.println();
        System.out.println(WrapperManager.getRes().getString("WrapperStartStopApp Usage:"));
        System.out.println(WrapperManager.getRes().getString("  java org.tanukisoftware.wrapper.WrapperStartStopApp {start_class{/start_method}} {start_arg_count} [start_arguments] {stop_class{/stop_method}} {stop_wait} {stop_arg_count} [stop_arguments]"));
        System.out.println();
        System.out.println(WrapperManager.getRes().getString("Where:"));
        System.out.println(WrapperManager.getRes().getString("  start_class:     The fully qualified class name to run to start the "));
        System.out.println(WrapperManager.getRes().getString("                   application."));
        System.out.println(WrapperManager.getRes().getString("  start_arg_count: The number of arguments to be passed to the start class''s "));
        System.out.println(WrapperManager.getRes().getString("                   main method."));
        System.out.println(WrapperManager.getRes().getString("  start_arguments: The arguments that would normally be passed to the start "));
        System.out.println(WrapperManager.getRes().getString("                   class application."));
        System.out.println(WrapperManager.getRes().getString("  stop_class:      The fully qualified class name to run to stop the "));
        System.out.println(WrapperManager.getRes().getString("                   application."));
        System.out.println(WrapperManager.getRes().getString("  stop_wait:       When stopping, should the Wrapper wait for all threads to "));
        System.out.println(WrapperManager.getRes().getString("                   complete before exiting (true/false)."));
        System.out.println(WrapperManager.getRes().getString("  stop_arg_count:  The number of arguments to be passed to the stop class''s "));
        System.out.println(WrapperManager.getRes().getString("                   main method."));
        System.out.println(WrapperManager.getRes().getString("  stop_arguments:  The arguments that would normally be passed to the stop "));
        System.out.println(WrapperManager.getRes().getString("                   class application."));
    }

    public static void main(String[] args) {
        new WrapperStartStopApp(args);
    }
}

