/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Random;
import org.tanukisoftware.wrapper.WrapperJNIError;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.test.Main;

public class RuntimeExec {
    private static String c_encoding = System.getProperty("sun.jnu.encoding");
    static final int WAIT_MODE_NONE = 0;
    static final int WAIT_MODE_API = 1;
    static final int WAIT_MODE_MANUAL = 2;

    private static void handleInputStream(final InputStream is, final String encoding, final String label) {
        Thread runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            System.out.println(label + " " + line);
                        }
                    }
                    finally {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleJavaProcessInner(String testId, Process process) throws IOException, InterruptedException {
        try {
            RuntimeExec.handleInputStream(process.getInputStream(), c_encoding, testId + "stdout:");
            RuntimeExec.handleInputStream(process.getErrorStream(), c_encoding, testId + "stderr:");
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            int exitCode = process.waitFor();
            System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode)));
            throw throwable;
        }
        int exitCode = process.waitFor();
        System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode)));
    }

    private static void handleJavaProcess(String testId, String command) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}Runtime.exec command: {1}", (Object)testId, (Object)command));
        RuntimeExec.handleJavaProcessInner(testId, Runtime.getRuntime().exec(command));
    }

    private static void handleJavaProcess(String testId, String[] command) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}Runtime.exec command: {1}", (Object)testId, (Object)RuntimeExec.toString(command)));
        RuntimeExec.handleJavaProcessInner(testId, Runtime.getRuntime().exec(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void handleWrapperProcessInner(String testId, WrapperProcess process, long timeoutMS, boolean handleOutErr, boolean closeStdOutErr, boolean closeStdIn, int waitMode) throws IOException, InterruptedException {
        block12: {
            try {
                if (handleOutErr) {
                    RuntimeExec.handleInputStream(process.getStdOut(), c_encoding, testId + "stdout:");
                    RuntimeExec.handleInputStream(process.getStdErr(), c_encoding, testId + "stderr:");
                } else if (closeStdOutErr) {
                    process.getStdOut().close();
                    process.getStdErr().close();
                }
                if (closeStdIn) {
                    process.getStdIn().close();
                }
                if (waitMode != 1 && waitMode == 2 && timeoutMS > 0L) {
                    long start = System.currentTimeMillis();
                    while (process.isAlive() && System.currentTimeMillis() - start < timeoutMS) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (process.isAlive()) {
                        System.out.println(Main.getRes().getString("{0}Timed out waiting for child.  Destroying.", (Object)testId));
                        process.destroy();
                    }
                }
                Object var12_9 = null;
                if (waitMode != 1 && waitMode != 2) break block12;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                if (waitMode != 1 && waitMode != 2) {
                    System.out.println(Main.getRes().getString("{0}leave running...", (Object)testId));
                    throw throwable;
                }
                int exitCode = process.waitFor();
                System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode)));
                throw throwable;
            }
            int exitCode = process.waitFor();
            System.out.println(Main.getRes().getString("{0}exitCode: {1}", (Object)testId, (Object)new Integer(exitCode)));
            return;
        }
        System.out.println(Main.getRes().getString("{0}leave running...", (Object)testId));
    }

    private static void handleWrapperProcess(String testId, String command, WrapperProcessConfig config, long timeoutMS, boolean handleOutErr, boolean closeStdOutErr, boolean closeStdIn, int waitMode) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}WrapperManager.exec command: {1}", (Object)testId, (Object)command));
        if (config == null) {
            RuntimeExec.handleWrapperProcessInner(testId, WrapperManager.exec((String)command), timeoutMS, handleOutErr, closeStdOutErr, closeStdIn, waitMode);
        } else {
            RuntimeExec.handleWrapperProcessInner(testId, WrapperManager.exec((String)command, (WrapperProcessConfig)config), timeoutMS, handleOutErr, closeStdOutErr, closeStdIn, waitMode);
        }
    }

    private static void handleWrapperProcess(String testId, String command) throws IOException, InterruptedException {
        RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 2);
    }

    private static void handleWrapperProcess(String testId, String[] command, WrapperProcessConfig config, long timeoutMS, boolean handleOutErr, boolean closeStdOutErr, boolean closeStdIn, int waitMode) throws IOException, InterruptedException {
        System.out.println(Main.getRes().getString("{0}WrapperManager.exec command: {1}", (Object)testId, (Object)RuntimeExec.toString(command)));
        if (config == null) {
            RuntimeExec.handleWrapperProcessInner(testId, WrapperManager.exec((String[])command), timeoutMS, handleOutErr, closeStdOutErr, closeStdIn, waitMode);
        } else {
            RuntimeExec.handleWrapperProcessInner(testId, WrapperManager.exec((String[])command, (WrapperProcessConfig)config), timeoutMS, handleOutErr, closeStdOutErr, closeStdIn, waitMode);
        }
    }

    private static void handleWrapperProcess(String testId, String[] command) throws IOException, InterruptedException {
        RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 2);
    }

    private static void beginCase(String testId) {
        System.out.println();
        System.out.println(Main.getRes().getString("{0}BEGIN ----------------------------------------", (Object)testId));
    }

    private static void endCase(String testId) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println(Main.getRes().getString("{0}END   ----------------------------------------", (Object)testId));
    }

    private static String toString(String[] command) {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        for (int i = 0; i < command.length; ++i) {
            String arg = command[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"");
            sb.append(arg);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestJava(String simplewaiter) {
        String testId = "Simple Java : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"";
                RuntimeExec.handleJavaProcess(testId, command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestWrapper(String simplewaiter) {
        String testId = "Simple Wrapper : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " -v \"test 123\" test 123 \"\\\"test\\\"";
                RuntimeExec.handleWrapperProcess(testId, command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestJavaAry(String simplewaiter) {
        String testId = "Simple Java (Array) : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String[] command = new String[]{simplewaiter, "-v", "\"test 123\"", "test 123", "\"\\\"test\\\"\""};
                RuntimeExec.handleJavaProcess(testId, command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSimpleTestWrapperAry(String simplewaiter) {
        String testId = "Simple Wrapper (Array) : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String[] command = new String[]{simplewaiter, "-v", "\"test 123\"", "test 123", "\"\\\"test\\\"\""};
                RuntimeExec.handleWrapperProcess(testId, command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseLongCommand(String simplewaiter, int len, boolean expectFailure) {
        block8: {
            String testId = "Long Command " + len + ": ";
            RuntimeExec.beginCase(testId);
            try {
                try {
                    StringBuffer sb = new StringBuffer();
                    sb.append(simplewaiter);
                    sb.append(" -v ");
                    while (sb.length() < len - 1) {
                        sb.append("x");
                    }
                    sb.append("y");
                    String command = sb.toString();
                    RuntimeExec.handleWrapperProcess(testId, command);
                    if (expectFailure) {
                        System.out.println(Main.getRes().getString("{0}Did not fail as expected.", (Object)testId));
                    }
                }
                catch (Exception e) {
                    if (expectFailure) {
                        System.out.println(Main.getRes().getString("{0}Failed as expected: {1}", (Object)testId, (Object)e.toString()));
                        break block8;
                    }
                    e.printStackTrace();
                }
            }
            finally {
                RuntimeExec.endCase(testId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseWaitFor(String simplewaiter) {
        String testId = "WaitFor : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " 1 10";
                RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseSmallChildProcess(String simplewaiter) {
        String testId = "Simple Wrapper (Array) : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " 65 1";
                RuntimeExec.handleWrapperProcess(testId, command, null, 0L, false, false, true, 2);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseVFork(String simplewaiter) {
        String testId = "VFork : ";
        RuntimeExec.beginCase(testId);
        try {
            if (!WrapperProcessConfig.isSupported((int)3)) {
                System.out.println(Main.getRes().getString("{0}vfork not supported", (Object)testId));
            } else {
                System.out.println(Main.getRes().getString("{0}vfork is supported", (Object)testId));
                try {
                    String command = simplewaiter + " 20 10";
                    RuntimeExec.handleWrapperProcess(testId, command, new WrapperProcessConfig().setStartType(3), 0L, true, false, false, 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void casePosixSpawn(String simplewaiter) {
        String testId = "PosixSpawn : ";
        RuntimeExec.beginCase(testId);
        try {
            if (!WrapperProcessConfig.isSupported((int)1)) {
                System.out.println(Main.getRes().getString("{0}posix spawn not supported", (Object)testId));
            } else {
                System.out.println(Main.getRes().getString("{0}posix spawn is supported", (Object)testId));
                try {
                    String command = simplewaiter + " 20 10";
                    RuntimeExec.handleWrapperProcess(testId, command, new WrapperProcessConfig().setStartType(1), 0L, true, false, false, 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseEnvSmall(String simplewaiter) {
        String testId = "Environment Small : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                WrapperProcessConfig config = new WrapperProcessConfig();
                Map environment = config.getEnvironment();
                environment.clear();
                environment.put("TEST", "TEST123");
                System.out.println(Main.getRes().getString("{0}size of Environment map = {1}", (Object)testId, (Object)new Integer(environment.size())));
                String command = simplewaiter + " -e TEST";
                RuntimeExec.handleWrapperProcess(testId, command, config, 0L, true, false, false, 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseEnvLarge(String simplewaiter, int len, boolean expectFailure) {
        block8: {
            String testId = "Environment Large " + len + ": ";
            RuntimeExec.beginCase(testId);
            try {
                try {
                    int valueLen = len - 4 - 1;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < valueLen - 1; ++i) {
                        sb.append("X");
                    }
                    sb.append("Y");
                    String value = sb.toString();
                    WrapperProcessConfig config = new WrapperProcessConfig();
                    Map environment = config.getEnvironment();
                    environment.clear();
                    environment.put("TEST", value);
                    System.out.println(Main.getRes().getString("{0}size of Environment map = {1}", (Object)testId, (Object)new Integer(environment.size())));
                    String command = simplewaiter + " -e TEST";
                    RuntimeExec.handleWrapperProcess(testId, command, config, 0L, true, false, false, 2);
                    if (expectFailure) {
                        System.out.println(Main.getRes().getString("{0}Did not fail as expected.", (Object)testId));
                    }
                }
                catch (Exception e) {
                    if (expectFailure) {
                        System.out.println(Main.getRes().getString("{0}Failed as expected: {1}", (Object)testId, (Object)e.toString()));
                        break block8;
                    }
                    e.printStackTrace();
                }
            }
            finally {
                RuntimeExec.endCase(testId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseWorkingDir(String simplewaiter) {
        String testId = "Change Working Dir : ";
        RuntimeExec.beginCase(testId);
        try {
            if (WrapperProcessConfig.isSupported((int)2) || WrapperProcessConfig.isSupported((int)3)) {
                System.out.println(Main.getRes().getString("{0}changing the working directory is supported", (Object)testId));
                try {
                    WrapperProcessConfig config = new WrapperProcessConfig();
                    config.setStartType(WrapperProcessConfig.isSupported((int)2) ? 2 : 3);
                    config.setWorkingDirectory(new File(".."));
                    String command = WrapperManager.isWindows() ? "cmd.exe /c dir" : "ls -l";
                    RuntimeExec.handleWrapperProcess(testId, command, config, 0L, true, false, false, 2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println(Main.getRes().getString("{0}changing the working directory is not supported", (Object)testId));
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseWrapperDuringJava(String simplewaiter) {
        String testId = "Wrapper During Java : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String javaCommand = simplewaiter + " 5 10";
                String wrapperCommand = simplewaiter + " 6 5";
                Process javaProcess = Runtime.getRuntime().exec(javaCommand);
                RuntimeExec.handleInputStream(javaProcess.getInputStream(), c_encoding, testId + "Runtime.exec stdout:");
                RuntimeExec.handleInputStream(javaProcess.getErrorStream(), c_encoding, testId + "Runtime.exec stderr:");
                WrapperProcess wrapperProcess = WrapperManager.exec((String)wrapperCommand);
                RuntimeExec.handleInputStream(wrapperProcess.getStdOut(), c_encoding, testId + "WrapperManager.exec stdout:");
                RuntimeExec.handleInputStream(wrapperProcess.getStdErr(), c_encoding, testId + "WrapperManager.exec stderr:");
                System.out.println(Main.getRes().getString("{0}WrapperManager.exec exitCode: {1}", (Object)testId, (Object)new Integer(wrapperProcess.waitFor())));
                System.out.println(Main.getRes().getString("{0}Runtime.exec exitCode: {1}", (Object)testId, (Object)new Integer(javaProcess.waitFor())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseJavaDuringWrapper(String simplewaiter) {
        String testId = "Java During Wrapper : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String wrapperCommand = simplewaiter + " 5 10";
                String javaCommand = simplewaiter + " 6 5";
                WrapperProcess wrapperProcess = WrapperManager.exec((String)wrapperCommand);
                RuntimeExec.handleInputStream(wrapperProcess.getStdOut(), c_encoding, testId + "WrapperManager.exec stdout:");
                RuntimeExec.handleInputStream(wrapperProcess.getStdErr(), c_encoding, testId + "WrapperManager.exec stderr:");
                Process javaProcess = Runtime.getRuntime().exec(javaCommand);
                RuntimeExec.handleInputStream(javaProcess.getInputStream(), c_encoding, testId + "Runtime.exec stdout:");
                RuntimeExec.handleInputStream(javaProcess.getErrorStream(), c_encoding, testId + "Runtime.exec stderr:");
                System.out.println(Main.getRes().getString("{0}Runtime.exec exitCode: {1}", (Object)testId, (Object)new Integer(javaProcess.waitFor())));
                System.out.println(Main.getRes().getString("{0}WrapperManager.exec exitCode: {1}", (Object)testId, (Object)new Integer(wrapperProcess.waitFor())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseInvalid(String simplewaiter) {
        String testId = "Invalid : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = "invalid";
                RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 2);
                System.out.println(Main.getRes().getString("{0}ERROR! Did not fail as expected.", (Object)testId));
            }
            catch (Exception e) {
                System.out.println(Main.getRes().getString("{0}Failed as expected.", (Object)testId));
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseTimeoutShort(String simplewaiter) {
        String testId = "Timeout Short : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " 0 5";
                RuntimeExec.handleWrapperProcess(testId, command, null, 10000L, true, false, false, 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void caseTimeoutLong(String simplewaiter) {
        String testId = "Timeout Long : ";
        RuntimeExec.beginCase(testId);
        try {
            try {
                String command = simplewaiter + " 0 30";
                RuntimeExec.handleWrapperProcess(testId, command, null, 10000L, true, false, false, 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean caseLeaveRunning(String simplewaiter) {
        String testId = "Leave Running : ";
        RuntimeExec.beginCase(testId);
        try {
            String command = simplewaiter + " 1 600";
            RuntimeExec.handleWrapperProcess(testId, command, null, 0L, true, false, false, 0);
            boolean bl = false;
            return bl;
        }
        catch (WrapperJNIError e) {
            System.out.println(Main.getRes().getString("{0}Unable to launch child process because JNI library unavailable. Normal on shutdown.", (Object)testId));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = true;
            return bl;
        }
        finally {
            RuntimeExec.endCase(testId);
        }
    }

    public static void main(String[] args) {
        final String simplewaiter = WrapperManager.isWindows() ? "../test/simplewaiter.exe" : "../test/simplewaiter";
        System.out.println("Communicate with child processes using encoding: " + c_encoding);
        Random rand = new Random();
        System.out.println(Main.getRes().getString("Is DYNAMIC supported? A:") + WrapperProcessConfig.isSupported((int)4));
        System.out.println(Main.getRes().getString("Is FORK_EXEC supported? A:") + WrapperProcessConfig.isSupported((int)2));
        System.out.println(Main.getRes().getString("Is VFORK_EXEC supported? A:") + WrapperProcessConfig.isSupported((int)3));
        System.out.println(Main.getRes().getString("Is POSIX_SPAWN supported? A:") + WrapperProcessConfig.isSupported((int)1));
        RuntimeExec.caseSimpleTestJava(simplewaiter);
        RuntimeExec.caseSimpleTestWrapper(simplewaiter);
        RuntimeExec.caseSimpleTestJavaAry(simplewaiter);
        RuntimeExec.caseSimpleTestWrapperAry(simplewaiter);
        RuntimeExec.caseLongCommand(simplewaiter, 32766, false);
        RuntimeExec.caseLongCommand(simplewaiter, Short.MAX_VALUE, true);
        RuntimeExec.caseWaitFor(simplewaiter);
        RuntimeExec.caseSmallChildProcess(simplewaiter);
        RuntimeExec.caseVFork(simplewaiter);
        RuntimeExec.casePosixSpawn(simplewaiter);
        RuntimeExec.caseEnvSmall(simplewaiter);
        RuntimeExec.caseEnvLarge(simplewaiter, Short.MAX_VALUE, false);
        RuntimeExec.caseEnvLarge(simplewaiter, 32768, true);
        RuntimeExec.caseWorkingDir(simplewaiter);
        RuntimeExec.caseWrapperDuringJava(simplewaiter);
        RuntimeExec.caseJavaDuringWrapper(simplewaiter);
        RuntimeExec.caseInvalid(simplewaiter);
        RuntimeExec.caseTimeoutShort(simplewaiter);
        RuntimeExec.caseTimeoutLong(simplewaiter);
        RuntimeExec.caseLeaveRunning(simplewaiter);
        System.out.println();
        if (WrapperManager.getJVMId() == 1) {
            System.out.println(Main.getRes().getString("All Done. Restarting..."));
            WrapperManager.restart();
        } else {
            System.out.println(Main.getRes().getString("All Done. Registering long shutdown hook and stopping.\nWrapper should timeout and kill the JVM, cleaning up all processes in the process."));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    System.out.println(Main.getRes().getString("Starting shutdown hook. Loop for 25 seconds."));
                    System.out.println(Main.getRes().getString("Should timeout unless this property is set: wrapper.jvm_exit.timeout=30"));
                    long start = System.currentTimeMillis();
                    boolean failed = false;
                    while (System.currentTimeMillis() - start < 25000L) {
                        if (!failed) {
                            failed = RuntimeExec.caseLeaveRunning(simplewaiter);
                            System.out.println(Main.getRes().getString("Launched child..."));
                        }
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {}
                    }
                    System.out.println(Main.getRes().getString("Shutdown hook complete. Should exit now."));
                }
            });
            System.exit(0);
        }
    }

    static {
        if (c_encoding == null && (c_encoding = System.getProperty("file.encoding")) == null) {
            c_encoding = "Cp1252";
        }
    }
}

