/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.util.Random;

public class TimedLogOutput {
    private static String lPad(int n, int len, String padding) {
        String s = Integer.toString(n);
        int len2 = s.length();
        if (len2 < len) {
            return padding.substring(0, len - len2) + s;
        }
        return s;
    }

    public static void main(String[] args) {
        System.out.println("Log lots of output of varying length with varying delays between entries.  Each line shows the time it took to log the previous entry.  This is done in a repeatable random series.");
        StringBuffer messageSB = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            messageSB.append("ThisIsAVeryLongStringWithoutSpaces.");
        }
        String message = messageSB.toString();
        int messageLen = message.length();
        Random rand = new Random(0L);
        long allStart = System.currentTimeMillis();
        System.out.println("Starting...");
        long prevTime = 0L;
        for (int i = 0; i < 1000; ++i) {
            long lineTime;
            int subMessageLen = (int)(rand.nextFloat() * (float)(messageLen - 1));
            String subMessage = message.substring(0, subMessageLen);
            String line = "#" + TimedLogOutput.lPad(i, 6, "0000000000") + ":" + TimedLogOutput.lPad((int)prevTime, 6, "          ") + "ms:" + TimedLogOutput.lPad(subMessageLen, 6, "          ") + ":" + subMessage;
            long lineStart = System.currentTimeMillis();
            System.out.println(line);
            prevTime = lineTime = System.currentTimeMillis() - lineStart;
            if (!(rand.nextFloat() < 0.1f)) continue;
            long sleepTime = (long)(rand.nextFloat() * 50.0f);
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        long allTime = System.currentTimeMillis() - allStart;
        System.out.println("Total time: " + allTime);
        System.out.println("All done.");
    }
}

