/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.demo;

import java.io.File;
import javax.swing.filechooser.FileFilter;

class ExtensionFilter
extends FileFilter {
    String description;
    String[] extensions;

    public ExtensionFilter(String description, String extension) {
        this(description, new String[]{extension});
    }

    public ExtensionFilter(String description, String[] extensions) {
        this.description = description == null ? extensions[0] : description;
        this.extensions = (String[])extensions.clone();
        this.toLower(this.extensions);
    }

    private void toLower(String[] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i] = array[i].toLowerCase();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String path = file.getAbsolutePath().toLowerCase();
        int n = this.extensions.length;
        for (int i = 0; i < n; ++i) {
            String extension = this.extensions[i];
            if (!path.endsWith(extension) || path.charAt(path.length() - extension.toLowerCase().length() - 1) != '.') continue;
            return true;
        }
        return false;
    }
}

