<?php
/*
Plugin Name: Feedback Champuru
Version: 0.2.1
Plugin URI: 
Description: Champuru!
Author: wokamoto
Author URI: http://dogmap.jp/
Text Domain: feedback-champuru
Domain Path: /languages/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2010 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/******************************************************************************
 * Define
 *****************************************************************************/
if (!defined('FCHAMPURU_AKISMET_CHECK'))
	define('FCHAMPURU_AKISMET_CHECK',	false);

//**********************************************************************************
// Template tag
//**********************************************************************************
function feedback_type($commenttxt = false, $trackbacktxt = false, $pingbacktxt = false, $tweettext = false, $hatenatext = false, $delisioustext = false, $echo = true) {
	global $feedback_champru;

	if (!isset($feedback_champru))
		$feedback_champru = new FeedbackChampuru();

	add_filter('get_comment_type', array(&$feedback_champru, 'get_comment_type'));
	$type = get_comment_type();
	remove_filter('get_comment_type', array(&$feedback_champru, 'get_comment_type'));

	switch( $type ) {
		case 'trackback' :
			$text = ( false === $trackbacktxt ? __( 'Trackback' ) : $trackbacktxt );
			break;
		case 'pingback' :
			$text = ( false === $pingbacktxt ? __( 'Pingback' ) : $pingbacktxt );
			break;
		case 'tweet' :
			$text = ( false === $tweettext ? __( 'Tweet', 'feedback-champuru' ) : $tweettext );
			break;
		case 'hatena' :
			$text = ( false === $hatenatext ? __( 'Hatena Bookmark', 'feedback-champuru' ) : $hatenatext );
			break;
		case 'delicious' :
			$text = ( false === $delisioustext ? __( 'Delicious', 'feedback-champuru' ) : $delisioustext );
			break;
		default :
			$text = ( false === $commenttxt ? _x( 'Comment', 'noun' ) : $commenttxt );
	}

	if ($echo)
		echo $text;
	else
		return $text;
}

//**********************************************************************************
// Feedback Champuru
//**********************************************************************************
class FeedbackChampuru {
	private $plugin_name   = 'feedback-champuru';
	private $plugin_ver    = '0.2.1';

	private $plugin_dir;
	private $plugin_file;
	private $plugin_url;
	private $textdomain_name;

	private $topsy_api     = 'http://otter.topsy.com/trackbacks.json?url=%s&tracktype=tweet&perpage=50';
	private $hatena_api    = 'http://b.hatena.ne.jp/entry/jsonlite/?url=%s';
	private $delicious_api = 'http://feeds.delicious.com/v2/json/url/%s';
	private $livedoor_api  = 'http://api.clip.livedoor.com/json/comments?link=%s';
	private $buzzurl_api   = 'http://api.buzzurl.jp/api/posts/get/v1/json/?url=%s';

	private $cache_expired = 30;			// Request cache expired (minutes)
	private $comment_type  = '';
	private $comment_order = 'ASC';

	private $feedbacks     = array('tweet', 'hatena', 'delicious');

	private $comment_id    = 0;

	/**********************************************************
	* Constructor
	***********************************************************/
	public function __construct() {
		$this->_set_plugin_dir(__FILE__);
		$this->_load_textdomain();

		$this->feedbacks = apply_filters('feedback-champuru/feedback_types', $this->feedbacks);
		$this->comment_order = (strtoupper(get_settings('comment_order')) !== 'DESC' ? 'ASC' : 'DESC');

		add_filter('comments_array', array(&$this, 'comments_champuru'), 10, 2);
		add_filter('get_comments_number', array(&$this, 'get_comments_number'), 10, 2);
		add_filter('comment_class', array(&$this, 'comment_class'), 10, 4);
		add_filter('get_avatar', array(&$this, 'get_avatar'), 10, 5);
		add_filter('comment_reply_link', array(&$this, 'comment_reply_link'), 10, 4);

		add_filter('feedback-champuru/cache_expired', array(&$this, 'get_cache_expired'), 10, 2);

		add_filter('post_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('page_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('tag_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('category_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('preview_post_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('get_the_guid', array(&$this, 'percent_encode_capital_letter'));
	}

	// set plugin dir
	private function _set_plugin_dir( $file = '' ) {
		$file_path = ( !empty($file) ? $file : __FILE__);
		$filename = explode("/", $file_path);
		if(count($filename) <= 1) $filename = explode("\\", $file_path);
		$this->plugin_dir  = $filename[count($filename) - 2];
		$this->plugin_file = $filename[count($filename) - 1];
		$this->plugin_url  = $this->_wp_plugin_url($this->plugin_dir);
		unset($filename);
	}

	// load textdomain
	private function _load_textdomain( $sub_dir = 'languages', $textdomain_name = '' ) {
		$this->textdomain_name = (empty($textdomain_name) ? $this->plugin_dir : $textdomain_name);
		$plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
		$abs_plugin_dir = $this->_wp_plugin_dir($this->plugin_dir);
		$sub_dir = ( !empty($sub_dir)
			? preg_replace('/^\//', '', $sub_dir)
			: (file_exists($abs_plugin_dir.'languages') ? 'languages' : (file_exists($abs_plugin_dir.'language') ? 'language' : (file_exists($abs_plugin_dir.'lang') ? 'lang' : '')))
			);
		$textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir) . $sub_dir);

		if ( $this->_check_wp_version("2.6") && defined('WP_PLUGIN_DIR') )
			load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
		else
			load_plugin_textdomain($this->textdomain_name, $plugins_dir . $textdomain_dir);
	}

	// check wp version
	private function _check_wp_version($version, $operator = ">=") {
		global $wp_version;
		return version_compare($wp_version, $version, $operator);
	}

	// WP_CONTENT_DIR
	private function _wp_content_dir($path = '') {
		return trailingslashit( trailingslashit( defined('WP_CONTENT_DIR')
			? WP_CONTENT_DIR
			: trailingslashit(ABSPATH) . 'wp-content'
			) . preg_replace('/^\//', '', $path) );
	}

	// WP_CONTENT_URL
	private function _wp_content_url($path = '') {
		return trailingslashit( trailingslashit( defined('WP_CONTENT_URL')
			? WP_CONTENT_URL
			: trailingslashit(get_option('siteurl')) . 'wp-content'
			) . preg_replace('/^\//', '', $path) );
	}

	// WP_PLUGIN_DIR
	private function _wp_plugin_dir($path = '') {
		return trailingslashit($this->_wp_content_dir( 'plugins/' . preg_replace('/^\//', '', $path) ));
	}

	// WP_PLUGIN_URL
	private function _wp_plugin_url($path = '') {
		return trailingslashit($this->_wp_content_url( 'plugins/' . preg_replace('/^\//', '', $path) ));
	}

	// Get post_meta
	private function _get_post_meta($post_id, $key) {
		return maybe_unserialize(get_post_meta($post_id, $key, true));
	}

	// Add or Update post_meta
	private function _update_post_meta($post_id, $key, $val) {
		if (is_array($val))
			$val = maybe_serialize($val);
		return (
			add_post_meta($post_id, $key, $val, true) or
			update_post_meta($post_id, $key, $val)
			);
	}

	/**********************************************************
	* Champuru!
	***********************************************************/
	public function comments_champuru($comments, $post_id){
		$permalink = get_permalink($post_id);
		foreach ($this->feedbacks as $type) {
			$comments = array_merge($comments ,	$this->_get_feedback($type, $post_id, $permalink));
		}
		usort($comments, array($this, '_comments_cmp'));

		return $comments;
	}

	private function _comments_cmp($a, $b){
	    if ($a->comment_date == $b->comment_date)
	        return 0;
	    if (strtotime($a->comment_date) < strtotime($b->comment_date)) 
			return ( $this->comment_order === 'ASC' ? -1 : 1);
		else
			return ( $this->comment_order === 'ASC' ? 1 : -1);
	}

	public function comment_build($type, $post_id, $author = '', $author_url = '', $datetime = 0, $content = '', $photo_url = ''){
		$comment = (object) array(
			"comment_ID" => $type . '-' . $this->comment_id++ ,
			"comment_post_ID" => (string) $post_id ,
			"comment_author" => $author ,
			"comment_author_email" => $photo_url ,
			"comment_author_url" => $author_url ,
			"comment_author_IP" => "" ,
			"comment_date" => date('Y-m-d H:i:s', $datetime) ,
			"comment_date_gmt" => gmdate('Y-m-d H:i:s', $datetime) ,
			"comment_content" => $content ,
			"comment_karma" => "0" ,
			"comment_approved" => "1" ,
			"comment_agent" => "" ,
			"comment_type" => apply_filters('feedback-champuru/comment_type', $this->comment_type, $type) ,
			"comment_parent" => "0" ,
			"user_id" => "0" ,
			);
		if (FCHAMPURU_AKISMET_CHECK && $this->akismet($post_id, $comment))
			$comment->comment_approved = "0";
		return $comment;
	}

	private function _get_type_from_ID($comment_id = ''){
		$comment_id = (empty($comment_id)) || is_null($comment_id)
			? get_comment_ID()
			: (!is_null($comment_id) ? $comment_id : '');
		$comment_type = '';
		if (preg_match('/^([^\-]*)\-[\d]+$/', $comment_id, $matches))
			$comment_type = strtolower($matches[1]);
		unset($matches);
		return $comment_type;
	}

	/**********************************************************
	* Get Feedbacks
	***********************************************************/
	private function _get_feedback($type, $post_id, $permalink){
		$comments_array = array();
		$permalink = $this->percent_encode_capital_letter($permalink);

		switch ($type){
		case 'tweet':
			$comments_array = $this->_get_topsy($type, $post_id, $permalink);
			break;
		case 'hatena':
			$comments_array = $this->_get_hatena($type, $post_id, $permalink);
			break;
		case 'delicious':
			$comments_array = $this->_get_delicious($type, $post_id, $permalink);
			break;
		case 'livedoor':
			$comments_array = $this->_get_livedoor($type, $post_id, $permalink);
			break;
		case 'buzzurl':
			$comments_array = $this->_get_buzzurl($type, $post_id, $permalink);
			break;
		default:
			$comments_array = apply_filters('feedback-champuru/get_feedback', $comments_array, $type, $post_id, $permalink);
			break;
		}

		return apply_filters('feedback-champuru/comments_array', $comments_array, $type);
	}

	/**********************************************************
	* Get Twitter Feedbacks (Topsy)
	***********************************************************/
	private function _get_topsy($type, $post_id, $permalink){
		$cache = $this->_get_post_meta($post_id, '_feedback_'.$type);
		if ( isset($cache["expired"]) && $cache["expired"] > time() )
			return $cache["comments"];
		if ( !is_singular() || is_robots() )
			return ( isset($cache["comments"]) ? $cache["comments"] : array() );

		$comments = array();
		$ret = wp_remote_get(sprintf($this->topsy_api, urlencode($permalink)));
		if (is_array($ret) && isset($ret["body"]) && !empty($ret["body"])){
			$json = json_decode($ret["body"]);
			$list = (isset($json->response) ? $json->response->list : array());
			foreach ((array) $list as $item){
//				$author     = esc_attr($item->author->name);
				$author     = preg_replace('/^http:\/\/topsy\.com\/twitter\/([^\?]*)\?.*$/i', '$1', esc_attr($item->author->topsy_author_url));
//				$author_url = esc_attr((isset($item->author->url) && !empty($item->author->url)) ? $item->author->url : 'http://twitter.com/' . $author);
				$author_url = esc_attr('http://topsy.com/' . str_replace('http://', '', $permalink));
				$datetime   = (int) $item->date;
				$content    = esc_attr($item->content);
				$photo_url  = esc_attr($item->author->photo_url);

				$content    = apply_filters('feedback-champuru/content', $content, $type, $author, $author_url, $datetime, $photo_url, $item);

				if ( $content )
					$comments[] = $this->comment_build($type, $post_id, $author, $author_url, $datetime, $content, $photo_url);
			}
		}
		$comments = (count($comments) > 0 ? $comments : (isset($cache["comments"]) ? $cache["comments"] : $comments));

		$cache = array(
			"expired" => time() + apply_filters('feedback-champuru/cache_expired', $this->cache_expired * 60, $post_id) ,
			"comments" => $comments ,
			);
		$this->_update_post_meta($post_id, '_feedback_'.$type, $cache );

		return $comments;
	}

	/**********************************************************
	* Get Hatena Bookmark Feedbacks
	***********************************************************/
	private function _get_hatena($type, $post_id, $permalink){
		$cache = $this->_get_post_meta($post_id, '_feedback_'.$type);
		if ( isset($cache["expired"]) && $cache["expired"] > time() )
			return $cache["comments"];
		if ( !is_singular() || is_robots() )
			return ( isset($cache["comments"]) ? $cache["comments"] : array() );

		$comments = array();
		$ret = wp_remote_get(sprintf($this->hatena_api, urlencode($permalink)));
		if (is_array($ret) && isset($ret["body"]) && !empty($ret["body"])){
			$json = json_decode($ret["body"]);
			$list = (isset($json->bookmarks) ? $json->bookmarks : array());
			foreach ((array) $list as $item){
				$author     = esc_attr($item->user);
//				$author_url = 'http://b.hatena.ne.jp/' . $author;
				$author_url = esc_attr('http://b.hatena.ne.jp/entry/' . str_replace('http://', '', $permalink));
				$datetime   = strtotime(str_replace('/', '-', $item->timestamp));
				$content    = esc_attr($item->comment);
				$photo_url  = 'http://www.hatena.ne.jp/users/' . substr($author, 0, 2) . '/' . $author . '/profile.gif';

				$content    = apply_filters('feedback-champuru/content', $content, $type, $author, $author_url, $datetime, $photo_url, $item);

				if ( $content )
					$comments[] = $this->comment_build($type, $post_id, $author, $author_url, $datetime, $content, $photo_url);
			}
		}
		$comments = (count($comments) > 0 ? $comments : (isset($cache["comments"]) ? $cache["comments"] : $comments));

		$cache = array(
			"expired" => time() + apply_filters('feedback-champuru/cache_expired', $this->cache_expired * 60, $post_id) ,
			"comments" => $comments ,
			);
		$this->_update_post_meta($post_id, '_feedback_'.$type, $cache );

		return $comments;
	}

	/**********************************************************
	* Get Delicious Feedbacks
	***********************************************************/
	private function _get_delicious($type, $post_id, $permalink){
		$cache = $this->_get_post_meta($post_id, '_feedback_'.$type);
		if ( isset($cache["expired"]) && $cache["expired"] > time() )
			return $cache["comments"];
		if ( !is_singular() || is_robots() )
			return ( isset($cache["comments"]) ? $cache["comments"] : array() );

		$comments = array();
		$ret = wp_remote_get(sprintf($this->delicious_api, md5($permalink)));
		if (is_array($ret) && isset($ret["body"]) && !empty($ret["body"])){
			$json = json_decode($ret["body"]);
			foreach ((array) $json as $item){
				$author     = esc_attr($item->a);
//				$author_url = 'http://delicious.com/'.$author;
				$author_url = esc_attr('http://delicious.com/url/' . md5($permalink));
				$datetime   = strtotime($item->dt);
				$content    = esc_attr($item->n);
				$photo_url  = '';

				$content    = apply_filters('feedback-champuru/content', $content, $type, $author, $author_url, $datetime, $photo_url, $item);

				if ( $content )
					$comments[] = $this->comment_build($type, $post_id, $author, $author_url, $datetime, $content, $photo_url);
			}
		}
		$comments = (count($comments) > 0 ? $comments : (isset($cache["comments"]) ? $cache["comments"] : $comments));

		$cache = array(
			"expired" => time() + apply_filters('feedback-champuru/cache_expired', $this->cache_expired * 60, $post_id) ,
			"comments" => $comments ,
			);
		$this->_update_post_meta($post_id, '_feedback_'.$type, $cache );

		return $comments;
	}

	/**********************************************************
	* Get livedoor clip Feedbacks
	***********************************************************/
	private function _get_livedoor($type, $post_id, $permalink){
		$cache = $this->_get_post_meta($post_id, '_feedback_'.$type);
		if ( isset($cache["expired"]) && $cache["expired"] > time() )
			return $cache["comments"];
		if ( !is_singular() || is_robots() )
			return ( isset($cache["comments"]) ? $cache["comments"] : array() );

		$comments = array();
		$ret = wp_remote_get(sprintf($this->livedoor_api, urlencode($permalink)));
		if (is_array($ret) && isset($ret["body"]) && !empty($ret["body"])){
			$json = json_decode($ret["body"]);
			$list = (isset($json->Comments) ? $json->Comments : array());
			foreach ((array) $list as $item){
				$author     = esc_attr($item->livedoor_id);
//				$author_url = 'http://clip.livedoor.com/clips/' . $author;
				$author_url = esc_attr('http://clip.livedoor.com/page/' . $permalink);
				$datetime   = $item->created_on;
				$content    = esc_attr($item->notes);
				$photo_url  = 'http://image.profile.livedoor.jp/icon/' . $author . '_60.gif';

				$content    = apply_filters('feedback-champuru/content', $content, $type, $author, $author_url, $datetime, $photo_url, $item);

				if ( $content )
					$comments[] = $this->comment_build($type, $post_id, $author, $author_url, $datetime, $content, $photo_url);
			}
		}
		$comments = (count($comments) > 0 ? $comments : (isset($cache["comments"]) ? $cache["comments"] : $comments));

		$cache = array(
			"expired" => time() + apply_filters('feedback-champuru/cache_expired', $this->cache_expired * 60, $post_id) ,
			"comments" => $comments ,
			);
		$this->_update_post_meta($post_id, '_feedback_'.$type, $cache );

		return $comments;
	}

	/**********************************************************
	* Get buzzurl Feedbacks
	***********************************************************/
	private function _get_buzzurl($type, $post_id, $permalink){
		$cache = $this->_get_post_meta($post_id, '_feedback_'.$type);
		if ( isset($cache["expired"]) && $cache["expired"] > time() )
			return $cache["comments"];
		if ( !is_singular() || is_robots() )
			return ( isset($cache["comments"]) ? $cache["comments"] : array() );

		$comments = array();
		$ret = wp_remote_get(sprintf($this->buzzurl_api, urlencode($permalink)));
		if (is_array($ret) && isset($ret["body"]) && !empty($ret["body"])){
			$json = json_decode($ret["body"]);
			$list = (isset($json->posts) ? $json->posts : array());
			foreach ((array) $list as $item){
				$author     = esc_attr($item->user_name);
//				$author_url = 'http://buzzurl.jp/user/' . $author;
				$author_url = esc_attr('http://buzzurl.jp/entry/' . $permalink);
				$datetime   = strtotime($item->date);
				$content    = esc_attr($item->comment);
				$photo_url  = 'http://buzzurl.jp.eimg.jp/user/' . $author . '/photo.png';

				$content    = apply_filters('feedback-champuru/content', $content, $type, $author, $author_url, $datetime, $photo_url, $item);

				if ( $content )
					$comments[] = $this->comment_build($type, $post_id, $author, $author_url, $datetime, $content, $photo_url);
			}
		}
		$comments = (count($comments) > 0 ? $comments : (isset($cache["comments"]) ? $cache["comments"] : $comments));

		$cache = array(
			"expired" => time() + apply_filters('feedback-champuru/cache_expired', $this->cache_expired * 60, $post_id) ,
			"comments" => $comments ,
			);
		$this->_update_post_meta($post_id, '_feedback_'.$type, $cache );

		return $comments;
	}

	/**********************************************************
	* Akismet
	***********************************************************/
	public function akismet($post_id, $comment) {
		global $akismet_api_host, $akismet_api_port;

		if ( !function_exists('akismet_http_post') || !(get_option('wordpress_api_key') || $wpcom_api_key) )
			return false;

		$author = $author_email = $author_url = $content = '';

		$c['blog'] = get_option( 'home' );
		$c['comment_type'] = $comment->comment_type;
		if ( $permalink = get_permalink() )
			$c['permalink'] = $permalink;
		if ( '' != $comment->comment_author )
			$c['comment_author'] = $comment->comment_author;
		if ( '' != $comment->comment_author_email )
			$c['comment_author_email'] = $comment->comment_author_email;
		if ( '' != $comment->comment_author_url )
			$c['comment_author_url'] = $comment->comment_author_url;
		if ( '' != $comment->comment_content )
			$c['comment_content'] = $comment->comment_content;

		$query_string = '';
		foreach ( $c as $key => $data ) {
			$query_string .= $key . '=' . urlencode( stripslashes( $data ) ) . '&';
		}
		$result_key = md5($query_string);

		$akismet_result = $this->_get_post_meta($post_id, '_feedback_akismet_result');
		if ( !isset($akismet_result[$result_key]) ) {
			$response = akismet_http_post( $query_string, $akismet_api_host, '/1.1/comment-check', $akismet_api_port );
			$akismet_result[$result_key] = ('true' == $response[1] ? true : false);
			$this->_update_post_meta($post_id, '_feedback_akismet_result', $akismet_result );
		}
		return $akismet_result[$result_key];
	}

	/**********************************************************
	* get comments number
	***********************************************************/
	public function get_comments_number($count, $post_id = ''){
		$comments = $this->comments_champuru(array(), $post_id);
		return $count + count($comments);
	}

	/**********************************************************
	* comment class
	***********************************************************/
	public function comment_class($classes, $class = '', $comment_id = '', $post_id = ''){
		$comment_type = $this->_get_type_from_ID($comment_id);
		if (!empty($comment_type))
			$classes[] = esc_attr($comment_type);
		return $classes;
	}

	/**********************************************************
	* comment type
	***********************************************************/
	public function get_comment_type($comment_type){
		global $comment;
		$comment_type = $this->_get_type_from_ID(isset($comment) ? $comment->comment_ID : '');
		if (!empty($comment_type))
			$comment_type = esc_attr($comment_type);
		return $comment_type;
	}

	/**********************************************************
	* get avatar
	***********************************************************/
	public function get_avatar($avatar, $id_or_email = '', $size = '96', $default = '', $alt = false){
		global $pagenow, $comment;

		if($pagenow == 'options-discussion.php')
			return $avatar;
		if (!isset($comment))
			return $avatar;

		$type_pattern = '/^('.implode('|',$this->feedbacks).')\-/i';
		if (preg_match('/^http:\/\//i', $comment->comment_author_email)) {
			$img_src = $comment->comment_author_email;
		} elseif (preg_match($type_pattern, $comment->comment_ID, $matches)) {
			$img_src = site_url(str_replace(ABSPATH, '', dirname(__FILE__))) . '/images/';
			$img_src .= $matches[1] . ( $size <= 24 ? '_16.png' : '_32.png' );
		} else {
			$img_src = '';
		}

		if (!empty($img_src)) {
			$avatar = preg_replace(
				  '/^(.*<img [^>]* src=[\'"])http:\/\/[^\'"]+([\'"][^>]*\/>.*)$/i'
				, "$1{$img_src}$2"
				, $avatar);
		}

		return $avatar;
	}

	/**********************************************************
	* comment reply link
	***********************************************************/
	public function comment_reply_link($link, $args = '', $comment = '', $post = ''){
		return (preg_match('/^[\d]+$/', isset($comment->comment_ID) ? $comment->comment_ID : get_comment_ID()) ? $link : '');
	}

	/**********************************************************
	* percent encode capital letter
	***********************************************************/
	public function percent_encode_capital_letter($uri) {
		return preg_replace_callback('/(%[0-9a-f]{2}?)+/', create_function('$matches','return strtoupper($matches[0]);'), $uri);
	}

	/**********************************************************
	* Get cache expired
	***********************************************************/
	public function get_cache_expired($expired, $id = 0){
		$post = &get_post($id);
		$post_date_diff = (time() - strtotime($post->post_date_gmt . ' GMT')) / 60;
		return (int) ( $post_date_diff > 100
			? $expired * (1 + log($post_date_diff))
			: $expired );
	}
}
global $feedback_champru;

$feedback_champru = new FeedbackChampuru();
?>
