<?php
/* これは文字化け防止のための日本語文字列です。
   このソースファイルは UTF-8 で保存されています。
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with UTF-8.
 */

/* ==================================================
 *   KtaiPictogramImages class
   ================================================== */

class KtaiPictogramImages {
	private $pictograms;
	private $pict_url;
	private $translated;
	const TEXT_DOMAIN = 'ktai_pictogram';
	const PICT_DIR = 'pics/';
	const PICT_CLASS = 'pictogram';
	const PICT_STYLE = 'border:0 none;';

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct() {
	global $Ktai_Style;
	load_plugin_textdomain(self::TEXT_DOMAIN, false, $Ktai_Style->get('plugin_dir') . KtaiStyle::DOMAIN_PATH);
	$this->pict_url = $Ktai_Style->get('plugin_url') . self::PICT_DIR; // keep FQDN for PC

 	// http://www.au.kddi.com/ezfactory/tec/spec/4_4.html
	// http://creation.mb.softbank.jp/download.php?docid=103 (members only)
	// http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/
	// http://www.willcom-inc.com/ja/service/contents_service/club_air_edge/for_phone/homepage/pdf/contents_reference.pdf
	// http://developer.emnet.ne.jp/emoji_list.pdf
	$this->pictograms = array(
		'1'     => array('SA/danger.gif', '[!]'), 
		'2'     => array('SA/sign01.gif', '!'), 
		'3'     => '?', 
		'4'     => array('SA/mobaq.gif', 'Q'), 
		'5'     => '&lsaquo;', 
		'6'     => '&rsaquo;', 
		'7'     => '&laquo;', 
		'8'     => '&raquo;', 
		'9'     => '□', 
		'10'    => '■', 
		'11'    => '[i]', 
		'12'    => array('SA/wine.gif', __('[wine glass]', 'ktai_pictogram')), 
		'13'    => __('[loud speaker]', 'ktai_pictogram'), 
		'14'    => '$', 
		'15'    => array('SA/moon3.gif', __('[moon]', 'ktai_pictogram')), 
		'16'    => array('SA/thunder.gif', __('[lightning]', 'ktai_pictogram')), 
		'17'    => '□', 
		'18'    => '■', 
		'19'    => '◇', 
		'20'    => '◆', 
		'21'    => '□', 
		'22'    => '■', 
		'23'    => '◇', 
		'24'    => '◆', 
		'25'    => array('SA/watch.gif', __('[watch]', 'ktai_pictogram')), 
		'26'    => '＋', 
		'27'    => '－', 
		'28'    => '☆', 
		'29'    => '&uarr;', 
		'30'    => '&darr;', 
		'31'    =>  array('SA/ban.gif', __('[ban]', 'ktai_pictogram')), 
		'32'    => '▽', 
		'33'    => '△', 
		'34'    => '▼', 
		'35'    => '▲', 
		'36'    => '◇', 
		'37'    => '◆', 
		'38'    => '□', 
		'39'    => '■', 
		'40'    => '○', 
		'41'    => '●', 
		'42'    => array('SA/upwardleft.gif', __('[upper-left]', 'ktai_pictogram')), 
		'43'    => array('SA/downwardright.gif', __('[lower-right]', 'ktai_pictogram')), 
		'44'    => array('SA/sun.gif', __('[sunny]', 'ktai_pictogram')), 
		'45'    => array('SA/baseball.gif', __('[baseball]', 'ktai_pictogram')), 
		'46'    => array('SA/clock.gif', __('[clock]', 'ktai_pictogram')), 
		'47'    => array('SA/moon03.gif', __('[moon]', 'ktai_pictogram')), 
		'48'    => array('SA/bell.gif', __('[bell]', 'ktai_pictogram')), 
		'49'    => __('[thumbtack]', 'ktai_pictogram'), 
		'50'    => "('')", // small face
		'51'    => array('SA/heart01.gif', '&hearts;'), // heart
		'52'    => array('SA/bar.gif', __('[martini]', 'ktai_pictogram')), 
		'53'    => array('SA/clover.gif', __('[quatrefoil]', 'ktai_pictogram')), 
		'54'    => array('SA/tm.gif', '&trade;'), 
		'55'    => '×', // multiply
		'56'    => array('SA/memo.gif', __('[doc]', 'ktai_pictogram')), 
		'57'    => array('SA/sandclock.gif', __('[sand clock]', 'ktai_pictogram')), 
		'58'    => array('SA/sandclock.gif', __('[sand clock]', 'ktai_pictogram')), 
		'59'    => __('[floppy disk]', 'ktai_pictogram'), 
		'60'    => '*', // snow crystal
		'61'    => '×', // cross 1
		'62'    => '×', // cross 2 
		'63'    => '&rarr;', // right arrow 1
		'64'    => '&larr;', // left arrow 1
		'65'    =>  array('SA/beer.gif', __('[mug cup]', 'ktai_pictogram')), 
		'66'    => '÷', // divide
		'67'    => __('[calendar]', 'ktai_pictogram'), 
		'68'    => array('68.png', "(^_^)"),  // smile face
		'69'    => '★', // star 2
		'70'    => array('SA/upwardright.gif', __('[upper-right]', 'ktai_pictogram')), 
		'71'    => array('SA/downwardleft.gif', __('[lower-left]', 'ktai_pictogram')), 
		'72'    => array('SA/ring.gif', __('[ring]', 'ktai_pictogram')), 
		'73'    => __('&#10003;', 'ktai_pictogram'), // check mark 1
		'74'    => array('SA/dog.gif', __('[poodle]', 'ktai_pictogram')), 
		'75'    => '☆', // star 3
		'76'    => '‡', // spark
		'77'    => array('SA/flair.gif', __('[light bulb]', 'ktai_pictogram')), 
		'78'    => array('SA/chick.gif', __('[bird]', 'ktai_pictogram')), 
		'79'    => __('[closed folder]', 'ktai_pictogram'), 
		'80'    => "('_')", // face
		'81'    => array('SA/copyright.gif', '&copy;'), 
		'82'    => array('SA/r-mark.gif', '&reg;'), 
		'83'    => __('[briefcase]', 'ktai_pictogram'), 
		'84'    => __('[opened folder]', 'ktai_pictogram'), 
		'85'    => array('SA/telephone.gif', __('[telephone]', 'ktai_pictogram')), 
		'86'    => array('86.png', __('[comment]', 'ktai_pictogram')), 
		'87'    => __('[credit card]', 'ktai_pictogram'), 
		'88'    => '△', 
		'89'    => '▽', 
		'90'    => array('90.png', __('[USA]', 'ktai_pictogram')), 
		'91'    => array('SA/memo.gif', __('[notebook]', 'ktai_pictogram')), 
		'92'    => array('SA/memo.gif', __('[clipboard]', 'ktai_pictogram')), 
		'93'    => array('SA/cafe.gif', __('[cup]', 'ktai_pictogram')), 
		'94'    => array('SA/camera.gif', __('[camera]', 'ktai_pictogram')),  
		'95'    => array('SA/rain.gif', __('[rain]', 'ktai_pictogram')), 
		'96'    => __('[football]', 'ktai_pictogram'), 
		'97'    => array('SA/book.gif', __('[book]', 'ktai_pictogram')), 
		'98'    => array('SA/ban.gif', __('[keep out]', 'ktai_pictogram')), 
		'99'    => array('SA/signaler.gif', __('[signal]', 'ktai_pictogram')), 
		'100'   => array('SA/book.gif', __('[book]', 'ktai_pictogram')), 
		'101'   => array('SA/book.gif', __('[book]', 'ktai_pictogram')), 
		'102'   => array('SA/book.gif', __('[book]', 'ktai_pictogram')), 
		'103'   => array('SA/memo.gif', __('[doc]', 'ktai_pictogram')), 
		'104'   => array('SA/hairsalon.gif', __('[scissors]', 'ktai_pictogram')), 
		'105'   => __('[calendar]', 'ktai_pictogram'), 
		'106'   => array('SA/ticket.gif', __('[ticket]', 'ktai_pictogram')), 
		'107'   => array('SA/cloud.gif', __('[cloud]', 'ktai_pictogram')), 
		'108'   => array('SA/mail.gif', __('[envelope]', 'ktai_pictogram')), 
		'109'   => array('SA/yen.gif', __('[&yen]', 'ktai_pictogram')), 
		'110'   => array('SA/movie.gif', __('[video camera]', 'ktai_pictogram')), 
		'111'   => array('SA/movie.gif', __('[handy camera]', 'ktai_pictogram')), 
		'112'   => array('SA/house.gif', __('[home]', 'ktai_pictogram')), 
		'113'   => array('SA/tulip.gif', __('[tulip]', 'ktai_pictogram')), 
		'114'   => __('[knife]', 'ktai_pictogram'), 
		'115'   => __('[video tape]', 'ktai_pictogram'), 
		'116'   => array('SA/eyeglass.gif', __('[glasses]', 'ktai_pictogram')), 
		'117'   => '└→', // rotated arrow 1
		'118'   => array('SA/enter.gif', '⏎'), // otated arrow 2 
		'119'   => array('SA/search.gif', __('[magnifier]', 'ktai_pictogram')), 
		'120'   => array('SA/key.gif', __('[key]', 'ktai_pictogram')), 
		'121'   => array('SA/memo.gif', __('[notebook]', 'ktai_pictogram')), 
		'122'   => array('SA/memo.gif', __('[opened notebook]', 'ktai_pictogram')), 
		'123'   => __('[bolt and nut]', 'ktai_pictogram'), 
		'124'   => array('SA/boutique.gif',__('[high heels]', 'ktai_pictogram')), 
		'125'   => array('SA/car.gif', __('[car]', 'ktai_pictogram')), 
		'126'   => __('[floppy disk]', 'ktai_pictogram'), 
		'127'   => __('[bar chart]', 'ktai_pictogram'), 
		'128'   => __('[line chart]', 'ktai_pictogram'), 
		'129'   => array('SA/mail.gif', __('[mailbox]', 'ktai_pictogram')), 
		'130'   => __('[flashlight]', 'ktai_pictogram'), 
		'131'   => __('[Roldex]', 'ktai_pictogram'), 
		'132'   => __('&#10003;', 'ktai_pictogram'), // check mark 2
		'133'   => array('SA/maple.gif', __('[maple leaf]', 'ktai_pictogram')), 
		'134'   => array('SA/dog.gif', __('[hound dog]', 'ktai_pictogram')), 
		'135'   => __('[battery]', 'ktai_pictogram'), 
		'136'   => __('[scroll]', 'ktai_pictogram'), 
		'137'   => __('[thumbtack]', 'ktai_pictogram'), 
		'138'   => array('SA/key.gif', __('[lock]', 'ktai_pictogram')), 
		'139'   => array('SA/ticket.gif', __('[green paper]', 'ktai_pictogram')), 
		'140'   => __('&larr;', 'ktai_pictogram'), // left pointing
		'141'   => __('&rarr;', 'ktai_pictogram'), // right pointing
		'142'   => array('SA/book.gif', __('[ledger]', 'ktai_pictogram')), 
		'143'   => array('SA/clip.gif', __('[clip]', 'ktai_pictogram')), 
		'144'   => array('SA/present.gif', __('[present]', 'ktai_pictogram')), 
		'145'   => __('[nameplate]', 'ktai_pictogram'), 
		'146'   => array('SA/restaurant.gif', __('[restaurant]', 'ktai_pictogram')), 
		'147'   => array('SA/book.gif', __(__('[book]', 'ktai_pictogram'), 'ktai_pictogram')), 
		'148'   => __('[truck]', 'ktai_pictogram'), 
		'149'   => array('SA/pencil.gif', __('[pencil]', 'ktai_pictogram')), 
		'150'   => __('[IDO]', 'ktai_pictogram'), 
		'151'   => array('SA/mailto.gif', __('[envelope]', 'ktai_pictogram')), 
		'152'   => array('SA/wrench.gif', __('[wrench]', 'ktai_pictogram')), 
		'153'   => array('SA/mail.gif', __('[Send BOX]', 'ktai_pictogram')), 
		'154'   => array('SA/mailto.gif', __('[In BOX]', 'ktai_pictogram')), 
		'155'   => array('SA/telephone.gif', __('[telephone receive]', 'ktai_pictogram')), 
		'156'   => array('SA/building.gif', __('[building]', 'ktai_pictogram')), 
		'157'   => '□', // ruler (rectangle)
		'158'   => '△', // ruler (triangle)
		'159'   => __('[line chart]', 'ktai_pictogram'), 
		'160'   => __('[meat', 'ktai_pictogram'), 
		'161'   => array('SA/mobilephone.gif', __('[mobile phone]', 'ktai_pictogram')), 
		'162'   => __('[outlet]', 'ktai_pictogram'), 
		'163'   => array('SA/shadow.gif', __('[family]', 'ktai_pictogram')), 
		'164'   => array('SA/ribbon.gif', __('[link]', 'ktai_pictogram')), 
		'165'   => array('SA/present.gif', __('[package]', 'ktai_pictogram')), 
		'166'   => array('SA/faxto.gif', __('[FAX]', 'ktai_pictogram')), 
		'167'   => array('SA/cloud.gif', __('[occasionally cloudy]', 'ktai_pictogram')), 
		'168'   => array('SA/airplane.gif', __('[airplane]', 'ktai_pictogram')), 
		'169'   => array('SA/yacht.gif', __('[boat]', 'ktai_pictogram')), 
		'170'   => __('[dice]', 'ktai_pictogram'), 
		'171'   => array('SA/memo.gif', __('[newspaper]', 'ktai_pictogram')), 
		'172'   => array('SA/train.gif', __('[train]', 'ktai_pictogram')), 
		'173'   => '　', // full-width blank
		'174'   => ' ',  // half-width balnk
		'175'   => ' ',  // quarter-width blank
		'176'   => array('SA/smoking.gif', __('[smoking]', 'ktai_pictogram')), 
		'177'   => array('SA/nosmoking.gif', __('[no smoking]', 'ktai_pictogram')), 
		'178'   => array('SA/wheelchair.gif', __('[wheel chair]', 'ktai_pictogram')), 
		'179'   => __('[beginner]', 'ktai_pictogram'), 
		'180'   => array('SA/one.gif', '1'), 
		'181'   => array('SA/two.gif', '2'), 
		'182'   => array('SA/three.gif', '3'), 
		'183'   => array('SA/four.gif', '4'), 
		'184'   => array('SA/five.gif', '5'), 
		'185'   => array('SA/six.gif', '6'), 
		'186'   => array('SA/seven.gif', '7'), 
		'187'   => array('SA/eight.gif', '8'), 
		'188'   => array('SA/nine.gif', '9'), 
		'189'   => array('SA/zero.gif', '10'), 
		'190'   => array('SA/typhoon.gif', __('[typhoon]', 'ktai_pictogram')), 
		'191'   => array('SA/snow.gif', __('[snow]', 'ktai_pictogram')), 
		'192'   => array('SA/aries.gif', __('[Aries]', 'ktai_pictogram')),
		'193'   => array('SA/taurus.gif', __('[Taurus]', 'ktai_pictogram')), 
		'194'   => array('SA/gemini.gif', __('[Gemini]', 'ktai_pictogram')), 
		'195'   => array('SA/cancer.gif', __('[Cancer]', 'ktai_pictogram')),
		'196'   => array('SA/leo.gif', __('[Leo]', 'ktai_pictogram')), 
		'197'   => array('SA/virgo.gif', __('[Virgo]', 'ktai_pictogram')), 
		'198'   => array('SA/libra.gif', __('[Libra]', 'ktai_pictogram')), 
		'199'   => array('SA/scorpius.gif', __('[Scorpius]', 'ktai_pictogram')), 
		'200'   => array('SA/sagittarius.gif', __('[Sagittarius]', 'ktai_pictogram')), 
		'201'   => array('SA/capricornus.gif', __('[Capricornus]', 'ktai_pictogram')),
		'202'   => array('SA/aquarius.gif', __('[Aquarius]', 'ktai_pictogram')), 
		'203'   => array('SA/pisces.gif', __('[Pisces]', 'ktai_pictogram')), 
		'204'   => __('[Ophiuchus]', 'ktai_pictogram'), 
		'205'   => array('SA/atm.gif', __('[ATM]', 'ktai_pictogram')),
		'206'   => array('SA/24hours.gif', __('[CVS]', 'ktai_pictogram')), 
		'207'   => array('SA/toilet.gif', __('[toilet]', 'ktai_pictogram')), 
		'208'   => array('SA/parking.gif', __('[parking]', 'ktai_pictogram')), 
		'209'   => array('SA/bus.gif', __('[bus stop]', 'ktai_pictogram')), 
		'210'   => array('SA/flag.gif', __('[location info]', 'ktai_pictogram')), 
		'211'   => array('SA/ship.gif', __('[anchor]', 'ktai_pictogram')), 
		'212'   => array('SA/bank.gif', __('[bank]', 'ktai_pictogram')), 
		'213'   => array('SA/gasstation.gif', __('[gas station]', 'ktai_pictogram')), 
		'214'   => __('[map]', 'ktai_pictogram'), 
		'215'   => array('SA/bicycle.gif', __('[bicycle]', 'ktai_pictogram')), 
		'216'   => array('SA/bus.gif', __('[bus]', 'ktai_pictogram')), 
		'217'   => array('SA/bullettrain.gif', __('[bullet train]', 'ktai_pictogram')), 
		'218'   => array('SA/run.gif', __('[marathon]', 'ktai_pictogram')), 
		'219'   => array('SA/soccer.gif', __('[soccer]', 'ktai_pictogram')), 
		'220'   => array('SA/tennis.gif', __('[tennis]', 'ktai_pictogram')), 
		'221'   => array('SA/snowboard.gif', __('[snowboard]', 'ktai_pictogram')), 
		'222'   => array('SA/motorsports.gif', __('[checker flag]', 'ktai_pictogram')), 
		'223'   => array('SA/carouselpony.gif', __('[amusement park]', 'ktai_pictogram')), 
		'224'   => array('SA/spa.gif', __('[hot spring]', 'ktai_pictogram')), 
		'225'   => array('SA/bottle.gif', __('[red lantern]', 'ktai_pictogram')), 
		'226'   => array('SA/movie.gif', __('[movie]', 'ktai_pictogram')), 
		'227'   => array('SA/night.gif', __('[night bridge]', 'ktai_pictogram')), 
		'228'   => __('[Tokyo tower]', 'ktai_pictogram'), 
		'229'   => __('[777]', 'ktai_pictogram'), 
		'230'   => __('[decorative banner]', 'ktai_pictogram'), 
		'231'   => '◎&larr;', // win a center by arrow
		'232'   => array('SA/game.gif', __('[game]', 'ktai_pictogram')), 
		'233'   => array('SA/dollar.gif', '($)'), // prize money 
		'234'   => array('SA/xmas.gif', __('[Christmas tree]', 'ktai_pictogram')), 
		'235'   => array('SA/cherryblossom.gif', __('[cherry blossom viewing]', 'ktai_pictogram')), 
		'236'   => __('[ghost]', 'ktai_pictogram'), 
		'237'   => array('237.png', __('[Japan]', 'ktai_pictogram')), 
		'238'   => __('[watermelon]', 'ktai_pictogram'), 
		'239'   => array('SA/cake.gif', __('[cake]', 'ktai_pictogram')), 
		'240'   => __('[frying pan]', 'ktai_pictogram'), 
		'241'   => array('SA/cherry.gif', __('[cherry]', 'ktai_pictogram')), 
		'242'   => __('[blowfish]', 'ktai_pictogram'), 
		'243'   => __('[strawberry]', 'ktai_pictogram'), 
		'244'   => array('SA/riceball.gif', __('[rice ball]', 'ktai_pictogram')), 
		'245'   => array('SA/fastfood.gif', __('[hamburger]', 'ktai_pictogram')), 
		'246'   => __('[whale]', 'ktai_pictogram'), 
		'247'   => __('[rabbit]', 'ktai_pictogram'), 
		'248'   => array('SA/horse.gif', __('[horse]', 'ktai_pictogram')), 
		'249'   => __('[monkey]', 'ktai_pictogram'), 
		'250'   => __('[frog]', 'ktai_pictogram'), 
		'251'   => array('SA/cat.gif', __('[cat]', 'ktai_pictogram')), 
		'252'   => array('SA/penguin.gif', __('[penguin]', 'ktai_pictogram')), 
		'253'   => __('[ant]', 'ktai_pictogram'), 
		'254'   => array('SA/pig.gif', __('[pig]', 'ktai_pictogram')), 
		'255'   => __('[palm tree]', 'ktai_pictogram'), 
		'256'   => __('[sunflower]', 'ktai_pictogram'), 
		'257'   => array('SA/happy01.gif', "(^_^)"), // happy face
		'258'   => array('SA/angry.gif', "(`_`)"), // angry face
		'259'   => array('SA/sad.gif', "(;_;)"), // sad face
		'260'   => array('SA/wobbly.gif', "(x_x)"), // tired face
		'261'   => array('SA/sleepy.gif', 'Zzz'), // sleepy (ZZZ...)
		'262'   => array('SA/annoy.gif', __('[miffed]', 'ktai_pictogram')), 
		'263'   => array('SA/weep.gif', __('[drip]', 'ktai_pictogram')), 
		'264'   => array('SA/bleah.gif', "(^j^)"), // baitling face
		'265'   => array('SA/heart03.gif', __('[break heart]', 'ktai_pictogram')), 
		'266'   => array('SA/heart04.gif', '&hearts;&hearts;'), // heart 3 (big & small)
		'267'   => array('SA/shine.gif', '‡'), // spark 2 (shining mark)
		'268'   => array('SA/bomb.gif', '●~'), // bomb
		'269'   => __('[flame]', 'ktai_pictogram'), 
		'270'   => __('[SOS]', 'ktai_pictogram'), 
		'271'   => __('[biceps]', 'ktai_pictogram'), 
		'272'   => array('SA/heart01.gif', '&rarr;&hearts;'), // heart 5 (with arrows)
		'273'   => array('SA/kissmark.gif', __('[hickey]', 'ktai_pictogram')), 
		'274'   => array('SA/shadow.gif', __('[space alien]', 'ktai_pictogram')), 
		'275'   => array('SA/typhoon.gif', __('[Naruto]', 'ktai_pictogram')), 
		'276'   => array('SA/foot.gif', __('[footmark]', 'ktai_pictogram')), 
		'277'   => __('[devil]', 'ktai_pictogram'), 
		'278'   => __('[flower circle]', 'ktai_pictogram'), 
		'279'   => array('SA/secret.gif', __('[secret]', 'ktai_pictogram')), 
		'280'   => __('[perfect score]', 'ktai_pictogram'), 
		'281'   => array('SA/punch.gif', __('[punch]', 'ktai_pictogram')), 
		'282'   => array('SA/dash.gif', '=3'), // dash
		'283'   => __('[plop]', 'ktai_pictogram'), 
		'284'   => __('&uarr;', 'ktai_pictogram'), 
		'285'   => __('(save)', 'ktai_pictogram'), 
		'286'   => __('[scull]', 'ktai_pictogram'), 
		'287'   => array('SA/good.gif', __('[thumb sign]', 'ktai_pictogram')), 
		'288'   => array('SA/tv.gif', __('[tv set]', 'ktai_pictogram')), 
		'289'   => array('SA/karaoke.gif', __('[microphone]', 'ktai_pictogram')), 
		'290'   => array('SA/moneybag.gif', __('[wallet]', 'ktai_pictogram')), 
		'291'   => array('SA/notes.gif', '&#9835;'), // melody
		'292'   => __('[guitar]', 'ktai_pictogram'), 
		'293'   => __('[violin]', 'ktai_pictogram'), 
		'294'   => array('SA/music.gif', __('[headphone]', 'ktai_pictogram')), 
		'295'   => array('SA/rouge.gif', __('[rouge]', 'ktai_pictogram')), 
		'296'   => __('[pistol]', 'ktai_pictogram'), 
		'297'   => __('[beauty-treatment]', 'ktai_pictogram'), 
		'298'   => __('[EZ]', 'ktai_pictogram'), 
		'299'   => array('SA/free.gif', __('[FREE]', 'ktai_pictogram')), 
		'300'   => array('SA/cd.gif', __('[CD/DVD]', 'ktai_pictogram')), 
		'301'   => __("[women's wear]", 'ktai_pictogram'), 
		'302'   => __('[UFO]', 'ktai_pictogram'), 
		'303'   => __('[updated!]', 'ktai_pictogram'), 
		'304'   => __('[injection]', 'ktai_pictogram'), 
		'305'   => array('SA/mist.gif', __('[fog]', 'ktai_pictogram')), 
		'306'   => array('SA/golf.gif', __('[golf]', 'ktai_pictogram')), 
		'307'   => array('SA/basketball.gif', __('[basketball]', 'ktai_pictogram')), 
		'308'   => array('SA/pocketbell.gif', __('[pager]', 'ktai_pictogram')), 
		'309'   => array('SA/art.gif', __('[art]', 'ktai_pictogram')), 
		'310'   => array('SA/drama.gif', __('[play]', 'ktai_pictogram')), 
		'311'   => array('SA/event.gif', __('[event]', 'ktai_pictogram')), 
		'312'   => array('SA/ribbon.gif', __('[ribbon]', 'ktai_pictogram')), 
		'313'   => array('SA/birthday.gif', __('[birthday]', 'ktai_pictogram')), 
		'314'   => array('SA/spade.gif', '&spades;'), 
		'315'   => array('SA/diamond.gif', '&diams;'), 
		'316'   => array('SA/club.gif', '&clubs;'), 
		'317'   => array('SA/eye.gif', __('[eye]', 'ktai_pictogram')), 
		'318'   => array('SA/ear.gif', __('[ear]', 'ktai_pictogram')), 
		'319'   => array('SA/scissors.gif', _x('[scissors]', 'gesture game', 'ktai_pictogram')), 
		'320'   => array('SA/paper.gif', _x('[paper]', 'gesture game', 'ktai_pictogram')), 
		'321'   => array('SA/newmoon.gif', '●'), // new moon 
		'322'   => array('SA/moon1.gif', __('[lunar eclipse]', 'ktai_pictogram')), 
		'323'   => array('SA/moon2.gif', __('[half moon]', 'ktai_pictogram')), 
		'324'   => array('SA/clear.gif', __('[clear]', 'ktai_pictogram')), 
		'325'   => array('SA/zero.gif', '0'), 
		'326'   => array('SA/ok.gif', __('[OK]', 'ktai_pictogram')), 
		'327'   => array('SA/wobbly.gif', "(x_x)"), // very tired
		'328'   => array('SA/cute.gif', '&hearts;'), // cute
		'329'   => array('SA/impact.gif', 'Σ3'), // bump sound 
		'330'   => array('SA/sweat01.gif', ';;'), // clammy sweat
		'331'   => __('[ezplus]', 'ktai_pictogram'), 
		'332'   => __('[earth]', 'ktai_pictogram'), 
		'333'   => array('SA/noodle.gif', __('[ramen]', 'ktai_pictogram')), 
		'334'   => array('SA/new.gif', __('[NEW]', 'ktai_pictogram')), 
		'335'   => array('SA/t-shirt.gif', __('[shirt]', 'ktai_pictogram')), 
		'336'   => array('SA/shoe.gif', __('[shoe]', 'ktai_pictogram')), 
		'337'   => array('SA/pc.gif', __('[personal computer]', 'ktai_pictogram')), 
		'338'   => __('[radio]', 'ktai_pictogram'), 
		'339'   => __('[rose]', 'ktai_pictogram'), 
		'340'   => array('SA/bell.gif', __('[chapel]', 'ktai_pictogram')), 
		'341'   => array('SA/subway.gif', __('[subway]', 'ktai_pictogram')), 
		'342'   => array('SA/fuji.gif', __('[Mt. Fuji]', 'ktai_pictogram')), 
		'343'   => array('SA/note.gif', '♪'), // an eighth note
		'344'   => __('[angel]', 'ktai_pictogram'), 
		'345'   => __('[tiger]', 'ktai_pictogram'), 
		'346'   => __('[bear]', 'ktai_pictogram'), 
		'347'   => __('[mouse]', 'ktai_pictogram'), 
		'348'   => array('SA/wink.gif', "('_-)"), // wink
		'349'   => array('SA/lovely.gif', "(*_*)"), // eyes are hearts
		'350'   => array('SA/shock.gif', ")@_@("), // shocked
		'351'   => array('SA/think.gif', ";-.-)"), // in trouble
		'352'   => __('[octopus]', 'ktai_pictogram'), 
		'353'   => __('[rocket]', 'ktai_pictogram'), 
		'354'   => array('SA/crown.gif', __('[crown]', 'ktai_pictogram')), 
		'355'   => array('SA/kissmark.gif', __('[kissing]', 'ktai_pictogram')), 
		'356'   => __('[hammer]', 'ktai_pictogram'), 
		'357'   => __('[fireworks]', 'ktai_pictogram'), 
		'358'   => array('SA/maple.gif', __('[autumn leaves]', 'ktai_pictogram')), 
		'359'   => array('SA/bag.gif', __('[suitcase]', 'ktai_pictogram')), 
		'360'   => __('[fountain]', 'ktai_pictogram'), 
		'361'   => __('[camp]', 'ktai_pictogram'), 
		'362'   => __('[mahjong]', 'ktai_pictogram'), 
		'363'   => __('[VS]', 'ktai_pictogram'), 
		'364'   => __('[trophy]', 'ktai_pictogram'), 
		'365'   => __('[turtle]', 'ktai_pictogram'), 
		'366'   => __('[Spain]', 'ktai_pictogram'), 
		'367'   => __('[Rossiya]', 'ktai_pictogram'), 
		'368'   => __('[under construction]', 'ktai_pictogram'), 
		'369'   => array('SA/spa.gif', __('[bath]', 'ktai_pictogram')), 
		'370'   => __('[congratulations]', 'ktai_pictogram'), 
		'371'   => __('[evening]', 'ktai_pictogram'), 
		'372'   => __('[egg]', 'ktai_pictogram'), 
		'373'   => __('[stock pric]', 'ktai_pictogram'), 
		'374'   => __('[police officer]', 'ktai_pictogram'), 
		'375'   => array('SA/postoffice.gif', __('[post office]', 'ktai_pictogram')), 
		'376'   => array('SA/hospital.gif', __('[hospital]', 'ktai_pictogram')), 
		'377'   => array('SA/school.gif', __('[school]', 'ktai_pictogram')), 
		'378'   => array('SA/hotel.gif', __('[hotel]', 'ktai_pictogram')), 
		'379'   => array('SA/ship.gif', __('[ship]', 'ktai_pictogram')), 
		'380'   => array('SA/ban.gif', __('[R18]', 'ktai_pictogram')), 
		'381'   => __('[.i|]', 'ktai_pictogram'), // in service area
		'382'   => __('[COOL!]', 'ktai_pictogram'), 
		'383'   => __('[discount]', 'ktai_pictogram'), 
		'384'   => __('[service fee]', 'ktai_pictogram'), 
		'385'   => array('SA/id.gif', __('[ID]', 'ktai_pictogram')), 
		'386'   => array('SA/full.gif', __('[occupied]', 'ktai_pictogram')), 
		'387'   => array('SA/empty.gif', __('[vacant]', 'ktai_pictogram')), 
		'388'   => __('[reserved]', 'ktai_pictogram'), 
		'389'   => __('[business hours]', 'ktai_pictogram'), 
		'390'   => '&uarr;', // upper pointing
		'391'   => '&darr;', // lower pointing
		'392'   => __('[fortune]', 'ktai_pictogram'), 
		'393'   => array('SA/mobilephone.gif', __('[silent mode]', 'ktai_pictogram')), 
		'394'   => array('SA/mobilephone.gif', __('[turn off]', 'ktai_pictogram')), 
		'395'   => array('SA/memo.gif', __('[memo]', 'ktai_pictogram')), 
		'396'   => __('[tie]', 'ktai_pictogram'), 
		'397'   => array('SA/cute.gif', __('[hibiscus]', 'ktai_pictogram')), 
		'398'   => array('SA/cute.gif', __('[bouquet]', 'ktai_pictogram')), 
		'399'   => __('[cactus]', 'ktai_pictogram'), 
		'400'   => array('SA/bottle.gif', __('[sake bottle]', 'ktai_pictogram')), 
		'401'   => array('SA/beer.gif', __('[beer]', 'ktai_pictogram')), 
		'402'   => __('[congratulations]', 'ktai_pictogram'), 
		'403'   => __('[pill]', 'ktai_pictogram'), 
		'404'   => __('[balloon]', 'ktai_pictogram'), 
		'405'   => __('[cracker]', 'ktai_pictogram'), 
		'406'   => __('[eznavi]', 'ktai_pictogram'), 
		'407'   => __('[hat]', 'ktai_pictogram'), 
		'408'   => array('SA/shoe.gif', __('[long boots]', 'ktai_pictogram')), 
		'409'   => __('[nail]', 'ktai_pictogram'), 
		'410'   => array('SA/hairsalon.gif', __('[beauty salon]', 'ktai_pictogram')), 
		'411'   => _x('[barbershop]', 'ezweb411', 'ktai_pictogram'), 
		'412'   => __('[kimono]', 'ktai_pictogram'), 
		'413'   => array('SA/sports.gif', __('[bikini]', 'ktai_pictogram')), 
		'414'   => array('SA/heart.gif', '&hearts;'), // heart of cards
		'415'   => array('SA/heart02.gif', '&hearts;'), // shining heart
		'416'   => array('SA/heart02.gif', '&hearts;'), // blue heart
		'417'   => array('SA/heart02.gif', '&hearts;'), // green heart
		'418'   => array('SA/heart02.gif', '&hearts;'), // yellow heart
		'419'   => array('SA/heart02.gif', '&hearts;'), // violet heart
		'420'   => array('SA/shine.gif', '†'), // shining
		'421'   => array('SA/ski.gif', __('[ski]', 'ktai_pictogram')), 
		'422'   => '○', // circle for OK sing
		'423'   => array('SA/japanesetea.gif', __('[green tea]', 'ktai_pictogram')), 
		'424'   => array('SA/bread.gif', __('[bread]', 'ktai_pictogram')), 
		'425'   => __('[soft ice cream]', 'ktai_pictogram'), 
		'426'   => __('[French fries]', 'ktai_pictogram'), 
		'427'   => __('[dumpling]', 'ktai_pictogram'), 
		'428'   => __('[rice cracker]', 'ktai_pictogram'), 
		'429'   => __('[rice]', 'ktai_pictogram'), 
		'430'   => __('[spaghetti]', 'ktai_pictogram'), 
		'431'   => __('[curry with rice]', 'ktai_pictogram'), 
		'432'   => __('[oden]', 'ktai_pictogram'), 
		'433'   => __('[sushi]', 'ktai_pictogram'), 
		'434'   => array('SA/apple.gif', __('[apple]', 'ktai_pictogram')),  
		'435'   => __('[orange]', 'ktai_pictogram'), 
		'436'   => __('[tomato]', 'ktai_pictogram'), 
		'437'   => __('[eggplant]', 'ktai_pictogram'), 
		'438'   => __('[box lunch]', 'ktai_pictogram'), 
		'439'   => __('[pan]', 'ktai_pictogram'), 
		'440'   => array('SA/confident.gif', "(-」-)"), // ふっ
		'441'   => array('SA/despair.gif', "(v_v)"), // depressed
		'442'   => array('SA/happy02.gif', "^^.^^"), // triumph
		'443'   => array('SA/sad.gif', "(x~x)"), // failed 
		'444'   => array('SA/think.gif', "(?_?)"), // thinking
		'445'   => array('SA/sleepy.gif', "(~_~)"), // sleepy
		'446'   => array('SA/lovely.gif', "(*_*)"), // shy
		'447'   => array('SA/coldsweats02.gif', "(ToT)"), // pale
		'448'   => array('SA/bearing.gif', "(#□#)"), // cold
		'449'   => array('SA/pout.gif', "(#_#)"), // fever
		'450'   => array('SA/gawk.gif', "(→_→)"), // looked sideways 
		'451'   => array('SA/shock.gif', "(@_@)"), // surprised
		'452'   =>  array('SA/coldsweats02.gif', "(:_;;"), //nervous
		'453'   => array('SA/notes.gif', '♪♯'), // musical notes
		'454'   => array('SA/happy02.gif', "(^o^)"), // smile
		'455'   => array('SA/lovely.gif', "(~3~)"), // kissing 2
		'456'   => array('SA/lovely.gif', "(^3^)"), // light kiss
		'457'   => __('[nose]', 'ktai_pictogram'), 
		'458'   => array('SA/kissmark.gif', __('[mouth]', 'ktai_pictogram')), 
		'459'   => __('[sorry]', 'ktai_pictogram'), 
		'460'   => __('[clap]', 'ktai_pictogram'), 
		'461'   => array('SA/ok.gif', __('[OK!]', 'ktai_pictogram')), // OK sign by finger
		'462'   => __('[boo!]', 'ktai_pictogram'), // thumb down sing
		'463'   => __('[bye]', 'ktai_pictogram'), 
		'464'   => array('SA/ng.gif', __('[No Good]', 'ktai_pictogram')), 
		'465'   => array('SA/ok.gif', __('[OK!]', 'ktai_pictogram')), 
		'466'   => "m(__)m", // humble apology 
		'467'   => __('[couple]', 'ktai_pictogram'), 
		'468'   => __('[bunny]', 'ktai_pictogram'), 
		'469'   => __('[trumpet]', 'ktai_pictogram'), 
		'470'   => __('[billiards]', 'ktai_pictogram'), 
		'471'   => __('[swimming]', 'ktai_pictogram'), 
		'472'   => __('[fire engine]', 'ktai_pictogram'), 
		'473'   => __('[ambulance]', 'ktai_pictogram'), 
		'474'   => __('[police car]', 'ktai_pictogram'), 
		'475'   => __('[roller coaster]', 'ktai_pictogram'), 
		'476'   => __('[pine branches]', 'ktai_pictogram'), 
		'477'   => __("[Girls' Festival]", 'ktai_pictogram'), 
		'478'   => __('[graduation ceremony]', 'ktai_pictogram'), 
		'479'   => __('[entrance ceremony]', 'ktai_pictogram'), 
		'480'   => __('[carp streamer]', 'ktai_pictogram'), 
		'481'   => array('SA/sprinkle.gif', __('[umbrella]', 'ktai_pictogram')), 
		'482'   => __('[bride]', 'ktai_pictogram'), 
		'483'   => __('[shaved ice]', 'ktai_pictogram'), 
		'484'   => __('[sparkler]', 'ktai_pictogram'), 
		'485'   => __('[conch]', 'ktai_pictogram'), 
		'486'   => __('[wind-bell]', 'ktai_pictogram'), 
		'487'   => __('[Halloween]', 'ktai_pictogram'), 
		'488'   => __('[moon-viewing]', 'ktai_pictogram'), 
		'489'   => __('[Santa Claus]', 'ktai_pictogram'), 
		'490'   => array('SA/night.gif', __('[night]', 'ktai_pictogram')), 
		'491'   => __('[rainbow]', 'ktai_pictogram'), 
		'492'   => array('SA/hotel.gif', __('[love hotel]', 'ktai_pictogram')), 
		'493'   => array('SA/sun.gif', __('[sunrise]', 'ktai_pictogram')), 
		'494'   => array('SA/drama.gif', __('[silk hat]', 'ktai_pictogram')), 
		'495'   => array('SA/building.gif', __('[department store]', 'ktai_pictogram')), 
		'496'   => __('[castle tower]', 'ktai_pictogram'), 
		'497'   => __('[castle]', 'ktai_pictogram'), 
		'498'   => __('[factory]', 'ktai_pictogram'), 
		'499'   => __('[France]', 'ktai_pictogram'), 
		'500'   => __('[Openwave]', 'ktai_pictogram'), 
		'501'   => array('SA/key.gif', __('[locked fast]', 'ktai_pictogram')), 
		'502'   => _x('[ABC]', 'uppercase', 'ktai_pictogram'),
		'503'   => _x('[abc]', 'lowercase', 'ktai_pictogram'),
		'504'   => _x('[012]', 'numbers', 'ktai_pictogram'),
		'505'   => _x('[,@#]', 'punctuation', 'ktai_pictogram'),
		'506'   => __('[enabled]', 'ktai_pictogram'), 
		'507'   => __('&#10003;', 'ktai_pictogram'), // check box
		'508'   => array('SA/pen.gif', __('[edit]', 'ktai_pictogram')), 
		'509'   => '◎', // radio button
		'510'   => array('SA/search.gif', __(__('[magnifier]', 'ktai_pictogram'), 'ktai_pictogram')), 
		'511'   => array('SA/enter.gif', __('⏎', 'ktai_pictogram')), 
		'512'   => array('SA/memo.gif', __('[favorites]', 'ktai_pictogram')), 
		'513'   => array('SA/end.gif', __('[termination]', 'ktai_pictogram')), 
		'514'   => array('SA/house.gif', __('[Home]', 'ktai_pictogram')), 
		'515'   => array('SA/mailto.gif', __('[Inbox]', 'ktai_pictogram')), 
		'516'   => '□', // marked
		'517'   => array('SA/key.gif', __('[Private]', 'ktai_pictogram')), 
		'518'   => array('SA/recycle.gif', __('[Reload]', 'ktai_pictogram')), 
		'700'   => __('[Germany]', 'ktai_pictogram'), 
		'701'   => __('[Italy]', 'ktai_pictogram'), 
		'702'   => __('[Britain]', 'ktai_pictogram'), 
		'703'   => __('[China]', 'ktai_pictogram'), 
		'704'   => __('[Korea]', 'ktai_pictogram'), 
		'705'   => __('[White people]', 'ktai_pictogram'), 
		'706'   => __('[Chinese people]', 'ktai_pictogram'), 
		'707'   => __('[Indian]', 'ktai_pictogram'), 
		'708'   => __('[grand father]', 'ktai_pictogram'), 
		'709'   => __('[grand mother]', 'ktai_pictogram'), 
		'710'   => __('[baby]', 'ktai_pictogram'), 
		'711'   => __('[construction worker]', 'ktai_pictogram'), 
		'712'   => __('[princess]', 'ktai_pictogram'), 
		'713'   => __('[dolphin]', 'ktai_pictogram'), 
		'714'   => __('[dance]', 'ktai_pictogram'), 
		'715'   => array('SA/fish.gif', __('[tropical fish]', 'ktai_pictogram')), 
		'716'   => __('[hairy caterpillar]', 'ktai_pictogram'), 
		'717'   => __('[elephant]', 'ktai_pictogram'), 
		'718'   => __('[koala]', 'ktai_pictogram'), 
		'719'   => __('[cow]', 'ktai_pictogram'), 
		'720'   => __('[snake]', 'ktai_pictogram'), 
		'721'   => array('SA/chick.gif', __('[chicken]', 'ktai_pictogram')), 
		'722'   => __('[wild boar]', 'ktai_pictogram'), 
		'723'   => __('[camel]', 'ktai_pictogram'), 
		'724'   => __('[Blood type A]', 'ktai_pictogram'), 
		'725'   => __('[Blood type B]', 'ktai_pictogram'), 
		'726'   => __('[Blood type O]', 'ktai_pictogram'), 
		'727'   => __('[Blood type AB]', 'ktai_pictogram'), 
		'728'   => array('SA/foot.gif', __('[footmark]', 'ktai_pictogram')), 
		'729'   => array('SA/shoe.gif', __('[sneakers]', 'ktai_pictogram')), 
		'730'   => array('SA/flag.gif', __('[flag]', 'ktai_pictogram')), 
		'731'   => array('SA/up.gif', '↑'), // curved upper arrow
		'732'   => array('SA/down.gif', '↓'), // curved lower arrow
		'733'   => array('SA/sign02.gif', '!?'), 
		'734'   => array('SA/sign03.gif', '!!'), 
		'735'   => array('SA/sign05.gif', '-o-'), // spun
		'736'   => __('[melon]', 'ktai_pictogram'), 
		'737'   => __('[pineapple]', 'ktai_pictogram'), 
		'738'   => __('[grape]', 'ktai_pictogram'), 
		'739'   => array('SA/banana.gif', __('[banana]', 'ktai_pictogram')),
		'740'   => __('[corn]', 'ktai_pictogram'), 
		'741'   => __('[mushroom]', 'ktai_pictogram'), 
		'742'   => __('[chestnut]', 'ktai_pictogram'), 
		'743'   => __('[peach]', 'ktai_pictogram'), 
		'744'   => __('[sweet potato]', 'ktai_pictogram'), 
		'745'   => __('[pizza]', 'ktai_pictogram'), 
		'746'   => __('[turkey]', 'ktai_pictogram'), 
		'747'   => __('[Star Festival]', 'ktai_pictogram'), 
		'748'   => array('SA/wine.gif', __('[tropical drink]', 'ktai_pictogram')), 
		'749'   => __('[dragon]', 'ktai_pictogram'), 
		'750'   => __('[piano]', 'ktai_pictogram'), 
		'751'   => array('SA/wave.gif', __('[surfing]', 'ktai_pictogram')), 
		'752'   => __('[fishing]', 'ktai_pictogram'), 
		'753'   => __('[bowling]', 'ktai_pictogram'), 
		'754'   => __('[Namahage]', 'ktai_pictogram'), 
		'755'   => __('[long-nosed goblin]', 'ktai_pictogram'), 
		'756'   => __('[panda]', 'ktai_pictogram'), 
		'757'   => array('SA/bleah.gif', ':-P'), // baitling face 
		'758'   => array('SA/pig.gif',__('[pig nose]', 'ktai_pictogram')), 
		'759'   => array('SA/cute.gif', __('[flower]', 'ktai_pictogram')), 
		'760'   => __('[ice cream]', 'ktai_pictogram'), 
		'761'   => '◎', // donut
		'762'   => __('[cookie]', 'ktai_pictogram'), 
		'763'   => __('[chocolate]', 'ktai_pictogram'), 
		'764'   => __('[candy]', 'ktai_pictogram'), 
		'765'   => __('[lolipop]', 'ktai_pictogram'), 
		'766'   => '(/_＼)', // do not see (monkey)
		'767'   => '(・x・)', // do not say (monkey)
		'768'   => '|(・_・)|', // do not hear (monkey)
		'769'   => __('[volcano]', 'ktai_pictogram'), 
		'770'   => __('[heart with ribbon', 'ktai_pictogram'), 
		'771'   => _x('[ABC]', 'primary english', 'ktai_pictogram'), 
		'772'   => __('[pudding]', 'ktai_pictogram'), 
		'773'   => __('[honey]', 'ktai_pictogram'), 
		'774'   => __('[ladybug]', 'ktai_pictogram'), 
		'775'   => __('[honey pot]', 'ktai_pictogram'), 
		'776'   => array('SA/apple.gif', __('[green apple]', 'ktai_pictogram')),
		'777'   => __('[bill with wing]', 'ktai_pictogram'), 
		'778'   => "(@_@)", // eyes are rolling
		'779'   => array('SA/pout.gif', "(`_`)"), // get pouty
		'780'   => array('SA/pout.gif', "(`_`)"), // get pouty (cat)
		'781'   => __('[Milky Way]', 'ktai_pictogram'), 
		'782'   => array('SA/lovely.gif', "(^3^)"), // kissing (cat)
		'783'   => array('SA/happy02.gif', "(^-^)"), // smile (cat)
		'784'   => array('SA/mail.gif', __('[send mail]', 'ktai_pictogram')), 
		'785'   => array('SA/happy02.gif', "(T^T)"), // cry and laugh (cat)
		'786'   => array('SA/happy02.gif', "(T^T)"), // cry and laugh
		'787'   => array('SA/lovely.gif', "(*_*)"), // eyes are hearts (cat)
		'788'   => array('SA/crying.gif', "('o')"), // ほえー (cat)
		'789'   => array('SA/crying.gif', "('o')"), // ほえー
		'790'   => array('SA/coldsweats01.gif', "(-_;)"), // sheding a tear 
		'791'   => array('SA/coldsweats01.gif', "(-_;)"), // sheding a tear (cat)
		'792'   => array('SA/gawk.gif', "(-v-)"), // きりり (cat) 
		'793'   => __('[formal dress]', 'ktai_pictogram'), 
		'794'   => __('[Moyai statue]', 'ktai_pictogram'), 
		'795'   => __('[station]', 'ktai_pictogram'), 
		'796'   => __('[Japanese playing cards]', 'ktai_pictogram'), 
		'797'   => __('[joker]', 'ktai_pictogram'), 
		'798'   => __('[fried prawn]', 'ktai_pictogram'), 
		'799'   => array('SA/mail.gif', __('[e-mail]', 'ktai_pictogram')), 
		'800'   => __('[walking person]', 'ktai_pictogram'), 
		'801'   => __('[siren]', 'ktai_pictogram'), 
		'802'   => __('[ezmovie]', 'ktai_pictogram'), 
		'803'   => array('SA/heart02.gif', __('[pounding heart]', 'ktai_pictogram')), 
		'804'   => array('SA/chick.gif', __('[chick]', 'ktai_pictogram')), 
		'805'   => array('SA/denim.gif', __('[jeans]', 'ktai_pictogram')), 
		'806'   => array('SA/loveletter.gif', __('[love letter]', 'ktai_pictogram')), 
		'807'   => array('SA/recycle.gif', __('[cycling arrows]', 'ktai_pictogram')), 
		'808'   => array('SA/leftright.gif', '⇔'), 
		'809'   => array('SA/updown.gif', '↑↓'), 
		'810'   => array('SA/wave.gif', __('[angry waves]', 'ktai_pictogram')), 
		'811'   => array('SA/bud.gif', __('[cotyledons]', 'ktai_pictogram')), 
		'812'   => array('SA/snail.gif', __('[snail]', 'ktai_pictogram')), 
		'813'   => array('SA/smile.gif', "(^◇^)"), // triumph (cat)
		'814'   => array('SA/smile.gif', "(^◇^)"), // triumph 
		'815'   => array('SA/mail.gif', __('[C mail]', 'ktai_pictogram')), 
		'816'   => array('SA/bud.gif', __('[herb]', 'ktai_pictogram')), 
		'817'   => array('SA/rock.gif', _x('[rock]', 'gesture game', 'ktai_pictogram')), 
		'818'   => array('SA/sharp.gif', '#'), 
		'819'   => "!('')", // show hands
		'820'   => "!(^^)!", // banzai
		'821'   => "(v_v)", // disappointed
		'822'   => "(`^`)", // cute angry
		'se001' => "(^_^)", // boy
		'se002' => "(^^)", // girl
		'se003' => array('SA/kissmark.gif', __('[hickey]', 'ktai_pictogram')), 
		'se004' => "('_')", // father
		'se005' => "('')", // mother 
		'se006' => array('SA/t-shirt.gif', __('[clothing]', 'ktai_pictogram')), 
		'se007' => array('SA/shoe.gif', __('[boots]', 'ktai_pictogram')), 
		'se008' => array('SA/camera.gif', __('[camera]', 'ktai_pictogram')),
		'se009' => array('SA/telephone.gif', __('[telephone]', 'ktai_pictogram')), 
		'se00a' => array('SA/mobilephone.gif', __('[mobile phone]', 'ktai_pictogram')), 
		'se00b' => array('SA/faxto.gif', __('[FAX]', 'ktai_pictogram')), 
		'se00c' => array('SA/pc.gif', __('[personal computer]', 'ktai_pictogram')), 
		'se00d' => array('SA/punch.gif', __('[punch]', 'ktai_pictogram')), 
		'se00e' => array('SA/good.gif', __('[GOOD!]', 'ktai_pictogram')), 
		'se00f' => __('[No.1!]', 'ktai_pictogram'), 
		'se010' => array('SA/rock.gif', _x('[rock]', 'gesture game', 'ktai_pictogram')), 
		'se011' => array('SA/scissors.gif', _x('[scissors]', 'gesture game', 'ktai_pictogram')), 
		'se012' => array('SA/paper.gif', _x('[paper]', 'gesture game', 'ktai_pictogram')), 
		'se013' => array('SA/ski.gif', __('[ski]', 'ktai_pictogram')), 
		'se014' => array('SA/golf.gif', __('[golf]', 'ktai_pictogram')), 
		'se015' => array('SA/tennis.gif', __('[tennis]', 'ktai_pictogram')), 
		'se016' => array('SA/baseball.gif', __('[baseball]', 'ktai_pictogram')), 
		'se017' => array('SA/snowboard.gif', __('[surfing]', 'ktai_pictogram')), 
		'se018' => array('SA/soccer.gif', __('[soccer]', 'ktai_pictogram')), 
		'se019' => array('SA/fish.gif', __('[fish]', 'ktai_pictogram')), 
		'se01a' => array('SA/horse.gif', __('[horse]', 'ktai_pictogram')), 
		'se01b' => array('SA/car.gif', __('[car]', 'ktai_pictogram')), 
		'se01c' => array('SA/yacht.gif', __('[sailboat]', 'ktai_pictogram')), 
		'se01d' => array('SA/airplane.gif', __('[airplane]', 'ktai_pictogram')),
		'se01e' => array('SA/train.gif', __('[train]', 'ktai_pictogram')), 
		'se01f' => array('SA/bullettrain.gif', __('[bullet train]', 'ktai_pictogram')), 
		'se020' => '?', 
		'se021' => array('SA/sign01.gif', '!'), 
		'se022' => array('SA/heart01.gif', '&hearts;'), // heart
		'se023' => array('SA/heart03.gif', __('[break heart]', 'ktai_pictogram')), 
		'se024' => array('se024.png', __("[one o'clock]", 'ktai_pictogram')), 
		'se025' => array('se025.png', __("[two o'clock]", 'ktai_pictogram')), 
		'se026' => array('se026.png', __('[clock]', 'ktai_pictogram')), 
		'se027' => array('se027.png', __("[four o'clock]", 'ktai_pictogram')), 
		'se028' => array('se028.png', __("[five o'clock]", 'ktai_pictogram')), 
		'se029' => array('se029.png', __("[six o'clock]", 'ktai_pictogram')), 
		'se02a' => array('se02a.png', __("[seven o'clock]", 'ktai_pictogram')), 
		'se02b' => array('se02b.png', __("[eight o'clock]", 'ktai_pictogram')), 
		'se02c' => array('se02c.png', __("[nine o'clock]", 'ktai_pictogram')), 
		'se02d' => array('se02d.png', __("[ten o'clock]", 'ktai_pictogram')), 
		'se02e' => array('se02e.png', __("[eleven o'clock]", 'ktai_pictogram')), 
		'se02f' => array('se02f.png', __("[twelve o'clock]", 'ktai_pictogram')), 
		'se030' => array('SA/cherryblossom.gif', __('[cherry blossom viewing]', 'ktai_pictogram')), 
		'se031' => array('SA/crown.gif', __('[emblem]', 'ktai_pictogram')), 
		'se032' => array('SA/cherryblossom.gif', __('[rose]', 'ktai_pictogram')), 
		'se033' => array('SA/xmas.gif', __('[Christmas]', 'ktai_pictogram')), 
		'se034' => array('SA/ring.gif', __('[ring]', 'ktai_pictogram')), 
		'se035' => array('SA/ring.gif', __('[jewel]', 'ktai_pictogram')), 
		'se036' => array('SA/house.gif', __('[home]', 'ktai_pictogram')), 
		'se037' => array('SA/bell.gif', __('[church]', 'ktai_pictogram')), 
		'se038' =>  array('SA/building.gif', __('[building]', 'ktai_pictogram')), 
		'se039' => __('[station]', 'ktai_pictogram'), 
		'se03a' => array('SA/gasstation.gif', __('[gas station]', 'ktai_pictogram')), 
		'se03b' => array('SA/fuji.gif', __('[mountain]', 'ktai_pictogram')), 
		'se03c' => array('SA/karaoke.gif', __('[microphone]', 'ktai_pictogram')), 
		'se03d' => array('SA/movie.gif', __('[movie]', 'ktai_pictogram')), 
		'se03e' => array('SA/note.gif', __('[music]', 'ktai_pictogram')), 
		'se03f' => array('SA/key.gif', __('[key]', 'ktai_pictogram')), 
		'se040' => __('[saxophone]', 'ktai_pictogram'), 
		'se041' => __('[guitar]', 'ktai_pictogram'), 
		'se042' => __('[trumpet]', 'ktai_pictogram'), 
		'se043' => array('SA/restaurant.gif', __('[restaurant]', 'ktai_pictogram')), 
		'se044' => array('SA/bar.gif', __('[cocktail]', 'ktai_pictogram')), 
		'se045' => array('SA/cafe.gif', __('[coffee]', 'ktai_pictogram')), 
		'se046' => array('SA/cake.gif', __('[cake]', 'ktai_pictogram')), 
		'se047' => array('SA/beer.gif', __('[beer]', 'ktai_pictogram')), 
		'se048' => array('SA/snow.gif', __('[snow]', 'ktai_pictogram')), 
		'se049' => array('SA/cloud.gif', __('[cloud]', 'ktai_pictogram')), 
		'se04a' => array('SA/sun.gif',  __('[sunny]', 'ktai_pictogram')), 
		'se04b' => array('SA/rain.gif',  __('[rain]', 'ktai_pictogram')), 
		'se04c' => array('SA/moon3.gif', __('[moon]', 'ktai_pictogram')), 
		'se04d' => array('SA/sun.gif', __('[morning]', 'ktai_pictogram')), 
		'se04e' => __('[angel]', 'ktai_pictogram'), 
		'se04f' => array('SA/cat.gif', __('[cat]', 'ktai_pictogram')), 
		'se050' => __('[tiger]', 'ktai_pictogram'), 
		'se051' => __('[bear]', 'ktai_pictogram'), 
		'se052' => array('SA/dog.gif', __('[dog]', 'ktai_pictogram')), 
		'se053' => __('[mouse]', 'ktai_pictogram'), 
		'se054' => __('[whale]', 'ktai_pictogram'), 
		'se055' => array('SA/penguin.gif', __('[penguin]', 'ktai_pictogram')), 
		'se056' => array('SA/happy01.gif', "(^_^)"), // hopeful 
		'se057' => array('SA/happy02.gif', "(^o^)"), // joyful
		'se058' => array('SA/despair.gif', "(v_v)"),
		'se059' => array('SA/angry.gif', "(`_`)"),
		'se05a' => __('[plop]', 'ktai_pictogram'), 
		'se101' => array('SA/mailto.gif', __('[incoming mail]', 'ktai_pictogram')), 
		'se102' => array('SA/mailto.gif', __('[outgoing mail]', 'ktai_pictogram')), 
		'se103' => array('SA/mail.gif', __('[send to]', 'ktai_pictogram')), 
		'se104' => array('SA/phoneto.gif', __('[tel to]', 'ktai_pictogram')), 
		'se105' => array('SA/bleah.gif', "(^i^)"), // baitling face
		'se106' => array('SA/lovely.gif', "(*_*)"), // loving 
		'se107' => array('SA/shock.gif', "(@_@)"), // astonished
		'se108' => array('SA/coldsweats02.gif', "(-_-;"), // clammy sweat
		'se109' => __('[monkey]', 'ktai_pictogram'), 
		'se10a' => __('[octopus]', 'ktai_pictogram'), 
		'se10b' => array('SA/pig.gif', __('[pig]', 'ktai_pictogram')), 
		'se10c' => array('SA/shadow.gif', __('[space alien]', 'ktai_pictogram')), 
		'se10d' => __('[rocket]', 'ktai_pictogram'), 
		'se10e' => array('SA/crown.gif', __('[crown]', 'ktai_pictogram')), 
		'se10f' => array('SA/flair.gif', __('[light bulb]', 'ktai_pictogram')), 
		'se110' => array('SA/clover.gif', __('[quatrefoil]', 'ktai_pictogram')), 
		'se111' => array('SA/kissmark.gif', __('[kiss]', 'ktai_pictogram')), 
		'se112' => array('SA/present.gif', __('[present]', 'ktai_pictogram')), 
		'se113' => __('[pistol]', 'ktai_pictogram'), 
		'se114' => array('SA/search.gif', __('[magnifier]', 'ktai_pictogram')), 
		'se115' => array('SA/run.gif', __('[athletics]', 'ktai_pictogram')), 
		'se116' => __('[auction]', 'ktai_pictogram'), 
		'se117' => array('SA/shine.gif', __('[fireworks]', 'ktai_pictogram')), 
		'se118' => array('SA/maple.gif', __('[maple leaf]', 'ktai_pictogram')), 
		'se119' => array('SA/maple.gif', __('[fallen leaves]', 'ktai_pictogram')), 
		'se11a' => __('[devil]', 'ktai_pictogram'), 
		'se11b' => __('[ghost]', 'ktai_pictogram'), 
		'se11c' => __('[scull]', 'ktai_pictogram'), 
		'se11d' => __('[fire]', 'ktai_pictogram'), 
		'se11e' => array('SA/bag.gif', __('[bag]', 'ktai_pictogram')), 
		'se11f' => array('SA/chair.gif', __('[seat]', 'ktai_pictogram')), 
		'se120' => array('SA/fastfood.gif', __('[hamburger]', 'ktai_pictogram')), 
		'se121' => __('[park]', 'ktai_pictogram'), 
		'se122' => __('[camp]', 'ktai_pictogram'), 
		'se123' => array('SA/spa.gif', __('[hot spring]', 'ktai_pictogram')), 
		'se124' => array('SA/carouselpony.gif', __('[amusement park]', 'ktai_pictogram')), 
		'se125' => array('SA/ticket.gif', __('[ticket]', 'ktai_pictogram')), 
		'se126' => array('SA/cd.gif', __('[CD]', 'ktai_pictogram')), 
		'se127' => array('SA/cd.gif', __('[DVD]', 'ktai_pictogram')), 
		'se128' => array('SA/music.gif', __('[radio]', 'ktai_pictogram')), 
		'se129' => __('[video]', 'ktai_pictogram'), 
		'se12a' => array('SA/tv.gif', __('[tv set]', 'ktai_pictogram')), 
		'se12b' => array('SA/game.gif', __('[game]', 'ktai_pictogram')), 
		'se12c' => '&#12349;', // start of songs
		'se12d' => __('[mahjong]', 'ktai_pictogram'), 
		'se12e' => __('[VS]', 'ktai_pictogram'), 
		'se12f' => array('SA/dollar.gif', '($)'), // doller bag 
		'se130' => __('[bingo]', 'ktai_pictogram'), 
		'se131' => __('[trophy]', 'ktai_pictogram'), 
		'se132' => array('SA/motorsports.gif', __('[checker flag]', 'ktai_pictogram')), 
		'se133' => __('[slot game]', 'ktai_pictogram'), 
		'se134' => array('SA/horse.gif', __('[horse race]', 'ktai_pictogram')), 
		'se135' => array('SA/yacht.gif', __('[motorboat race]', 'ktai_pictogram')), 
		'se136' => array('SA/bicycle.gif', __('[keirin]', 'ktai_pictogram')), 
		'se137' => __('[under construction]', 'ktai_pictogram'), 
		'se138' => '♂', // male
		'se139' => '♀', // female
		'se13a' => __('[infant]', 'ktai_pictogram'), 
		'se13b' => __('[injector]', 'ktai_pictogram'), 
		'se13c' => array('SA/sleepy.gif', 'Zzz'), 
		'se13d' => array('SA/thunder.gif', __('[thunder]', 'ktai_pictogram')), 
		'se13e' => array('SA/boutique.gif',__('[high heels]', 'ktai_pictogram')), 
		'se13f' => array('SA/spa.gif', __('[tub bath]', 'ktai_pictogram')), 
		'se140' => array('SA/toilet.gif', __('[toilet]', 'ktai_pictogram')), 
		'se141' => __('[audio]', 'ktai_pictogram'), 
		'se142' => __('[notice]', 'ktai_pictogram'), 
		'se143' => __('[holiday]', 'ktai_pictogram'), 
		'se144' => array('SA/key.gif',__('[locked]', 'ktai_pictogram')), 
		'se145' => array('SA/key.gif',__('[unlocked]', 'ktai_pictogram')), 
		'se146' => __('[town]', 'ktai_pictogram'), 
		'se147' => __('[egg]', 'ktai_pictogram'), 
		'se148' => array('SA/book.gif', __(__('[book]', 'ktai_pictogram'), 'ktai_pictogram')), 
		'se149' => __('[exchange]', 'ktai_pictogram'), 
		'se14a' => __('[stock prices]', 'ktai_pictogram'), 
		'se14b' => __('[dish antenna]', 'ktai_pictogram'), 
		'se14c' => __('[biceps]', 'ktai_pictogram'), 
		'se14d' => array('SA/bank.gif', __('[bank]', 'ktai_pictogram')), 
		'se14e' => array('SA/signaler.gif', __('[signal]', 'ktai_pictogram')), 
		'se14f' => array('SA/parking.gif', __('[parking]', 'ktai_pictogram')), 
		'se150' => array('SA/bus.gif', __('[bus stop]', 'ktai_pictogram')), 
		'se151' => array('SA/toilet.gif', __('[public toilet]', 'ktai_pictogram')), 
		'se152' => __('[police box]', 'ktai_pictogram'), 
		'se153' => array('SA/postoffice.gif', __('[post office]', 'ktai_pictogram')), 
		'se154' => array('SA/atm.gif', __('[ATM]', 'ktai_pictogram')), 
		'se155' => array('SA/hospital.gif', __('[hospital]', 'ktai_pictogram')), 
		'se156' => array('SA/24hours.gif', __('[CVS]', 'ktai_pictogram')), 
		'se157' => array('SA/school.gif', __('[school]', 'ktai_pictogram')), 
		'se158' => array('SA/hotel.gif', __('[hotel]', 'ktai_pictogram')), 
		'se159' => array('SA/bus.gif', __('[bus]', 'ktai_pictogram')), 
		'se15a' => array('SA/car.gif', __('[taxi]', 'ktai_pictogram')), 
		'se201' => array('SA/run.gif', __('[walk]', 'ktai_pictogram')), 
		'se202' => array('SA/ship.gif', __('[ship]', 'ktai_pictogram')), 
		'se203' => __('[here]', 'ktai_pictogram'), 
		'se204' => array('SA/cute.gif', '&#10070;'), // decoration line 1
		'se205' => array('SA/cute.gif', '&#10070;'), // decoration line 2 
		'se206' => array('SA/cute.gif', '&#10070;'), // decoration line 3
		'se207' => array('SA/ban.gif', __('[R18]', 'ktai_pictogram')), 
		'se208' => array('SA/nosmoking.gif', __('[no smoking]', 'ktai_pictogram')), 
		'se209' => __('[beginner]', 'ktai_pictogram'), 
		'se20a' => array('SA/wheelchair.gif', __('[wheel chair]', 'ktai_pictogram')), 
		'se20b' => __('[.i|]', 'ktai_pictogram'), // anntena
		'se20c' => array('SA/heart.gif', '&hearts;'), 
		'se20d' => array('SA/diamond.gif', '&diams;'), 
		'se20e' => array('SA/spade.gif', '&spades;'), 
		'se20f' => array('SA/club.gif', '&clubs;'), 
		'se210' => array('SA/sharp.gif', '#'), // hash number
		'se211' => array('SA/free.gif', __('[toll free dial]', 'ktai_pictogram')), 
		'se212' => array('SA/new.gif', __('[new]', 'ktai_pictogram')), 
		'se213' => array('SA/shine.gif', __('[update]', 'ktai_pictogram')), 
		'se214' => array('SA/eyeglass.gif', __('[COOL]', 'ktai_pictogram')), 
		'se215' => array('SA/yen.gif', __('[pay]', 'ktai_pictogram')), 
		'se216' => array('SA/free.gif', __('[free]', 'ktai_pictogram')), 
		'se217' => __('[monthly]', 'ktai_pictogram'), // monthly pay
		'se218' => __('[apply]', 'ktai_pictogram'), // apply
		'se219' => '●', // healine button 1
		'se21a' => '◎', // healine button 2
		'se21b' => '◎', // healine button 3
		'se21c' => array('SA/one.gif', '1'), 
		'se21d' => array('SA/two.gif', '2'), 
		'se21e' => array('SA/three.gif', '3'), 
		'se21f' => array('SA/four.gif', '4'), 
		'se220' => array('SA/five.gif', '5'), 
		'se221' => array('SA/six.gif', '6'), 
		'se222' => array('SA/seven.gif', '7'), 
		'se223' => array('SA/eight.gif', '8'), 
		'se224' => array('SA/nine.gif', '9'), 
		'se225' => array('SA/zero.gif', '0'), 
		'se226' => __('[save]', 'ktai_pictogram'),
		'se227' => __('[discount]', 'ktai_pictogram'),
		'se228' => __('[service fee]', 'ktai_pictogram'),
		'se229' => array('SA/id.gif', __('[ID]', 'ktai_pictogram')), 
		'se22a' => array('SA/full.gif', __('[occupied]', 'ktai_pictogram')), 
		'se22b' => array('SA/empty.gif', __('[vacant]', 'ktai_pictogram')), 
		'se22c' => __('[reserved]', 'ktai_pictogram'),
		'se22d' => __('[business hours]', 'ktai_pictogram'),
		'se22e' => '&uarr;', 
		'se22f' => '&darr;', 
		'se230' => '&larr;', 
		'se231' => '&rarr;', 
		'se232' => '&uarr;', 
		'se233' => '&darr;', 
		'se234' => '&rarr;', 
		'se235' => '&larr;', 
		'se236' => array('SA/upwardright.gif', __('[upper-right]', 'ktai_pictogram')), 
		'se237' => array('SA/upwardleft.gif', __('[upper-left]', 'ktai_pictogram')), 
		'se238' => array('SA/downwardright.gif', __('[lower-right]', 'ktai_pictogram')), 
		'se239' => array('SA/downwardleft.gif', __('[lower-left]', 'ktai_pictogram')), 
		'se23a' => '&lsaquo;', 
		'se23b' => '&rsaquo;', 
		'se23c' => '&laquo;', 
		'se23d' => '&raquo;', 
		'se23e' => __('[☆]', 'ktai_pictogram'), // constellation
		'se23f' => array('SA/aries.gif', __('[Aries]', 'ktai_pictogram')), 
		'se240' => array('SA/taurus.gif', __('[Taurus]', 'ktai_pictogram')), 
		'se241' => array('SA/gemini.gif', __('[Gemini]', 'ktai_pictogram')), 
		'se242' => array('SA/cancer.gif', __('[Cancer]', 'ktai_pictogram')),
		'se243' => array('SA/leo.gif', __('[Leo]', 'ktai_pictogram')), 
		'se244' => array('SA/virgo.gif', __('[Virgo]', 'ktai_pictogram')),
		'se245' => array('SA/libra.gif', __('[Libra]', 'ktai_pictogram')), 
		'se246' => array('SA/scorpius.gif', __('[Scorpius]', 'ktai_pictogram')), 
		'se247' => array('SA/sagittarius.gif', __('[Sagittarius]', 'ktai_pictogram')), 
		'se248' => array('SA/capricornus.gif', __('[Capricornus]', 'ktai_pictogram')), 
		'se249' => array('SA/aquarius.gif', __('[Aquarius]', 'ktai_pictogram')), 
		'se24a' => array('SA/pisces.gif', __('[Pisces]', 'ktai_pictogram')), 
		'se24b' => __('[Ophiuchus]', 'ktai_pictogram'), 
		'se24c' => __('[TOP]', 'ktai_pictogram'), 
		'se24d' => array('SA/ok.gif', __('[OK]', 'ktai_pictogram')), 
		'se24e' => array('SA/copyright.gif', '&copy;'), 
		'se24f' => array('SA/r-mark.gif', '&reg;'), 
		'se250' => array('SA/mobilephone.gif', __('[silent mode]', 'ktai_pictogram')), 
		'se251' => array('SA/mobilephone.gif', __('[turn off]', 'ktai_pictogram')), 
		'se252' => array('SA/danger.gif', '[!]'), 
		'se253' => array('SA/shadow.gif', __('[infomation]', 'ktai_pictogram')), 
		'se254' => array('SA/building.gif', __('[J-PHONE Shop]', 'ktai_pictogram')), 
		'se255' => __('[Skyweb]', 'ktai_pictogram'), 
		'se256' => array('SA/mail.gif', __('[Skywalker]', 'ktai_pictogram')), 
		'se257' => __('[SkyMelody]', 'ktai_pictogram'), 
		'se258' => 'J-', 
		'se259' => 'Pho', 
		'se25a' => 'ne', 
		'se301' => array('SA/memo.gif', __('[memo]', 'ktai_pictogram')), 
		'se302' => __('[tie]', 'ktai_pictogram'), 
		'se303' => array('SA/cute.gif', __('[hibiscus]', 'ktai_pictogram')), 
		'se304' => array('SA/tulip.gif', __('[tulip]', 'ktai_pictogram')), 
		'se305' => __('[sunflower]', 'ktai_pictogram'), 
		'se306' => __('[bouquet]', 'ktai_pictogram'), 
		'se307' => __('[palm tree]', 'ktai_pictogram'), 
		'se308' => __('[cactus]', 'ktai_pictogram'), 
		'se309' => array('SA/toilet.gif', __('[toilet]', 'ktai_pictogram')), 
		'se30a' => array('SA/music.gif', __('[headphone]', 'ktai_pictogram')), 
		'se30b' => array('SA/bottle.gif', __('[liquor bottle]', 'ktai_pictogram')), 
		'se30c' => array('SA/beer.gif', __('[beer]', 'ktai_pictogram')), 
		'se30d' => __('[congratulations]', 'ktai_pictogram'), 
		'se30e' => array('SA/smoking.gif', __('[smoking]', 'ktai_pictogram')), 
		'se30f' => __('[pill]', 'ktai_pictogram'), 
		'se310' => __('[balloon]', 'ktai_pictogram'), 
		'se311' => array('SA/bomb.gif', '●~'), // bomb
		'se312' => __('[cracker]', 'ktai_pictogram'), 
		'se313' => array('SA/hairsalon.gif', __('[scissors]', 'ktai_pictogram')), 
		'se314' => array('SA/ribbon.gif', __('[ribbon]', 'ktai_pictogram')), 
		'se315' => array('SA/secret.gif', __('[secret]', 'ktai_pictogram')), 
		'se316' => __('[MD]', 'ktai_pictogram'), 
		'se317' => __('[megaphone]', 'ktai_pictogram'), 
		'se318' => __('[hat]', 'ktai_pictogram'), 
		'se319' => __('[dress]', 'ktai_pictogram'), 
		'se31a' => array('SA/boutique.gif', __('[mule]', 'ktai_pictogram')), 
		'se31b' => __('[long boots]', 'ktai_pictogram'), 
		'se31c' => array('SA/rouge.gif', __('[rouge]', 'ktai_pictogram')), 
		'se31d' => __('[manicure]', 'ktai_pictogram'), 
		'se31e' => __('[beauty-treatment]', 'ktai_pictogram'), 
		'se31f' => __('[beauty salon]', 'ktai_pictogram'), 
		'se320' => __('[barbershop]', 'ktai_pictogram'), 
		'se321' => __('[kimono]', 'ktai_pictogram'), 
		'se322' => array('SA/sports.gif', __('[bikini]', 'ktai_pictogram')), 
		'se323' => array('SA/bag.gif', __('[brand bag]', 'ktai_pictogram')), 
		'se324' => array('SA/slate.gif', __('[clapperboard]', 'ktai_pictogram')), 
		'se325' => array('SA/bell.gif', __('[bell]', 'ktai_pictogram')), 
		'se326' => array('SA/notes.gif', '&#9835;'), // dancing note 
		'se327' => array('SA/heart02.gif', '&hearts;'), // shining heart
		'se328' => array('SA/heart02.gif', '&hearts;'), // pounding heart
		'se329' => array('SA/heart.gif', '&rarr;&hearts;'), // shoot heart
		'se32a' => array('SA/heart.gif', '&hearts;'), // blue heart
		'se32b' => array('SA/heart.gif', '&hearts;'), // green heart
		'se32c' => array('SA/heart.gif', '&hearts;'), // yellow heart
		'se32d' => array('SA/heart.gif', '&hearts;'), // violet heart
		'se32e' => array('SA/shine.gif', '◇'), // shining
		'se32f' => '☆', 
		'se330' => array('SA/dash.gif', '=3'), // dash, 
		'se331' => array('SA/sweat01.gif', ';;'), // sparking sweat  
		'se332' => '○', 
		'se333' => '×', 
		'se334' => array('SA/annoy.gif', __('[miffed]','ktai_pictogram')), 
		'se335' => '☆', 
		'se336' => '?', 
		'se337' => array('SA/sign01.gif', '!'), 
		'se338' => array('SA/japanesetea.gif', __('[tea]', 'ktai_pictogram')), 
		'se339' => array('SA/bread.gif', __('[bread]', 'ktai_pictogram')), 
		'se33a' => __('[soft ice cream]', 'ktai_pictogram'), 
		'se33b' => __('[French fries]', 'ktai_pictogram'), 
		'se33c' => __('[dumpling]', 'ktai_pictogram'), 
		'se33d' => __('[rice cracker]', 'ktai_pictogram'), 
		'se33e' => __('[rice]', 'ktai_pictogram'), 
		'se33f' => __('[spaghetti]', 'ktai_pictogram'), 
		'se340' => array('SA/noodle.gif', __('[ramen]', 'ktai_pictogram')), 
		'se341' => __('[curry with rice]', 'ktai_pictogram'), 
		'se342' => array('SA/riceball.gif', __('[rice ball]', 'ktai_pictogram')), 
		'se343' => __('[oden]', 'ktai_pictogram'), 
		'se344' => __('[sushi]', 'ktai_pictogram'), 
		'se345' => array('SA/apple.gif', __('[apple]', 'ktai_pictogram')), 
		'se346' => __('[orange]', 'ktai_pictogram'), 
		'se347' => __('[strawberry]', 'ktai_pictogram'), 
		'se348' => __('[watermelon]', 'ktai_pictogram'), 
		'se349' => __('[tomato]', 'ktai_pictogram'), 
		'se34a' => __('[eggplant]', 'ktai_pictogram'), 
		'se34b' => array('SA/birthday.gif', __('[birthday cake]', 'ktai_pictogram')), 
		'se34c' => __('[railway lunch box]', 'ktai_pictogram'), 
		'se34d' => __('[pan]', 'ktai_pictogram'), 
		'se401' => array('SA/coldsweats02.gif', "(:_;;"), // anxious
		'se402' => array('SA/catface.gif', "(- 」-)"), // laughing slightly
		'se403' => array('SA/think.gif', "m(__)m"), // humble apology
		'se404' => array('SA/think.gif', "^^.^^"), // triumph
		'se405' => array('SA/wink.gif', "('_-)"), // wink
		'se406' => array('SA/bearing.gif', "(x_x)"), // too much wasabi
		'se407' => array('SA/sad.gif', "(@_@)"), // eyes are rolling
		'se408' => array('SA/sleepy.gif', "(zzz)"), // snot bubble
		'se409' => array('SA/bleah.gif', "(^j^)"), // baitling face
		'se40a' => array('SA/confident.gif', "(*_*)"), // drunk
		'se40b' => array('SA/shock.gif', "(ToT)"), // barf
		'se40c' => "(#□#)", // face with mask
		'se40d' => array('SA/happy02.gif',"(#_#)"), // red face
		'se40e' => array('SA/gawk.gif', "(→_→)"), // disenchantment
		'se40f' => array('SA/coldsweats02.gif', "('_';"), // clammy sweat
		'se410' => array('SA/wobbly.gif', "(@_@)"), // surprised
		'se411' => array('SA/crying.gif', "(T_T)"), // cry
		'se412' => array('SA/crying.gif', "(T^T)"), // cry and laugh
		'se413' => array('SA/weep.gif', "(;_;)"), // cute cry
		'se414' => array('SA/smile.gif', "(^.^)"), // smile
		'se415' => array('SA/happy01.gif', "(^o^)"), // laugh
		'se416' => array('SA/pout.gif', "(`^`)"), // very angry
		'se417' => array('SA/lovely.gif', "(~3~)"), // KISS
		'se418' => array('SA/lovely.gif', "(^3-)"), // throwing KISS
		'se419' => array('SA/eye.gif', __('[eye]', 'ktai_pictogram')), 
		'se41a' => __('[nose]', 'ktai_pictogram'), 
		'se41b' => array('SA/ear.gif', __('[ear]', 'ktai_pictogram')), 
		'se41c' => array('SA/kissmark.gif', __('[mouth]', 'ktai_pictogram')), 
		'se41d' => __('[sorry]', 'ktai_pictogram'), // sorry with hands together
		'se41e' => array('SA/paper.gif', __('[bye]', 'ktai_pictogram')), 
		'se41f' => array('SA/paper.gif', __('[clap]', 'ktai_pictogram')), 
		'se420' => array('SA/ok.gif', __('[OK!]', 'ktai_pictogram')), // OK by fingers
		'se421' => array('SA/down.gif', __('[boo!]', 'ktai_pictogram')), // booging
		'se422' => array('SA/paper.gif', __('[good morning!]', 'ktai_pictogram')), 
		'se423' => array('SA/ng.gif', '×'), 
		'se424' => array('SA/ok.gif', '○'), 
		'se425' => __('[holding hands]', 'ktai_pictogram'), 
		'se426' => "m(__)m", // humble apology
		'se427' => '＼(^o^)／', // banzai
		'se428' => __('[two persons]', 'ktai_pictogram'), 
		'se429' => __('[bunny]', 'ktai_pictogram'), 
		'se42a' => array('SA/basketball.gif', __('[basketball]', 'ktai_pictogram')),  
		'se42b' => __('[american football]', 'ktai_pictogram'), 
		'se42c' => __('[billiards]', 'ktai_pictogram'), 
		'se42d' => array('SA/wave.gif', __('[swimming]', 'ktai_pictogram')), 
		'se42e' => array('SA/rvcar.gif', __('[RV car]', 'ktai_pictogram')), 
		'se42f' => __('[truck]', 'ktai_pictogram'), 
		'se430' => __('[fire engine]', 'ktai_pictogram'), 
		'se431' => __('[ambulance]', 'ktai_pictogram'), 
		'se432' => __('[police car]', 'ktai_pictogram'), 
		'se433' => __('[roller coaster]', 'ktai_pictogram'), 
		'se434' => array('SA/subway.gif', __('[subway]', 'ktai_pictogram')), 
		'se435' => array('SA/bullettrain.gif', __('[bullet train]', 'ktai_pictogram')), 
		'se436' => __('[pine branches]', 'ktai_pictogram'), 
		'se437' => __('[chocolate]', 'ktai_pictogram'), 
		'se438' => __("[Girls' Festival]", 'ktai_pictogram'), 
		'se439' => __('[graduation ceremony]', 'ktai_pictogram'), 
		'se43a' => __('[school bag]', 'ktai_pictogram'), 
		'se43b' => __('[carp streamer]', 'ktai_pictogram'), 
		'se43c' => array('SA/sprinkle.gif', __('[umbrella]', 'ktai_pictogram')), 
		'se43d' => __('[bridal]', 'ktai_pictogram'), 
		'se43e' => array('SA/wave.gif', __('[wave comming]', 'ktai_pictogram')), 
		'se43f' => __('[shaved ice]', 'ktai_pictogram'), 
		'se440' => __('[sparkler]', 'ktai_pictogram'), 
		'se441' => __('[conch]', 'ktai_pictogram'), 
		'se442' => __('[wind-bell]', 'ktai_pictogram'), 
		'se443' => array('SA/typhoon.gif', __('[typhoon]', 'ktai_pictogram')), 
		'se444' => __('[rice ear]', 'ktai_pictogram'), 
		'se445' => __('[Halloween]', 'ktai_pictogram'), 
		'se446' => array('SA/fullmoon.gif', __('[moon-viewing]', 'ktai_pictogram')), 
		'se447' => array('SA/maple.gif', __('[wind blowing]', 'ktai_pictogram')), 
		'se448' => __('[Santa Claus]', 'ktai_pictogram'), 
		'se449' => array('SA/sun.gif', __('[rising sun]', 'ktai_pictogram')), 
		'se44a' => array('SA/sun.gif', __('[setting sun]', 'ktai_pictogram')), 
		'se44b' => array('SA/night.gif',  __('[shooting star]', 'ktai_pictogram')), 
		'se44c' => __('[rainbow]', 'ktai_pictogram'), 
		'se501' => array('SA/hotel.gif', __('[love hotel]', 'ktai_pictogram')), 
		'se502' => array('SA/art.gif', __('[art]', 'ktai_pictogram')), 
		'se503' => array('SA/drama.gif', __('[play]', 'ktai_pictogram')), 
		'se504' => array('SA/building.gif', __('[department store]', 'ktai_pictogram')), 
		'se505' => __('[castle tower]', 'ktai_pictogram'), 
		'se506' => __('[castle]', 'ktai_pictogram'), 
		'se507' => array('SA/movie.gif', __('[movie theater]', 'ktai_pictogram')), 
		'se508' => array('SA/building.gif', __('[factory]', 'ktai_pictogram')), 
		'se509' => __('[Tokyo tower]', 'ktai_pictogram'), 
		'se50a' => array('SA/building.gif', __('[Shibuya 109]', 'ktai_pictogram')), 
		'se50b' => array('237.png', __('[Japan]', 'ktai_pictogram')), 
		'se50c' => array('90.png', __('[USA]', 'ktai_pictogram')), 
		'se50d' => __('[France]', 'ktai_pictogram'), 
		'se50e' => __('[Germany]', 'ktai_pictogram'), 
		'se50f' => __('[Italy]', 'ktai_pictogram'), 
		'se510' => __('[Britain]', 'ktai_pictogram'), 
		'se511' => __('[Spain]', 'ktai_pictogram'), 
		'se512' => __('[Rossiya]', 'ktai_pictogram'), 
		'se513' => __('[China]', 'ktai_pictogram'), 
		'se514' => __('[Korea]', 'ktai_pictogram'), 
		'se515' => __('[White people]', 'ktai_pictogram'), 
		'se516' => __('[Chinese people]', 'ktai_pictogram'), 
		'se517' => __('[Indian]', 'ktai_pictogram'), 
		'se518' => __('[grand father]', 'ktai_pictogram'), 
		'se519' => __('[grand mother]', 'ktai_pictogram'), 
		'se51a' => __('[baby]', 'ktai_pictogram'), 
		'se51b' => __('[safety first]', 'ktai_pictogram'), 
		'se51c' => __('[princess]', 'ktai_pictogram'), 
		'se51d' => __('[Statue of Liberty]', 'ktai_pictogram'), 
		'se51e' => __('[guard]', 'ktai_pictogram'), 
		'se51f' => __('[flamenco]', 'ktai_pictogram'), 
		'se520' => array('SA/fish.gif', __('[dolphin]', 'ktai_pictogram')), 
		'se521' => array('SA/chick.gif', __('[bird]', 'ktai_pictogram')), 
		'se522' => array('SA/fish.gif', __('[tropical fish]', 'ktai_pictogram')), 
		'se523' => array('SA/chick.gif', __('[chick]', 'ktai_pictogram')), 
		'se524' => __('[hamster]', 'ktai_pictogram'), 
		'se525' => __('[hairy caterpillar]', 'ktai_pictogram'), 
		'se526' => __('[elephant]', 'ktai_pictogram'), 
		'se527' => __('[koala]', 'ktai_pictogram'), 
		'se528' => __('[chimpanzee]', 'ktai_pictogram'), 
		'se529' => __('[sheep]', 'ktai_pictogram'), 
		'se52a' => array('SA/dog.gif', __('[wolf]', 'ktai_pictogram')), 
		'se52b' => __('[cow]', 'ktai_pictogram'), 
		'se52c' => __('[rabbit]', 'ktai_pictogram'), 
		'se52d' => __('[snake]', 'ktai_pictogram'), 
		'se52e' => array('SA/chick.gif', __('[chicken]', 'ktai_pictogram')), 
		'se52f' => __('[wild boar]', 'ktai_pictogram'), 
		'se530' => __('[camel]', 'ktai_pictogram'), 
		'se531' => __('[frog]', 'ktai_pictogram'), 
		'se532' => __('[Blood type A]', 'ktai_pictogram'), 
		'se533' => __('[Blood type B]', 'ktai_pictogram'), 
		'se534' => __('[Blood type AB]', 'ktai_pictogram'), 
		'se535' => __('[Blood type O]', 'ktai_pictogram'), 
		'se536' => array('SA/foot.gif', __('[footmark]', 'ktai_pictogram')), 
		'se537' => array('SA/tm.gif', '&trade;'), 
		'se538' => 'J-', 
		'se539' => 'Sky', 
		'se53a' => '“', 
		'se53b' => '”', 
		'se53c' => '◎V', 
		'se53d' => 'odaf', 
		'se53e' => 'one', 
		'd001'  => array('SA/sun.gif', __('[sunny]', 'ktai_pictogram')), 
		'd002'  => array('SA/cloud.gif', __('[cloud]', 'ktai_pictogram')), 
		'd003'  => array('SA/rain.gif', __('[rain]', 'ktai_pictogram')), 
		'd004'  => array('SA/snow.gif', __('[snow]', 'ktai_pictogram')), 
		'd005'  => array('SA/thunder.gif', __('[thunder]', 'ktai_pictogram')), 
		'd006'  => array('SA/typhoon.gif', __('[typhoon]', 'ktai_pictogram')), 
		'd007'  => array('SA/mist.gif', __('[fog]', 'ktai_pictogram')), 
		'd008'  => array('SA/sprinkle.gif', __('[drizzle]', 'ktai_pictogram')), 
		'd009'  => array('SA/aries.gif', __('[Aries]', 'ktai_pictogram')),
		'd010'  => array('SA/taurus.gif', __('[Taurus]', 'ktai_pictogram')), 
		'd011'  => array('SA/gemini.gif', __('[Gemini]', 'ktai_pictogram')), 
		'd012'  => array('SA/cancer.gif', __('[Cancer]', 'ktai_pictogram')),
		'd013'  => array('SA/leo.gif', __('[Leo]', 'ktai_pictogram')), 
		'd014'  => array('SA/virgo.gif', __('[Virgo]', 'ktai_pictogram')), 
		'd015'  => array('SA/libra.gif', __('[Libra]', 'ktai_pictogram')), 
		'd016'  => array('SA/scorpius.gif', __('[Scorpius]', 'ktai_pictogram')), 
		'd017'  => array('SA/sagittarius.gif', __('[Sagittarius]', 'ktai_pictogram')), 
		'd018'  => array('SA/capricornus.gif', __('[Capricornus]', 'ktai_pictogram')),
		'd019'  => array('SA/aquarius.gif', __('[Aquarius]', 'ktai_pictogram')), 
		'd020'  => array('SA/pisces.gif', __('[Pisces]', 'ktai_pictogram')), 
		'd021'  => array('SA/sports.gif', __('[sportswear]', 'ktai_pictogram')), 
		'd022'  => array('SA/baseball.gif', __('[baseball]', 'ktai_pictogram')), 
		'd023'  => array('SA/golf.gif', __('[golf]', 'ktai_pictogram')), 
		'd024'  => array('SA/tennis.gif', __('[tennis]', 'ktai_pictogram')), 
		'd025'  => array('SA/soccer.gif', __('[soccer]', 'ktai_pictogram')), 
		'd026'  => array('SA/ski.gif', __('[ski]', 'ktai_pictogram')), 
		'd027'  => array('SA/basketball.gif', __('[basketball]', 'ktai_pictogram')), 
		'd028'  => array('SA/motorsports.gif', __('[checker flag]', 'ktai_pictogram')), 
		'd029'  => array('SA/pocketbell.gif', __('[pager]', 'ktai_pictogram')), 
		'd030'  => array('SA/train.gif', __('[train]', 'ktai_pictogram')), 
		'd031'  => array('SA/subway.gif', __('[subway]', 'ktai_pictogram')), 
		'd032'  => array('SA/bullettrain.gif', __('[bullet train]', 'ktai_pictogram')), 
		'd033'  => array('SA/car.gif', __('[car]', 'ktai_pictogram')), 
		'd034'  => array('SA/rvcar.gif', __('[RV car]', 'ktai_pictogram')), 
		'd035'  => array('SA/bus.gif', __('[bus]', 'ktai_pictogram')), 
		'd036'  => array('SA/ship.gif', __('[ship]', 'ktai_pictogram')), 
		'd037'  => array('SA/airplane.gif', __('[airplane]', 'ktai_pictogram')), 
		'd038'  => array('SA/house.gif', __('[home]', 'ktai_pictogram')), 
		'd039'  => array('SA/building.gif', __('[building]', 'ktai_pictogram')), 
		'd040'  => array('SA/postoffice.gif', __('[post office]', 'ktai_pictogram')), 
		'd041'  => array('SA/hospital.gif', __('[hospital]', 'ktai_pictogram')), 
		'd042'  => array('SA/bank.gif', __('[bank]', 'ktai_pictogram')), 
		'd043'  => array('SA/atm.gif', __('[ATM]', 'ktai_pictogram')),
		'd044'  => array('SA/hotel.gif', __('[hotel]', 'ktai_pictogram')), 
		'd045'  => array('SA/24hours.gif', __('[CVS]', 'ktai_pictogram')), 
		'd046'  => array('SA/gasstation.gif', __('[gas station]', 'ktai_pictogram')), 
		'd047'  => array('SA/parking.gif', __('[parking]', 'ktai_pictogram')), 
		'd048'  => array('SA/signaler.gif', __('[signal]', 'ktai_pictogram')), 
		'd049'  => array('SA/toilet.gif', __('[toilet]', 'ktai_pictogram')), 
		'd050'  => array('SA/restaurant.gif', __('[restaurant]', 'ktai_pictogram')), 
		'd051'  => array('SA/cafe.gif', __('[coffee shop]', 'ktai_pictogram')), 
		'd052'  => array('SA/bar.gif', __('[martini]', 'ktai_pictogram')), 
		'd053'  => array('SA/beer.gif', __('[beer]', 'ktai_pictogram')),
		'd054'  => array('SA/fastfood.gif', __('[hamburger]', 'ktai_pictogram')), 
		'd055'  => array('SA/boutique.gif', __('[boutique]', 'ktai_pictogram')), 
		'd056'  => array('SA/hairsalon.gif', __('[scissors]', 'ktai_pictogram')), // hair salon
		'd057'  => array('SA/karaoke.gif', __('[microphone]', 'ktai_pictogram')), // karaoke
		'd058'  => array('SA/movie.gif', __('[movie]', 'ktai_pictogram')), 
		'd059'  => array('SA/upwardright.gif', __('[upper-right]', 'ktai_pictogram')), 
		'd060'  => array('SA/carouselpony.gif', __('[dummy horse]', 'ktai_pictogram')), 
		'd061'  => array('SA/music.gif', __('[headphone]', 'ktai_pictogram')), 
		'd062'  => array('SA/art.gif', __('[art]', 'ktai_pictogram')), 
		'd063'  => array('SA/drama.gif', __('[play]', 'ktai_pictogram')), 
		'd064'  => array('SA/event.gif', __('[event]', 'ktai_pictogram')), 
		'd065'  => array('SA/ticket.gif', __('[ticket]', 'ktai_pictogram')), 
		'd066'  => array('SA/smoking.gif', __('[smoking]', 'ktai_pictogram')), 
		'd067'  => array('SA/nosmoking.gif', __('[no smoking]', 'ktai_pictogram')), 
		'd068'  => array('SA/camera.gif', __('[camera]', 'ktai_pictogram')), 
		'd069'  => array('SA/bag.gif', __('[bag]', 'ktai_pictogram')), 
		'd070'  => array('SA/book.gif', __(__('[book]', 'ktai_pictogram'), 'ktai_pictogram')), 
		'd071'  => array('SA/ribbon.gif', __('[ribbon]', 'ktai_pictogram')), 
		'd072'  => array('SA/present.gif', __('[present]', 'ktai_pictogram')), 
		'd073'  => array('SA/birthday.gif', __('[birthday]', 'ktai_pictogram')), 
		'd074'  => array('SA/telephone.gif', __('[telephone]', 'ktai_pictogram')), 
		'd075'  => array('SA/mobilephone.gif', __('[mobile phone]', 'ktai_pictogram')), 
		'd076'  => array('SA/memo.gif', __('[memo]', 'ktai_pictogram')), 
		'd077'  => array('SA/tv.gif', __('[TV]', 'ktai_pictogram')), 
		'd078'  => array('SA/game.gif', __('[game]', 'ktai_pictogram')), 
		'd079'  => array('SA/cd.gif', __('[CD]', 'ktai_pictogram')), 
		'd080'  => array('SA/heart.gif', '&hearts;'), 
		'd081'  => array('SA/spade.gif', '&spades;'), 
		'd082'  => array('SA/diamond.gif', '&diams;'), 
		'd083'  => array('SA/club.gif', '&clubs;'), 
		'd084'  => array('SA/eye.gif', __('[eye]', 'ktai_pictogram')), 
		'd085'  => array('SA/ear.gif', __('[ear]', 'ktai_pictogram')), 
		'd086'  => array('SA/rock.gif', _x('[rock]', 'gesture game', 'ktai_pictogram')), 
		'd087'  => array('SA/scissors.gif', _x('[scissors]', 'gesture game', 'ktai_pictogram')), 
		'd088'  => array('SA/paper.gif', _x('[paper]', 'gesture game', 'ktai_pictogram')), 
		'd089'  => array('SA/downwardright.gif', __('[lower-right]', 'ktai_pictogram')), 
		'd090'  => array('SA/upwardleft.gif', __('[upper-lef]', 'ktai_pictogram')), 
		'd091'  => array('SA/foot.gif', __('[footmark]', 'ktai_pictogram')), 
		'd092'  => array('SA/shoe.gif', __('[shoe]', 'ktai_pictogram')), 
		'd093'  => array('SA/eyeglass.gif', __('[glasses]', 'ktai_pictogram')), 
		'd094'  => array('SA/wheelchair.gif', __('[wheel chair]', 'ktai_pictogram')), 
		'd095'  => array('SA/newmoon.gif', '●'), // new moon
		'd096'  => array('SA/moon1.gif', __('[lunar eclipse]', 'ktai_pictogram')), 
		'd097'  => array('SA/moon2.gif', __('[half moon]', 'ktai_pictogram')), 
		'd098'  => array('SA/moon3.gif', __('[crescent]', 'ktai_pictogram')), 
		'd099'  => array('SA/fullmoon.gif', '○'), // full moon
		'd100'  => array('SA/dog.gif', __('[dog]', 'ktai_pictogram')), 
		'd101'  => array('SA/cat.gif', __('[cat]', 'ktai_pictogram')),
		'd102'  => array('SA/yacht.gif', __('[sailboat]', 'ktai_pictogram')), 
		'd103'  => array('SA/xmas.gif', __('[Christmas]', 'ktai_pictogram')), 
		'd104'  => array('SA/downwardleft.gif', __('[lower-left]', 'ktai_pictogram')), 
		'd105'  => array('SA/phoneto.gif', __('[phone to]', 'ktai_pictogram')), 
		'd106'  => array('SA/mailto.gif', __('[mail to]', 'ktai_pictogram')), 
		'd107'  => array('SA/faxto.gif', __('[FAX]', 'ktai_pictogram')), 
		'd108'  => array('SA/info01.gif', __('[i]', 'ktai_pictogram')), 
		'd109'  => array('SA/info02.gif', __('[i]', 'ktai_pictogram')), 
		'd110'  => array('SA/mail.gif', __('[mail]', 'ktai_pictogram')), 
		'd111'  => array('SA/by-d.gif', __('[presented by docoomo]', 'ktai_pictogram')), 
		'd112'  => array('SA/d-point.gif', __('[docomo point]', 'ktai_pictogram')), 
		'd113'  => array('SA/yen.gif', __('[pay]', 'ktai_pictogram')), 
		'd114'  => array('SA/free.gif', __('[free]', 'ktai_pictogram')), 
		'd115'  => array('SA/id.gif', __('[ID]', 'ktai_pictogram')), 
		'd116'  => array('SA/key.gif', __('[password]', 'ktai_pictogram')), 
		'd117'  => array('SA/enter.gif', '⏎'), // having next item
		'd118'  => array('SA/clear.gif', __('[CL]', 'ktai_pictogram')), 
		'd119'  => array('SA/search.gif', __('[magnifier]', 'ktai_pictogram')), 
		'd120'  => array('SA/new.gif', __('[NEW]', 'ktai_pictogram')), 
		'd121'  => array('SA/flag.gif', __('[location info]', 'ktai_pictogram')), 
		'd122'  => array('SA/free.gif', __('[FREE]', 'ktai_pictogram')), 
		'd123'  => array('SA/sharp.gif', '#'), 
		'd124'  => array('SA/mobaq.gif', 'Q'), 
		'd125'  => array('SA/one.gif', '1'), 
		'd126'  => array('SA/two.gif', '2'), 
		'd127'  => array('SA/three.gif', '3'), 
		'd128'  => array('SA/four.gif', '4'), 
		'd129'  => array('SA/five.gif', '5'), 
		'd130'  => array('SA/six.gif', '6'), 
		'd131'  => array('SA/seven.gif', '7'), 
		'd132'  => array('SA/eight.gif', '8'), 
		'd133'  => array('SA/nine.gif', '9'), 
		'd134'  => array('SA/zero.gif', '0'), 
		'd135'  => array('SA/ok.gif', __('[OK]', 'ktai_pictogram')), 
		'd136'  => array('SA/heart01.gif', '&hearts;'), // black heart
		'd137'  => array('SA/heart02.gif', '&hearts;'), // swing heart
		'd138'  => array('SA/heart03.gif', __('[break heart]', 'ktai_pictogram')), 
		'd139'  => array('SA/heart04.gif', '&hearts;&hearts;'), // multi hearts
		'd140'  => array('SA/happy01.gif', "(^_^)"), // happy
		'd141'  => array('SA/angry.gif', "(`_`)"), // tsk (angry)
		'd142'  => array('SA/despair.gif', "(v_v)"), // disappointed
		'd143'  => array('SA/sad.gif', "(;_;)"), // get tired (sad)
		'd144'  => array('SA/wobbly.gif', "(x_x)"), // very tired
		'd145'  => array('SA/up.gif', '&uarr;'), // good
		'd146'  => array('SA/note.gif', '♪'), // happy mood (melody)
		'd147'  => array('SA/spa.gif', __('[hot spring]', 'ktai_pictogram')), 
		'd148'  => array('SA/cute.gif', __('[flower]', 'ktai_pictogram')), // かわいい 
		'd149'  => array('SA/kissmark.gif', __('[hickey]', 'ktai_pictogram')), 
		'd150'  => array('SA/shine.gif', '◇'), // shining
		'd151'  => array('SA/flair.gif', __('[flash]', 'ktai_pictogram')), 
		'd152'  => array('SA/annoy.gif', __('[miffed]', 'ktai_pictogram')), 
		'd153'  => array('SA/punch.gif', __('[punch]', 'ktai_pictogram')), 
		'd154'  => array('SA/bomb.gif', '●~'), // bomb
		'd155'  => array('SA/notes.gif', '♪♪'), // moody
		'd156'  => array('SA/down.gif', '&darr;'), // bad
		'd157'  => array('SA/sleepy.gif', 'Zzz'), // sleepy
		'd158'  => array('SA/sign01.gif', '!'), 
		'd159'  => array('SA/sign02.gif', '!?'), 
		'd160'  => array('SA/sign03.gif', '!!'), 
		'd161'  => array('SA/impact.gif', 'Σ3'), // bump sound 
		'd162'  => array('SA/sweat01.gif', ';;'), // clammy sweat 
		'd163'  => array('SA/sweat02.gif', __('[clammy sweat]', 'ktai_pictogram')), 
		'd164'  => array('SA/dash.gif', '=3'), // dash 
		'd165'  => array('SA/sign04.gif', '&#12336;'), // dash sign 1
		'd166'  => array('SA/sign05.gif', '-o-'), // dash sign 2
		'd167'  => array('SA/slate.gif', __('[clapperboard]', 'ktai_pictogram')), 
		'd168'  => array('SA/pouch.gif', __('[sack]', 'ktai_pictogram')), 
		'd169'  => array('SA/pen.gif', __('[pen]', 'ktai_pictogram')), 
		'd170'  => array('SA/shadow.gif', __('[human figure]', 'ktai_pictogram')), 
		'd171'  => array('SA/chair.gif', __('[chair]', 'ktai_pictogram')), 
		'd172'  => array('SA/night.gif', __('[night]', 'ktai_pictogram')), 
		'd173'  => array('SA/soon.gif', '→SOON'), 
		'd174'  => array('SA/on.gif', '←ON→'), 
		'd175'  => array('SA/end.gif', 'END←'), 
		'd176'  => array('SA/clock.gif', __('[clock]', 'ktai_pictogram')), 
		'd201'  => array('SA/appli01.gif', 'α'), 
		'd202'  => array('SA/appli02.gif', __('[α]', 'ktai_pictogram')), 
		'd203'  => array('SA/t-shirt.gif', __('[T-shirt]', 'ktai_pictogram')), 
		'd204'  => array('SA/moneybag.gif', __('[purse]', 'ktai_pictogram')), 
		'd205'  => array('SA/rouge.gif', __('[makeup]', 'ktai_pictogram')), 
		'd206'  => array('SA/denim.gif', __('[jeans]', 'ktai_pictogram')), 
		'd207'  => array('SA/snowboard.gif', __('[snow board]', 'ktai_pictogram')), 
		'd208'  => array('SA/bell.gif', __('[chapel]', 'ktai_pictogram')), 
		'd209'  => array('SA/door.gif', __('[door]', 'ktai_pictogram')), 
		'd210'  => array('SA/dollar.gif', '($)'), // doller bag
		'd211'  => array('SA/pc.gif', __('[personal computer]', 'ktai_pictogram')), 
		'd212'  => array('SA/loveletter.gif', __('[love letter]', 'ktai_pictogram')), 
		'd213'  => array('SA/wrench.gif', __('[wrench]', 'ktai_pictogram')), 
		'd214'  => array('SA/pencil.gif', __('[pencil]', 'ktai_pictogram')), 
		'd215'  => array('SA/crown.gif', __('[crown]', 'ktai_pictogram')), 
		'd216'  => array('SA/ring.gif', __('[ring]', 'ktai_pictogram')), 
		'd217'  => array('SA/sandclock.gif', __('[sand clock]', 'ktai_pictogram')), 
		'd218'  => array('SA/bicycle.gif', __('[bicycle]', 'ktai_pictogram')), 
		'd219'  => array('SA/japanesetea.gif', __('[tea cup]', 'ktai_pictogram')), 
		'd220'  => array('SA/watch.gif', __('[watch]', 'ktai_pictogram')), 
		'd221'  => array('SA/think.gif', "(?_?)"), // thinking
		'd222'  => array('SA/confident.gif', "(-.-)"), // relieved
		'd223'  => array('SA/coldsweats01.gif', "(^_^;"), // clammy sweat
		'd224'  => array('SA/coldsweats02.gif', "('_';"), // clammy sweat
		'd225'  => array('SA/pout.gif', "(`^`)"), // get pouty
		'd226'  => array('SA/gawk.gif', "(-_-)"), // idling
		'd227'  => array('SA/lovely.gif', "(*_*)"), // eyes are hearts
		'd228'  => array('SA/good.gif', __('[OK]', 'ktai_pictogram')), // OK by fingers
		'd229'  => array('SA/bleah.gif', "(^j^)"), // baitling face
		'd230'  => array('SA/wink.gif', "('_-)"), // wink
		'd231'  => array('SA/happy02.gif', "(^o^)"), // happy
		'd232'  => array('SA/bearing.gif', "(x_x)"), // patience
		'd233'  => array('SA/catface.gif', "(=ω=)"), // cat face
		'd234'  => array('SA/crying.gif', "(T_T)"), // crying
		'd235'  => array('SA/weep.gif', '(;_;)'), // tears
		'd236'  => array('SA/ng.gif', __('[No Good]', 'ktai_pictogram')), 
		'd237'  => array('SA/clip.gif', __('[clip]', 'ktai_pictogram')), 
		'd238'  => array('SA/copyright.gif', '&copy;'), 
		'd239'  => array('SA/tm.gif', '&trade;'), 
		'd240'  => array('SA/run.gif', __('[running person]', 'ktai_pictogram')), 
		'd241'  => array('SA/secret.gif', __('[secret]', 'ktai_pictogram')), 
		'd242'  => array('SA/recycle.gif', __('[recycle]', 'ktai_pictogram')), 
		'd243'  => array('SA/r-mark.gif', '&reg;'), 
		'd244'  => array('SA/danger.gif', '[!]'), 
		'd245'  => array('SA/ban.gif', __('[ban]', 'ktai_pictogram')), 
		'd246'  => array('SA/empty.gif', __('[vacant]', 'ktai_pictogram')), 
		'd247'  => array('SA/pass.gif', __('[pass]', 'ktai_pictogram')), 
		'd248'  => array('SA/full.gif', __('[occupied]', 'ktai_pictogram')), 
		'd249'  => array('SA/leftright.gif', '⇔'), 
		'd250'  => array('SA/updown.gif', '↑↓'), 
		'd251'  => array('SA/school.gif', __('[school]', 'ktai_pictogram')), 
		'd252'  => array('SA/wave.gif', __('[wave]', 'ktai_pictogram')), 
		'd253'  => array('SA/fuji.gif', __('[Mt. Fuji]', 'ktai_pictogram')), 
		'd254'  => array('SA/clover.gif', __('[clover]', 'ktai_pictogram')), 
		'd255'  => array('SA/cherry.gif', __('[cherry]', 'ktai_pictogram')), 
		'd256'  => array('SA/tulip.gif', __('[tulip]', 'ktai_pictogram')), 
		'd257'  => array('SA/banana.gif', __('[banana]', 'ktai_pictogram')), 
		'd258'  => array('SA/apple.gif', __('[apple]', 'ktai_pictogram')),
		'd259'  => array('SA/bud.gif', __('[germ]', 'ktai_pictogram')), 
		'd260'  => array('SA/maple.gif', __('[maple leaf]', 'ktai_pictogram')), 
		'd261'  => array('SA/cherryblossom.gif', __('[cherry blossoms]', 'ktai_pictogram')), 
		'd262'  => array('SA/riceball.gif', __('[rice ball]', 'ktai_pictogram')), 
		'd263'  => array('SA/cake.gif', __('[cake]', 'ktai_pictogram')), 
		'd264'  => array('SA/bottle.gif', __('[liquor bottle]', 'ktai_pictogram')), 
		'd265'  => array('SA/noodle.gif', __('[bowl]', 'ktai_pictogram')), 
		'd266'  => array('SA/bread.gif', __('[bread]', 'ktai_pictogram')), 
		'd267'  => array('SA/snail.gif', __('[snail]', 'ktai_pictogram')), 
		'd268'  => array('SA/chick.gif', __('[chick]', 'ktai_pictogram')), 
		'd269'  => array('SA/penguin.gif', __('[penguin]', 'ktai_pictogram')), 
		'd270'  => array('SA/fish.gif', __('[fish]', 'ktai_pictogram')), 
		'd271'  => array('SA/delicious.gif', "(^+^)"), // delicious 
		'd272'  => array('SA/smile.gif', "(^◇^)"), // triumph 
		'd273'  => array('SA/horse.gif', __('[horse]', 'ktai_pictogram')), 
		'd274'  => array('SA/pig.gif', __('[pig]', 'ktai_pictogram')), 
		'd275'  => array('SA/wine.gif', __('[wine glass]', 'ktai_pictogram')), 
		'd276'  => array('SA/shock.gif', ")@_@("), // very depressed
 		'e253'  => __('[first finger]', 'ktai_pictogram'), 
		'e254'  => __('[couple]', 'ktai_pictogram'), 
		'e255'  => __('[beginner]', 'ktai_pictogram'), 
		'e256'  => __('[guitar]', 'ktai_pictogram'), 
		'e257'  => __('[stock prices]', 'ktai_pictogram'), 
		'e258'  => __('[R18]', 'ktai_pictogram'), 
		'e259'  => __('[mahjong]', 'ktai_pictogram'), 
		'e260'  => __('[community]', 'ktai_pictogram'), 
		'e261'  => __('[hit]', 'ktai_pictogram'), 
		'e262'  => __('[newspaper]', 'ktai_pictogram'), 
		'e263'  => __('[Santa Claus]', 'ktai_pictogram'), 
		'e264'  => __('[newspaper]', 'ktai_pictogram'), 
		'e265'  => '　', // not in use
		'e266'  => __('[coin]', 'ktai_pictogram'), 
		'e267'  => '　', // not in use
		'e268'  => '　', // not in use
		'e269'  => 'EM', 
		'e270'  => 'EM', 
		'e271'  => '　', // not in use
		'e272'  => '　', // not in use
		'e273'  => '　', // not in use
		'e274'  => '　', // not in use
		'e275'  => '　', // not in use
		'e276'  => '　', // not in use
		'e277'  => '　', // not in use
		'e278'  => '　', // not in use
		'wf040' => array('SA/heart.gif', '&hearts;'), 
		'wf041' => array('SA/clock.gif', __('[wall clock]', 'ktai_pictogram')), 
		'wf042' => array('SA/telephone.gif', __('[telephone]', 'ktai_pictogram')), 
		'wf043' => __('[mug]', 'ktai_pictogram'), 
		'wf044' => '*', // asterisk
		'wf045' => array('SA/updown.gif', '↑↓'), 
		'wf046' => array('SA/leftright.gif', '⇔'), 
		'wf047' => '(((', 
		'wf048' => array('SA/sun.gif', __('[sunny]', 'ktai_pictogram')), 
		'wf049' => array('SA/rain.gif', __('[rain]', 'ktai_pictogram')), 
		'wf04a' => array('SA/cloud.gif', __('[cloud]', 'ktai_pictogram')), 
		'wf04b' => __('[tear]', 'ktai_pictogram'), 
		'wf04c' => "(^_^)", // smile 
		'wf04d' => array('SA/kissmark.gif', __('[mouth]', 'ktai_pictogram')), 
		'wf04e' => '&#9835;', // melody (sixteen musical note)
		'wf04f' => array('SA/car.gif', __('[car]', 'ktai_pictogram')), 
		'wf050' => array('SA/train.gif', __('[train]', 'ktai_pictogram')), 
		'wf051' => array('SA/airplane.gif', __('[airplane]', 'ktai_pictogram')), 
		'wf052' => __('[motorcycle]', 'ktai_pictogram'), 
		'wf053' => array('SA/house.gif', __('[home]', 'ktai_pictogram')), 
		'wf054' => array('SA/building.gif', __('[building]','ktai_pictogram')), 
		'wf055' => array('SA/scissors.gif', __('[peace sign]', 'ktai_pictogram')), 
		'wf056' => array('SA/restaurant.gif', __('[dinner]', 'ktai_pictogram')), 
		'wf057' => array('SA/bar.gif', __('[glass]', 'ktai_pictogram')), 
		'wf058' => "(;_;)", // crying face
		'wf059' => array('SA/tulip.gif', __('[tulip]', 'ktai_pictogram')), 
		'wf05a' => __('[bat]', 'ktai_pictogram'), 
		'wf05b' => array('SA/baseball.gif', __('[ball]', 'ktai_pictogram')), 
		'wf05c' => array('SA/punch.gif', __('[punch]', 'ktai_pictogram')), 
		'wf05d' => array('SA/thunder.gif', __('[thunder]', 'ktai_pictogram')), 
		'wf05e' => array('SA/angry.gif', "(`_`)"), // angry face
		'wf05f' => array('SA/beer.gif', __('[beer]', 'ktai_pictogram')), 
		'wf060' =>  array('SA/memo.gif', __(__('[notebook]', 'ktai_pictogram'), 'ktai_pictogram')), 
		'wf061' => array('SA/pencil.gif', __('[pen]', 'ktai_pictogram')), 
		'wf062' => __('[scull]', 'ktai_pictogram'), 
		'wf063' => array('SA/mail.gif', __('[mail]', 'ktai_pictogram')), 
		'wf064' => array('SA/nosmoking.gif', __('[no smoking]', 'ktai_pictogram')), 
		'wf065' => array('SA/bell.gif', __('[bell]', 'ktai_pictogram')), 
		'wf066' => __('[flower]', 'ktai_pictogram'), 
		'wf067' => array('SA/spa.gif', __('[hot spring]', 'ktai_pictogram')), 
		'wf068' => __('[moon]', 'ktai_pictogram'), // reflected crescent
		'wf069' => __('[flag]', 'ktai_pictogram'), 
		'wf06a' => "(#□#)", // face with mask, 
		'wf06b' => __('[record]', 'ktai_pictogram'), 
		'wf06c' => __('[meat]', 'ktai_pictogram'), 
		'wf06d' => array('SA/dog.gif', __('[dog]', 'ktai_pictogram')), 
		'wf06e' => array('SA/cat.gif', __('[cat]', 'ktai_pictogram')), 
		'wf06f' => __('[monkey]', 'ktai_pictogram'), 
		'wf070' => __('[elephant]', 'ktai_pictogram'), 
		'wf071' => __('[octopus]', 'ktai_pictogram'), 
		'wf072' => array('SA/noodle.gif', __('[ramen]', 'ktai_pictogram')), 
		'wf073' => array('SA/karaoke.gif', __('[microphone]', 'ktai_pictogram')), 
		'wf074' => __('[miffed]', 'ktai_pictogram'), 
		'wf075' => array('SA/chick.gif', __('[chick]', 'ktai_pictogram')), 
		'wf076' => "(~_~)", // sleeping
		'wf077' => array('SA/cafe.gif', __('[coffee]', 'ktai_pictogram')), 
		'wf078' => array('SA/smoking.gif', __('[tabaco]', 'ktai_pictogram')), 
		'wf079' => array('SA/sweat01.gif', ';;'), // flying sweat 
		'wf07a' => array('SA/riceball.gif', __('[rice ball]', 'ktai_pictogram')), 
		'wf07b' => array('SA/bag.gif', __('[bag]', 'ktai_pictogram')), 
		'wf07c' => __('[plop]', 'ktai_pictogram'), 
		'wf07d' => __('[tie]', 'ktai_pictogram'), 
		'wf07e' => array('SA/t-shirt.gif', __('[shirt]', 'ktai_pictogram')), 
		'wf080' => __('[melon]', 'ktai_pictogram'), 
		'wf081' => __('[shaved ice]', 'ktai_pictogram'), 
		'wf082' => array('SA/sports.gif', __('[bikini]', 'ktai_pictogram')), 
		'wf083' => array('SA/hairsalon.gif', __('[scissors]', 'ktai_pictogram')), 
		'wf084' => __('[injector]', 'ktai_pictogram'), 
		'wf085' => __('[anchor]', 'ktai_pictogram'), 
		'wf086' => __('[frog]', 'ktai_pictogram'), 
		'wf087' => array('SA/paper.gif', _x('[paper]', 'gesture game', 'ktai_pictogram')), 
		'wf088' => array('SA/heart03.gif', __('[break heart]', 'ktai_pictogram')), 
		'wf089' => array('SA/diamond.gif', '&diams;'), 
		'wf08a' => array('SA/club.gif', '&clubs;'), 
		'wf08b' => array('SA/spade.gif', '&spades;'), 
		'wf08c' => array('SA/clip.gif', __('[clip]', 'ktai_pictogram')), 
		'wf08d' => array('SA/snow.gif', __('[snow]', 'ktai_pictogram')), 
		'wf08e' => array('SA/birthday.gif', __('[birthday cake]', 'ktai_pictogram')), 
		'wf08f' => array('SA/apple.gif', __('[apple]', 'ktai_pictogram')), 
		'wf090' => array('SA/present.gif', __('[present]', 'ktai_pictogram')), 
		'wf091' => array('SA/dollar.gif', '($)'), //money (dollar) 
		'wf092' => array('SA/door.gif', __('[EXIT]', 'ktai_pictogram')), 
		'wf093' => array('SA/door.gif', __('[door]', 'ktai_pictogram')), 
		'wf094' => __('[big buddy]', 'ktai_pictogram'), 
		'wf095' => array('SA/mobilephone.gif', __('[PHS]', 'ktai_pictogram')), 
		'wf096' => '☆', 
		'wf097' => array('SA/ticket.gif', __('[ticket]', 'ktai_pictogram')), 
		'wf098' => array('SA/heart04.gif', '&hearts;&hearts;'), 
		'wf099' => array('SA/flair.gif', __('[flash]', 'ktai_pictogram')), 
		'wf09a' => array('SA/foot.gif', __('[footmark]', 'ktai_pictogram')), 
		'wf09b' => array('SA/smile.gif', "(^o^)"), // smile face
		'wf09c' => array('SA/tennis.gif', __('[tennis]', 'ktai_pictogram')), 
		'wf09d' => array('SA/movie.gif', __('[movie]', 'ktai_pictogram')), 
		'wf09e' => array('SA/ski.gif', __('[ski]', 'ktai_pictogram')), 
		'wf09f' => array('SA/sign03.gif', '!!'), 
		'wf0a0' => array('SA/sign02.gif', '!?'), 
		'wf0a1' => '?', 
		'wf0a2' => '&darr;', 
		'wf0a3' => '&uarr;', 
		'wf0a4' => array('SA/ok.gif', __('[OK]', 'ktai_pictogram')), 
		'wf0a5' => __('[biceps]', 'ktai_pictogram'), 
		'wf0a6' => '&rarr;&hearts;', 
		'wf0a7' => __('[convolution]', 'ktai_pictogram'), 
		'wf0a8' => array('SA/typhoon.gif', __('[typhoon]', 'ktai_pictogram')), 
		'wf0a9' => __('[sea]', 'ktai_pictogram'), 
		'wf0aa' => __('[surfing]', 'ktai_pictogram'), 
		'wf0ab' => array('SA/fuji.gif', __('[mountain]', 'ktai_pictogram')), 
		'wf0ac' => array('SA/fuji.gif', __('[Mt. Fuji]', 'ktai_pictogram')), 
		'wf0ad' => __('[camp]', 'ktai_pictogram'), 
		'wf0ae' => array('SA/maple.gif', __('[fallen leaves]', 'ktai_pictogram')), 
		'wf0af' => array('SA/bus.gif', __('[bus]', 'ktai_pictogram')), 
		'wf0b0' => array('SA/soccer.gif', __('[soccer]', 'ktai_pictogram')), 
		'wf0b1' => __('[beginner]', 'ktai_pictogram'), 
		'wf0b2' => '&laquo;',
		'wf0b3' => '&raquo;', 
		'wf0b4' => __('[important]', 'ktai_pictogram'), 
		'wf0b5' => __('[R18]', 'ktai_pictogram'), 
		'wf0b6' => array('SA/danger.gif', '[!]'), 
		'wf0b7' => array('SA/recycle.gif', __('[Recycle]', 'ktai_pictogram')), 
		'wf0b8' => '▽.i|', // electric intensity 
		'wf0b9' => ')))', 
		'wf0ba' => '×', 
		'wf0bb' => array('SA/copyright.gif', '&copy;'), 
		'wf0bc' => array('SA/r-mark.gif', '&reg;'), 
		'wf0bd' => __('[777]', 'ktai_pictogram'), // three seven
		'wf0be' => array('SA/zero.gif', '0'), 
		'wf0bf' => array('SA/one.gif', '1'), 
		'wf0c0' => array('SA/two.gif', '2'), 
		'wf0c1' => array('SA/three.gif', '3'), 
		'wf0c2' => array('SA/four.gif', '4'), 
		'wf0c3' => array('SA/five.gif', '5'), 
		'wf0c4' => array('SA/six.gif', '6'), 
		'wf0c5' => array('SA/seven.gif', '7'), 
		'wf0c6' => array('SA/eight.gif', '8'), 
		'wf0c7' => array('SA/nine.gif', '9'), 
		'wf0c8' => array('SA/aries.gif', __('[Aries]', 'ktai_pictogram')),
		'wf0c9' => array('SA/taurus.gif', __('[Taurus]', 'ktai_pictogram')),
		'wf0ca' => array('SA/gemini.gif', __('[Gemini]', 'ktai_pictogram')), 
		'wf0cb' => array('SA/cancer.gif', __('[Cancer]', 'ktai_pictogram')), 
		'wf0cc' => array('SA/leo.gif', __('[Leo]', 'ktai_pictogram')), 
		'wf0cd' => array('SA/virgo.gif', __('[Virgo]', 'ktai_pictogram')), 
		'wf0ce' => array('SA/libra.gif', __('[Libra]', 'ktai_pictogram')), 
		'wf0cf' => array('SA/scorpius.gif', __('[Scorpius]', 'ktai_pictogram')), 
		'wf0d0' => __('[Ophiuchus]', 'ktai_pictogram'), 
		'wf0d1' => array('SA/sagittarius.gif', __('[Sagittarius]', 'ktai_pictogram')), 
		'wf0d2' => array('SA/capricornus.gif', __('[Capricornus]', 'ktai_pictogram')),
		'wf0d3' => array('SA/aquarius.gif', __('[Aquarius]', 'ktai_pictogram')),  
		'wf0d4' => array('SA/pisces.gif', __('[Aquarius]', 'ktai_pictogram')), 
		'wf0d5' => array('SA/shadow.gif', __('[Ksitigarbha]', 'ktai_pictogram')), 
		'wf0d6' => array('SA/fastfood.gif', __('[McDonald]', 'ktai_pictogram')), 
		'wf0d7' => array('SA/fastfood.gif', __('[MOS BURGER]', 'ktai_pictogram')), 
		'wf0d8' => '　', // not in use
		'wf0d9' => array('SA/fastfood.gif', __('[Lotteria]', 'ktai_pictogram')), 
		'wf0da' => '　', // not in use
		'wf0db' => array('SA/cafe.gif', __('[Doutor Coffee]', 'ktai_pictogram')), 
		'wf0dc' => '　', // not in use
		'wf0dd' => '　', // not in use
		'wf0de' => '　', // not in use
		'wf0df' => '　', // not in use
		'wf0e0' => __('[peach]', 'ktai_pictogram'), // (Bamiyan?)
		'wf0e1' => '　', // not in use
		'wf0e2' => '　', // not in use
		'wf0e3' => array('SA/restaurant.gif', __('[Bikkuri Donkey]', 'ktai_pictogram')), 
		'wf0e4' => '　', // not in use
		'wf0e5' => '　', // not in use
		'wf0e6' => '　', // not in use
		'wf0e7' => array('SA/24hours.gif', __('[LAWSON]', 'ktai_pictogram')), 
		'wf0e8' => '　', // not in use
		'wf0e9' => array('SA/24hours.gif', __('[am/pm]', 'ktai_pictogram')), 
		'wf0ea' => '　', // not in use
		'wf0eb' => '　', // not in use
		'wf0ec' => '　', // not in use
		'wf0ed' => '　', // not in use
		'wf0ee' => '　', // not in use
		'wf0ef' => '　', // not in use
		'wf0f0' => __('[Seibu]', 'ktai_pictogram'), 
		'wf0f1' => '　', // not in use
		'wf0f2' => '　', // not in use
		'wf0f3' => '　', // not in use
		'wf0f4' => '　', // not in use
		'wf0f5' => '　', // not in use
		'wf0f6' => '　', // not in use
		'wf0f7' => '　', // not in use
		'wf0f8' => '　', // not in use
		'wf0f9' => '　', // not in use
		'wf0fa' => '　', // not in use
		'wf0fb' => '　', // not in use
		'wf0fc' => array('SA/dog.gif', __('[Hachi-kou]', 'ktai_pictogram')), 
		'wf140' => array('SA/shadow.gif', __('[Moyai statue]', 'ktai_pictogram')), 
		'wf141' => '　', // not in use
		'wf142' => '　', // not in use
		'wf143' => '　', // not in use
		'wf144' => '　', // not in use
		'wf145' => '　', // not in use
		'wf146' => '　', // not in use
		'wf147' => '　', // not in use
		'wf148' => array('SA/bank.gif', __('[UFJ Bank]', 'ktai_pictogram')), 
		'wf149' => '　', // not in use
		'wf14a' => '　', // not in use
		'wf14b' => '　', // not in use
		'wf14c' => '　', // not in use
		'wf14d' => array('SA/door.gif', __('[EXIT]', 'ktai_pictogram')), 
		'wf14e' => '　', // not in use
		'wf14f' => '　', // not in use
		'wf150' => '(T_T)', // crying
		'wf151' => '　', // not in use
		'wf152' => '　', // not in use
		'wf153' => '　', // not in use
		'wf154' => '　', // not in use
		'wf155' => '　', // not in use
		'wf156' => '　', // not in use
		'wf157' => '　', // not in use
		'wf158' => '　', // not in use
		'wf159' => '　', // not in use
		'wf15a' => '　', // not in use
		'wf15b' => '　', // not in use
		'wf15c' => '　', // not in use
		'wf15d' => '　', // not in use
		'wf15e' => '　', // not in use
		'wf15f' => '　', // not in use
	);
	$charset = strtoupper(get_bloginfo('charset'));
	if ( $charset != 'UTF-8' ) {
		$code = create_function('$c', 
			'return (is_array($c) 
			 ? array($c[0], $Ktai_Style->encode->convert($c[1], $charset , "UTF-8")) 
			 : $Ktai_Style->encode->convert($c, $charset , "UTF-8")
		);');
		$this->translated = array_map($code, $this->pictograms);
	} else {
		$this->translated = $this->pictograms;
	}
	$this->translated = apply_filters('ktai_pictogram_table', $this->translated, __CLASS__, $charset);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_pict_image($buffer) {
	$buffer = preg_replace(
		'!<img localsrc="([^"]+)"( alt="(' . KtaiStyle::DOUBLE_QUOTED_STRING_REGEX . ')")?[^/>]*/?>!se', // <?php /* syntax hilighting fix */
		'$this->pict_replace("$1", "$2", "$3", get_bloginfo("charset"))', 
		$buffer);
	return $buffer;
}

/* ==================================================
 * @param	string   $code
 * @param	boolean  $has_alt
 * @param	string   $alt
 * @param	string   $charset
 * @return	string   $converted
 */
public function pict_replace($code, $has_alt, $alt, $charset) {
	if (is_array($this->translated[$code])) {
		$converted = sprintf('<img src="%1$s" alt="%2$s" class="%3$s" style="%4$s" />', 
			$this->pict_url . $this->translated[$code][0],
			($has_alt ? $alt : $this->translated[$code][1]),
			self::PICT_CLASS,
			self::PICT_STYLE
		);
	} else {
		$converted = $has_alt ? $alt : $this->translated[$code];
	}
	$converted = apply_filters('ktai_convert_pict_other', $converted, $code, ($has_alt ? $alt : NULL), $charset);
	return $converted;
}

// ===== End of class ====================
}

?>