<?php 
$textdomain = 'photolog';
global $Ktai_Style;
if ($Ktai_Style->check_wp_version('2.7')) {
	load_theme_textdomain($textdomain, dirname(__FILE__));
} else { // back compatible for WP 2.6
	$locale = get_locale();
	$mofile = dirname(__FILE__) . "/$locale.mo";
	load_textdomain($textdomain, $mofile);
}

function ks_setup_post_thumbnail() {
	global $wpdb, $wp_query, $ks_thumbnails;
	$post_ids = $ks_thumbnails = array();
	foreach ($wp_query->posts as $p) {
		$post_ids[] = $p->ID;
	}
	if ($post_ids) {
		$results = $wpdb->get_results($wpdb->prepare(
		"SELECT 
		  p.post_parent AS post_parent, 
		  p.ID AS ID, p.post_title AS title, 
		  m.meta_value AS file 
		FROM 
		  `$wpdb->posts` AS p, 
		  `$wpdb->postmeta` AS m 
		WHERE 
		  p.ID = m.post_id 
		  AND 
		  p.post_parent IN(" . implode(',', array_map('intval', $post_ids)) . ") 
		  AND
		  ( LOCATE('image/', p.post_mime_type) = 1 
		    OR
		    ( LOCATE('import', p.post_mime_type) = 1 
		      AND 
		      RIGHT(m.meta_value, 4) IN('.jpg', 'jpeg', '.gif', '.png')
		    )
		  )
		  AND 
		  m.meta_key = '_wp_attached_file'
		ORDER BY post_parent"
		), ARRAY_A);
		if ($results) {
			foreach ($results as $r) {
				$ks_thumbnails[$r['post_parent']][$r['ID']] = array('title' => $r['title'], 'path' => $r['file']);
			}
		}
	}
}

function ks_get_post_thumbnail($post_id, $align = 'right') {
	global $ks_thumbnails;
	if (! isset($ks_thumbnails)) {
		$children = get_children(array('post_parent' => intval($post_id), 'post_type' => 'attachment'));
		$need_check = true;
	} elseif (isset($ks_thumbnails[$post_id])) {
		$children = $ks_thumbnails[$post_id];
		$need_check = false;
	} else {
		return;
	}
	if ($align == 'left') {
		$style = 'style="float:left;margin-right:2px;" align="left"';
	} else {
		$style = 'style="float:right;margin-left:2px;" align="right"';
	}
	if ($children) {
		global $Ktai_Style, $ks_settings;
		foreach ($children as $id => $c) {
			if ($need_check) {
				if (! wp_attachment_is_image($id)) {
					continue;
				}
				$path = get_attached_file($id);
				if (! $path) {
					continue;
				}
				$title = $c->post_title;
			} else {
				$path = $c['path'];
				$title = $c['title'];
			}
			if (strpos($path, '/') !== 0 && ! preg_match('|^.:\\\|', $path) && (($uploads = wp_upload_dir()) && false === $uploads['error']) ) {
				$path = $uploads['basedir'] . "/$path";
			}
			$thumb = $Ktai_Style->shrinkage->get_thumbnail($path);
			if (is_null($thumb) || is_ks_error($thumb)) {
				continue;
			}
			$thumb_url = dirname(KtaiStyle::strip_host(wp_get_attachment_url($id))) . '/' . basename($thumb);
			if (ks_is_image_inline()) {
				if (ks_applied_appl_xhtml()) {
					echo '<img src="' . attribute_escape($thumb_url) . '" alt="' . attribute_escape($title) . '" ' . $style . ' />';
				} else {
					echo '<img src="' . attribute_escape($thumb_url) . '" alt="' . attribute_escape($title) . '" /><br />';
				}
			} else {
				echo sprintf(__('<font color="%s">| </font><img localsrc="94" alt="Image:" />', 'photolog'), $ks_settings['list_color']) . '</font><a href="' . attribute_escape($thumb_url) . '">' . attribute_escape($title) . '</a><br />';
			}
			break;
		}
	}
}
?>