<?php
/* ==================================================
 *   Redirect to external sites
   ================================================== */

define ('KTAI_REDIR_URL_PARAM', 'url');
define ('KTAI_REDIR_NONCE_PARAM', '_wpnonce');
define ('KTAI_PCONLY_SITE_PARAM', 'pconly');

global $wpload_error, $Ktai_Style, $Redir;
$wpload_error = 'Could not open the redirect page because custom WP_PLUGIN_DIR is set.';
require dirname(__FILE__) . '/wp-load.php';
nocache_headers();

if (! defined('KS_ALWAYS_RELAY_PAGE')) {
	define ('KS_ALWAYS_RELAY_PAGE', false);
}
if (! isset($Ktai_Style) || ! $Ktai_Style->is_ktai()) {
	Ktai_Style_Redir::show_error();
} else {
	$Redir = new Ktai_Style_Redir($Ktai_Style);
	$template = $Ktai_Style->get('template_dir') . 'redir.php';
	if (file_exists($template)) {
		$Redir->use_template($template);
	} elseif ($Redir->full_url) {
		$Redir->output();
	} else {
		$Redir->nonce_error();
	}
}
exit();

/* ==================================================
 *   Ktai_Style_Redir class
   ================================================== */

class Ktai_Style_Redir {
	private $base;
	private $url       = NULL;
	public $full_url   = NULL;
	public $mobile_url = NULL;
	public $same_host  = NULL;

// ==================================================
public function __construct($base) {
	$this->base = $base;
	if (! isset($_GET[KTAI_REDIR_NONCE_PARAM]) || empty($_GET[KTAI_REDIR_NONCE_PARAM]) 
	||  ! isset($_GET[KTAI_REDIR_URL_PARAM]) || empty($_GET[KTAI_REDIR_URL_PARAM])) {
		self::show_error();
		// exit;
	}
	$this->url = stripslashes($_GET[KTAI_REDIR_URL_PARAM]);
	$nonce = stripslashes($_GET[KTAI_REDIR_NONCE_PARAM]);
	if (! $this->base->verify_anon_nonce($nonce, 'redir_' . md5($this->url) . md5($_SERVER['HTTP_USER_AGENT']))) {
		return;
	}
	$this->full_url = $this->url = clean_url($this->url);
	if (preg_match('|^/|', $this->url)) {
		$this->full_url = preg_replace('|^(https?://[^/]*)/.*$|', '$1', get_bloginfo('url')) . $this->url;
	}
	if (isset($_GET[KTAI_PCONLY_SITE_PARAM]) && $_GET[KTAI_PCONLY_SITE_PARAM] == 'true') {
		return;
	}
	$this->mobile_url = $this->discover_mobile($this->url);
	if ($this->mobile_url && $this->compare_host() && ! KS_ALWAYS_RELAY_PAGE) {
		wp_redirect($this->mobile_url);
		exit;
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
static function show_error() {
	header("HTTP/1.0 400 Bad Request");
?>
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HTML><HEAD>
<TITLE>400 Bad Request</TITLE>
</HEAD><BODY>
<H1>Bad Request</H1>
Your request could not be understood by the server due to malformed syntax.
</BODY></HTML>
<?php
	exit;
}

/* ==================================================
 * @param	string   $url
 * @return	string   $mobile_url
 * based on discover_pingback_server_uri() at comment.php of WP 2.5.1
 */
private function discover_mobile($url) {
	global $wp_version;

	$byte_count = 0;
	$timeout_bytes = 32768;
	$headers = '';
	extract(parse_url($url), EXTR_SKIP);
	if ( !isset($host) ) {
		// Not an URL. This should never happen.
		return false;
	}
	$path  = ( isset($path) )  ? $path        : '/';
	$path .= ( isset($query) ) ? '?' . $query : '';
	if (isset($scheme) && $scheme == 'https') {
		$host_sock = 'ssl://' . $host;
		$host_req  = $host;
		if (isset($port)) {
			$host_req .= ':' . $port;
		} else {
			$port = 443;
		}
	} else {
		$host_sock = $host;
		$host_req  = $host;
		if (isset($port)) {
			$host_req .= ':' . $port;
		} else {
			$port  = 80;
		}
	}

	// Try to connect to the server at $host
	$fp = @fsockopen($host_sock, $port, $errno, $errstr, 2.0);
	if ( !$fp ) // Couldn't open a connection to $host
		return false;

	// Send the GET request
	$request[] = 'GET ' . $path . ' HTTP/1.1';
	$request[] = 'Host: ' . $host_req;
	$request[] = 'User-Agent: WordPress/' . $wp_version . '; ' . get_bloginfo('url');
	// ob_end_flush();
	fputs($fp, implode("\r\n", preg_replace('/[\r\n]/', '', $request)) . "\r\n\r\n");

	// Check the content type
	while (! feof($fp)) {
		$line = fgets($fp, 512);
		if (trim($line) == '')
			break;
		$headers .= trim($line)."\n";
		if ( strpos(strtolower($headers), 'content-type: ') ) {
			preg_match('#content-type: (.+)#is', $headers, $matches);
			$content_type = trim($matches[1]);
		}
	}

	if (preg_match('#(image|audio|video|model)/#i', $content_type)) {
	 // Not an (x)html, sgml, or xml page, no use going further
		fclose($fp);
		return false;
	}

	$is_chunked = preg_match('/^Transfer-Encoding: chunked$/im', $headers);
	$contents = '';
	$offset = 0;
	while (! feof($fp)) {
		$line = $this->fgets($fp, $is_chunked);
		if (is_null($line)) {
			break;
		} elseif (empty($line)) {
			continue;
		}
		$contents .= trim($line);
		if (preg_match_all('!<link([^>]*?)media=([\'"])handheld\\2([^>]*)/?>!is', $contents, $links, PREG_SET_ORDER | PREG_OFFSET_CAPTURE, $offset)) {
			foreach ($links as $l) {
				$attr = $l[1][0] . $l[3][0];
				if (! preg_match('/rel=([\'"])alternate\\1/i', $attr) || ! preg_match('/href=([\'"])(.*?)\\1/is', $attr, $href)) {
					continue;
				}
				if (! preg_match('!^(https?:/)?/!', $href[2])) { // relarive URL
					$href[2] = $url . $href[2];
				}
				if (function_exists('sanitize_url')) {
					$mobile_url = sanitize_url($href[2]);
				} else {
					$mobile_url = $href[2];
				}
				if ($mobile_url) {
					fclose($fp);
					return $mobile_url;
				}
			}
			$offset = $links[count($links) -1][0][1] + strlen($links[count($links) -1][0][0]);
		}
		if (preg_match('!(</head>|<body[ >])!i', $contents)) {
			break;
		}
		$byte_count += strlen($line);
		if ( $byte_count > $timeout_bytes ) {
			// It's no use going further, there probably isn't any pingback
			// server to find in this file. (Prevents loading large files.)
			break;
		}
	}
	// We didn't find anything.
	fclose($fp);
	return false;
}

/* ==================================================
 * @param	resource $fp
 * @param	boolean  $is_chunked
 * @return	string   $line
 */
private function fgets($fp, $is_chunked) {
	$line = fgets($fp, 4096);
	if (! trim($line)) {
		return '';
	} elseif ($is_chunked && preg_match('/^[0-9a-fA-F]+$/', trim($line))) {
		$length = hexdec($line);
		if ($length <= 0) {
			return NULL;
		}
		for ($chunk = '' ; strlen($chunk) < $length ; $chunk .= $bytes) {
			if (feof($fp)) {
				break;
			}
			$bytes = fread($fp, $length - strlen($chunk));
			if (empty($bytes)) {
				break;
			}
		}
		$line = $chunk;
	}
	return $line;
}

// ==================================================
private function compare_host() {
	$pc     = parse_url($this->full_url);
	$mobile = parse_url($this->mobile_url);
	$this->same_host = ($pc['scheme'] === $mobile['scheme'] && $pc['host'] === $mobile['host'] && $pc['port'] === $mobile['port']);
	return $this->same_host;
}

// ==================================================
public function use_template($template) {
	require dirname(__FILE__) . '/tags.php';
	add_filter('raw_content/ktai_style.php', array($this->base->ktai, 'shrink_pre_encode'), 9);
	add_filter('encoding_converted/ktai_style.php', array($this->base->ktai, 'shrink_pre_split'), 5);
	add_filter('encoding_converted/ktai_style.php', array($this->base->ktai, 'replace_smiley'), 7);
	add_filter('encoding_converted/ktai_style.php', array($this->base->ktai, 'convert_pict'), 9);
	add_filter('encoding_converted/ktai_style.php', array($this->base->ktai, 'shrink_post_split'), 15);
	$buffer = $this->base->ktai->get('preamble');
	$buffer .= ($buffer ? "\n" : '');
	ob_start();
	include $template;
	$buffer .= ob_get_contents();
	ob_end_clean();
	$buffer = apply_filters('raw_content/ktai_style.php', $buffer);
	$buffer = $this->base->encode_for_ktai($buffer);
	$buffer = apply_filters('encoding_converted/ktai_style.php', $buffer);
	$mime_type    = $this->base->ktai->get('mime_type');
	$iana_charset = $this->base->ktai->get('iana_charset');
/*	if (is_null($this->full_url)) {
			header("HTTP/1.0 400 Bad Request");
	} */
	header ("Content-Type: $mime_type; charset=$iana_charset");
	echo $buffer;
}

// ==================================================
public function output() {
	$charset = $this->base->ktai->get('charset');
	$title = __('Confirm connecting to external sites', 'ktai_style');
	$html = '<p>';

	if (! $this->mobile_url) {
		$html .=  __('You are about to visit a website for PC:', 'ktai_style') 
		. '<br /><a href="' . attribute_escape($this->url) . '">' . htmlspecialchars($this->full_url, ENT_QUOTES) . '</a>';
	} else {
		if ($this->mobile_url === $this->full_url) {
			$html .= __('A mobile view is provided with the same URL at the visiting site:', 'ktai_style');
		} else {
			$html .= '<p>' . __('A mobile site found for the visiting site:', 'ktai_style');
		}
		$html .= '<br /><a href="' . attribute_escape($this->mobile_url) . '">' . htmlspecialchars($this->mobile_url, ENT_QUOTES) . '</a>';
		if (! $this->same_host) {
			$html .= '<br /><font color="red">' . __('The host is diffrent from the origial. Make sure the valid mobile site.', 'ktai_style') . '</font>';
		}
		if ($this->mobile_url != $this->full_url) {
			$html .= '</p><p>' . __('The original URL of the site:', 'ktai_style') 
			. '<br /><a href="' . attribute_escape($this->url) . '">' . htmlspecialchars($this->full_url, ENT_QUOTES) . '</a>';
		}
	}

	if ($this->base->is_ktai() == 'KDDI' && $this->base->get('type') == 'WAP2.0') {
		$html .= '<br />'. sprintf(__('(<a %s>View the site by PC Site Viewer.</a>)', 'ktai_style'), ' href="device:pcsiteviewer?url=' . attribute_escape($this->full_url) . '"');
	} elseif ($this->base->is_ktai() == 'DoCoMo' && $this->base->get('type') == 'FOMA') {
		$html .= '<br />'. sprintf(__('(<a %s>View the site by Full Browser.</a>)', 'ktai_style'), 'href="' . attribute_escape($this->url) . '" ifb="' . attribute_escape($this->full_url) . '"');
	}
	$html .= "</p>\n<p>" . __("If you are sure, follow above link. If not, go to the previous page with browser's back button.", 'ktai_style') . '</p>';
	$html .='<form action=""><div>' . __('To copy the URL, use below text field:', 'ktai_style') . '<br /><input type="text" name="url" size="80" maxlength="255" value="' . attribute_escape($this->full_url) . '" /></div></form>';
	$this->base->ks_die(apply_filters('redir/ktai_style.php', $html, $this->full_url, $this->mobile_url), $title, false);
}

// ==================================================
public function nonce_error() {
	$charset = $this->base->ktai->get('charset');
	$title = __('Error linking to external sites', 'ktai_style');
	$html = '<p>' . __("A certain time has elapsed since you viewed the page, the link to exteral sites has became invalid.<br />\nGo back the previous page and reload it. After that, retry clicking the link.", 'ktai_style') . '</p>';
//	header("HTTP/1.0 400 Bad Request");
	$this->base->ks_die(apply_filters('redir_error/ktai_style.php', $html), $title, false);
}

// ===== End of class ====================
}
?>