<?php
/* ==================================================
 *   Ktai Admin Edit Comments
 *   based on wp-admin/edit-comments.php of WP 2.7
   ================================================== */

define ('KS_HEADER_FOOTER_SIZE', 3000);
define ('KS_COMMENT_EXCERPT_SIZE', 200);
define ('KS_COMMENT_NAV_SIZE', 400);
require dirname(__FILE__) . '/admin.php';
$View = new KS_Admin_Edit_Comments($Ktai_Style, $KS_Admin);
exit();

/* ==================================================
 *   KS_Admin_Edit_Comments class
   ================================================== */

class KS_Admin_Edit_Comments {
	private $base;
	private $admin;
	private $post_id;

// ==================================================
public function __construct($base, $admin) {
	$this->base  = $base;
	$this->admin = $admin;

	$this->post_id = isset($_REQUEST['p']) ? intval($_REQUEST['p']) : 0;
	
	if ( ( isset( $_REQUEST['delete_all_spam'] ) || isset( $_REQUEST['delete_all_spam2'] ) ) && !empty( $_REQUEST['pagegen_timestamp'] ) ) {
		$this->delete_all_spam();
		exit;
	} elseif ( isset($_REQUEST['delete_comments']) && isset($_REQUEST['action']) && ( -1 != $_REQUEST['action'] || -1 != $_REQUEST['action2'] ) ) {
		$this->bulk_comments();
		exit;
	} elseif ( isset($_GET['_wp_http_referer']) && ! empty($_GET['_wp_http_referer']) ) {
		 $this->admin->redirect( remove_query_arg( array('_wp_http_referer', '_wpnonce'), stripslashes($_SERVER['REQUEST_URI']) ) );
		 exit;
	}
	$this->output();
}

// ==================================================
private function delete_all_spam() {
	global $wpdb;

	check_admin_referer('bulk-spamdelete', '_spam_nonce');
	$deleted_spam = $wpdb->query( $wpdb->prepare("DELETE FROM $wpdb->comments WHERE comment_approved = 'spam' AND %s > comment_date_gmt", $_REQUEST['pagegen_timestamp']) );
	$redirect_to = 'edit-comments.php?comment_status=spam&deleted=' . intval($deleted_spam);
	if ($this->post_id > 0) {
		$redirect_to = add_query_arg( 'p', $this->post_id, $redirect_to );
	}
	$this->admin->redirect($redirect_to);
}

// ==================================================
private function bulk_comments() {
	global $wpdb;

	check_admin_referer('bulk-comments');
	$doaction = ( -1 != $_REQUEST['action'] ) ? $_REQUEST['action'] : $_REQUEST['action2'];

	$deleted = $approved = $unapproved = $spammed = 0;
	foreach ( (array) $_REQUEST['delete_comments'] as $comment_id) : // Check the permissions on each
		$comment_id = (int) $comment_id;
		$_post_id = (int) $wpdb->get_var( $wpdb->prepare( "SELECT comment_post_ID FROM $wpdb->comments WHERE comment_ID = %d", $comment_id) );

		if ( !current_user_can('edit_post', $_post_id) ) {
			continue;
		}
		switch( $doaction ) {
			case 'markspam' :
				wp_set_comment_status($comment_id, 'spam');
				$spammed++;
				break;
			case 'delete' :
				wp_set_comment_status($comment_id, 'delete');
				$deleted++;
				break;
			case 'approve' :
				wp_set_comment_status($comment_id, 'approve');
				$approved++;
				break;
			case 'unapprove' :
				wp_set_comment_status($comment_id, 'hold');
				$unapproved++;
				break;
		}
	endforeach;

	$redirect_to = 'edit-comments.php?deleted=' . $deleted . '&approved=' . $approved . '&spam=' . $spammed . '&unapproved=' . $unapproved;
	if ( $this->post_id > 0 ) {
		$redirect_to = add_query_arg( 'p', $this->post_id, $redirect_to );
	}
	if ( isset($_REQUEST['apage']) ) {
		$redirect_to = add_query_arg( 'apage', absint($_REQUEST['apage']), $redirect_to );
	}
	if ( !empty($_REQUEST['mode']) ) {
		$redirect_to = add_query_arg('mode', $_REQUEST['mode'], $redirect_to);
	}
	if ( !empty($_REQUEST['comment_status']) ) {
		$redirect_to = add_query_arg('comment_status', 
	$_REQUEST['comment_status'], $redirect_to);
	}	
	if ( !empty($_REQUEST['s']) ) {
		$redirect_to = add_query_arg('s', $_REQUEST['s'], $redirect_to);
	}
	$this->admin->redirect($redirect_to);
}

// ==================================================
public function comments_stati($num_comments, $comment_status, $comment_type) {
	$stati = array(
			'all' => __('All', 'ktai_style'),
			'moderated' => __('Pending (%s)', 'ktai_style'),
			'approved' => __('Approved', 'ktai_style'),
			'spam' => __('Spam (%s)', 'ktai_style')
		);

	global $parent_file, $submenu, $submenu_file;
	$link = $submenu_file = 'edit-comments.php';
	if ( !empty($comment_type) && 'all' != $comment_type )
		$link = add_query_arg( 'comment_type', $comment_type, $link );
	foreach ( $stati as $status => $label ) {
		if ( !isset( $num_comments->$status ) ) {
			$num_comments->$status = 10;
		}
		if ( 'all' != $status ) {
			$link = add_query_arg( 'comment_status', $status, $link );
		}
		if ( $this->post_id )
			$link = add_query_arg( 'p', absint( $this->post_id ), $link );
		$submenu[$parent_file][] = array(sprintf($label, number_format_i18n( $num_comments->$status )), 'edit_posts', $link);
		if ( str_replace( 'all', '', $status ) == $comment_status )
			$submenu_file = $link;
	}
	return;
}

// ==================================================
public function get_post_title($id) {
	if ($id > 0) {
		$post = get_post($id, OBJECT, 'display');
		$post_title = wp_specialchars( $post->post_title, 'double' );
		$post_title = ('' == $post_title) ? "# $comment->comment_post_ID" : $post_title;
	} else {
		$post_title = NULL;
	}
	return $post_title;
}

// ==================================================
public function comment_list_item($c) {
	global $comment;
	$comment = $c;
	$comment_status = wp_get_comment_status($comment->comment_ID);
	if ('unapproved' == $comment_status ) {
		$gray_start = '<font color="gray">';
		$gray_end   = '</font>';
		$date_start = '';
		$link_color = 'gray';
	} else {
		$gray_start = '';
		$gray_end   = '';
		$date_start = '<font color="' . ks_option('ks_date_color') . '">';
		$link_color = 'olive';
	}
	echo $gray_start;
?>
<img localsrc="<?php comment_type(68, 112, 112); ?>" alt="[<?php comment_type(__('Comment', 'ktai_style'), __('Trackback'), __('Pingback')); ?>] " /><?php echo comment_author(); ?><img localsrc="46" alt=" @ " /><?php echo $date_start; ks_comment_datetime(); ?></font><br />
<?php 
	if ( strlen($author_url_display) > 50 )
		$author_url_display = substr($author_url_display, 0, 49) . '...';
	if ($comment->comment_author_url && 'http://' != $comment->comment_author_url) {
		$author_url_display = $comment->comment_author_url;
		$author_url_display = str_replace('http://www.', '', $author_url_display);
		$author_url_display = str_replace('http://', '', $author_url_display);
		if ( strlen($author_url_display) > 50 )
			$author_url_display = substr($author_url_display, 0, 49) . '...';
		?><img localsrc="112" alt="" /><font color="<?php echo $link_color; ?>"><?php echo wp_specialchars($author_url_display); ?></font><br /><?php 
	}
	if ($comment->comment_author_email && current_user_can('edit_post', $comment->comment_post_ID)) { 
		?><img localsrc="108" alt="" /><font color="<?php echo $link_color; ?>"><?php comment_author_email(); ?></font><br /><?php
	}
	echo $gray_start . mb_strcut(get_comment_excerpt(), 0, KS_COMMENT_EXCERPT_SIZE) . $gray_end . '<br />';
	if ( current_user_can('edit_post', $comment->comment_post_ID) ) {
		echo '[ ';
		if (current_user_can('moderate_comments')) {
			if ('approved' != $comment_status) {
				echo '<a href="' . $this->admin->add_sid('comment.php?action=approvecomment&p=' . $comment->comment_post_ID . '&c=' . $comment->comment_ID, 'approve-comment_' . $comment->comment_ID) . '"><font color="green">' . __('Approve') . '</font></a> | ';
			} elseif ('approved' == $_GET['comment_status'] && 'approved' == $comment_status) {
				echo '<a href="' . $this->admin->add_sid('comment.php?action=unapprovecomment&p=' . $comment->comment_post_ID . '&c=' . $comment->comment_ID, 'approve-comment_' . $comment->comment_ID) . '"><font color="#ff9900">' . __('Unapprove') . '</font></a> | ';
			}
		}
		echo '<a href="' . $this->admin->add_sid('comment.php?action=editcomment&c=' . $comment->comment_ID) . '">' .  __('Edit') . '</a>';
		echo ' ]';
	}
}

// ==================================================
public function output() {
	global $title, $parent_file;
	if ($this->post_id > 0) {
		$title = sprintf(__('Comments for %s', 'ktai_style'), wp_html_excerpt($this->get_post_title($this->post_id), 50));
	} else {
		$title = __('Edit Comments');
	}
	$parent_file = 'edit-comments.php';
	include dirname(__FILE__) . '/admin-header.php';
	
	$mode = ( ! isset($_GET['mode']) || empty($_GET['mode']) ) ? 'detail' : attribute_escape($_GET['mode']);
	$comment_status = !empty($_GET['comment_status']) ? attribute_escape($_GET['comment_status']) : '';
	$comment_type = !empty($_GET['comment_type']) ? attribute_escape($_GET['comment_type']) : '';
	$search_dirty = ( isset($_GET['s']) ) ? $_GET['s'] : '';
	$search = stripslashes($search_dirty);
	
	if ($search_dirty) {
		printf('<h2>' . __('Search results of %s', 'ktai_style') . '</h2>', attribute_escape($search));
	}
	
	if ( isset( $_GET['approved'] ) || isset( $_GET['deleted'] ) || isset( $_GET['spam'] ) ) {
		$approved = isset( $_GET['approved'] ) ? (int) $_GET['approved'] : 0;
		$deleted = isset( $_GET['deleted'] ) ? (int) $_GET['deleted'] : 0;
		$spam = isset( $_GET['spam'] ) ? (int) $_GET['spam'] : 0;
	
		if ( $approved > 0 || $deleted > 0 || $spam > 0 ) {
			echo '<p><font color="olive">';
	
			if ( $approved > 0 ) {
				printf( __ngettext( '%s comment approved', '%s comments approved', $approved ), $approved );
				echo '<br />';
			}
			if ( $deleted > 0 ) {
				printf( __ngettext( '%s comment deleted', '%s comments deleted', $deleted ), $deleted );
				echo '<br />';
			}
			if ( $spam > 0 ) {
				printf( __ngettext( '%s comment marked as spam', '%s comments marked as spam', $spam ), $spam );
				echo '<br />';
			}
			echo '</font></p>';
		}
	}
	
	$num_comments = ($this->post_id > 0) ? wp_count_comments($this->post_id) : wp_count_comments();
	$this->comments_stati($num_comments, $comment_status, $comment_type);
	?>
	<form id="comments-form" action="" method="get">
	<?php $this->admin->sid_field();?>
	<div><input type="text" name="ks" value="<?php echo attribute_escape($search); ?>" size="20" />
	<input type="submit" name="Submit" value="<?php _e('Search') ?>"  /></div>
	<?php 
	
	$comments_per_page = intval(($this->base->get('page_size') - KS_HEADER_FOOTER_SIZE) / (KS_COMMENT_EXCERPT_SIZE + KS_COMMENT_NAV_SIZE));
	$comments_per_page = apply_filters('comments_per_page', $comments_per_page, $comment_status);
	if ($comments_per_page < 1) {
		$comments_per_page = 1;
	} elseif ($comments_per_page > 20) {
		$comments_per_page = 20;
	}
	$page = isset($_GET['apage']) ? abs((int) $_GET['apage']) : 1;
	$start = $offset = ( $page - 1 ) * $comments_per_page;
	
	list($_comments, $total) = _wp_get_comment_list($comment_status, $search_dirty, $start, $comments_per_page + 5, $this->post_id, $comment_type); // Grab a few extra
	
	$_comment_post_ids = array();
	foreach ( $_comments as $_c ) {
		$_comment_post_ids[] = $_c->comment_post_ID;
	}
	$_comment_pending_count_temp = (array) get_pending_comments_num($_comment_post_ids);
	foreach ( (array) $_comment_post_ids as $_cpid ) {
		$_comment_pending_count[$_cpid] = isset( $_comment_pending_count_temp[$_cpid] ) ? $_comment_pending_count_temp[$_cpid] : 0;
	}
	if ( empty($_comment_pending_count) ) {
		$_comment_pending_count = array();
	}	
	$comments = array_slice($_comments, 0, $comments_per_page);
	$extra_comments = array_slice($_comments, $comments_per_page);
	
	?>
	<input type="hidden" name="mode" value="<?php echo $mode; ?>" />
	<?php if ( $this->post_id ) {
		echo '<input type="hidden" name="p" value="' . intval($this->post_id) . '" />';
	}
	if ( $comment_status ) {
		echo '<input type="hidden" name="comment_status" value="' . $comment_status . '" />' . "\n";
	} ?>
	<input type="hidden" name="pagegen_timestamp" value="<?php echo current_time('mysql', 1); ?>" />
	<div>
	<select name="comment_type">
	<option value="all"><?php _e('All comment types', 'ktai_style'); ?></option>
	<?php
		$comment_types = apply_filters( 'admin_comment_types_dropdown', array(
			'comment' => __('Comments'),
			'pings' => __('Pings', 'ktai_style'),
		) );
		foreach ( $comment_types as $type => $label ) {
			echo '<option value="' . attribute_escape($type) . '"';
			selected( $comment_type, $type );
			echo '>' . attribute_escape($label) . '</option>';
		}
	?>
	</select>
	<input type="submit" value="<?php _e('Filter'); ?>" />
	<?php if ( isset($_GET['apage']) ) { ?>
	<input type="hidden" name="apage" value="<?php echo absint( $_GET['apage'] ); ?>" />
	<?php }
	// do_action('manage_comments_nav', $comment_status);
	?>
	</div>
	<?php 
	if ($comments) {
		echo '<dl>';
		foreach ($comments as $c) {
			$checkbox = '';
			if (current_user_can('edit_post', $c->comment_post_ID)) {
				$checkbox = '<input type="checkbox" name="delete_comments[]" value="' . intval($c->comment_ID) . '" />';
			}
			echo '<dt>' . sprintf(_c('%1$s%2$5d:%3$s|comment-list-title', 'ktai_style'), $checkbox, $c->comment_ID, $this->get_post_title($c->comment_post_ID)) . '</dt><dd>';
			$this->comment_list_item($c);
			echo '</dd>';
		}
		echo '</dl>';
	?>
	<select name="action">
	<option value="-1" selected="selected"><?php _e('Bulk Actions', 'ktai_style') ?></option>
	<?php if ( empty($comment_status) || 'approved' == $comment_status ): ?>
	<option value="unapprove"><?php _e('Unapprove'); ?></option>
	<?php endif; ?>
	<?php if ( empty($comment_status) || 'moderated' == $comment_status || 'spam' == $comment_status ): ?>
	<option value="approve"><?php _e('Approve'); ?></option>
	<?php endif; ?>
	<?php if ( 'spam' != $comment_status ): ?>
	<option value="markspam"><?php _e('Mark as Spam'); ?></option>
	<?php endif; ?>
	<option value="delete"><?php _e('Delete'); ?></option>
	</select>
	<input type="submit" name="doaction" value="<?php _e('Apply'); ?>" />
	<?php wp_nonce_field('bulk-comments');
	if ( 'spam' == $comment_status ) {
		wp_nonce_field('bulk-spam-delete', '_spam_nonce'); ?>
	<input type="submit" name="delete_all_spam" value="<?php _e('Delete All Spam'); ?>" />
	<?php }
	} elseif ( 'moderated' == $_GET['comment_status'] ) { ?>
	<p><?php _e('No comments awaiting moderation&hellip; yet.'); ?></p>
	<?php } else {
	?><p><?php
		_e('No results found.');
	?></p><?php
	} ?>
	</form>
	<?php 
	$page_links = paginate_links( array(
		'base' => add_query_arg('apage', '%#%'), 
		'format' => '',
		'total' => ceil($total / $comments_per_page),
		'current' => $page,
		'prev_text' => __('<img localsrc="7" alt="&laquo;" />Previous Page', 'ktai_style'),
		'next_text' => __('Next Page<img localsrc="8" alt="&raquo;" />', 'ktai_style'),
	));
	if ($page_links) {
		$page_links = $this->base->filter_tags($page_links);
		$page_links = str_replace("\n", ' ', $page_links);
		$page_links = str_replace(ks_admin_url(false), '', $page_links);
		echo "<br /><div>$page_links</div>";
	}
	include dirname(__FILE__) . '/admin-footer.php';
}

// ===== End of class ====================
}
?>