<?php
/*
Plugin Name: WP-AutoPager
Version: 0.5.1
Plugin URI: http://wppluginsj.sourceforge.jp/wp-autopager/
Description: Add autoloading for next page to Wordpress. DblClick to enable/disable it.
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2007-2008 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Based:
 This script based on
 GoogleAutoPager(http://la.ma.la/blog/diary_200506231749.htm)
 thanks to ma.la.

Includes:
 jQuery 1.2.6 - New Wave Javascript
  Copyright (c) 2008 John Resig (jquery.com)
  Dual licensed under the MIT and GPL licenses.
*/

if (!class_exists('wokController') || !class_exists('wokScriptManager'))
	require(dirname(__FILE__).'/includes/common-controller.php');

class AutoPagerController extends wokController {
	var $plugin_name   = 'wp-autopager';

	var $autopager_js  = 'js/wp-autopager-0.5.1.min.js';
	var $autopager_ver = '0.5.1';

	var $_wpLightpop_enable = false;

	/*
	* Constructor
	*/
	function AutoPagerController() {
		$this->__construct();
	}
	function __construct() {
		$this->init(__FILE__);
		$this->options = $this->_initOptions($this->getOptions());

		// wp-lightpop active?
		$this->_wpLightpop_enable = $this->isActive('wp-lightpop.php');
	}

	/*
	* Init Options
	*/
	function _initOptions($wk_options) {
		if (!is_array($wk_options)) $wk_options = array();

		if (!isset($wk_options['content_id']))       $wk_options['content_id'] = "content";
		if (!isset($wk_options['post_class']))       $wk_options['post_class'] = "post";
		if (!isset($wk_options['navigation_class'])) $wk_options['navigation_class'] = "navigation";
		if (!isset($wk_options['remain']))           $wk_options['remain'] = 500;
		if (!isset($wk_options['default_enable']))   $wk_options['default_enable'] = 1;

		return ($wk_options);
	}

	function _isLoadScripts() {
		return (!is_admin() && !is_404() && !is_single() && !is_page());
	}

	/*
	* add action (wp_print_scripts)
	*/
	function addScripts() {
		if ($this->_isLoadScripts() && have_posts()) {
			$this->addjQuery();	// regist jQuery
			wp_enqueue_script('wp-autopager', $this->plugin_url.$this->autopager_js, array('jquery'), $this->autopager_ver);
		}
	}

	/*
	* add action (wp_head)
	*/
	function addWpHead() {
		if ($this->_isLoadScripts() && !have_posts())
			header("HTTP/1.1 404 Not Found");
	}

	/*
	* add action (wp_footer)
	*/
	function addWpFooter() {
		global $request, $posts_per_page, $wpdb, $paged, $script_manager;

		if ($this->_isLoadScripts() && have_posts()){
			// get Max Page
			$numposts = 0;
			if(strpos(get_query_var('tag'), " ")) {
				preg_match('#^(.*)\sLIMIT#siU', $request, $matches);
				$fromwhere = $matches[1];
				$results = $wpdb->get_results($fromwhere);
				$numposts = count($results);
			} else {
				preg_match('#FROM\s*+(.+?)\s+(GROUP BY|ORDER BY)#si', $request, $matches);
				$fromwhere = $matches[1];
				$numposts = $wpdb->get_var("SELECT COUNT(DISTINCT ID) FROM $fromwhere");
			}
			$max_page = ceil($numposts/$posts_per_page);

			// get Next Page No.
			if(empty($paged))
				$paged = 1;
			$next_page = $paged + 1;

			// get Query String
			$query = get_pagenum_link($next_page);
			if (strstr($query,"?") != false) {
				if (preg_match("/^(.*\/)page\/(\d+)\/(.*)$/i", $query, $matches)) {
					$query = $matches[1].$matches[3]."&paged=";
					$next_page = $matches[2];
				} elseif (preg_match("/(.*paged=)(\d+)/i", $query, $matches)) {
					$query = $matches[1];
					$next_page = $matches[2];
				}
			} elseif (preg_match("/(.+page\/)(\d+)/i", $query, $matches)) {
				$query = $matches[1];
				$next_page = $matches[2];
			} else {
				if (preg_match("/(.+paged=)(\d+)/i", $query, $matches)) {
					$query = $matches[1];
					$next_page = $matches[2];
				} else {
					if (strstr($query,"?"))
						$query = $query."&paged=";
				}
			}
			$query = str_replace('http://'.$_SERVER['SERVER_NAME'].'/', '/', $query);

			// lightpop callback
			$callback  = 'function(){';
			$callback .= ($this->_wpLightpop_enable ? "if(typeof lightpop!='undefined') lightpop.start();" : '');
			$callback .= '}';

			// settings
			$settings  = "{";
			$settings .= "enable:".($this->options['default_enable']==1?'true':'false');
			$settings .= ",remain:".(int) $this->options['remain'];
			$settings .= ",contentId:'{$this->options['content_id']}'";
			$settings .= ",postClass:'{$this->options['post_class']}'";
			$settings .= ",naviClass:'{$this->options['navigation_class']}'";
			$settings .= ",loadingSrc:'{$this->plugin_url}images/ajax-loader.gif'";
			$settings .= ",loadingTxt:'".__('Now Loading...', $this->textdomain_name)."'";
			if ($callback != '') {$settings .= ",callback:".$callback;}
			$settings .= "}";

			// echo javascript
			$start_autopager = "autopager('%s', %d, %d, %s);";
			$out = "jQuery(function(){".sprintf($start_autopager, $query, $next_page, $max_page, $settings)."});\n";
			if ($out != '')  $this->writeScript($out, 'footer');
		}
	}

	/*
	* add action (admin_menu)
	*/
	function addAdminMenu() {
		$this->addOptionPage(__('AutoPager', $this->textdomain_name), array($this,'optionPage'));
	}

	function pluginActionLinks($links, $file) {
		$this_plugin = plugin_basename(__FILE__);
		if ($file == $this_plugin) {
			$settings_link = '<a href="options-general.php?page=' . $this->plugin_file . '">' . __('Settings') . '</a>';
			array_unshift($links, $settings_link); // before other links
		}
		return $links;
	}

	function optionPage() {
		// options update
		if(isset($_POST['ap_options_update'])) {
			// check referer
			if ($this->wp25) check_admin_referer("update_options", "_wpnonce_update_options");

			// strip slashes array
			$_POST = $this->stripArray($_POST);

			// get options
			$this->options['content_id']       = $_POST['ap_content_id'];
			$this->options['post_class']       = $_POST['ap_post_class'];
			$this->options['navigation_class'] = $_POST['ap_navigation_class'];
			$this->options['remain']           = (int) $_POST['ap_remain'];
			$this->options['default_enable']   = $_POST['ap_default_enable'] == 1;
			$_POST = '';

			// Done!
			$this->updateOptions();
			$this->note .= __('<strong>Done!</strong>', $this->textdomain_name);

		} elseif(isset($_POST['ap_options_uninstall'])) {
			// check referer
			if ($this->wp25) check_admin_referer("delete_options", "_wpnonce_delete_options");

			// uninstall
			$this->deleteOptions();
			$this->note .= __('<strong>Done!</strong>', $this->textdomain_name);
			$this->error++;
			$this->options = $this->_initOptions(array());
		}

		// Add Options
		$out .= '<div class="wrap">'."\n";
		$out .= '<h2>'.__('WP-AutoPager Options', $this->textdomain_name).'</h2><br />'."\n";
		$out .= '<form method="post" id="update_options" action="'.$this->admin_action.'">'."\n";
		if ($this->wp25)
			$out .= $this->makeNonceField("update_options", "_wpnonce_update_options", true, false);

		$out .= '<table>'."\n";

		// Content ID
		$out .= '<tr><td><strong>'.__('Content ID', $this->textdomain_name).'</strong></td>';
		$out .= '<td><input type="text" name="ap_content_id" value="'.$this->options['content_id'].'"/></td>';
		$out .= '<td></td></tr>'."\n";

		// Posts Class
		$out .= '<tr><td><strong>'.__('Posts Class', $this->textdomain_name).'</strong></td>';
		$out .= '<td><input type="text" name="ap_post_class" value="'.$this->options['post_class'].'"/></td>';
		$out .= '<td></td></tr>'."\n";

		// Navigation Class
		$out .= '<tr><td><strong>'.__('Navigation Class', $this->textdomain_name).'</strong></td>';
		$out .= '<td><input type="text" name="ap_navigation_class" value="'.$this->options['navigation_class'].'"/></td>';
		$out .= '<td></td></tr>'."\n";

		// Remain
		$out .= '<tr><td><strong>'.__('Remain', $this->textdomain_name).'</strong></td>';
		$out .= '<td><input type="text" name="ap_remain" value="'.$this->options['remain'].'" /></td>';
		$out .= '<td>'.__('Position in which lookahead is begun(relative value px from the bottom of a browser)', $this->textdomain_name).'</td></tr>'."\n";

		// Default Enable / Desable
		$out .= '<tr><td><strong>'.__('Default Enable', $this->textdomain_name).'</strong></td>';
		$out .= '<td><select name="ap_default_enable">';
		$out .= '<option value="0"'.($this->options['default_enable']==0?' selected="selected"':'').'>'.__('disable', $this->textdomain_name).'</option>';
		$out .= '<option value="1"'.($this->options['default_enable']==1?' selected="selected"':'').'>'.__('enable', $this->textdomain_name).'</option>';
		$out .= '</select></td>';
		$out .= '<td>'.__('Whether operation is enabled when the page is displayed is set.', $this->textdomain_name).'</td></tr>'."\n";

		$out .= '</table>'."\n";

		// Add Update Button
		$out .= '<input type="submit" name="ap_options_update" class=\"button-primary\" value="'.__('Update Options', $this->textdomain_name).' &raquo;" class="button" />';
		$out .= '</form></div>'."\n";

		// Add Usage
		$out .= '<div class="wrap" style="margin-top:3em;">'."\n";
		$out .= '<h2>'.__('Usage', $this->textdomain_name).'</h2><br />'."\n";
		$out .= '<p>'.__('If it is a default template base, it operates yet in there is no template correction.', $this->textdomain_name).'<br />'."\n";
		$out .= __('If the structure of HTML is as follows, it is OK.', $this->textdomain_name).'</p>'."\n";

		$out .= '<div style="border:1px solid gray;background-color:#F9F7ED;width:auto;_width:95%;margin:0.25em;padding:0.25em;">'."\n";
		$out .= '&lt;html&gt;<br />'."\n";
		$out .= '&lt;head&gt;</p>'."\n";
		$out .= '<div style="padding-left:3em;">：</div>'."\n";
		$out .= '<p>&lt;/head&gt;<br />'."\n";
		$out .= '&lt;body&gt;</p>'."\n";
		$out .= '<div style="padding-left:3em;">：</div>'."\n";
		$out .= '<div style="border:1px solid gray;background-color:#F9F7DD;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>id=&#8221;content&#8221;</strong></em>&gt;</p>'."\n";
		$out .= '<div style="padding-left:3em;">：</div>'."\n";

		$out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";
		$out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";

		$out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";
		$out .= '<div style="padding-left:3em;">：</div>'."\n";
		$out .= '<div style="border:1px solid gray;background-color:#F9F7BB;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;navigation&#8221;</strong></em>&gt;&#8230;'.__('Page navigation', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";

		$out .= '<p>&lt;/div&gt;</div>'."\n";
		$out .= '<div style="padding-left:3em;">：</div>'."\n";
		$out .= '<p>&lt;/body&gt;<br />'."\n";
		$out .= '&lt;/html&gt;'."\n";
		$out .= '</div>'."\n";

		$out .= '</div>'."\n";

		// Add Options
		$out .= "<div class=\"wrap\" style=\"margin-top:3em;\">\n";
		$out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
		$out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
		if ($this->wp25)
			$out .= $this->makeNonceField("delete_options", "_wpnonce_delete_options", true, false);

		// Delete Button
		$out .= "<input type=\"submit\" name=\"ap_options_uninstall\" class=\"button-primary\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
		$out .= "</form></div>\n";

		// Note snuff
		if(!empty($this->note))
			$this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";

		// If any error, dont display body
		if($this->error>0)
			$out = '';

		// Output
		echo $this->note."\n";
		echo $out."\n";
	}

}//class

$wpAutoPager = new AutoPagerController();

if (is_admin()) {
	add_action('admin_menu', array(&$wpAutoPager,'addAdminMenu'));
	add_filter('plugin_action_links', array(&$wpAutoPager, 'pluginActionLinks'), 10, 2 );
} else {
	add_action('wp_print_scripts', array(&$wpAutoPager,'addScripts'));
	add_action('wp_head', array(&$wpAutoPager,'addWpHead'));
	add_action('wp_footer', array(&$wpAutoPager,'addWpFooter'));
}

unset($wpAutoPager);
?>