// wp-autopager-0.5.1.js
//  Released under the GPL license
//   http://www.gnu.org/copyleft/gpl.html

//  this script based on
//   GoogleAutoPager(http://la.ma.la/blog/diary_200506231749.htm)
//   thanks to ma.la.

var autopager = function(query, next_page, max_page, settings){
  settings = jQuery.extend({
     enable     : true
   , remain     : 500
   , contentId  : 'content'
   , postClass  : 'post'
   , naviClass  : 'navigation'
   , loadingSrc : '/wp-content/plugins/wp-autopager/images/ajax-loader.gif'
   , loadingTxt : 'Now Loading...'
   , callback   : function(){}
  }, settings);

  var loading_html = '<img src="' + settings.loadingSrc + '" alt="' + settings.loadingTxt + '" style="float:left;margin:0 1em;" />'
                   + '<p style="float:left;">' + settings.loadingTxt + '</p>';
  var last_page = (next_page > max_page);

  var loading = false;

  var getPageScrollY = function(){
    var w = window, d = document;
    var e = d.documentElement, b = d.body;
    var yScroll = (w.pageYOffset ? w.pageYOffset : (e && e.scrollTop ? e.scrollTop : (b ? b.scrollTop : 0)));
    return yScroll;
  }

  var getPageHeight = function(){
    var w = window, d = document;
    var e = d.documentElement, b = d.body;
    var yScroll = (w.innerHeight && w.scrollMaxY ? w.innerHeight + w.scrollMaxY : (b.scrollHeight > b.offsetHeight ? b.scrollHeight : b.offsetHeight));
    var windowHeight = (w.innerHeight ? w.innerHeight : (e && e.clientHeight ? e.clientHeight : (b ? b.clientHeight : 0)));
    // for small pages with total height less then height of the viewport
    return ((yScroll < windowHeight) ? windowHeight : yScroll) - windowHeight;
  }

  var watch_scroll = function(){
    if(loading || last_page || !settings.enable){return;}
    if(getPageHeight() - getPageScrollY() < settings.remain){do_request();}
    var self = arguments.callee;
    setTimeout(self, 100);
  };

  // find navigation
  var find_navi = function() {
    var content = jQuery('#' + settings.contentId);
    var navi = jQuery('div.' + settings.naviClass + ':last', content);
    if(navi.length < 0) {
      navi = jQuery('<div class="' + settings.naviClass + '"></div>');
      content.append(navi);
    }
    return navi;
  }

  // get next page and insert
  var do_request = function(){
    if(loading || last_page || !settings.enable){return;}
    loading = true;

    // Next Page URL
    var url = query+next_page;
    if(url.indexOf('/page/')!=-1) {url = url + '/';}
    url = url.replace('&amp;','&');

    // Get Next Page...
    jQuery.get(url, function(responseText, status){
      var navi = find_navi();
      var insertPoint = navi.parent();
      navi.remove();
      if(status === 'success') {
        var newPage_html = jQuery.trim(responseText.replace(/[\r\n]/g,'').replace(/.*<body.*?>(.*?)<\/body>.*$/, '$1').replace(/<script.*?>.*<\/script>/g, ''));
        var contents = jQuery('div.' + settings.postClass + ', div.' + settings.naviClass, jQuery('#' + settings.contentId, jQuery(newPage_html)));
        insertPoint.append(contents);
        if(typeof settings.callback === 'function'){
          settings.callback(contents);
        }
        next_page ++;
      } else {
        last_page = true;
      }
      if (max_page != 0 && next_page > max_page) {last_page = true;}
      if (last_page) {settings.enable = false;}
      loading = false;
      //if(typeof lightpop!='undefined') lightpop.start();
    });
  };

  // init
  var init_autopager = function(){
    loading = false;
    if(last_page){settings.enable = false;}

    jQuery(document)
    .dblclick(function(){
      // Attach Event (Double Click)
      settings.enable = settings.enable?false:true;
      if (settings.enable) {watch_scroll();}
    })
    .ajaxStart(function(){
      // Ajax Start ... Display Now Loading
      loading = true;
      find_navi().html(loading_html);
    })
    .ajaxStop(function(){
      // Ajax Stop ... Start Watch Scroll
      if (next_page >= max_page) {
        last_page = true;
        settings.enable = false;
        find_navi().remove();
      }
      if (settings.enable) {watch_scroll();}
      loading = false;
    });

    // Start watch scroll
    if (settings.enable) {watch_scroll();}
  };
  init_autopager();
};
