<?php
/*
Plugin Name:  WordPress Related Post from Referer
Version: 1.0.1
Plugin URI: http://wppluginsj.sourceforge.jp/wp-jrelated-fr/
Description: 検索エンジン経由で来訪した人に対して、<a href="http://wppluginsj.sourceforge.jp/wp-jrelated/" title="WordPress Plugins/JSeries » WordPress Related Post for Japanese">WordPress Related Post for Japanese</a>の作成する形態素解析情報を利用して関連記事を表示します。
Author: wokamoto
Author URI: http://dogmap.jp/
*/
class RelatedPostFromRefererController {
  var $yahooId, $relatedHeader;

  /*
  * Constructor
  */
  function RelatedPostFromRefererController() {
    $option = get_option('WpJRelated');
    $this->yahooId = stripslashes($option->yahooId);
    $this->relatedHeader = stripslashes($option->relatedHeader);
  }

  function getKeyword($linkurl) {
    $str = '';
    $charset = get_option('blog_charset');
    if (strpos($linkurl,".google.")) {
      $str = preg_replace("/^.*[\?&]q=([^&]+)&.*$/i","$1",$linkurl);
      $str = urldecode($str);
      $str = mb_convert_encoding($str, $charset, "UTF-8");
    } elseif (strpos($linkurl,".goo.")) {
      $str = preg_replace("/^.*[\?&]MT=([^&]+)&.*$/i","$1",$linkurl);
      $str = urldecode($str);
      $str = mb_convert_encoding($str, $charset, "EUC-JP");
    } elseif (strpos($linkurl,".yahoo.")) {
      $str = preg_replace("/^.*[\?&]p=([^&]+)&.*$/i","$1",$linkurl);
      $str = urldecode($str);
      $str = mb_convert_encoding($str, $charset, "UTF-8");
    } elseif (strpos($linkurl,".msn.")) {
      $str = preg_replace("/^.*[\?&]q=([^&]+)&.*$/i","$1",$linkurl);
      $str = urldecode($str);
      $str = mb_convert_encoding($str, $charset, "UTF-8");
    }
    $key = strip_tags(mb_convert_kana($str,"s"));
    return $key;
  }

  function getRelatedHeader() {
    return $this->relatedHeader;
  }

  function getRelatedPost($keyword = "") {
    global $wpdb, $post;

    if ($keyword == "") $keyword = $this->getKeyword($linkurl);
    $keywords = explode(' ', $keyword);
    if(count($keywords) == 0) return false;

    //キーワードのハッシュを取得する。
    $hashes = array();
    foreach($keywords as $keyword) {
      $hashes[] = md5($keyword);
      if ($keyword != strtolower($keyword)) $hashes[] = md5(strtolower($keyword));
      if ($keyword != strtoupper($keyword)) $hashes[] = md5(strtoupper($keyword));
      if ($keyword != ucfirst($keyword))    $hashes[] = md5(ucfirst($keyword));
    }

    //キーワードがなかったらなにもしない
    if(count($hashes) == 0) return false;

    //がんばってSQLつくる
    $sql_select = '';
    $sql_where = '';
    foreach($hashes as $hash) {
      $sql_select .= $wpdb->prepare(
                       "IF(INSTR(mo.uniq_delimitar_hash, '%s') <> 0,INSTR(mo.uniq_delimitar_hash, '%s'), 10000) +"
                      ,$hash
                      ,$hash
                     );
      $sql_where .= $wpdb->prepare(
                      "mo.uniq_delimitar_hash LIKE '%s' or "
                     ,'%' . $hash . '%'
                    );
    }
    $sql_select = substr($sql_select , 0, strlen($sql_select) - 1) . "\n";
    $sql_where = substr($sql_where , 0, strlen($sql_where) - 3) . "\n";
    $appId = $wpdb->prepare("mo.appid = '%s'", $this->yahooId);
    $query =
        "SELECT" .
        "    mo.ID" .
        "    ,$sql_select as rank" .
        "  FROM" .
        "    {$wpdb->prefix}morpheme as mo" .
        "    ,{$wpdb->prefix}posts as po" .
        "  WHERE" .
        "    ($sql_where) " .
        (is_single() ? "    AND mo.ID <> " . $post->ID : "") .
        "    AND $appId " .
        "    AND po.post_status = 'publish'" .
        "    AND po.post_password = ''" .
        "    AND po.post_type = 'post'" .
        "    AND mo.ID = po.ID" .
        "  ORDER BY" .
        "        rank" .
        "  LIMIT 0, 5";
		
    //クエリーなげて関連投稿リンクの文字列作成
    $content = '<ul id="wpjrelated_fr">' . "\n";
    $entries = $wpdb->get_results($query);
    if(count($entries) == 0) return false;
    foreach($entries as $entry) {
      $title = get_the_title($entry->ID);
      $link = get_permalink($entry->ID);
      $content .= "<li><a href=\"{$link}\">{$title}</a></li>\n";
    }
    $content .= '</ul>' . "\n";
		
    return $content;
  }
}

function jrelated_referer($header = "", $pre = "", $post = "") {
  $rpfr = new RelatedPostFromRefererController();
  $link_url = stripslashes($_SERVER["HTTP_REFERER"]);
  $keyword = $rpfr->getKeyword($link_url);
  if ($keyword !== false) {
    $related = $rpfr->getRelatedPost($keyword);
    if ($related !== false) {
      if ($header == "") $header  = $rpfr->getRelatedHeader();
      $charset = get_option('blog_charset');
      echo $header;
      echo $pre;
      printf('<p><a href="http://%1$s/">%1$s</a> で<strong>「%2$s」</strong>をお探しですか？<br />' .
             'この記事以外にも<strong>「%2$s」</strong>に関連する記事がありますので合わせてご覧ください。</p>'
            , preg_replace('/^https?:\/\/([^\/]*)\/.*$/i', '$1', $link_url)
            , htmlspecialchars( $keyword, ENT_QUOTES, $charset ));
      echo $related;
      echo $post;
    }
  }
  unset($rpfr);
}
?>