if (typeof google.maps == 'undefined') google.load('maps', '2', {'language' : (typeof googlemapsAnywhereL10n != 'undefined' ? googlemapsAnywhereL10n.language : 'en')});
if (typeof jQuery == 'undefined') google.load('jquery', '1.2');

google.setOnLoadCallback(function(){
  var gma_opt = jQuery.extend({
    markerTitle:'Move to the Google map.'
   ,cssPath:'div.map'
   ,language:'en'
   }, googlemapsAnywhereL10n);

  var markeropt = {title:gma_opt.markerTitle};

  jQuery(gma_opt.cssPath).each( function(){
    var map_link = jQuery(this).children('a:first');
    var map_url = map_link.attr('href');

    var zoom = Number(map_url.replace(/^.*(\?|\&|\&amp;)z=([\d]+)[\&]?.*$/i,'$2'));
    zoom = ((zoom == NaN ? 0 : zoom) > 0 ? zoom : 14);

    var map_type;
    switch (map_url.replace(/^.*(\?|\&|\&amp;)t=([^\&]+)[\&]?.*$/i,'$2').toUpperCase()) {
     case 'NORMAL':
     case 'G_NORMAL_MAP':
      map_type = G_NORMAL_MAP;
      break;
     case 'SATELLITE':
     case 'G_SATELLITE_MAP':
      map_type = G_SATELLITE_MAP;
      break;
     case 'HYBRID':
     case 'G_HYBRID_MAP':
      map_type = G_HYBRID_MAP;
      break;
     case 'PHYSICAL':
     case 'G_PHYSICAL_MAP':
      map_type = G_PHYSICAL_MAP;
      break;
     default:
      map_type = G_NORMAL_MAP;
      break;
    };

    var latlng = map_url.replace(/^.*(\?|\&|\&amp;)q=([^\&]+)[\&]?.*$/i,'$2').split(",");
    if (latlng.length >= 2) {
      var point = new google.maps.LatLng(Number(latlng[0]), Number(latlng[1]));
      if (point) {
        map_url = 'http://maps.google.co.jp/maps?hl=' + gma_opt.language + '&q=' + point.toUrlValue() + '&z=' + zoom;

        var map = new google.maps.Map2(this);
        map.addControl(new google.maps.SmallZoomControl());
        map.setCenter(point, zoom, map_type);

        var marker = new google.maps.Marker(map.getCenter(), markeropt);
        map.addOverlay(marker);
        google.maps.Event.addListener(marker, 'click', function(){location.href = map_url;});
      }
    }
  });
});
