<?php
/*
Plugin Name: Quick Comments
Version: 0.4.1
Plugin URI: http://wppluginsj.sourceforge.jp/quick-comments/
Description: Post comments quickly without leaving or refreshing the page.
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

Includes:
 jQuery 1.2.6 - New Wave Javascript
  Copyright (c) 2008 John Resig (jquery.com)
  Dual licensed under the MIT and GPL licenses.

 jQuery blockUI plugin (http://malsup.com/jquery/block/)
  Version 2.08 (06/11/2008)
  Copyright (c) 2007-2008 M. Alsup
  Dual licensed under the MIT and GPL licenses:
*/

class QuickCommentsController {
  var $plugin_name  = 'quick-comments';
  var $plugin_ver   = '0.4.1';
  var $plugin_js    = 'js/quick-comments-0.4.1.min.js';

  var $jquery_js    = 'js/jquery-1.2.6.min.js';
  var $jquery_ver   = '1.2.6';

  var $blockUI_js   = 'js/jquery.blockUI.min.js';
  var $blockUI_ver  = '2.08';

  var $plugin_directory, $plugin_filename;
  var $admin_option, $admin_action;
  var $options_default, $options;
  var $option_name, $textdomain_name;
  var $effects, $effectSpeeds;
  var $note, $error;

  /*
  * Constructor
  */
  function QuickCommentsController() {
    $filename = explode("/", __FILE__);
    if(count($filename) <= 1) $filename = explode("\\", __FILE__);
    $this->plugin_directory = $filename[count($filename) - 2];
    $this->plugin_filename  = $filename[count($filename) - 1];

    $this->note = '';
    $this->error = 0;

    $this->admin_option    = $this->plugin_filename;
    $this->admin_action    = get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option;

    $this->textdomain_name = $this->plugin_name;
    load_plugin_textdomain($this->textdomain_name, 'wp-content/plugins/'.$this->plugin_directory.'/language');

    $this->effects         = array(
                              "0" => __('Default', $this->textdomain_name)
                             ,"1" => __('Slide Down', $this->textdomain_name)
                             );
    $this->effectSpeeds    = array(
                              "fast"   => __('fast', $this->textdomain_name)
                             ,"normal" => __('normal', $this->textdomain_name)
                             ,"slow"   => __('slow', $this->textdomain_name)
                             );

    $this->option_name     = $this->plugin_name." Options";
    $this->options         = $this->getOptions();
  }

  function getAbsoluteUrl() {
    return get_option('siteurl')."/wp-content/plugins/".$this->plugin_directory;
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function initOptions($wk_options = '') {
    $this->options_default = array(
      'form'    => 'form#commentform'
     ,'list'    => 'ol.commentlist:first'
     ,'message' => __('Please wait', $this->textdomain_name).'...'
     ,'loader'  => $this->getAbsoluteUrl().'/images/ajax-loader.gif'
     ,'messageCSS' => "border:1px solid #8C8C8C; font:normal 12px Arial;"
     ,'overlayCSS' => "backgroundColor:#FFF; opacity:0.6;"
     ,'effect' => 0
     ,'speed' => "fast"
     );
    $template = get_settings('template');
    if ( preg_match('/^default/i', $template) ) {
     $this->options_default['form'] = 'form#commentform';
     $this->options_default['list'] = 'ol.commentlist:first';
    } elseif ( preg_match('/^(classic|easyall|k2)/i', $template) ) {
     $this->options_default['form'] = 'form#commentform';
     $this->options_default['list'] = 'ol#commentlist';
    } elseif ( preg_match('/^wp.vicuna/i', $template) ) {
     $this->options_default['form'] = 'form#commentsForm';
     $this->options_default['list'] = 'dl.log:first';
    }

    if (!is_array($wk_options)) $wk_options = array();
    if (!isset($wk_options['form']))       $wk_options['form']       = $this->options_default['form'];
    if (!isset($wk_options['list']))       $wk_options['list']       = $this->options_default['list'];
    if (!isset($wk_options['message']))    $wk_options['message']    = $this->options_default['message'];
    if (!isset($wk_options['loader']))     $wk_options['loader']     = $this->options_default['loader'];
    if (!isset($wk_options['messageCSS'])) $wk_options['messageCSS'] = $this->options_default['messageCSS'];
    if (!isset($wk_options['overlayCSS'])) $wk_options['overlayCSS'] = $this->options_default['overlayCSS'];
    if (!isset($wk_options['effect']))     $wk_options['effect']     = $this->options_default['effect'];
    if (!isset($wk_options['speed']))      $wk_options['speed']      = $this->options_default['speed'];
    return $wk_options;
  }

  function getOptions(){
    return $this->initOptions(get_option($this->option_name));
  }

  function updateOptions() {
    update_option($this->option_name, $this->options);
  }

  function deleteOptions() {
    delete_option($this->option_name);
  }

  // regist script
  function re_regist_script( $handle, $src = '', $deps = false, $ver = false ) {
    global $wp_scripts;
    if ( !is_a($wp_scripts, 'WP_Scripts') ) $wp_scripts = new WP_Scripts();
    if ( isset($wp_scripts->scripts[$handle]) ) {
      if ( version_compare($wp_scripts->scripts[$handle]->ver, $ver, "<") ) {
        if ($src  != '')     $wp_scripts->scripts[$handle]->src  = $src;
        if (is_array($deps)) $wp_scripts->scripts[$handle]->deps = $deps;
        if ($ver  != false)  $wp_scripts->scripts[$handle]->ver  = $ver;
      }
    } else {
      if (!is_array($deps)) $deps = array();
      $wp_scripts->add( $handle, $src, $deps, $ver );
    }
  }

  // regist script
  function addScripts() {
    global $wp_scripts;
    if (is_single()) {
      // regist jQuery
      wp_enqueue_script('jquery');
      if ( version_compare($wp_scripts->scripts['jquery']->ver, '1.2.3', "<") ) {
        $this->re_regist_script('jquery', $this->getAbsoluteUrl().'/'.$this->jquery_js, false, $this->jquery_ver);
      }
      wp_enqueue_script('jquery.blockUI', $this->getAbsoluteUrl().'/'.$this->blockUI_js, array('jquery'), $this->blockUI_ver);
    }
  }

  // for WordPress 2.0.x
  function addHeadScripts() {
    if (is_single()) {
      $out  = "<script type=\"text/javascript\" src=\"".$this->getAbsoluteUrl().'/'.$this->jquery_js."\"></script>\n";
      $out .= "<script type=\"text/javascript\" src=\"".$this->getAbsoluteUrl().'/'.$this->blockUI_js."\"></script>\n";
      echo $out;
    }
  }

  function addHead() {
    global $user_ID;
    if (is_single()) {
      $out  = "<script type=\"text/javascript\">/*<![CDATA[ */\n";
      $out .= "var quickCommentsL10n = {";
      $out .= " form:\"{$this->options['form']}\"";
      $out .= ",list:\"{$this->options['list']}\"";
      $out .= ",message:\"{$this->options['message']}\"";
      $out .= ",loader:\"{$this->options['loader']}\"";
      if ( get_settings('require_name_email') && !$user_ID ) {
       $out .= ",requireNameEmail:true";
       $out .= ",errMsgNameEmail:\"".__('Error: please fill the required fields (name, email).')."\"";
      }
      $out .= ",errMsgEmail:\"".__('Error: please enter a valid email address.')."\"";
      $out .= ",errMsgCommentNone:\"".__('Error: please type a comment.')."\"";

      if ($this->options['messageCSS'] != $this->options_default['messageCSS']) {
       $messageCSS = preg_split('/[,;]/', $this->options['messageCSS'], -1, PREG_SPLIT_NO_EMPTY);
       if (is_array($messageCSS) && count($messageCSS) > 0) {
        $out .= ",messageCSS:{";
        $count = 0;
        foreach ($messageCSS as $value) {
         if ($count++ >= 1) $out .= ',';
         $out .= preg_replace("/^([^:]*)[ \t]*:[ \t]*(.*)$/", "$1:'$2'", trim($value));
        }
        $out .= "}";
       }
      }

      if ($this->options['overlayCSS'] != $this->options_default['overlayCSS']) {
       $overlayCSS = preg_split('/[,;]/', $this->options['overlayCSS'], -1, PREG_SPLIT_NO_EMPTY);
       if (is_array($overlayCSS) && count($overlayCSS) > 0) {
        $out .= ",overlayCSS:{";
         $count = 0;
         foreach ($overlayCSS as $value) {
          if ($count++ >= 1) $out .= ',';
          $out .= preg_replace("/^([^:]*)[ \t]*:[ \t]*(.*)$/", "$1:'$2'", trim($value));
         }
        $out .= "}";
       }
      }

      if ($this->options['effect'] != $this->options_default['effect']) $out .= ",effect:".(int)$this->options['effect'];
      if ($this->options['speed'] != $this->options_default['speed']) $out .= ",speed:\"{$this->options['speed']}\"";

      $out .= "};\n";
      $out .= "/* ]]>*/</script>\n";
      echo $out;
    }
  }

  function addFooter() {
    if (is_single()) {
      $out  = "<script type=\"text/javascript\" src=\"".$this->getAbsoluteUrl().'/'.$this->plugin_js."\" charset=\"UTF-8\"></script>\n";
      echo $out;
    }
  }

  function addAdminMenu() {
    add_options_page( __('Quick Comments', $this->textdomain_name)
                     ,__('Quick Comments', $this->textdomain_name)
                     ,9
                     ,$this->admin_option
                     ,array($this,'optionPage')
                    );
  }

  function optionPage() {
    global $wp_version;

    // check referer (Wordpress 2.5+)
    $check_referer = version_compare($wp_version, "2.5", ">=");

    if(isset($_POST['ap_options_update'])) {
      // check referer
      if ($check_referer) check_admin_referer("update_options", "_wpnonce_update_options");

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['form']       = $_POST['ap_form'];
      $this->options['list']       = $_POST['ap_list'];
      $this->options['message']    = $_POST['ap_message'];
      $this->options['loader']     = $_POST['ap_loader'];
      $this->options['messageCSS'] = $_POST['ap_messageCSS'];
      $this->options['overlayCSS'] = $_POST['ap_overlayCSS'];
      $this->options['effect']     = $_POST['ap_effect'];
      $this->options['speed']      = $_POST['ap_speed'];
      $_POST = '';

      // options update
      $this->updateOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";

    } elseif(isset($_POST['ap_options_delete'])) {
      // check referer
      if ($check_referer) check_admin_referer("delete_options", "_wpnonce_delete_options");

      // options delete
      $this->deleteOptions();
      $this->options = $this->initOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";
      $this->error++;
    }

    $out  = '';

    // Add Options
    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('Quick Comments Options', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->make_nonce_field("update_options", "_wpnonce_update_options", true, false);

    $out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\"><tbody>\n";

    // Form
    $out .= "<tr>";
    $out .= "<th>".__('Comment Form CSS Path', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_form\" id=\"ap_form\" size=\"50\" value=\"".$this->options['form']."\" /></td>";
    $out .= "</tr>\n";

    // List
    $out .= "<tr>";
    $out .= "<th>".__('Comment List CSS Path', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_list\" id=\"ap_list\" size=\"50\" value=\"".$this->options['list']."\" /></td>";
    $out .= "</tr>\n";

    // Wait Message
    $out .= "<tr>";
    $out .= "<th>".__('Wait Message', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_message\" id=\"ap_message\" size=\"50\" value=\"".$this->options['message']."\" /></td>";
    $out .= "</tr>\n";

    // Loading Image
    $out .= "<tr>";
    $out .= "<th>".__('Loading Image', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_loader\" id=\"ap_loader\" size=\"50\" value=\"".$this->options['loader']."\" /></td>";
    $out .= "</tr>\n";

    // Message CSS
    $out .= "<tr>";
    $out .= "<th>".__('Message CSS', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_messageCSS\" id=\"ap_messageCSS\" size=\"50\" value=\"".$this->options['messageCSS']."\" /></td>";
    $out .= "</tr>\n";

    // Overlay CSS
    $out .= "<tr>";
    $out .= "<th>".__('Overlay CSS', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_overlayCSS\" id=\"ap_overlayCSS\" size=\"50\" value=\"".$this->options['overlayCSS']."\" /></td>";
    $out .= "</tr>\n";

    // Effect
    $out .= "<tr>";
    $out .= "<th>".__('Effect', $this->textdomain_name)."</th>";
    $out .= "<td>";
    $out .= "<select name=\"ap_effect\">";
    foreach($this->effects as $key => $value) {
      $out .= "<option value=\"{$key}\"".($this->options['effect']==$key ? " selected=\"true\"": "").">{$value}</option>";
    }
    $out .= "</select>";

    $out .= "<select name=\"ap_speed\" style=\"margin-left:1em;\">";
    foreach($this->effectSpeeds as $key => $value) {
      $out .= "<option value=\"{$key}\"".($this->options['speed']==$key ? " selected=\"true\"": "").">{$value}</option>";
    }
    $out .= "</select>";
    $out .= "</td>";
    $out .= "</tr>\n";

    $out .= "</tbody></table>";

    // Add Update Button
    $out .= "<p style=\"margin-top:1em\"><input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
    $out .= "</form></div>\n";

    // Add Options
    $out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
    $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";

    if ($check_referer) $out .= $this->make_nonce_field("delete_options", "_wpnonce_delete_options", true, false);

    // Delete Button
    $out .= "<input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  function commentRedirect($location) {
    global $comment_post_ID;
    if (isset($_POST['quick-comments'])) {
      $param = '';
      if (isset($_POST['redirect_to']) && strstr($_POST['redirect_to'], '?'))
        $param = '&'.preg_replace('/^.*\?(.*)$/' ,'$1', $_POST['redirect_to']);
      return $this->getAbsoluteUrl().'/'.$this->plugin_filename.'?comment_post_ID='.$comment_post_ID.$param;
    } else {
      return $location;
    }
  }

  function getComments($comment_post_ID) {
    global $post, $withcomments;

    // get comment list elements
    $list_element = 'ol';
    $list_id      = '';
    $list_class   = '';
    if (preg_match('/^([^#\.]*)([#\.])([^:]*)/', $this->options['list'], $matches)) {
      $list_element = $matches[1];
      $list_id      = ($matches[2]=='#' ? '[^>]* id=[\'"]'.$matches[3].'[\'"]' : '');
      $list_class   = ($matches[2]=='.' ? '[^>]* class=[\'"]'.$matches[3].'[\'"]' : '');
    } else {
      $list_element = preg_replace('/^([^#\.]*)[#\.].*$/', '$1', $this->options['list']);
    }
    unset($matches);

    // get post data
    if (function_exists('get_post')) {
      $post = get_post($comment_post_ID);
    } else {
      $post->ID = $comment_post_ID;
    }
    $withcomments = true;

    // generate HTML
    $out  = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
    $out .= "<html>\n";
    $out .= "<head>";
    $out .= "<title>Comments (PostID:{$comment_post_ID})</title>";
    //$out .= "<link rel=\"stylesheet\" href=\"".get_option('siteurl')."/wp-content/themes/".get_option('template')."/style.css\" type=\"text/css\" media=\"screen\" />";
    $out .= "</head>\n";
    $out .= "<body><div>";

    // get comment data
    ob_start();				// start buffering output
    comments_template();
    $commentout = preg_replace('/[\r\n]/ims', '', ob_get_clean());	// grab buffered output

    // get comment list element
    if (preg_match('/<'.$list_element.$list_id.$list_class.'[^>]*>.*<\/'.$list_element.'>/i', $commentout, $matches)) {
      $out .= $matches[0];
    } else {
      $out .= $commentout;
    }
    unset($matches);

    $out .= "</div></body>\n";
    $out .= "</html>";

    // convert encoding (UTF-8)
    $charset = get_option('blog_charset');
    if (strtoupper($charset) != "UTF-8") $out = mb_convert_encoding($out, "UTF-8", $charset);

    // output
    nocache_headers();
    header('Content-type: text/html; charset=utf-8');
    echo $out;

  }

  function make_nonce_field($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
    if ( !function_exists('wp_nonce_field') ) {
      return;
    } else {
      return wp_nonce_field($action, $name, $referer, $echo);
    }
  }
}//class

if(!function_exists('get_option')) {
  $path = (defined('ABSPATH') ? ABSPATH : dirname(dirname(dirname(dirname(__FILE__)))) . '/');
  require_once(file_exists($path.'wp-load.php') ? $path.'wp-load.php' : $path.'wp-config.php');
}

$QuickComments = new QuickCommentsController();

if (strstr($_SERVER['PHP_SELF'], '/quick-comments.php') && isset($_GET['comment_post_ID'])) {
  // Get comment list
  foreach (get_option('active_plugins') as $val) {
   // quick-comments active?
   if (preg_match('/'.preg_quote('quick-comments.php').'/i', $val)) {
    $comment_post_ID = (int) $_GET['comment_post_ID'];
    $QuickComments->getComments($comment_post_ID);
    break;
   }
  }

} else {
  add_action('admin_menu', array(&$QuickComments,'addAdminMenu'));

  if (function_exists('wp_enqueue_script')) {
    // Wordpress 2.1+
    add_action('wp_print_scripts', array(&$QuickComments,'addScripts'));
  } else {
    // Wordpress 2.0.x
    add_action('wp_head', array(&$QuickComments,'addHeadScripts'));
  }
  add_action('wp_head', array(&$QuickComments,'addHead'));
  add_action('wp_footer', array(&$QuickComments,'addFooter'));

  add_filter('comment_post_redirect', array(&$QuickComments,'commentRedirect'));
}

unset($QuickComments);
?>
