<?php

/******************************************************************************
 * INITIALIZE
 *****************************************************************************/
$tmkm_amazon_config = array(
	'AssociatesID'	=> 'tomokametei-22',
	'DevToken'		=> '10J7BBWBHFNGXM612JR2',
	'Version'		=> '2007-01-15',
	'JPendpoint'	=> 'http://ecs.amazonaws.jp/onca/xml?Service=AWSECommerceService',
	'OperationLookup'	=> 'ItemLookup',
	'OperationSearch'	=> 'ItemSearch',
	'PageNum'		=> 1,
	'litephp_path'	=> 'Lite.php',
	'xmlphp_path'	=> 'xml.php',
);


/******************************************************************************
 * MAIN CLASS
 *****************************************************************************/
class GetAmazonXmlParse {

	var $AssociatesID;
	var $getmode;
	var $SearchString;
	var $SearchIndex;
	var $ResponseGroup;

	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return Object reference
	 */

	function GetAmazonXmlParse() {

		global $tmkm_amazon_config;

	}

	/**
	 * Get Amazon Image.
	 * 
	 * @param $item (Amazon Xml)
	 * @param $size (Image Size)
	 */
	function get_goods_image($item,$imgsize) {

		if( $imgsize == 'medium' ) {
			$amazon_imgurl = $item["MediumImage"]["URL"];
		} elseif( $imgsize == 'small' ) {
			$amazon_imgurl = $item["SmallImage"]["URL"];
		}
		return $amazon_imgurl;
	}


	/**
	 * Get Amazon Text.
	 * 
	 * @param $item (Amazon Xml)
	 * @param $flag (Text Type)
	 */
	function get_amazon_text($item, $flag=''){

		switch ( $flag ) {
			case url: $textdata = $item["DetailPageURL"]; break;
			case title: $textdata = $item["ItemAttributes"]["Title"]; break;
			case manufacturer: $textdata = $item["ItemAttributes"]["Manufacturer"]; break;
			case asincode: $textdata = $item["ASIN"]; break;
			case eancode: $textdata = $item["ItemAttributes"]["EAN"]; break;
			case price: $textdata = $item["ItemAttributes"]["ListPrice"]["FormattedPrice"]; break;
			case lowestusedprice: $textdata = $item["OfferSummary"]["LowestUsedPrice"]["FormattedPrice"]; break;
			case releasedate: $textdata = $item["ItemAttributes"]["ReleaseDate"]; break;
			case runningtime: $textdata = $item["ItemAttributes"]["RunningTime"]; break;
			case binding:  $textdata = $item["ItemAttributes"]["Binding"]; break;
			case numofdisc: $textdata = $item["ItemAttributes"]["NumberOfDiscs"]; break;
			case pages: $textdata = $item["ItemAttributes"]["NumberOfPages"]; break;
			case role: $textdata = $item["ItemAttributes"]; break;
			case author: $textdata = $item["ItemAttributes"]["Author"]; break;
			case isbn10: $textdata = $item["ItemAttributes"]["ISBN"]; break;
			case publicationdate: $textdata = $item["ItemAttributes"]["PublicationDate"]; break;
			case format: $textdata = $item["ItemAttributes"]["Format"]; break;
			case artist: $textdata = $item["ItemAttributes"]["Artist"]; break;
			case productgroup: $textdata = $item["ItemAttributes"]["ProductGroup"]; break;

		}

		return $textdata;
	}

	/**
	 * Get ECS XML.
	 * 
	 * @param $SearchString (ASIN)
	 * @param $ResponseGroup (Small / Medium / Large : 情報量)
	 * @param $Page (詳細情報ページ)
	 */
	function getamazonxml( $AssociatesID, $SearchString, $getmode, $SearchIndex, $ResponseGroup ) {
		global $tmkm_amazon_config;
		// --- Build XML Link ---

		$xmlFeed  = $tmkm_amazon_config['JPendpoint'];
		$xmlFeed .= '&AWSAccessKeyId=' .$tmkm_amazon_config['DevToken'];
		if( $AssociatesID == '' ) { $AssociatesID = $tmkm_amazon_config['AssociatesID']; }
		$xmlFeed .= '&AssociateTag=' . $AssociatesID;
		if( $getmode == 'single' ) {
			$xmlFeed .= '&Operation=' .$tmkm_amazon_config['OperationLookup'];
			$xmlFeed .= '&ItemId=' .$SearchString;
			$xmlFeed .= '&MerchantId=All';
			$xmlFeed .= '&Condition=All';
		} elseif( $getmode == 'plural' ) {
			$xmlFeed .= '&Operation=' .$tmkm_amazon_config['OperationSearch'];
			$xmlFeed .= '&Keywords=' .$SearchString;
			$xmlFeed .= '&SearchIndex=' .$SearchIndex;
		}
		$xmlFeed .= '&Version=' .$tmkm_amazon_config['Version'];
		$xmlFeed .= '&ResponseGroup=' .$ResponseGroup;
		$xmlFeed .= '&page=' .$tmkm_amazon_config['Pagenum']. '&f=xml';

//		if($getmode == 'plural'){ echo $xmlFeed; } // DEBUG

		// --- Include the cache package ---
		// IMPORTANT - enter the path to Lite.php
		include_once( $tmkm_amazon_config['litephp_path'] );

		// --- Set an ID for this cache ---
		$id = $xmlFeed;

		/**
		* Cache options
		* "lifeTime" is in seconds, so 1 hour would be 60*60*1
		*
		* IMPORTANT - enter the path to your cache directory (a new directory with full permissions)
		*/
		$options = array(
			"cacheDir" => "./cache/",
			"lifeTime" => 60*60*1
			);
		
		$objCache = new Cache_Lite($options);
	
		// Check to see if there is a valid cache of xml
	
		if ($xmlCache = $objCache->get($id)) {  // there is a cache, so parse cached xml
			include_once( $tmkm_amazon_config['xmlphp_path'] );
			$parsedata = XML_unserialize($xmlCache);
			return $parsedata;
		}else{
			$data = @implode("",file($xmlFeed));

			if(!strpos($data, 'xml')){ // there is no XML data in the string (Amazon's Web Services are down)
				return false;
			} else { // there is XML data, so parse the XML

				include_once( $tmkm_amazon_config['xmlphp_path'] );
				$parsedata = XML_unserialize($data);
				return $parsedata;

				// --- Cache the XML ---
				$objCache->save($data, $id);
			}
		}
	}

}

class generalFuncLibrary {

	function calc_chkdgt_mod10( $val ){
		$f = 0;
		$g = 0;
		$k = 0;

		$mod_res = explode( ',',chunk_split( $val, 1, ',' ) );
		for( $ii=count( $mod_res )-1; $ii>-1; $ii-- ){
			$x=intval( $mod_res[$ii] );
			if( $f == 0 ){
				$k += $x;
				$f = 1;
			} else {
				$g += $x;
				$f = 0;
			}
		}
		$chkdgt = substr( strval( 10-intval( substr( strval( $g*3 + $k ), -1 ) ) ),-1 );
		return $val.$chkdgt;
	}

	function calc_chkdgt_isbn10( $val ){
		$g = 0;

		$mod_res = explode( ',',chunk_split( $val, 1, ',' ) );
		for( $ii=count( $mod_res )-1; $ii>-1; $ii-- ){
			$x=intval( $mod_res[$ii] );
			$g += $x*( 11-( $ii+1 ));
		}

		$checksum = (( (int)( $g/11 ) )+1)*11 - $g;

		if( $checksum == 11 ){
			$chkdgt = 0;
		} elseif( $checksum == 10 ){
			$chkdgt = 'X';
		} else {
			$chkdgt = $checksum;
		}

		return $val.$chkdgt;
	}

}
?>