/**
 * quick comments for WordPress
 * Post comments quickly without leaving or refreshing the page.
 * @name quick-comments.js
 * @author wokamoto - http://dogmap.jp
 * @version 0.1.1
 * @date June 19, 2008
 * @copyright (c) 2008 wokamoto (dogmap.jp)
 * @license  Released under the GPL license (http://www.gnu.org/copyleft/gpl.html)
 * @requires jQuery v1.2.3 or later and jQuery.blockUI v2.08 or later
 */

var param = (quickCommentsL10n ? quickCommentsL10n : {form:'#commentform', list:'#commentlist', message:'wait...', loader:'ajax-loader.gif'});
jQuery((function(opt){
 return (function(){
  // get comment form
  var f = jQuery(opt.form);

  // comment form AJAX submit
  f.ajaxStart(function(){
   this.submit.disabled = true; // disable submit
   jQuery(this).block({
     message: '<div style="margin:0 auto;padding:0 0 0 23px;width:100px;font:normal 12px Arial;background:url(' + opt.loader + ') no-repeat 0 50%;"><p style="margin:2em 0;">' + opt.message + '</p></div>'
    ,css: {border: '1px solid #8C8C8C'}
    ,overlayCSS: {backgroundColor:'#FFF',opacity:'0.6'}
   })
  });
  f.ajaxError(function(request, settings){
   alert(settings.responseText.replace(/[\r\n]/g, '').replace(/.*<p>(.*?)<\/p>.*/i, '$1'));
  });
  f.ajaxStop(function(){
   this.submit.disabled = false; // enable submit
   jQuery(this).unblock();
  });
  f.unbind('submit').submit(function(){
   if (jQuery.browser.msie) {
    var redirect_to = jQuery('input[@name=redirect_to]', jQuery(this));
    date = new Date();
    redirect_to.attr('value', redirect_to.attr('value') + '?comments=' + date.getYear() + date.getMonth() + date.getDate());
   }
   var url = jQuery(this).attr('action');
   var param = jQuery('input, textarea', jQuery(this)).serialize();
   jQuery.post(
    url,
    param,
    function(responseText, status) {
     // Add comment list
     var list_id = (opt.list).replace(/^.*[#\.]/, '').replace(/:.*$/, '');
     var ul = jQuery(opt.list);
     if (ul.size() <= 0) {
      ul = jQuery('<ul ' + ((/^#/).test(opt.list) ? 'id' : 'class') + '="' + list_id + '"></ul>');
      jQuery(opt.form).prepend(ul);
     }
     var body_html = responseText.replace(/[\r\n]/g, '').replace(/^.*<body ?[^>]*>(.*)<\/body>.*$/i, '$1');
     var comments = jQuery(opt.list, jQuery(body_html)).children('li');
     if (comments.size() > 0) {
      ul.animate({opacity:'hide'},'normal', function(){
       jQuery(this).empty().append(comments).animate({opacity:'show'},'fast');
      });
      jQuery('textarea', jQuery(opt.form)).val(''); // Reset comment
     } else {
      alert(responseText.replace(/[\r\n]/g, '').replace(/.*<p>(.*?)<\/p>.*/i, '$1'));
     }
    }
   );
   return false;
  });
 })
})(param));
