<?php
/*
Plugin Name: VideoPop Plus
Plugin URI: http://wppluginsj.sourceforge.jp/videopop-plus/
Description: Add links to your posts and pages that open Videos in a popup window. Upload & administration via the WP admin panel
Version: 0.6.9b
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

 this plugin based on
  VideoPop v.1.3.1(http://www.lynk.de/wordpress/videopop/)
  thanks to Marcus Grellert.

*/

@ini_set("max_execution_time","5000");

/*
* function getVideoPopObject()
*/
require("videopop_link.php");

// =============
// CLASS

class VideoPopPlus {
 var $plugin_name = 'videopop_plus';
 var $plugin_uri, $videopop_uri;
 var $data_dir, $data_txt, $vids, $flvplayer;
 var $options, $option_name;
 var $textdomain_name;
 var $videosizes;
 var $note, $error, $blog_charset;
 var $admin_option, $admin_action, $admin_post, $post_action;
 var $wpLightpop_enable = false;
 var $is_wp25 = false;

 var $jquery_js    = 'jquery-1.2.3.min.js';
 var $jquery_ver   = '1.2.3';
 var $lightpop_js  = 'jquery.lightpop-0.4.3.min.js';
 var $lightpop_ver = '0.4.3';

 /*
 * Constructor
 */
 function VideoPopPlus() {
  global $wp_version;

  $this->option_name  = $this->plugin_name." Options";
  $this->options      = get_option($this->option_name);
  $this->initOptions();

  $this->textdomain_name = $this->plugin_name;
  load_plugin_textdomain($this->textdomain_name, 'wp-content/plugins/videopop_plus');

  $this->plugin_uri   = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.$this->plugin_name."/";
  $this->videopop_uri = $this->plugin_uri.'videopop.php';
  $this->data_dir     = 'wp-content/videopop/';
  $this->data_txt     = ABSPATH.$this->data_dir.'videopopdata.txt';
  $this->flvplayer    = (file_exists(dirname(__FILE__).'/mediaplayer.swf') ? 'mediaplayer.swf' : 'flvplayer.swf');

  $this->note = '';
  $this->error = 0;
  $this->blog_charset = get_settings('blog_charset');
  $this->admin_option = basename(__FILE__);
  $this->admin_post   = 'manage_VideoPop_Files';
  $this->admin_action = get_settings('siteurl').'/wp-admin/admin.php?page='.$this->admin_option;
  $this->post_action  = get_settings('siteurl').'/wp-admin/edit.php?page='.$this->admin_post;

  $this->videosizes = array(
    160 => array('width' => 160, 'height' => 120, 'note' => '')
   ,320 => array('width' => 320, 'height' => 240, 'note' => '')
   ,640 => array('width' => 640, 'height' => 480, 'note' => '')
   ,719 => array('width' => 720, 'height' => 252, 'note' => '')
   ,450 => array('width' => 450, 'height' => 120, 'note' => ' [16:9 - 1.78:1]')
   ,480 => array('width' => 480, 'height' => 260, 'note' => '')
   ,720 => array('width' => 720, 'height' => 405, 'note' => ' [16:9 - 1.78:1]')
   ,721 => array('width' => 720, 'height' => 390, 'note' => ' [16:9 - 1.85:1]')
  );

  // wp-lightpop active?
  foreach (get_option('active_plugins') as $val) {
   if (preg_match('/wp\-lightpop\.php/i', $val)) {
    $this->wpLightpop_enable = true;
    break;
   }
  }

  // WordPress 2.5 ?
  $this->is_wp25 = (version_compare($wp_version, "2.5", ">="));
 }

 /*
 * Init Options
 */
 function initOptions() {
  if (!is_array($this->options)) $this->options = array();

  //----- Options default Value -----
  // User Level Permission -- Subscriber = 0,Contributor = 1,Author = 2,Editor= 7,Administrator = 9
  // Set the user level the user needs to have (at least) to manage/upload/delete videos
  if (!isset($this->options['user_lvl'])) {$this->options['user_lvl'] = '7';}

  // Show Option
  // "lightpop" or "popup"
  if (!isset($this->options['show_option'])) {$this->options['show_option'] = 'lightpop';}

  // class name
  if (!isset($this->options['class_name'])) {$this->options['class_name'] = 'video';}
  if (!isset($this->options['class_name_with_type'])) {$this->options['class_name_with_type'] = '0';}

  // Insert ShortCode ?
  if (!isset($this->options['ins_shortcode'])) {$this->options['ins_shortcode'] = '1';}

  // list Max
  if (!isset($this->options['post_list_max'])) {$this->options['post_list_max'] = 5;}
  if (!isset($this->options['manage_list_max'])) {$this->options['manage_list_max'] = 10;}
 }

 /*
 * Update Options
 */
 function updateOptions() {
  update_option($this->option_name, $this->options);
 }

 /*
 * Delete Options
 */
 function deleteOptions() {
  delete_option($this->option_name);
  $this->options = array();
 }

 /*
 * Handles Add/strips slashes to the given array
 */
 function stripArray($array) {
  if(is_array($array)) {
   // If already slashed, strip.
   foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
   return $slashed_array;
  } else {
   return stripslashes($array);
  }
 }

 /*
 * Remove dir and all its contents
 */
 function removeDir($dir) {
  if(file_exists($dir)) {
   if($objs = glob($dir."/*")){
    foreach($objs as $obj) {is_dir($obj)? rmdir($obj) : unlink($obj);}
   }
   rmdir($dir);
  }
 }

 /*
 * Check/Create folder/files
 */
 function checkDir() {
  if(file_exists($this->data_txt)) {
   return true;
  } else {
   if(!is_writable(ABSPATH.'wp-content/')) {
    $this->note .= __("To use <strong>VideoPop+</strong>, the directory <strong>&quot;wp-content&quot;</strong> within your WordPress installation on your webserver must be writeable.<br /><br />To change permission, use a FTP program to access your websever and right-click on the directory <strong>&quot;wp-content&quot;</strong>.<br /> Tick all boxes that say &quot;Write&quot; or set the permission to <strong>777</strong>.", $this->textdomain_name);
    $this->error++;
    return false;
   }

   // Create directory
   if(!file_exists(ABSPATH.$this->data_dir)) {
    if(mkdir(ABSPATH.$this->data_dir,0777)!=true) {
     $this->note .= __("The VideoPop+ directory couldn't be created with &quot;mkdir()&quot; on your server. The function could be disabled by your webhost or another restriction is in place. Ask your host.", $this->textdomain_name);
     $this->error++;
     return false;
    }
   }

   // Write default file
   $handle = fopen($this->data_txt, 'w');
   if($handle==false) {
    $this->note .= __("The VideoPop+ files couldn't be created with &quot;fopen()&quot; on your server. The function could be disabled by your webhost or another restriction is in place. Ask your host.", $this->textdomain_name);
    $this->error++;
    return false;
   } else {
    fwrite($handle,'N;');
    fclose($handle);
    return true;
   }
  }//else
 }//func

 /*
 * Open file and fill array with unserialized data
 */
 function loadDataText() {
  return unserialize(file_get_contents($this->data_txt));
 }

 /*
 * Save ser. array
 */
 function saveDataText($vid_array) {
  $handle = fopen($this->data_txt, 'w');
  fwrite($handle, serialize($vid_array));
  fclose($handle);
 }

 /**
 * Validates form first input
 */
 function valInput() {
  switch(TRUE) {
  case (empty($_POST['lynkvp_name'])):
   $this->note .= __('Please enter a Name.', $this->textdomain_name);
   return FALSE; break;
  case (empty($_FILES['lynkvp_file']['size']) && empty($_POST['lynkvp_url'])):
   $this->note .= __('Please choose a Video or enter an URL.', $this->textdomain_name);
   return FALSE; break;
  case (empty($_POST['lynkvp_type'])):
   $this->note .= __('Please choose a Video Type.', $this->textdomain_name);
   return FALSE; break;
  case ($_POST['lynkvp_size']==0):
   $this->note .= __('Please select a Size.', $this->textdomain_name);
   return FALSE; break;
  default:
   return TRUE; break;
  }
 }

 /**
 * returns selected if value in POST array
 */
 function setOptionSelected($option,$value) {
  return ($option == $value ? ' selected="selected"' : '');
 }

 /**
 * returns selected if value in POST array
 */
 function getTypeSelect($options="") {
  $retval  = "<tr>\n";
  $retval .= "<td>".__('Video type', $this->textdomain_name).":</td>\n";
  $retval .= "<td>";
  $retval .= "<select name=\"lynkvp_type\" onchange=\"javascript:";
  $retval .= "document.getElementById('Thumbnail_title').style.display=(this.value=='flv'?'block':'none');";
  $retval .= "document.getElementById('Thumbnail_image').style.display=(this.value=='flv'?'block':'none');";
  $retval .= "\">";
  $retval .= " <option value=\"0\"".$this->setOptionSelected($_POST['lynkvp_type'],'0').">".__('Select video type', $this->textdomain_name)."</option>";
  $retval .= " <option value=\"asf\"".$this->setOptionSelected($_POST['lynkvp_type'],'asf').">.asf</option>";
  $retval .= " <option value=\"avi\"".$this->setOptionSelected($_POST['lynkvp_type'],'avi').">.avi</option>";
  $retval .= " <option value=\"mp4\"".$this->setOptionSelected($_POST['lynkvp_type'],'mp4').">.mp4</option>";
  $retval .= " <option value=\"mpg\"".$this->setOptionSelected($_POST['lynkvp_type'],'mpg').">.mpg</option>";
  $retval .= " <option value=\"mov\"".$this->setOptionSelected($_POST['lynkvp_type'],'mov').">.mov</option>";
  $retval .= " <option value=\"rm\"" .$this->setOptionSelected($_POST['lynkvp_type'],'rm'). ">.rm</option>";
  $retval .= " <option value=\"swf\"".$this->setOptionSelected($_POST['lynkvp_type'],'swf').">.swf</option>";
  if (file_exists(dirname(__FILE__).'/'.$this->flvplayer)) {
   $retval .= " <option value=\"flv\"".$this->setOptionSelected($_POST['lynkvp_type'],'flv').">.flv</option>";
  }
  $retval .= " <option value=\"wmv\"".$this->setOptionSelected($_POST['lynkvp_type'],'wmv').">.wmv</option>";
  $retval .= " <option value=\"3gp\"".$this->setOptionSelected($_POST['lynkvp_type'],'3gp').">.3gp</option>";
  $retval .= " </select>";
  $retval .= "</td>\n";
  $retval .= "</tr>\n";

  $retval .= "<tr>\n";
  $retval .= "<td><span id=\"Thumbnail_title\" style=\"display:".($_POST['lynkvp_type']!='flv'?'none':'block')."\">".__('Thumbnail', $this->textdomain_name).":</span></td>";
  $retval .= "<td><span id=\"Thumbnail_image\" style=\"display:".($_POST['lynkvp_type']!='flv'?'none':'block')."\"><input type=\"file\" name=\"lynkvp_image_file\" />&nbsp;&nbsp;&nbsp;\n";
  $retval .= __('<strong>or</strong>', $this->textdomain_name)." &nbsp;&nbsp;".__('URL', $this->textdomain_name).":&nbsp;&nbsp;http://<input type=\"text\" name=\"lynkvp_image_url\" style=\"width:400px;\" value=\"".$_POST['lynkvp_image']."\" /></span></td>\n";
  $retval .= "</tr>\n";

  return $retval;
 }

 /**
 * returns Video Link Tag
 */
 function getLinkTag($vid, $size = 320, $title = "", $inline = false, $quote = '"') {
  $link_format = '';
  switch($this->options['show_option']) {
  case "lightpop":
   $link_format = '<a href='.$quote.'%1$s?%3$s'.$quote.' title='.$quote.'%2$s'.$quote.'%5$s>%4$s</a>';
   break;
  case "modalbox":
  case "popup":
   $link_format = '<a href='.$quote.'%1$s'.$quote.' title='.$quote.'%2$s'.$quote.' onclick='.$quote.'javascript:VideoPop(%7$d,\'%6$d\');return false;'.$quote.'%5$s>%4$s</a>';
   break;
  case "inline":
   $inline = true;
   break;
  default:
   $link_format = '<a href='.$quote.'%1$s'.$quote.' title='.$quote.'%2$s'.$quote.'%5$s>%4$s</a>';
   break;
  }

  // Open file and fill array with unserialized data
  if (!is_array($this->vids)) {$this->vids = $this->loadDataText();}

  $retval = "";

  if (isset($this->vids[$vid])) {
   $vtitle = (isset($this->vids[$vid]['lynkvp_name']) ? $this->vids[$vid]['lynkvp_name'] : $title);
   $vsize  = (isset($this->vids[$vid]['lynkvp_size']) ? $this->vids[$vid]['lynkvp_size'] : $size);
   $vtype  = (isset($this->vids[$vid]['lynkvp_type']) ? $this->vids[$vid]['lynkvp_type'] : "");
  } else {
   $vtitle = $title;
   $vsize  = $size;
   $vtype  = "";
  }

  $wkClassName = "";
  if (isset($this->options['class_name'])) {
   $wkClassName = ($this->options['class_name'] != "" ? ' class='.$quote.$this->options['class_name'].'%s'.$quote : "");
   $vclass = sprintf($wkClassName, (isset($this->options['class_name_with_type']) && $this->options['class_name_with_type'] == "1" ? "-".$vtype : ""));
  }

  if (!$inline) {
   $src = "";
   if ($this->options['show_option'] != "lightpop") {
    $src = $this->videopop_uri.'?vid='.$vid;
   } else {
    if(!empty($this->vids[$vid]['lynkvp_url'])) {
     $src = 'http://'.$this->vids[$vid]['lynkvp_url'];
    } elseif(file_exists(ABSPATH.$this->data_dir.$this->vids[$vid]['lynkvp_id'].'.'.$this->vids[$vid]['lynkvp_type'])) {
     $src = get_settings('siteurl')."/".$this->data_dir.$this->vids[$vid]['lynkvp_id'].'.'.$this->vids[$vid]['lynkvp_type'];
    }
   }
   $sizes  = 'width='.$this->videosizes[$vsize]['width'].'&amp;'
           . 'height='.$this->videosizes[$vsize]['height'];
   $retval = sprintf($link_format
                    ,$src
                    ,$vtitle
                    ,$sizes
                    ,$title
                    ,$vclass
                    ,$vid
                    ,$this->videosizes[$vsize]['width']
                    );
  } elseif ($vclass != "") {
   $link_format = '<div%s>%s<br clear='.$quote.'all'.$quote.' />%s</div>';
   $retval = sprintf($link_format
                    , $vclass
                    , str_replace('"', $quote, getVideoPopObject($vid, false, $this->flvplayer, __("Sorry, video not available.", $this->textdomain_name), $this->videosizes))
                    , $title
                    );
  } else {
   $link_format = '%s<br clear='.$quote.'all'.$quote.' />%s';
   $retval = sprintf($link_format
                    , str_replace('"', $quote, getVideoPopObject($vid, false, $this->flvplayer, __("Sorry, video not available.", $this->textdomain_name), $this->videosizes))
                    , $title
                    );
  }

  return $retval;
 }

 function insertEditorJs() {
  $out  = "<script type=\"text/javascript\"> //<![CDATA[\n";
  $out .= "function vpInsertAtCursor(myValue) {";
  $out .= " var win = window;";
  $out .= " var richedit = false;";
  $out .= " var field = document.post.content;";
  $out .= " if (win.tinyMCE) {";
  $out .= "  if (!win){win = top};";
  $out .= "  var tinyMCE = win.tinyMCE;";
  $out .= "  richedit = ".($this->is_wp25 ? "(jQuery('#edButtonPreview').attr('class') == 'active' )" : "(typeof tinyMCE=='object' && tinyMCE.configs.length > 0 )").";";
  $out .= " }";
  $out .= " if (richedit) {";
  $out .= "  tinyMCE.execCommand('mceInsertContent',false,myValue);";
  $out .= " } else {";
  $out .= "  try {";
  $out .= "   if (typeof FCKeditor != \"undefined\") {";
  $out .= "    var oEditor = FCKeditorAPI.GetInstance('content');";
  $out .= "    oEditor.InsertHtml(myValue);";
  $out .= "   } else if (document.selection) {";
  $out .= "    field.value += myValue;";
  $out .= "   } else if (field.selectionStart || field.selectionStart=='0') {";
  $out .= "    var startPos = field.selectionStart;";
  $out .= "    var endPos = field.selectionEnd;";
  $out .= "    field.value = field.value.substring(0, startPos)+ myValue + field.value.substring(endPos, field.value.length);";
  $out .= "   } else {";
  $out .= "    field.value += myValue;";
  $out .= "   }";
  $out .= "  } catch(e) {";
  $out .= "   alert(e);";
  $out .= "  }";
  $out .= " }";
  $out .= "}\n";
  if ($this->options['ins_shortcode'] == '1') {
   $out .= "function vpEditCode(vp_id,vp_name,vp_caption,vp_inline) {";
   $out .= " return '[videopop vid=\"' + vp_id + '\" vtitle=\"' + vp_name + '\"' + (vp_inline==true?' vinline=\"true\"':'') + ']' + vp_caption + '[/videopop]';";
   $out .= "}\n";
  }
  $out .= "//]]> </script>\n";

  echo $out;
 }//func

 /*
 * Set Videopop Script
 */
 function addWpHead($unused) {
 }//func

 function addWpFooter($unused) {
  if (!(is_404() || is_page())) {
   $out = '';
   switch($this->options['show_option']) {
   case "lightpop":
    if (!$this->wpLightpop_enable) {
     $out .= "<script type=\"text/javascript\"> /*<![CDATA[*/\n";
     $out .= "jQuery(function(){";
     $out .= "var l={";
     $out .= "imageLoading:'".$this->plugin_uri."lightpop/lightpop-ico-loading.gif'";
     $out .= ",imageBtnPrev:'".$this->plugin_uri."lightpop/lightpop-btn-prev.gif'";
     $out .= ",imageBtnNext:'".$this->plugin_uri."lightpop/lightpop-btn-next.gif'";
     $out .= ",imageBtnClose:'".$this->plugin_uri."lightpop/lightpop-btn-close.gif'";
     $out .= ",imageBlank:'".$this->plugin_uri."lightpop/lightpop-blank.gif'";
     $out .= ",flvplayer:'".$this->plugin_uri.$this->flvplayer."'";
     $out .= ",iconAdd:false};";
     $out .= "jQuery('".$this->getLightPopElements()."').each(function(){jQuery(this).lightpop(l);});";
     $out .= "});\n";
     $out .= "/*]]>*/ </script>\n";
    }
    break;

   case "modalbox":
   case "popup":
    $out .= "<script type=\"text/javascript\"> /*<![CDATA[*/\n";
    $out .= "function VideoPop(vpsize,vpid){";
    $out .= " url = '".$this->videopop_uri."?vid='+vpid;";
    $out .= " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
    $out .= " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
    $out .= " lvp.focus();";
    $out .= "}\n";
    $out .= "/*]]>*/ </script>\n";
    break;

   case "inline":
    break;

   default:
    break;
   }
   echo $out;
  }
 }//func

 function getLightPopElements() {
  $elements = "";
  if ($this->options['class_name'] == "") {
   $elements .= "a[@href^=".trailingslashit(get_settings('siteurl')).$this->data_dir."]";
  } elseif ($this->options['class_name_with_type'] == "0") {
   $elements .= "a.".$this->options['class_name'];
  } else {
   $elements .= "a[@class^=".$this->options['class_name']."]";
  }
  return $elements;
 }

 function addLightPopElements($content = "") {
  if ($this->options['show_option'] == 'lightpop' && $this->wpLightpop_enable) {
   if ($content != '') $content .= "\n";
   $content .= $this->getLightPopElements();
  }
  return $content;
 }

 /*
 * Content Filter
 */
 function addContentFilter($content) {
  $matched = 0;

  $search_strings  = array();
  $replace_strings = array();

  // VideoPop+ shortcode found
  if (!$this->is_wp25 && strstr(strtolower($content),'[/videopop]')) {
   $pattern = '/\[videopop(.*)\](.*)\[\/videopop\]/i';
   if(preg_match_all($pattern, $content, $matches)) {
    for ($i=0; $i<count($matches[0]); $i++) {
     // get options
     $vid = 0;
     $vsize = 320;
     $options = explode(" v", $matches[1][$i]);
     for ($j=0; $j<count($options); $j++) {
      if (strstr(strtolower($options[$j]),'id')) {
        $vid = preg_replace('/id=[\'"]?(.*)[\'"]?/i', '$1', $options[$j]);
      } elseif (strstr(strtolower($options[$j]),'inline')) {
        $inline = strstr(strtolower($options[$j]),'true') != false;
      }
     }
     unset($options);
     $search_strings[$matched]  = '/' . preg_quote($matches[0][$i], '/') . '/';
     $replace_strings[$matched] = $this->getLinkTag($vid, $vsize, $matches[2][$i], $inline);
     $matched++;
    }
   }
   unset($matches);
  }

  // VideoPop tag found
  if (strstr(strtolower($content),'class="lynkvp"')) {
   $pattern = '/<a href="javascript:lynkVideoPop\(([0-9]*),[\'"]?([0-9]*)[\'"]?\);" class="lynkvp">(.*)<\/a>/i';
   if(preg_match_all($pattern, $content, $matches)) {
    for ($i=0; $i<count($matches[0]); $i++) {
     $search_strings[$matched]  = '/' . preg_quote($matches[0][$i], '/') . '/';
     $replace_strings[$matched] = $this->getLinkTag($matches[2][$i], $matches[1][$i], $matches[3][$i], $inline);
     $matched++;
    }
   }
   unset($matches);
  }

  if ($matched > 0) {
   if ($this->blog_charset!="UTF-8") $content = mb_convert_encoding($content, "UTF-8", $this->blog_charset);
   $content = preg_replace($search_strings, $replace_strings, $content);
   if ($this->blog_charset!="UTF-8") $content = mb_convert_encoding($content, $this->blog_charset, "UTF-8");
  }
  return $content;
 }//func

 /*
 * regist script
 */
 function re_regist_script( $handle, $src = '', $deps = false, $ver = false ) {
  global $wp_scripts;
  if ( !is_a($wp_scripts, 'WP_Scripts') ) $wp_scripts = new WP_Scripts();
  if ( isset($wp_scripts->scripts[$handle]) ) {
   if ( version_compare($wp_scripts->scripts[$handle]->ver, $ver, "<") ) {
    if ($src  != '')     $wp_scripts->scripts[$handle]->src  = $src;
    if (is_array($deps)) $wp_scripts->scripts[$handle]->deps = $deps;
    if ($ver  != false)  $wp_scripts->scripts[$handle]->ver  = $ver;
   }
  } else {
   if (!is_array($deps)) $deps = array();
   $wp_scripts->add( $handle, $src, $deps, $ver );
  }
 }

 function addLightPopScripts() {
  if ($this->options['show_option'] == 'lightpop' && !$this->wpLightpop_enable) {
   $this->re_regist_script('jquery', $this->plugin_uri.'lightpop/'.$this->jquery_js, false, $this->jquery_ver);
   wp_enqueue_script('jquery.lightpop', $this->plugin_uri.'lightpop/'.$this->lightpop_js, array('jquery'), $this->lightpop_ver);
  }
 }

 /*
 * Add shortcode API Handler
 */
 function shortcodeHandler($atts, $content = null) {
  extract( shortcode_atts( array(
       'vid'     => '0'
      ,'vsize'   => '320'
      ,'vtitle'  => ''
      ,'vinline' => 'false'
      ), $atts ) );
  $vinline = (strtolower($vinline)=='true');
  return $this->getLinkTag($vid, $vsize, $vtitle, $vinline);
 }

 /*
 * Add js to admin head
 */
 function adminHead() {
  $out  = "<script type=\"text/javascript\"> //<![CDATA[\n";
  $out .= "function VideoPop(vpsize,vpid){";
  $out .= " url = '".$this->videopop_uri."?vid='+vpid;";
  $out .= " xwidth = vpsize+110; xheight = (vpsize/1.3)+94;";
  $out .= " lvp = window.open(url,'','top=100,left=100,status=0,location=0,width='+xwidth+',height='+xheight+'');";
  $out .= " lvp.focus();";
  $out .= "}\n";
  $out .= "//]]> </script>\n";

  echo $out;
 }//func

 /*
 * Display option page body
 */
 function optionPage() {
  $out = $uninstall = '';

  // Check write permissions
  if($this->checkDir()) {
   if(isset($_POST['options_update'])) {      // options update

    // strip slashes array
    $_POST = $this->stripArray($_POST);

    $this->options['user_lvl'] = $_POST['vp_userlevel'];
    $this->options['show_option'] = $_POST['vp_show'];
    $this->options['class_name'] = $_POST['vp_classname'];
    $this->options['class_name_with_type'] = $_POST['vp_classwithtype'];
    $this->options['ins_shortcode'] = ($_POST['vp_shortcode']=='1'?'1':'0');
    $this->updateOptions();

    $_POST = '';
    $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);

   } elseif(isset($_POST['uninst'])) {         // uninstall
    $this->deleteOptions();
    if(file_exists(ABSPATH.$this->data_dir)) $this->removeDir(ABSPATH.$this->data_dir);
    $this->note .= __('All files and folders have (probably) been deleted. Now click <strong>Plugins</strong> in the admin panel above and <b>Deactivate</b> the VideoPop plugin.', $this->textdomain_name);
    $this->note .= "<br />".ABSPATH.$this->data_dir;
    $this->error++;
    $this->initOptions();
    error_reporting(0);
   }
  }

  // Add Options
  $out .= "<div class=\"wrap\">\n";
  $out .= "<h2>".__('VideoPop+ Options', $this->textdomain_name)."</h2><br />\n";
  $out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
  $out .= "<table>\n";

  // Add User Level
  //  Permission -- Subscriber = 0, Contributor = 1, Author = 2, Editor = 7, Administrator = 9
  $out .= "<tr>\n";
  $out .= "<td><strong>".__('User Level', $this->textdomain_name)."</strong></td>";
  $out .= "<td><select name=\"vp_userlevel\">";
  $out .= "<option value=\"0\"".$this->setOptionSelected($this->options['user_lvl'],'0').">".__('subscriber', $this->textdomain_name)."</option>";
  $out .= "<option value=\"1\"".$this->setOptionSelected($this->options['user_lvl'],'1').">".__('contributor', $this->textdomain_name)."</option>";
  $out .= "<option value=\"2\"".$this->setOptionSelected($this->options['user_lvl'],'2').">".__('author', $this->textdomain_name)."</option>";
  $out .= "<option value=\"7\"".$this->setOptionSelected($this->options['user_lvl'],'7').">".__('editor', $this->textdomain_name)."</option>";
  $out .= "<option value=\"9\"".$this->setOptionSelected($this->options['user_lvl'],'9').">".__('administrator', $this->textdomain_name)."</option>";
  $out .= "</select>&nbsp;</td>";
  $out .= "<td>".__('Set the user level the user needs to have (at least) to manage/upload/delete videos', $this->textdomain_name)."</td>\n";
  $out .= "</tr>\n";

  // Add Method of display
  $out .= "<tr>\n";
  $out .= "<td><strong>".__('Method of display', $this->textdomain_name)."</strong></td>";
  $out .= "<td><select name=\"vp_show\">";
  $out .= "<option value=\"popup\""   .$this->setOptionSelected($this->options['show_option'],'popup').">".   __('Pop up', $this->textdomain_name)."</option>";
  $out .= "<option value=\"lightpop\"".$this->setOptionSelected($this->options['show_option'],'lightpop').">".__('LightPop', $this->textdomain_name)."</option>";
//  $out .= "<option value=\"modalbox\"".$this->setOptionSelected($this->options['show_option'],'modalbox').">".__('ModalBox', $this->textdomain_name)."</option>";
  $out .= "<option value=\"inline\""  .$this->setOptionSelected($this->options['show_option'],'inline').">".  __('In line', $this->textdomain_name)."</option>";
  $out .= "<option value=\"none\""    .$this->setOptionSelected($this->options['show_option'],'none').">".    __('The effect none', $this->textdomain_name)."</option>";
  $out .= "</select>&nbsp;</td>";
  $out .= "<td>".__('Please select it from &quot;Pop up&quot;, &quot;LightPop&quot;, &quot;In line&quot;, and &quot;The effect none&quot;.', $this->textdomain_name);
//  $out .= "<br />".__("<strong>Attention:</strong> When &quot;ModalBox&quot; is selected, the installation of <a href='http://wildbit.com/demos/modalbox/' title='ModalBox - An easy way to create popups and wizards'>ModalBox.js</a> is separately needed.", $this->textdomain_name)."</td>\n";
  $out .= "</tr>\n";

  // Add Class Name Setting
  $out .= "<tr>\n";
  $out .= "<td><strong>".__('Class name of the link tag', $this->textdomain_name)."</strong></td>";
  $out .= "<td><input type=\"text\" name=\"vp_classname\" value=\"".$this->options['class_name']."\"/>&nbsp;</td>";
  $out .= "<td>".__('Please set the class name of the link tag.', $this->textdomain_name)."</td>\n";
  $out .= "</tr>\n";
  $out .= "<tr>\n";
  $out .= "<td></td>";
  $out .= "<td colspan=\"2\"><select name=\"vp_classwithtype\">";
  $out .= "<option value=\"0\"".$this->setOptionSelected($this->options['class_name_with_type'],'0').">".__('Without File Type', $this->textdomain_name)."</option>";
  $out .= "<option value=\"1\"".$this->setOptionSelected($this->options['class_name_with_type'],'1').">".__('With File Type', $this->textdomain_name)."</option>";
  $out .= "</select>&nbsp;</td>";
  $out .= "</tr>\n";

  // Insert Editor Option (Shortcode or HTML Tag?)
  $out .= "<tr>\n";
  $out .= "<td><strong>".__('Insert Editor Option', $this->textdomain_name)."</strong></td>";
  $out .= "<td colspan=\"2\"><input type=\"checkbox\" name=\"vp_shortcode\" value=\"1\" style=\"margin-right:0.5em;\" ".($this->options['ins_shortcode']==1?" checked":"")." />".__('Shortcode is inserted in the editor.', $this->textdomain_name)."</td>";
  $out .= "</tr>\n";
  $out .= "<tr>\n";

  $out .= "</table>\n";

  // Add Update Button
  $out .= "<div style=\"text-align:right\">";
  $out .= "<input type=\"submit\" name=\"options_update\" value=\"".__('Update Options', $this->textdomain_name)."\" class=\"button\" />";
  $out .= "</div>";
  $out .= "</form></div>\n";

  // About the file of the video of the FLV form
  $out .= "<div class=\"wrap\">\n";
  $out .= "<h2>".__('About the file of the video of the FLV form', $this->textdomain_name)."</h2><br />\n";
  $out .= "<p>".__("It comes to be able to treat the file of the FLV form by preserving free <a href='http://www.jeroenwijering.com/?item=Flash_Video_Player&amp;' title='JW FLV Player'>JW FLV Player</a> in the same to plug-in directory. ", $this->textdomain_name)."</p>\n";
  $out .= "</div>\n";

  // Add uninstall
  $out .= "<div class=\"wrap\">\n";
  $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
  $out .= "<p>".__('If you want to keep your videos and the popup functionality of your links but want to get rid of the additional menus in the control panel, just deactivate the plugin.<br />For a complete uninstall including all uploaded videos use the uninstall button.', $this->textdomain_name)."</p>\n";
  $out .= "<div style=\"text-align:right;\">";
  $out .= "<form method=\"post\" id=\"uninstall\" action=\"".$this->admin_action."\">\n";
  $out .= "<input type=\"submit\" name=\"uninst\" value=\"".__('Uninstall VideoPop+', $this->textdomain_name)."\" onclick=\"javascript:check=confirm('".__('You are about to delete all your settings and Videos! The links you created with VideoPop will not work after uninstall! Proceed with uninstall?', $this->textdomain_name)."');if(check==false) return false;\" class=\"button\" />\n";
  $out .= "</form>\n";
  $out .= "</div>\n";
  $out .= "</div>\n";

  // Note snuff
  if(!empty($this->note)) {
   $this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";
  }

  // If any error, dont display body
  if($this->error>0) {$out = '';}

  // Output
  echo $this->note."\n";
  echo $out."\n";
 }//func

 /*
 * Display manage page body
 */
 function manageVideoPopPlusFiles() {
  // Get List
  if (isset($_GET['get_list'])) {
   $start = 0;
   if (isset($_GET['start']) && is_numeric($_GET['start'])) {$start = $_GET['start'];}

   // Open file and fill array with unserialized data
   if (!is_array($this->vids)) {$this->vids = $this->loadDataText();}

   $out .= $this->videoLists($_GET['get_list'], $this->vids, $start, ($_GET['get_list']=='1' ? $this->options['manage_list_max'] : $this->options['post_list_max']));
   echo $out;
   return;
  }

  // Check write permissions
  if($this->checkDir()) {

   // IF Video is uploaded
   if(isset($_POST['lynkvp_upload']) AND $this->valInput()) {
    // defaults
    $vid_url = '';
    $vid_file = '';
    $vid_id = time(); // use timestamp for unique id
    $vid_image_file = '';
    $vid_image_url = '';

    // Save file
    if(is_uploaded_file($_FILES['lynkvp_file']['tmp_name'])) {
     $vid_file = $vid_id.'.'.$_POST['lynkvp_type']; // filename+extension
     if(!move_uploaded_file($_FILES['lynkvp_file']['tmp_name'], ABSPATH.$this->data_dir.$vid_file)) {
      $this->note .= __("The file couldn't be saved on your server", $this->textdomain_name);
     }
    } elseif(!empty($_POST['lynkvp_url'])) {
     $vid_url = ltrim($_POST['lynkvp_url'],'http://');
    }

    // Save Thumbnail file
    if(is_uploaded_file($_FILES['lynkvp_image_file']['tmp_name'])) {
     preg_match('/\.(gif|jpe?g|png|bmp)$/i', $_FILES['lynkvp_image_file']['name'], $matches);
     $vid_image_file = $vid_id.'.thum.'.$matches[1]; // filename+extension
     unset($matches);

     if(file_exists(ABSPATH.$this->data_dir.$vid_image_file)) {
      @unlink(ABSPATH.$this->data_dir.$vid_image_file);
     }

     if(move_uploaded_file($_FILES['lynkvp_image_file']['tmp_name'],ABSPATH.$this->data_dir.$vid_image_file)) {
      $vid_image_url = ltrim(get_settings('siteurl').'/'.$this->data_dir.$vid_image_file,'http://');
     } else {
      $this->note .= __("The file couldn't be saved on your server", $this->textdomain_name);
     }

    } elseif(!empty($_POST['lynkvp_image_url'])) {
     $vid_image_url = ltrim($_POST['lynkvp_image_url'],'http://');
    }

    // Open file and fill array with unserialized data
    if (!is_array($this->vids)) {$this->vids = $this->loadDataText();}

    // Add data to array
    $this->vids[$vid_id]['lynkvp_id'] = $vid_id;
    $this->vids[$vid_id]['lynkvp_filename'] = $vid_file;
    $this->vids[$vid_id]['lynkvp_url'] = $vid_url;
    $this->vids[$vid_id]['lynkvp_type'] = $_POST['lynkvp_type'];
    $this->vids[$vid_id]['lynkvp_size'] = $_POST['lynkvp_size'];
    $this->vids[$vid_id]['lynkvp_name'] = $_POST['lynkvp_name'];
    $this->vids[$vid_id]['lynkvp_caption'] = $_POST['lynkvp_caption'];
    $this->vids[$vid_id]['lynkvp_image'] = $vid_image_url;
    $this->vids[$vid_id]['lynkvp_image_filename'] = $vid_image_file;

    // Save ser. array
    $this->saveDataText($this->vids);

    $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);
    unset($_POST);

   } elseif(isset($_POST['lynkvp_edit2'])) {
    if(empty($_POST['lynkvp_name'])) {
     $this->note .= __('Please edit again and enter a name.', $this->textdomain_name);
    } elseif(isset($_POST['lynkvp_type']) && empty($_POST['lynkvp_type'])) {
     $this->note .= __('Please edit again and select a video type.', $this->textdomain_name);
    } elseif(isset($_POST['lynkvp_url']) && empty($_POST['lynkvp_url']) ) {
     $this->note .= __('Please edit again and enter an URL.', $this->textdomain_name);

    } else {
     // Open file and fill array with unserialized data
     if (!is_array($this->vids)) {$this->vids = $this->loadDataText();}
     $vid_id = $_POST['lynkvp_editid'];
     $vid_image_file = '';
     $vid_image_url = '';

     // Save Thumbnail file
     if(is_uploaded_file($_FILES['lynkvp_image_file']['tmp_name'])) {
      preg_match('/\.(gif|jpe?g|png|bmp)$/i', $_FILES['lynkvp_image_file']['name'], $matches);
      $vid_image_file = $vid_id.'.thum.'.$matches[1]; // filename+extension
      unset($matches);

      if(file_exists(ABSPATH.$this->data_dir.$vid_image_file)) {
       @unlink(ABSPATH.$this->data_dir.$vid_image_file);
      }

      if(move_uploaded_file($_FILES['lynkvp_image_file']['tmp_name'],ABSPATH.$this->data_dir.$vid_image_file)) {
       $vid_image_url = ltrim(get_settings('siteurl').'/'.$this->data_dir.$vid_image_file,'http://');
      } else {
       $this->note .= __("The file couldn't be saved on your server", $this->textdomain_name);
      }

     } elseif(!empty($_POST['lynkvp_image_url'])) {
      $vid_image_file = '';
      $vid_image_url = ltrim($_POST['lynkvp_image_url'],'http://');

     } else {
      $vid_image_url = $this->vids[$vid_id]['lynkvp_image'];
      $vid_image_file = $this->vids[$vid_id]['lynkvp_image_filename'];
     }

     // Add data to array
     $this->vids[$vid_id]['lynkvp_id'] = $vid_id;
     $this->vids[$vid_id]['lynkvp_filename'] = $_POST['lynkvp_filename'];
     $this->vids[$vid_id]['lynkvp_url'] = $_POST['lynkvp_url'];
     $this->vids[$vid_id]['lynkvp_type'] = $_POST['lynkvp_type'];
     $this->vids[$vid_id]['lynkvp_size'] = $_POST['lynkvp_size'];
     $this->vids[$vid_id]['lynkvp_name'] = $_POST['lynkvp_name'];
     $this->vids[$vid_id]['lynkvp_caption'] = $_POST['lynkvp_caption'];
     $this->vids[$vid_id]['lynkvp_image'] = $vid_image_url;
     $this->vids[$vid_id]['lynkvp_image_filename'] = $vid_image_file;

     // Save ser. array
     $this->saveDataText($this->vids);

     $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);
    }
    unset($_POST);

   } elseif(isset($_POST['lynkvp_del'])) {
    // Open file and fill array with unserialized data
    if (!is_array($this->vids)) {$this->vids = $this->loadDataText();}
    $a_id = array_flip($_POST['lynkvp_del']);

    // Remove Video
    @unlink(ABSPATH.$this->data_dir.$this->vids[$a_id[__('delete', $this->textdomain_name)]]['lynkvp_filename']);
    @unlink(ABSPATH.$this->data_dir.$this->vids[$a_id[__('delete', $this->textdomain_name)]]['lynkvp_image_filename']);

    foreach($this->vids as $key=>$value) {
     if($key!=$a_id[__('delete', $this->textdomain_name)]) {$a_vids2[$key] = $value;}
    }
    $this->vids = $a_vids2;
    unset($a_vids2);

    // Save ser. images
    $this->saveDataText($this->vids);

    $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);
    unset($_POST);

   }

   // IF edit
   if(isset($_POST['lynkvp_edit'])) {
    // Video ID
    $a_id = array_flip($_POST['lynkvp_edit']);

    // Open file and fill array with unserialized data
    if (!is_array($this->vids)) {$this->vids = $this->loadDataText();}

    // Populate POST & strip slashes array
    $_POST = $this->stripArray($this->vids[$a_id[__('edit', $this->textdomain_name)]]);

    $out .= "<div class=\"wrap\" style=\"text-align:left;\">\n";
    $out .= "<h2>".__('Video Edit', $this->textdomain_name)."</h2>\n";

    $out .= "<form method=\"post\" action=\"".$this->post_action."\" enctype=\"multipart/form-data\">\n";
    $out .= "<input type=\"hidden\" name=\"lynkvp_type\" value=\"".$_POST['lynkvp_type']."\" />\n";

    $out .= "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\n";

    $out .= "<tr>\n";
    $out .= "<td>".__('Name','videopop_plus').":</td>\n";
    $out .= "<td><input type=\"text\" name=\"lynkvp_name\" value=\"".$_POST['lynkvp_name']."\" /></td>\n";
    $out .= "</tr>\n";

    $out .= "<tr>\n";
    $out .= "<td>".__('Caption','videopop_plus').":</td>\n";
    $out .= "<td><input type=\"text\" name=\"lynkvp_caption\" value=\"".$_POST['lynkvp_caption']."\" /></td>\n";
    $out .= "</tr>\n";

    if(!empty($_POST['lynkvp_url'])) {
     $out .= "<tr>\n";
     $out .= "<td>".__('URL', $this->textdomain_name).":</td>\n";
     $out .= "<td>http://<input type=\"text\" name=\"lynkvp_url\" value=\"".$_POST['lynkvp_url']."\" style=\"width:400px;\" /></td>\n";
     $out .= "</tr>\n";

     $out .= $this->getTypeSelect()."\n";

    } else {
     $out .= "<tr>\n";
     $out .= "<td>".__('Video type', $this->textdomain_name).":</td>\n";
     $out .= "<td>".$_POST['lynkvp_type']."</td>\n";
     $out .= "</tr>\n";

     $out .= "<tr>\n";
     $out .= "<td><span style=\"display:".($_POST['lynkvp_type']!='flv'?'none':'block')."\">";
     $out .= __('Thumbnail', $this->textdomain_name).":";
     $out .= "</span></td>\n";
     $out .= "<td><span style=\"display:".($_POST['lynkvp_type']!='flv'?'none':'block')."\">";
     $out .= "<input type=\"file\" name=\"lynkvp_image_file\" />&nbsp;&nbsp;&nbsp;\n";
     $out .= __('<strong>or</strong>', $this->textdomain_name).' &nbsp;&nbsp;';
     $out .= __('URL', $this->textdomain_name).":&nbsp;&nbsp;";
     $out .= "http://<input type=\"text\" name=\"lynkvp_image_url\" style=\"width:400px;\" value=\"".$_POST['lynkvp_image']."\" />";
     $out .= "</span></td>\n";
     $out .= "</tr>\n";
    }

    $out .= "</table>\n";

    $out .= "<br />\n";
    $out .= "<input type=\"hidden\" name=\"lynkvp_size\" value=\"".$_POST['lynkvp_size']."\" />\n";
    $out .= "<input type=\"hidden\" name=\"lynkvp_editid\" value=\"".$_POST['lynkvp_id']."\" />\n";
    $out .= "<input type=\"hidden\" name=\"lynkvp_filename\" value=\"".$_POST['lynkvp_filename']."\" />\n";
    $out .= "<input type=\"submit\" name=\"lynkvp_edit2\" value=\"".__('Upload', $this->textdomain_name)."\" />\n";
    $out .= "</form>\n";
    $out .= "</div>\n";

   } else {
    // strip slashes array
    $_POST = $this->stripArray($_POST);

    // BLOCK Upload
    $out .= "<div class=\"wrap\" style=\"text-align:left;\">\n";
    $out .= "<h2>".__('Video Upload', $this->textdomain_name)."</h2>\n";

    $out .= "<form method=\"post\" action=\"".$this->post_action."\" enctype=\"multipart/form-data\">\n";

    $out .= "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\n";

    $out .= "<tr>\n";
    $out .= "<td>".__('Name', $this->textdomain_name).":</td>\n";
    $out .= "<td><input type=\"text\" name=\"lynkvp_name\" value=\"".$_POST['lynkvp_name']."\" /></td>\n";
    $out .= "</tr>\n";

    $out .= "<tr>\n";
    $out .= "<td>".__('Caption', $this->textdomain_name).":</td>\n";
    $out .= "<td><input type=\"text\" name=\"lynkvp_caption\" value=\"".$_POST['lynkvp_caption']."\" /></td>\n";
    $out .= "</tr>\n";

    $out .= "<tr>\n";
    $out .= "<td>".__('Choose video', $this->textdomain_name).":</td>\n";
    $out .= "<td>";
    $out .= "<input type=\"file\" name=\"lynkvp_file\" />&nbsp;&nbsp;&nbsp;\n";
    $out .= __('<strong>or</strong>', $this->textdomain_name)." &nbsp;&nbsp;";
    $out .= __('URL', $this->textdomain_name).":&nbsp;&nbsp;http://<input type=\"text\" name=\"lynkvp_url\" style=\"width:400px;\" value=\"".$_POST['lynkvp_url']."\" />";
    $out .= "</td>\n";
    $out .= "</tr>\n";

    $out .= $this->getTypeSelect()."\n";

    $out .= "<tr>\n";
    $out .= "<td>".__('Size', $this->textdomain_name).":</td>";
    $out .= "<td><select name=\"lynkvp_size\">\n";
    $out .= "<option value=\"0\"".$this->setOptionSelected($_POST['lynkvp_size'],'0').">".__('Select size', $this->textdomain_name)."</option>\n";
    $out .= "<!-- Video sizes, one each line -->\n";
    foreach($this->videosizes as $key=>$value) {
     $out .= "<option value=\"".$key."\"".$this->setOptionSelected($_POST['lynkvp_size'],$key).">".$value['width']." x ".$value['height'].$value['note']."</option>\n";
    }
    $out .= "</select></td>\n";
    $out .= "</tr>\n";

    $out .= "</table>\n";

    $out .= "<br />\n";
    $out .= "<input type=\"submit\" name=\"lynkvp_upload\" class=\"button\" value=\"".__('Upload', $this->textdomain_name)."\" />\n";
    $out .= "</form>\n";
    $out .= "</div>\n";
   }

   // ---------
   // ALWAYS DISPLAYED

   // BLOCK Your Videos
   $out .= "<div class=\"wrap\" style=\"text-align:left;padding-bottom:3em;margin-top:2em;\">\n";
   $out .= "<h2>".__('My Videos', $this->textdomain_name)."</h2>\n";

   // Open file and fill array with unserialized data
   if (!is_array($this->vids)) {$this->vids = $this->loadDataText();}

   // If any vids uploaded
   if(is_array($this->vids)) {
    // add JS to manage page;
    $this->adminHead();
    $out .= $this->videoLists('1', $this->vids, 0, $this->options['manage_list_max']);
   }

   $out .= "</div>\n";
  }

  // Note snuff
  if(!empty($this->note)) {
   $this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";
  }

  // If any error, dont display body
  if($this->error>0) {$out = '';}

  // Output
  echo $this->note."\n";
  echo $out."\n";
 }//func

 /*
 * Menu on the write pages
 */
 function editFormAdvanced() {
  global $post_ID;

  // Open file and fill array with unserialized data
  if (!is_array($this->vids)) {$this->vids = unserialize(file_get_contents($this->data_txt));}

  // If any vids uploaded
  if(is_array($this->vids)) {$out .= $this->videoLists('2', $this->vids, 0, $this->options['post_list_max']);}

  $edit_html = "";
  if ($this->is_wp25) {
   $edit_html  = "<div id=\"videopop-plus\" class=\"postbox if-js-closed\">\n";
   $edit_html .= "<h3>".__('My Videos', $this->textdomain_name)."</h3>\n";
   $edit_html .= "<div class=\"inside\">".$out."</div>\n";
   $edit_html .= "</div>\n";
  } else {
   $edit_html  = "<div class=\"dbx-b-ox-wrapper\">\n";
   $edit_html .= "<fieldset id=\"videopop-plus\" class=\"dbx-box\">\n";
   $edit_html .= "<div class=\"dbx-h-andle-wrapper\">\n";
   $edit_html .= "<h3 class=\"dbx-handle\">".__('My Videos', $this->textdomain_name)."</h3>\n";
   $edit_html .= "</div>\n";
   $edit_html .= "<div class=\"dbx-c-ontent-wrapper\">\n";
   $edit_html .= "<div class=\"dbx-content\">".$out."</div>\n";
   $edit_html .= "</div>\n";
   $edit_html .= "</fieldset>\n";
   $edit_html .= "</div>\n";
   $edit_html .= "<div class=\"dbx-b-ox-wrapper\"></div>\n";
  }
  echo $edit_html;
  $this->insertEditorJs();
 }//func

 /*
 * Video Lists
 */
 function videoLists($list_type='1', $vid_list, $start=0, $limit=0) {
  if ($limit==0) {$limit = ($list_type=='1' ? $this->options['manage_list_max'] : $this->options['post_list_max']);}
  if (!is_array($vid_list)) {$vid_list = unserialize(file_get_contents($this->data_txt));}
  $vid_list = array_reverse($vid_list);
  $link_format = '<a href="'.$this->videopop_uri.'?vid=%1$d" title="%2$s" onclick="javascript:VideoPop(%3$d,\'%1$d\');return false;">%4$s</a>';
  $count = 0;
  $next = false;

  $retval  = "<!--- list start --->\n";
  $retval .= "<div id=\"videopop_list\">\n";
  if ($list_type=='1') {
   $retval .= "<form method=\"post\" action=\"".$this->post_action."\">\n";
   $retval .= "<table id=\"VideoLists\" class=\"stats\">";
   $retval .= "<thead><tr>\n";
   $retval .= "<th style=\"text-align:center;\">".__('Name', $this->textdomain_name)."</th>\n";
   $retval .= "<th>".__('Video type', $this->textdomain_name)."</th>\n";
   $retval .= "<th></th>\n";
   $retval .= "</tr></thead>\n";
  } else {
   $retval .= "<table id=\"VideoLists\" style=\"border-collapse:collapse;margin:10px 0;\">";
   $retval .= "<thead><tr>\n";
   $retval .= "<th>&nbsp;</th>\n";
   $retval .= "<th>".__('In line', $this->textdomain_name)."</th>\n";
   $retval .= "<th>".__('Name', $this->textdomain_name)."</th>\n";
   $retval .= "<th>".__('Video type', $this->textdomain_name)."</th>\n";
   $retval .= "</tr></thead>\n";
  }

  $retval .= "<tbody>\n";
  $class = "";
  $root_uri = preg_replace("/^(https?:\/\/[^\/]*\/).*$/i", "$1", trailingslashit(get_settings('siteurl')));
  foreach($vid_list as $key => $a_value) {
   if ($count >= $limit + $start) {
    $next = true;
    break;
   } elseif ($count >= $start) {
    $a_value = $this->stripArray($a_value); // strip slashes
    $src = '../wp-content/videopop/'.$a_value['lynkvp_filename'];
    $is_type = '';
    if(!empty($a_value['lynkvp_url'])) {
     $src = "http://".$a_value['lynkvp_url'];
     $is_type = "<span style=\"font-size:10px;\">URL</span>";
    }
    $retval .= "<tr".$class.">\n";
    if ($list_type=='1') {
     $retval .= "<td>";
     $retval .= "<input type=\"submit\" value=\"".__('edit', $this->textdomain_name)."\" name=\"lynkvp_edit[".$a_value['lynkvp_id']."]\" class=\"button\" style=\"font-size:10px;\" />&nbsp;&nbsp;&nbsp;";
     $retval .= "<input type=\"submit\" value=\"".__('delete', $this->textdomain_name)."\" name=\"lynkvp_del[".$a_value['lynkvp_id']."]\" onclick=\"javascript:check=confirm('".__('The links you created will not work anymore. Delete?', $this->textdomain_name)."');if(check==false) return false;\" class=\"button\" style=\"font-size:10px;\" />&nbsp;&nbsp;&nbsp;";
     $retval .= sprintf($link_format, $a_value['lynkvp_id'], $a_value['lynkvp_title'], $a_value['lynkvp_size'], $a_value['lynkvp_name']).'&nbsp;&nbsp;';
     $retval .= "</td>\n";
     $retval .= "<td>".$a_value['lynkvp_type']."&nbsp;&nbsp;</td>\n";
     $retval .= "<td>".$is_type."&nbsp;&nbsp;</td>\n";
     $retval .= "</tr>\n";
     $class = ($class=='' ? ' class="alt"' : '');
    } else {
     $retval .= "<td><input type=\"submit\" value=\"".__('Add to Editor', $this->textdomain_name)."\" name=\"insert_".$a_value['lynkvp_id']."\"";
     if ($this->options['ins_shortcode'] == '1') {
      $retval .= " onclick=\"javascript:vpInsertAtCursor(";
      $retval .= "vpEditCode('".$a_value['lynkvp_id']."','".$a_value['lynkvp_name']."','".$a_value['lynkvp_caption']."',(inline_".$a_value['lynkvp_id'].".checked==true?true:false))";
      $retval .= ");return false;\"";
     } else {
      $retval .= " onclick='javascript:vpInsertAtCursor(";
      $retval .=  "(inline_".$a_value['lynkvp_id'].".checked==false";
      $retval .= str_replace("<", "<\"+\"", str_replace("=", "=\"+\"", str_replace("&amp;", "&\"+\"amp;", str_replace($root_uri, "/",
                   "?\"".$this->getLinkTag($a_value['lynkvp_id'], $a_value['lynkvp_size'], $a_value['lynkvp_name'], false, "\\"."\"")."\""
                  .":\"".$this->getLinkTag($a_value['lynkvp_id'], $a_value['lynkvp_size'], $a_value['lynkvp_name'], true , "\\"."\"")."\""
                 ))));
      $retval .= "));return false;'";
     }
     $retval .= " class=\"button\" style=\"font-size:10px;\" /></td>\n";
     $retval .= "<td>&nbsp;&nbsp;<input type=\"checkbox\" name=\"inline_".$a_value['lynkvp_id']."\" value=\"\" /></td>\n";
     $retval .= "<td>".sprintf($link_format, $a_value['lynkvp_id'], $a_value['lynkvp_title'], $a_value['lynkvp_size'], $a_value['lynkvp_name'])."&nbsp;&nbsp;</td>\n";
     $retval .= "<td>".$a_value['lynkvp_type']."&nbsp;&nbsp;</td>\n";
    }
    $retval .= "</tr>\n";
   }
   $count++;
  }
  $retval .= "</tbody>\n";
  $retval .= "</table>\n";
  if ($list_type=='1') $retval .= "</form>\n";

  $retval .= "</div>\n";

  $retval .= "<div id=\"videopop_navi\" style=\"width:95%;margin:0 auto;\">";
  $retval .= "<span style=\"float:left;margin-top:-1em;\"><input type=\"submit\" value=\"&laquo; ".__('Prev', $this->textdomain_name)."\" name=\"prev\" id=\"prev\" class=\"button\" style=\"visibility:".($start > 0 ? 'visible' : 'hidden').";\" />&nbsp;&nbsp;</span>";
  $retval .= "<span style=\"float:right;margin-top:-1em;\">&nbsp;&nbsp;<input type=\"submit\" value=\"".__('Next', $this->textdomain_name)." &raquo;\" name=\"next\" id=\"next\" class=\"button\" style=\"visibility:".($next==true ? 'visible' : 'hidden').";\" /></span>";
  $retval .= "</div>\n";
  $retval .= "<!--- list end --->\n";

  $retval .= "<script type=\"text/javascript\"> /*<![CDATA[ */\n";
  $retval .= "jQuery(function(){\n";
  $retval .= " jQuery('#prev').unbind('submit').unbind('click').click(function(){get_page(".$list_type.",  0, ".$limit.");return false;});\n";
  $retval .= " jQuery('#next').unbind('submit').unbind('click').click(function(){get_page(".$list_type.", ".$limit.", ".$limit.");return false;});\n";
  $retval .= " jQuery('#videopop_list').css({height:(jQuery('#VideoLists').height()>180?jQuery('#VideoLists').height():180) + 20});\n";
  $retval .= " function get_page(list_type, start_count, max_count){\n";
  $retval .= "  if (start_count < 0) {start_count = 0;}\n";
  $retval .= "  if (list_type == 1) {\n";
  $retval .= "   jQuery('#VideoLists').children().fadeOut('normal');\n";
  $retval .= "  } else {\n";
  $retval .= "   jQuery('#VideoLists').children().css({visibility:'hidden'});\n";
  $retval .= "  }\n";
  $retval .= "  jQuery('#videopop_navi').fadeOut('normal');\n";
  $retval .= "  jQuery.get(\n";
  $retval .= "    '".$this->post_action."'\n";
  $retval .= "   ,{'get_list':list_type, 'start':start_count}\n";
  $retval .= "   ,function(responseText){\n";
  $retval .= "     var newList_html = responseText.replace(/[\\r\\n]/g,'').replace(/^.*<\\!\\-+ list start \\-+>(.*?)<\\!\\-+ list end \\-+>.*$/i, '$1');\n";
  $retval .= "     jQuery('tbody', jQuery('#VideoLists')).children().remove();\n";
  $retval .= "     jQuery('#videopop_navi').children().remove();\n";
  $retval .= "     jQuery('tbody', jQuery('#VideoLists')).append(jQuery.trim(newList_html.replace(/^.*<tbody.*?>(.*?)<\\/tbody>.*$/i, '$1')));\n";
  $retval .= "     if (list_type == 1) {\n";
  $retval .= "      jQuery('#VideoLists').children().fadeIn('fast');\n";
  $retval .= "     } else {\n";
  $retval .= "      jQuery('#VideoLists').children().css({visibility:'visible'});\n";
  $retval .= "     }\n";
  $retval .= "     jQuery('#videopop_navi').append(jQuery.trim(newList_html.replace(/^.*<div id=\"videopop_navi\".*?>(.*?)<\\/div>.*$/i, '$1'))).fadeIn('fast');\n";
  $retval .= "     jQuery('#prev').unbind('submit').unbind('click').click(function(){get_page(list_type, start_count - max_count, max_count);return false;});\n";
  $retval .= "     jQuery('#next').unbind('submit').unbind('click').click(function(){get_page(list_type, start_count + max_count, max_count);return false;});\n";
  $retval .= "    }\n";
  $retval .= "  );\n";
  $retval .= " }\n";
  $retval .= "});\n";
  $retval .= "/*]]>*/ </script>\n";

  unset($vid_list);
  return $retval;
 }//func

 /*
 * Add menu item to WP admin panel
 */
 function addAdminPrintScripts() {
  // add JS to admin_head
  if ( preg_match('/(post|page)(\-new)?\.php/i', $_SERVER['PHP_SELF'])
    OR preg_match('/'.preg_quote(strtolower($this->admin_post)).'/i', $_GET['page']) ){
   wp_enqueue_script('jquery');
  }
 }//func

 function addAdminMenu() {
  // Upload and Adminstration
  add_options_page(__('VideoPop+', $this->textdomain_name), __('VideoPop+', $this->textdomain_name), 9, $this->admin_option, array($this,'optionPage'));
  add_submenu_page('edit.php', __('My Videos', $this->textdomain_name), __('My Videos', $this->textdomain_name), $this->options['user_lvl'], $this->admin_post, array($this,'manageVideoPopPlusFiles'),1);

  if (preg_match('/(post|page)(\-new)?\.php/i', $_SERVER['PHP_SELF'])){
   // add JS to admin_head
   add_action('admin_head',array($this,'adminHead'));

   // add Menu on the Write Pages
   add_action('dbx_post_advanced', array($this, 'editFormAdvanced'));
   add_action('dbx_page_advanced', array($this, 'editFormAdvanced'));
  }
 }//func
}//class

// Go, Go, Go!
$VideoPopPlus = & new VideoPopPlus();

add_action('admin_print_scripts', array(&$VideoPopPlus,'addAdminPrintScripts'));
add_action('admin_menu', array(&$VideoPopPlus,'addAdminMenu'));

add_action('wp_print_scripts', array(&$VideoPopPlus, 'addLightPopScripts'));
add_action('wp_head',array(&$VideoPopPlus, 'addWpHead'));
add_action('wp_footer',array(&$VideoPopPlus, 'addWpFooter'));
add_filter('css_elements/wp-lightpop.php',array(&$VideoPopPlus, 'addLightPopElements'));

if (function_exists('add_shortcode')) {add_shortcode('videopop', array(&$VideoPopPlus, 'shortcodeHandler'));}
add_filter('the_content', array(&$VideoPopPlus, 'addContentFilter'));

unset($VideoPopPlus);
?>