<?php
/* これは文字化け防止のための日本語文字列です。
   このソースファイルは UTF-8 で保存されています。
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with UTF-8.
 */

/* ==================================================
 *   Ktai_Services class
   ================================================== */

define ('KS_DEFAULT_CHARSET', 'SJIS');
define ('KS_MAX_PAGE_NUM', 1000);
define ('KS_START_PAGING', '<!--start paging-->');
define ('KS_END_PAGING', '<!--end paging-->');

class Ktai_Services {
	protected $theme;
	protected $user_agent;
	protected $operator   = 'Unknown';
	protected $type       = 'N/A';
	protected $flat_rate  = TRUE;
	protected $image_inline = TRUE;
	protected $image_inline_default = TRUE;
	protected $term_name  = 'N/A';
	protected $term_ID    = '';
	protected $usim_ID    = '';
	protected $sub_ID     = '';
	protected $page_size  = 50000;
	protected $cache_size = 524288;
	protected $charset    = 'SJIS-win';
	protected $mime_type  = 'text/html';
	protected $preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">';
	protected $allowedtags;
 	// http://www.au.kddi.com/ezfactory/tec/spec/4_4.html
	// http://developers.softbankmobile.co.jp/dp/tool_dl/web/picword_top.php
	// http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/
	// http://www.willcom-inc.com/ja/service/contents_service/club_air_edge/for_phone/homepage/pdf/contents_reference.pdf
	// http://emobile.jp/tech/emoji_list.pdf
	private static $trans;
	static public $pics = array(
		'1'     => '[!]', 
		'2'     => '!', 
		'3'     => '?', 
		'4'     => 'Q', 
		'5'     => '＜', 
		'6'     => '＞', 
		'7'     => '≪', 
		'8'     => '≫', 
		'9'     => '□', 
		'10'    => '■', 
		'11'    => '[i]', 
		'12'    => '[ワイングラス]', 
		'13'    => '[スピーカー]', 
		'14'    => '$', 
		'15'    => '[月]', 
		'16'    => '[稲妻]', 
		'17'    => '□', 
		'18'    => '■', 
		'19'    => '◇', 
		'20'    => '◆', 
		'21'    => '□', 
		'22'    => '■', 
		'23'    => '◇', 
		'24'    => '◆', 
		'25'    => '[腕時計]', 
		'26'    => '+', 
		'27'    => '-', 
		'28'    => '☆', 
		'29'    => '↑', 
		'30'    => '↓', 
		'31'    => '[禁止]', 
		'32'    => '▽', 
		'33'    => '△', 
		'34'    => '▼', 
		'35'    => '▲', 
		'36'    => '◇', 
		'37'    => '◆', 
		'38'    => '□', 
		'39'    => '■', 
		'40'    => '○', 
		'41'    => '●', 
		'42'    => '[左上]', 
		'43'    => '[右下]', 
		'44'    => '[晴れ]', 
		'45'    => '[野球]', 
		'46'    => '[時計]', 
		'47'    => '[月]', 
		'48'    => '[ベル]', 
		'49'    => '[画鋲]', 
		'50'    => "('')", // 小顔
		'51'    => '&hearts;', // ハート
		'52'    => '[マティーニ]', 
		'53'    => '[四つ葉]', 
		'54'    => '&trade;', 
		'55'    => '×', // かける
		'56'    => '[文書]', 
		'57'    => '[砂時計]', 
		'58'    => '[砂時計]', 
		'59'    => '[フロッピー]', 
		'60'    => '[雪の結晶]', 
		'61'    => '×', // バツ1
		'62'    => '×', // バツ2 
		'63'    => '→', 
		'64'    => '→', 
		'65'    => '[マグカップ]', 
		'66'    => '÷', 
		'67'    => '[カレンダー]', 
		'68'    => "(^_^)",  // スマイルフェイス
		'69'    => '☆', // 星2
		'70'    => '[右上]', 
		'71'    => '[左下]', 
		'72'    => '[指輪]', 
		'73'    => 'レ', // チェックマーク1
		'74'    => '[プードル]', 
		'75'    => '☆', //星3
		'76'    => '‡', // スパーク
		'77'    => '[電球]', 
		'78'    => '[鳥]', 
		'79'    => '[閉フォルダ]', 
		'80'    => "('_')", // 顔
		'81'    => '&copy;', 
		'82'    => '&reg;', 
		'83'    => '[ブリーフケース]', 
		'84'    => '[開フォルダ]', 
		'85'    => '[電話]', 
		'86'    => '[吹き出し]', 
		'87'    => '[クレジットカード]', 
		'88'    => '△', 
		'89'    => '▽', 
		'90'    => '[アメリカ]', 
		'91'    => '[ノート]', 
		'92'    => '[クリップボード]', 
		'93'    => '[カップ]', 
		'94'    => '[カメラ]', 
		'95'    => '[雨]', 
		'96'    => '[フットボール]', 
		'97'    => '[本]', 
		'98'    => '[立ち入り禁止]', 
		'99'    => '[信号]', 
		'100'   => '[本]', 
		'101'   => '[本]', 
		'102'   => '[本]', 
		'103'   => '[文書]', 
		'104'   => '[はさみ]', 
		'105'   => '[カレンダー]', 
		'106'   => '[チケット]', 
		'107'   => '[くもり]', 
		'108'   => '[封筒]', 
		'109'   => '[￥]', 
		'110'   => '[ビデオカメラ]', 
		'111'   => '[ハンディカム]', 
		'112'   => '[家]', 
		'113'   => '[チューリップ]', 
		'114'   => '[ナイフ]', 
		'115'   => '[ビデオテープ]', 
		'116'   => '[眼鏡]', 
		'117'   => '└→', // 回り矢印1
		'118'   => '←┘', // 回り矢印2 
		'119'   => '[虫眼鏡]', 
		'120'   => '[鍵]', 
		'121'   => '[ノート]', 
		'122'   => '[開ノート]', 
		'123'   => '[ボルトとナット]', 
		'124'   => '[ハイヒール]', 
		'125'   => '[車]', 
		'126'   => '[フロッピー]', 
		'127'   => '[棒グラフ]', 
		'128'   => '[折れ線グラフ]', 
		'129'   => '[メールボックス]', 
		'130'   => '[懐中電灯]', 
		'131'   => '[Roldex]', 
		'132'   => 'レ', // チェックマーク2
		'133'   => '[紅葉]', 
		'134'   => '[犬]', 
		'135'   => '[電池]', 
		'136'   => '[スクロール]', 
		'137'   => '[画鋲]', 
		'138'   => '[錠前]', 
		'139'   => '[ドル札]', 
		'140'   => '←', // 指差し確認左
		'141'   => '→', // 指差し確認右 
		'142'   => '[台帳]', 
		'143'   => '[クリップ]', 
		'144'   => '[プレゼント]', 
		'145'   => '[名札]', 
		'146'   => '[レストラン]', 
		'147'   => '[本]', 
		'148'   => '[トラック]', 
		'149'   => '[鉛筆]', 
		'150'   => '[IDO社]', 
		'151'   => '[封筒]', 
		'152'   => '[レンチ]', 
		'153'   => '[送信 BOX]', 
		'154'   => '[受信 BOX]', 
		'155'   => '[受話器]', 
		'156'   => '[建物]', 
		'157'   => '[定規]', 
		'158'   => '[三角定規]', 
		'159'   => '[グラフ]', 
		'160'   => '[マンガ肉]', 
		'161'   => '[携帯電話]', 
		'162'   => '[コンセント]', 
		'163'   => '[家族]', 
		'164'   => '[リンク]', 
		'165'   => '[パッケージ]', 
		'166'   => '[FAX]', 
		'167'   => '[ときどき曇り]', 
		'168'   => '[飛行機]', 
		'169'   => '[ボート]', 
		'170'   => '[サイコロ]', 
		'171'   => '[新聞]', 
		'172'   => '[電車]', 
		'173'   => '　', // 全部ブランク
		'174'   => ' ',  // 半分ブランク
		'175'   => ' ',  // 1/4ブランク
		'176'   => '[喫煙]', 
		'177'   => '[禁煙]', 
		'178'   => '[車椅子]', 
		'179'   => '[初心者]', 
		'180'   => '1', 
		'181'   => '2', 
		'182'   => '3', 
		'183'   => '4', 
		'184'   => '5', 
		'185'   => '6', 
		'186'   => '7', 
		'187'   => '8', 
		'188'   => '9', 
		'189'   => '10', 
		'190'   => '[台風]', 
		'191'   => '[雪]', 
		'192'   => '[牡羊座]', 
		'193'   => '[牡牛座]', 
		'194'   => '[双子座]', 
		'195'   => '[蟹座]', 
		'196'   => '[獅子座]', 
		'197'   => '[乙女座]', 
		'198'   => '[天秤座]', 
		'199'   => '[蠍座]', 
		'200'   => '[射手座]', 
		'201'   => '[山羊座]', 
		'202'   => '[水瓶座]', 
		'203'   => '[魚座]', 
		'204'   => '[蛇遣座]', 
		'205'   => '[ATM]', 
		'206'   => '[コンビニ]', 
		'207'   => '[トイレ]', 
		'208'   => '[駐車場]', 
		'209'   => '[バス停]', 
		'210'   => '[位置情報]', 
		'211'   => '[錨]', 
		'212'   => '[銀行]', 
		'213'   => '[ガススタンド]', 
		'214'   => '[地図]', 
		'215'   => '[自転車]', 
		'216'   => '[バス]', 
		'217'   => '[新幹線]', 
		'218'   => '[マラソン]', 
		'219'   => '[サッカー]', 
		'220'   => '[テニス]', 
		'221'   => '[スノーボード]', 
		'222'   => '[チェッカーフラッグ]', 
		'223'   => '[遊園地]', 
		'224'   => '[温泉]', 
		'225'   => '[赤ちょうちん]', 
		'226'   => '[映画]', 
		'227'   => '[夜の橋]', 
		'228'   => '[東京タワー]', 
		'229'   => '[スロット]', 
		'230'   => '[くす玉]', 
		'231'   => '[当選弓矢]', 
		'232'   => '[ゲーム]', 
		'233'   => '($)', // 賞金 
		'234'   => '[クリスマスツリー]', 
		'235'   => '[花見]', 
		'236'   => '[お化け]', 
		'237'   => '[日本]', 
		'238'   => '[西瓜]', 
		'239'   => '[ケーキ]', 
		'240'   => '[フライパン]', 
		'241'   => '[さくらんぼ]', 
		'242'   => '[河豚]', 
		'243'   => '[苺]', 
		'244'   => '[おにぎり]', 
		'245'   => '[ハンバーガー]', 
		'246'   => '[鯨]', 
		'247'   => '[兎]', 
		'248'   => '[馬]', 
		'249'   => '[猿]', 
		'250'   => '[蛙]', 
		'251'   => '[猫]', 
		'252'   => '[ペンギン]', 
		'253'   => '[蟻]', 
		'254'   => '[豚]', 
		'255'   => '[椰子の木]', 
		'256'   => '[向日葵]', 
		'257'   => "(^_^)", // うれしい顔
		'258'   => "(`_')", // おこった顔
		'259'   => "(;_;)", // かなしい顔
		'260'   => "(+_+)", // つかれた顔
		'261'   => '[Zzz]', // 眠い (ZZZ...)
		'262'   => '[ムカッ]', 
		'263'   => '[雫]', 
		'264'   => "(^j^)", // からかう (あっかんべえ) 
		'265'   => '[失恋]', 
		'266'   => '&hearts;&hearts;', // ハート3 (大きい&小さい)
		'267'   => '‡', // スパーク2 (キラリマーク)
		'268'   => '●〜', // 爆弾
		'269'   => '[炎]', 
		'270'   => '[SOS]', 
		'271'   => '[力こぶ]', 
		'272'   => '→&hearts;', // ハート5 (矢がささっている)
		'273'   => '[キスマーク]', 
		'274'   => '[宇宙人]', 
		'275'   => '[なると]', 
		'276'   => '[足跡]', 
		'277'   => '[悪魔]', 
		'278'   => '[花丸]', 
		'279'   => '[秘]', 
		'280'   => '[100点満点]', 
		'281'   => '[パンチ]', 
		'282'   => '=3', // ダッシュ
		'283'   => '[ウンチ]', 
		'284'   => '[人差し指サイン]', 
		'285'   => '[マル得]', 
		'286'   => '[ドクロ]', 
		'287'   => '[親指サイン]', 
		'288'   => '[テレビ]', 
		'289'   => '[マイク]', 
		'290'   => '[財布]', 
		'291'   => '&#9835;', // メロディ
		'292'   => '[ギター]', 
		'293'   => '[バイオリン]', 
		'294'   => '[ヘッドフォン]', 
		'295'   => '[口紅]', 
		'296'   => '[ピストル]', 
		'297'   => '[エステ]', 
		'298'   => '[EZ マーク]', 
		'299'   => '[FREE]', 
		'300'   => '[CD/DVD]', 
		'301'   => '[婦人服]', 
		'302'   => '[UFO]', 
		'303'   => '[更新!]', 
		'304'   => '[注射器]', 
		'305'   => '[霧]', 
		'306'   => '[ゴルフ]', 
		'307'   => '[バスケットボール]', 
		'308'   => '[ページャー]', 
		'309'   => '[アート]', 
		'310'   => '[演劇]', 
		'311'   => '[イベント]', 
		'312'   => '[リボン]', 
		'313'   => '[バースデー]', 
		'314'   => '&spades;', 
		'315'   => '&diams;', 
		'316'   => '&clubs;', 
		'317'   => '[目]', 
		'318'   => '[耳]', 
		'319'   => '[チョキ]', 
		'320'   => '[パー]', 
		'321'   => '●', 
		'322'   => '[やや欠け月]', 
		'323'   => '[半月]', 
		'324'   => '[クリア]', 
		'325'   => '0', 
		'326'   => '[OK]', 
		'327'   => "(xox)", // ふらふら
		'328'   => '&hearts;', // かわいい
		'329'   => 'Σ3', // どんっ, 
		'330'   => ';;', // あせあせ
		'331'   => '[ezplus]', 
		'332'   => '[地球]', 
		'333'   => '[ラーメン]', 
		'334'   => '[NEW]', 
		'335'   => '[シャツ]', 
		'336'   => '[靴]', 
		'337'   => '[パソコン]', 
		'338'   => '[ラジオ]', 
		'339'   => '[薔薇]', 
		'340'   => '[チャペル]', 
		'341'   => '[地下鉄]', 
		'342'   => '[富士山]', 
		'343'   => '♪', // 八分音符
		'344'   => '[天使]', 
		'345'   => '[虎]', 
		'346'   => '[熊]', 
		'347'   => '[鼠]', 
		'348'   => "('_-)", // ウィンク
		'349'   => "(*_*)", // 目がハート
		'350'   => ")@_@(", // ショッキング
		'351'   => ";-.-)", // 困り
		'352'   => '[蛸]', 
		'353'   => '[ロケット]', 
		'354'   => '[王冠]', 
		'355'   => '[チュー]', 
		'356'   => '[ハンマー]', 
		'357'   => '[打ち上げ花火]', 
		'358'   => '[枯れ葉]', 
		'359'   => '[仕事かばん]', 
		'360'   => '[噴水]', 
		'361'   => '[キャンプ]', 
		'362'   => '[麻雀]', 
		'363'   => '[VS]', 
		'364'   => '[トロフィー]', 
		'365'   => '[亀]', 
		'366'   => '[スペイン]', 
		'367'   => '[ロシア]', 
		'368'   => '[工事中]', 
		'369'   => '[風呂]', 
		'370'   => '[祝日]', 
		'371'   => '[夕方街並み]', 
		'372'   => '[卵割り]', 
		'373'   => '[株価]', 
		'374'   => '[警察官]', 
		'375'   => '〒', 
		'376'   => '[病院]', 
		'377'   => '[学校]', 
		'378'   => '[ホテル]', 
		'379'   => '[船]', 
		'380'   => '[18禁]', 
		'381'   => '[圏内]', 
		'382'   => '[COOL!]', 
		'383'   => '[割]', 
		'384'   => '[サ]', 
		'385'   => '[ID]', 
		'386'   => '[満席]', 
		'387'   => '[空席]', 
		'388'   => '[指]', 
		'389'   => '[営]', 
		'390'   => '↑', // 上指差し
		'391'   => '↓', // 下指差し
		'392'   => '[占い]', 
		'393'   => '[マナーモード]', 
		'394'   => '[電源OFF]', 
		'395'   => '[メモ]', 
		'396'   => '[ネクタイ]', 
		'397'   => '[ハイビスカス]', 
		'398'   => '[花束]', 
		'399'   => '[サボテン]', 
		'400'   => '[お銚子]', 
		'401'   => '[ビールで乾杯]', 
		'402'   => '[祝]', 
		'403'   => '[カプセル薬]', 
		'404'   => '[風船]', 
		'405'   => '[クラッカー]', 
		'406'   => '[eznavi]', 
		'407'   => '[帽子]', 
		'408'   => '[ロングブーツ]', 
		'409'   => '[ネイル]', 
		'410'   => '[美容院]', 
		'411'   => '[床屋]', 
		'412'   => '[着物]', 
		'413'   => '[ビキニ]', 
		'414'   => '&hearts;', // ハート (トランプ)
		'415'   => '&hearts;', // 光るハート
		'416'   => '&hearts;', // 青ハート
		'417'   => '&hearts;', // 緑ハート
		'418'   => '&hearts;', // 黄ハート
		'419'   => '&hearts;', // 紫ハート
		'420'   => '†', // きらきら
		'421'   => '[スキー]', 
		'422'   => '○', // ○
		'423'   => '[日本茶]', 
		'424'   => '[食パン]', 
		'425'   => '[ソフトクリーム]', 
		'426'   => '[ポテト]', 
		'427'   => '[団子]', 
		'428'   => '[煎餅]', 
		'429'   => '[御飯]', 
		'430'   => '[スパゲティ]', 
		'431'   => '[カレー]', 
		'432'   => '[おでん]', 
		'433'   => '[寿司]', 
		'434'   => '[林檎]', 
		'435'   => '[蜜柑]', 
		'436'   => '[トマト]', 
		'437'   => '[茄子]', 
		'438'   => '[弁当]', 
		'439'   => '[鍋]', 
		'440'   => "(-」-)", // ふっ
		'441'   => "(v_v)", // しょんぼり
		'442'   => "^^.^^", // 勝ち誇り
		'443'   => "(x~x)", // 失敗 
		'444'   => "(?_?)", // わからん
		'445'   => "(~_~)", // 眠い
		'446'   => "(*_*)", // てれてれ
		'447'   => "(ToT)", // 青ざめ
		'448'   => "(#□#)", // 風邪ひき
		'449'   => "(#_#)", // 熱 
		'450'   => "(→_→)", // 横目
		'451'   => "(@_@)", // びっくり
		'452'   => "(:_;;", //あせり
		'453'   => '♪♯',  // 楽譜
		'454'   => "(^o^)", // にこにこ
		'455'   => "(~3~)", // チュー 2
		'456'   => "(^3^)", // チュッ
		'457'   => '[鼻]', 
		'458'   => '[口]', 
		'459'   => '[ゴメン]', 
		'460'   => '[拍手]', 
		'461'   => '[OK!]', // 指で丸サイン
		'462'   => '[ブーイング]', // 親指を下
		'463'   => '[バイバイ]', 
		'464'   => '[NG]', 
		'465'   => '[OK!]', 
		'466'   => "m(__)m", // 平謝り 
		'467'   => '[カップル]', 
		'468'   => '[バニー]', 
		'469'   => '[トランペット]', 
		'470'   => '[ビリヤード]', 
		'471'   => '[水泳]', 
		'472'   => '[消防車]', 
		'473'   => '[救急車]', 
		'474'   => '[パトカー]', 
		'475'   => '[ローラーコースター]', 
		'476'   => '[門松]', 
		'477'   => '[雛祭り]', 
		'478'   => '[卒業式]', 
		'479'   => '[入学式]', 
		'480'   => '[鯉のぼり]', 
		'481'   => '[傘]', 
		'482'   => '[花嫁]', 
		'483'   => '[かき氷]', 
		'484'   => '[線香花火]', 
		'485'   => '[巻き貝]', 
		'486'   => '[風鈴]', 
		'487'   => '[ハロウィン]', 
		'488'   => '[お月見]', 
		'489'   => '[サンタクロース]', 
		'490'   => '[夜]', 
		'491'   => '[虹]', 
		'492'   => '[ラブホテル]', 
		'493'   => '[日の出]', 
		'494'   => '[シルクハット]', 
		'495'   => '[デパート]', 
		'496'   => '[天守閣]', 
		'497'   => '[城]', 
		'498'   => '[工場]', 
		'499'   => '[フランス]', 
		'500'   => '[オープンウェーブ]', 
		'501'   => '[ロック確認]', 
		'502'   => '[大文字]', 
		'503'   => '[小文字]', 
		'504'   => '[数字]', 
		'505'   => '[記号]', 
		'506'   => '[受領]', 
		'507'   => 'レ', // チェックボックス
		'508'   => '[ペン]', 
		'509'   => '◎', // ラジオボタン
		'510'   => '[虫眼鏡]', 
		'511'   => '[戻る]', 
		'512'   => '[お気に入り]', 
		'513'   => '[終了]', 
		'514'   => '[ホーム]', 
		'515'   => '[受信箱]', 
		'516'   => '□', // マーク
		'517'   => '[個人用]', 
		'518'   => '[再読み込み]', 
		'700'   => '[ドイツ]', 
		'701'   => '[イタリア]', 
		'702'   => '[イギリス]', 
		'703'   => '[中国]', 
		'704'   => '[韓国]', 
		'705'   => '[白人]', 
		'706'   => '[中国人]', 
		'707'   => '[インド人]', 
		'708'   => '[おじいさん]', 
		'709'   => '[おばあさん]', 
		'710'   => '[赤ちゃん]', 
		'711'   => '[工事現場の人]', 
		'712'   => '[お姫様]', 
		'713'   => '[イルカ]', 
		'714'   => '[ダンス]', 
		'715'   => '[熱帯魚]', 
		'716'   => '[毛虫]', 
		'717'   => '[象]', 
		'718'   => '[コアラ]', 
		'719'   => '[ホルスタイン]', 
		'720'   => '[蛇]', 
		'721'   => '[鶏]', 
		'722'   => '[猪]', 
		'723'   => '[ラクダ]', 
		'724'   => '[A型]', 
		'725'   => '[B型]', 
		'726'   => '[O型]', 
		'727'   => '[AB型]', 
		'728'   => '[足跡]', 
		'729'   => '[スニーカー]', 
		'730'   => '[旗]', 
		'731'   => '↑', // 上向きカーブ矢印
		'732'   => '↓', // 下向きカーブ矢印
		'733'   => '!?', 
		'734'   => '!!', 
		'735'   => '-o-', // くるり
		'736'   => '[メロン]', 
		'737'   => '[パイナップル]', 
		'738'   => '[葡萄]', 
		'739'   => '[バナナ]', 
		'740'   => '[とうもろこし]', 
		'741'   => '[キノコ]', 
		'742'   => '[栗]', 
		'743'   => '[桃]', 
		'744'   => '[焼き芋]', 
		'745'   => '[ピザ]', 
		'746'   => '[ターキー]', 
		'747'   => '[七夕笹飾り]', 
		'748'   => '[トロピカルドリンク]', 
		'749'   => '[辰]', 
		'750'   => '[ピアノ]', 
		'751'   => '[サーフィン]', 
		'752'   => '[釣り]', 
		'753'   => '[ボウリング]', 
		'754'   => '[なまはげ]', 
		'755'   => '[天狗]', 
		'756'   => '[パンダ]', 
		'757'   => ':-P', // あかんべー (舌)
		'758'   => '[豚の鼻]', 
		'759'   => '[花]', 
		'760'   => '[アイスクリーム]', 
		'761'   => '[ドーナツ]', 
		'762'   => '[クッキー]', 
		'763'   => '[チョコ]', 
		'764'   => '[包みキャンディ]', 
		'765'   => '[ぺろぺろキャンディ]', 
		'766'   => '(/_＼)',            // 見ざる (猿)
		'767'   => '(・x・)',           // 言わざる (猿)
		'768'   => '|(・_・)|',         // 聞かざる (猿)
		'769'   => '[火山]', 
		'770'   => '[リボンがけのハート]', 
		'771'   => '[ABC]', 
		'772'   => '[プリン]', 
		'773'   => '[蜜蜂]', 
		'774'   => '[テントウムシ]', 
		'775'   => '[蜂蜜ポット]', 
		'776'   => '[青林檎]', 
		'777'   => '[羽のはえたお札]', 
		'778'   => "(@_@)", // 目がまわる時の記号 
		'779'   => "(`_`)", // ぷー
		'780'   => "(`_`)", // ぷー (ネコ)
		'781'   => '[天の川]', 
		'782'   => "(^3^)", // チュー (ネコ)
		'783'   => "(^-^)", // にこ (ネコ)
		'784'   => '[メールする]', 
		'785'   => "(T^T)", // 泣き笑い (ネコ)
		'786'   => "(T^T)", // 泣き笑い
		'787'   => "(*_*)", // 目がハート (ネコ)
		'788'   => "('o')", // ほえー (ネコ)
		'789'   => "('o')", // ほえー
		'790'   => "(-_;)", // 涙ぽろり 
		'791'   => "(-_;)", // 涙ぽろり (ネコ)
		'792'   => "(-v-)", // きりり (ネコ) 
		'793'   => '[ドレス]', 
		'794'   => '[モヤイ像]', 
		'795'   => '[駅]', 
		'796'   => '[花札]', 
		'797'   => '[ジョーカー]', 
		'798'   => '[エビフライ]', 
		'799'   => '[eメール]', 
		'800'   => '[歩く人]', 
		'801'   => '[パトカーのランプ]', 
		'802'   => '[ezmovie]', 
		'803'   => '[ドキドキハート]', 
		'804'   => '[正面向きのひよこ]', 
		'805'   => '[ジーンズ]', 
		'806'   => '[ラブレター]', 
		'807'   => '[循環矢印]', 
		'808'   => '⇔', 
		'809'   => '↑↓', 
		'810'   => '[荒波]', 
		'811'   => '[双葉]', 
		'812'   => '[かたつむり]', 
		'813'   => "(^◇^)", //うっしっし (ネコ)
		'814'   => "(^◇^)", //うっしっし 
		'815'   => '[Cメール]', 
		'816'   => '[ハーブ]', 
		'817'   => '[グー]', 
		'818'   => '#', 
		'819'   => "!('')", // 挙手 (キャラ)
		'820'   => "!(^^)!", // 万歳 (キャラ)
		'821'   => "(v_v)", // しょんぼり (キャラ)
		'822'   => "(`^`)", // かわいく怒る (キャラ) 
		'se001' => "(^_^)", // 男の子
		'se002' => "(^^)", // 女の子
		'se003' => '[キス]', 
		'se004' => "('_')", // お父さん
		'se005' => "('')", // お母さん 
		'se006' => '[洋服]', 
		'se007' => '[ブーツ]', 
		'se008' => '[カメラ]', 
		'se009' => '[電話]', 
		'se00a' => '[携帯電話]', 
		'se00b' => '[FAX]', 
		'se00c' => '[パソコン]', 
		'se00d' => '[パンチ]', 
		'se00e' => '[GOOD!]', 
		'se00f' => '[No.1!]', 
		'se010' => '[グー]', 
		'se011' => '[チョキ]', 
		'se012' => '[パー]', 
		'se013' => '[スキー]', 
		'se014' => '[ゴルフ]', 
		'se015' => '[テニス]', 
		'se016' => '[野球]', 
		'se017' => '[サーフィン]', 
		'se018' => '[サッカー]', 
		'se019' => '[魚]', 
		'se01a' => '[馬]', 
		'se01b' => '[車]', 
		'se01c' => '[ヨット]', 
		'se01d' => '[飛行機]', 
		'se01e' => '[電車]', 
		'se01f' => '[新幹線]', 
		'se020' => '?', 
		'se021' => '!', 
		'se022' => '&hearts;', // ハート
		'se023' => '[失恋]', 
		'se024' => '[1時]', 
		'se025' => '[2時]', 
		'se026' => '[時計]', 
		'se027' => '[4時]', 
		'se028' => '[5時]', 
		'se029' => '[6時]', 
		'se02a' => '[7時]', 
		'se02b' => '[8時]', 
		'se02c' => '[9時]', 
		'se02d' => '[10時]', 
		'se02e' => '[11時]', 
		'se02f' => '[12時]', 
		'se030' => '[お花見]', 
		'se031' => '[エンブレム]', 
		'se032' => '[バラ]', 
		'se033' => '[クリスマス]', 
		'se034' => '[指輪]', 
		'se035' => '[宝石]', 
		'se036' => '[家]', 
		'se037' => '[教会]', 
		'se038' => '[ビル]', 
		'se039' => '[駅]', 
		'se03a' => '[ガソリンスタンド]', 
		'se03b' => '[山]', 
		'se03c' => '[マイク]', 
		'se03d' => '[映画]', 
		'se03e' => '[音楽]', 
		'se03f' => '[カギ]', 
		'se040' => '[サックス]', 
		'se041' => '[ギター]', 
		'se042' => '[トランペット]', 
		'se043' => '[レストラン]', 
		'se044' => '[カクテル]', 
		'se045' => '[コーヒー]', 
		'se046' => '[ケーキ]', 
		'se047' => '[ビール]', 
		'se048' => '[雪]', 
		'se049' => '[曇り]', 
		'se04a' => '[晴れ]', 
		'se04b' => '[雨]', 
		'se04c' => '[月]', 
		'se04d' => '[朝]', 
		'se04e' => '[天使]', 
		'se04f' => '[猫]', 
		'se050' => '[虎]', 
		'se051' => '[熊]', 
		'se052' => '[犬]', 
		'se053' => '[鼠]', 
		'se054' => '[鯨]', 
		'se055' => '[ペンギン]', 
		'se056' => "(^_^)", // 楽 (顔) 
		'se057' => "(^o^)", // 喜 (顔)
		'se058' => "(v_v)", // 哀 (顔) 
		'se059' => "(`_`)", // 怒 (顔) 
		'se05a' => '[ウンチ]', 
		'se101' => '[メール受信]', 
		'se102' => '[メール送信]', 
		'se103' => '[メール宛先]', 
		'se104' => '[電話連絡先]', 
		'se105' => "(^i^)", // アカンベー
		'se106' => "(*_*)", // ラブラブ 
		'se107' => "(@_@)", // ガビーン
		'se108' => "(-_-;", // タラー
		'se109' => '[猿]', 
		'se10a' => '[蛸]', 
		'se10b' => '[豚]', 
		'se10c' => '[宇宙人]', 
		'se10d' => '[ロケット]', 
		'se10e' => '[王冠]', 
		'se10f' => '[電球]', 
		'se110' => '[四つ葉]', 
		'se111' => '[キス]', 
		'se112' => '[プレゼント]', 
		'se113' => '[ピストル]', 
		'se114' => '[虫眼鏡]', 
		'se115' => '[陸上]', 
		'se116' => '[オークション]', 
		'se117' => '[花火]', 
		'se118' => '[もみじ]', 
		'se119' => '[落ち葉]', 
		'se11a' => '[悪魔]', 
		'se11b' => '[お化け]', 
		'se11c' => '[ドクロ]', 
		'se11d' => '[ファイヤー]', 
		'se11e' => '[かばん]', 
		'se11f' => '[座席]', 
		'se120' => '[ハンバーガー]', 
		'se121' => '[公園]', 
		'se122' => '[キャンプ場]', 
		'se123' => '[温泉]', 
		'se124' => '[遊園地]', 
		'se125' => '[チケット]', 
		'se126' => '[CD]', 
		'se127' => '[DVD]', 
		'se128' => '[ラジオ]', 
		'se129' => '[ビデオ]', 
		'se12a' => '[テレビ]', 
		'se12b' => '[ゲーム]', 
		'se12c' => '&#12349;', // 歌い出し
		'se12d' => '[マージャン]', 
		'se12e' => '[VS]', 
		'se12f' => '($)', // ドル袋 
		'se130' => '[当たり]', 
		'se131' => '[トロフィー]', 
		'se132' => '[チェッカーフラッグ]', 
		'se133' => '[スロット]', 
		'se134' => '[競馬]', 
		'se135' => '[競艇]', 
		'se136' => '[競輪]', 
		'se137' => '[工事中]', 
		'se138' => '♂', // 男性
		'se139' => '♀', // 女性
		'se13a' => '[乳幼児]', 
		'se13b' => '[注射器]', 
		'se13c' => '[Zzz]', 
		'se13d' => '[雷]', 
		'se13e' => '[ハイヒール]', 
		'se13f' => '[入浴]', 
		'se140' => '[トイレ]', 
		'se141' => '[音声]', 
		'se142' => '[お知らせ]', 
		'se143' => '[祝日]', 
		'se144' => '[ロックON]', 
		'se145' => '[ロックOFF]', 
		'se146' => '[街]', 
		'se147' => '[卵]', 
		'se148' => '[本]', 
		'se149' => '[為替相場]', 
		'se14a' => '[株価]', 
		'se14b' => '[パラボラ]', 
		'se14c' => '[力こぶ]', 
		'se14d' => '[銀行]', 
		'se14e' => '[信号]', 
		'se14f' => '[駐車場]', 
		'se150' => '[バス停]', 
		'se151' => '[公衆トイレ]', 
		'se152' => '[交番]', 
		'se153' => '〒', 
		'se154' => '[ATM]', 
		'se155' => '[病院]', 
		'se156' => '[コンビニ]', 
		'se157' => '[学校]', 
		'se158' => '[ホテル]', 
		'se159' => '[バス]', 
		'se15a' => '[タクシー]', 
		'se201' => '[徒歩]', 
		'se202' => '[船]', 
		'se203' => '[ココ]', 
		'se204' => '&#10070;', // 飾罫1
		'se205' => '&#10070;', // 飾罫2 
		'se206' => '&#10070;', // 飾罫3
		'se207' => '[18禁]', 
		'se208' => '[禁煙]', 
		'se209' => '[初心者]', 
		'se20a' => '[車椅子]', 
		'se20b' => '[.i|]', // アンテナ
		'se20c' => '&hearts;', 
		'se20d' => '&diams;', 
		'se20e' => '&spades;', 
		'se20f' => '&clubs;', 
		'se210' => '#', // シャープダイヤル
		'se211' => '[フリーダイヤル]', 
		'se212' => '[新着]', 
		'se213' => '[更新]', 
		'se214' => '[COOL]', 
		'se215' => '[有料]', 
		'se216' => '[無料]', 
		'se217' => '[月額]', 
		'se218' => '[申し込み]', 
		'se219' => '●', // 見出しボタン1
		'se21a' => '◎', // 見出しボタン2
		'se21b' => '◎', // 見出しボタン3
		'se21c' => '1', 
		'se21d' => '2', 
		'se21e' => '3', 
		'se21f' => '4', 
		'se220' => '5', 
		'se221' => '6', 
		'se222' => '7', 
		'se223' => '8', 
		'se224' => '9', 
		'se225' => '0', 
		'se226' => '[得]', 
		'se227' => '[割]', 
		'se228' => '[サ]', 
		'se229' => '[ID]', 
		'se22a' => '[満席]', 
		'se22b' => '[空席]', 
		'se22c' => '[指]', 
		'se22d' => '[営]', 
		'se22e' => '↑', 
		'se22f' => '↓', 
		'se230' => '←', 
		'se231' => '→', 
		'se232' => '↑', 
		'se233' => '↓', 
		'se234' => '→', 
		'se235' => '←', 
		'se236' => '[右上]', 
		'se237' => '[左上]', 
		'se238' => '[右下]', 
		'se239' => '[左下]', 
		'se23a' => '＜', 
		'se23b' => '＞', 
		'se23c' => '≪', 
		'se23d' => '≫', 
		'se23e' => '[星座]', 
		'se23f' => '[牡羊座]', 
		'se240' => '[牡牛座]', 
		'se241' => '[双子座]', 
		'se242' => '[蟹座]', 
		'se243' => '[獅子座]', 
		'se244' => '[乙女座]', 
		'se245' => '[天秤座]', 
		'se246' => '[蠍座]', 
		'se247' => '[射手座]', 
		'se248' => '[山羊座]', 
		'se249' => '[水瓶座]', 
		'se24a' => '[魚座]', 
		'se24b' => '[蛇遣座]', 
		'se24c' => '[TOP]', 
		'se24d' => '[OK]', 
		'se24e' => '&copy;', 
		'se24f' => '&reg;', 
		'se250' => '[マナーモード]', 
		'se251' => '[電源切]', 
		'se252' => '[!]', 
		'se253' => '[ご案内]', 
		'se254' => '[J-PHONEショップ]', 
		'se255' => '[スカイウェブ]', 
		'se256' => '[スカイウォーカー]', 
		'se257' => '[スカイメロディ]', 
		'se258' => 'J-', 
		'se259' => 'Pho', 
		'se25a' => 'ne', 
		'se301' => '[メモ]', 
		'se302' => '[ネクタイ]', 
		'se303' => '[ハイビスカス]', 
		'se304' => '[チューリップ]', 
		'se305' => '[向日葵]', 
		'se306' => '[花束]', 
		'se307' => '[椰子の木]', 
		'se308' => '[サボテン]', 
		'se309' => '[トイレ]', 
		'se30a' => '[ヘッドホン]', 
		'se30b' => '[徳利]', 
		'se30c' => '[ビールで乾杯]', 
		'se30d' => '[祝]', 
		'se30e' => '[喫煙]', 
		'se30f' => '[カプセル薬]', 
		'se310' => '[風船]', 
		'se311' => '●〜', // 爆弾
		'se312' => '[クラッカー]', 
		'se313' => '[鋏]', 
		'se314' => '[リボン]', 
		'se315' => '[秘]', 
		'se316' => '[MD]', 
		'se317' => '[メガフォン]', 
		'se318' => '[帽子]', 
		'se319' => '[ワンピース]', 
		'se31a' => '[ミュール]', 
		'se31b' => '[ロングブーツ]', 
		'se31c' => '[口紅]', 
		'se31d' => '[マニキュア]', 
		'se31e' => '[エステ]', 
		'se31f' => '[美容院]', 
		'se320' => '[理髪店]', 
		'se321' => '[着物]', 
		'se322' => '[ビキニ]', 
		'se323' => '[ブランドバッグ]', 
		'se324' => '[カチンコ]', 
		'se325' => '[鈴]', 
		'se326' => '&#9835;', // 踊る音符 
		'se327' => '&hearts;', 
		'se328' => '&hearts;', 
		'se329' => '→&hearts;', 
		'se32a' => '&hearts;', 
		'se32b' => '&hearts;', 
		'se32c' => '&hearts;', 
		'se32d' => '&hearts;', 
		'se32e' => '◇', // ぴかぴか
		'se32f' => '☆', 
		'se330' => '=3', // ダッシュ, 
		'se331' => ';;', // 飛び散る汗  
		'se332' => '○', 
		'se333' => '×', 
		'se334' => '[ムカッ]', 
		'se335' => '☆', 
		'se336' => '?', 
		'se337' => '!', 
		'se338' => '[お茶]', 
		'se339' => '[パン]', 
		'se33a' => '[ソフトクリーム]', 
		'se33b' => '[フライドポテト]', 
		'se33c' => '[串団子]', 
		'se33d' => '[煎餅]', 
		'se33e' => '[ご飯]', 
		'se33f' => '[スパゲティ]', 
		'se340' => '[ラーメン]', 
		'se341' => '[カレーライス]', 
		'se342' => '[おにぎり]', 
		'se343' => '[おでん]', 
		'se344' => '[寿司]', 
		'se345' => '[林檎]', 
		'se346' => '[蜜柑]', 
		'se347' => '[苺]', 
		'se348' => '[西瓜]', 
		'se349' => '[トマト]', 
		'se34a' => '[茄子]', 
		'se34b' => '[バースデーケーキ]', 
		'se34c' => '[駅弁]', 
		'se34d' => '[鍋]', 
		'se401' => "(:_;;", // あせり
		'se402' => "(- 」-)", // ほそくんでいる
		'se403' => "m(__)m", // ひたすらごめんなさい
		'se404' => "^^.^^", // えっへん
		'se405' => "('_-)", // ウィンク
		'se406' => "(x_x)", // わさびがきいた
		'se407' => "(@_@)", // 目がぐるぐる
		'se408' => "(zzz)", // 鼻ちょうちん
		'se409' => "(^j^)", // あっかんべー
		'se40a' => "(*_*)", // 酔っ払い
		'se40b' => "(ToT)", // ゲロゲロ
		'se40c' => "(#□#)", // マスクをつけた顔
		'se40d' => "(#_#)", // 顔があかくなる
		'se40e' => "(→_→)", // しらけ顔
		'se40f' => "('_';", // 冷や汗
		'se410' => "(@_@)", // びっくり
		'se411' => "(T_T)", // 泣き
		'se412' => "(T^T)", // 泣いたり笑ったり
		'se413' => "(;_;)", // 可愛く泣いてる人
		'se414' => "(^.^)", // にこにこ
		'se415' => "(^o^)", // あははと笑う
		'se416' => "(`^`)", // めちゃめちゃ怒っている
		'se417' => "(~3~)", // KISS
		'se418' => "(^3-)", // 投げKISS
		'se419' => '[目]', 
		'se41a' => '[鼻]', 
		'se41b' => '[耳]', 
		'se41c' => '[口]', 
		'se41d' => "m(__)m", // ごめんなさい (合わせた手)
		'se41e' => '[バイバイ]', 
		'se41f' => '[拍手]', 
		'se420' => '[OK]', // 指で丸サイン
		'se421' => '[ブーイング]', // 親指を下
		'se422' => '[おっは〜]', 
		'se423' => '×', 
		'se424' => '○', 
		'se425' => '[手を繋ぐ]', 
		'se426' => "m(__)m", // 土下座
		'se427' => '[バンザイ]', 
		'se428' => '[人と人]', 
		'se429' => '[バニー]', 
		'se42a' => '[バスケットボール]', 
		'se42b' => '[アメフト]', 
		'se42c' => '[ビリヤード]', 
		'se42d' => '[水泳]', 
		'se42e' => '[RV車]', 
		'se42f' => '[トラック]', 
		'se430' => '[消防車]', 
		'se431' => '[救急車]', 
		'se432' => '[パトカー]', 
		'se433' => '[ローラーコースター]', 
		'se434' => '[地下鉄]', 
		'se435' => '[新幹線]', 
		'se436' => '[門松]', 
		'se437' => '[チョコ]', 
		'se438' => '[お雛様]', 
		'se439' => '[卒業式]', 
		'se43a' => '[ランドセル]', 
		'se43b' => '[鯉のぼり]', 
		'se43c' => '[閉じ傘]', 
		'se43d' => '[結婚式]', 
		'se43e' => '[波がザーン]', 
		'se43f' => '[かき氷]', 
		'se440' => '[線香花火]', 
		'se441' => '[貝]', 
		'se442' => '[風鈴]', 
		'se443' => '[台風]', 
		'se444' => '[稲穂]', 
		'se445' => '[ハロウィン]', 
		'se446' => '[お月見]', 
		'se447' => '[風がビュー]', 
		'se448' => '[サンタクロース]', 
		'se449' => '[朝日]', 
		'se44a' => '[夕日]', 
		'se44b' => '[流れ星]', 
		'se44c' => '[虹]', 
		'se501' => '[ラブホテル]', 
		'se502' => '[アート]', 
		'se503' => '[演劇]', 
		'se504' => '[デパート]', 
		'se505' => '[天守閣]', 
		'se506' => '[城]', 
		'se507' => '[映画館]', 
		'se508' => '[工場]', 
		'se509' => '[東京タワー]', 
		'se50a' => '[109]', 
		'se50b' => '[日本]', 
		'se50c' => '[アメリカ]', 
		'se50d' => '[フランス]', 
		'se50e' => '[ドイツ]', 
		'se50f' => '[イタリア]', 
		'se510' => '[イギリス]', 
		'se511' => '[スペイン]', 
		'se512' => '[ロシア]', 
		'se513' => '[中国]', 
		'se514' => '[韓国]', 
		'se515' => '[白人]', 
		'se516' => '[中国人]', 
		'se517' => '[インド人]', 
		'se518' => '[おじいちゃん]', 
		'se519' => '[おばあちゃん]', 
		'se51a' => '[赤ちゃん]', 
		'se51b' => '[安全第一]', 
		'se51c' => '[お姫さま]', 
		'se51d' => '[自由の女神]', 
		'se51e' => '[衛兵]', 
		'se51f' => '[フラメンコ]', 
		'se520' => '[イルカ]', 
		'se521' => '[鳥]', 
		'se522' => '[熱帯魚]', 
		'se523' => '[ひよこ]', 
		'se524' => '[ハムスター]', 
		'se525' => '[毛虫]', 
		'se526' => '[象]', 
		'se527' => '[コアラ]', 
		'se528' => '[チンバンジー]', 
		'se529' => '[羊]', 
		'se52a' => '[狼]', 
		'se52b' => '[牛]', 
		'se52c' => '[兎]', 
		'se52d' => '[蛇]', 
		'se52e' => '[鶏]', 
		'se52f' => '[猪]', 
		'se530' => '[ラクダ]', 
		'se531' => '[蛙]', 
		'se532' => '[A型]', 
		'se533' => '[B型]', 
		'se534' => '[AB型]', 
		'se535' => '[O型]', 
		'se536' => '[足跡]', 
		'se537' => '&trade;', 
		'se538' => 'J-', 
		'se539' => 'Sky', 
		'se53a' => '“', 
		'se53b' => '”', 
		'se53c' => '◎V', 
		'se53d' => 'odaf', 
		'se53e' => 'one', 
		'd001'  => '[晴れ]', 
		'd002'  => '[曇り]', 
		'd003'  => '[雨]', 
		'd004'  => '[雪]', 
		'd005'  => '[雷]', 
		'd006'  => '[台風]', 
		'd007'  => '[霧]', 
		'd008'  => '[小雨]', 
		'd009'  => '[牡羊座]', 
		'd010'  => '[牡牛座]', 
		'd011'  => '[双子座]', 
		'd012'  => '[蟹座]', 
		'd013'  => '[獅子座]', 
		'd014'  => '[乙女座]', 
		'd015'  => '[天秤座]', 
		'd016'  => '[蠍座]', 
		'd017'  => '[射手座]', 
		'd018'  => '[山羊座]', 
		'd019'  => '[水瓶座]', 
		'd020'  => '[魚座]', 
		'd021'  => '[スポーツウェア]', 
		'd022'  => '[野球]', 
		'd023'  => '[ゴルフ]', 
		'd024'  => '[テニス]', 
		'd025'  => '[サッカー]', 
		'd026'  => '[スキー]', 
		'd027'  => '[バスケットボール]', 
		'd028'  => '[チェッカーフラッグ]', 
		'd029'  => '[ページャー]', 
		'd030'  => '[電車]', 
		'd031'  => '[地下鉄]', 
		'd032'  => '[新幹線]', 
		'd033'  => '[車]', 
		'd034'  => '[RV車]', 
		'd035'  => '[バス]', 
		'd036'  => '[船]', 
		'd037'  => '[飛行機]', 
		'd038'  => '[家]', 
		'd039'  => '[ビル]', 
		'd040'  => '〒', 
		'd041'  => '[病院]', 
		'd042'  => '[銀行]', 
		'd043'  => '[ATM]', 
		'd044'  => '[ホテル]', 
		'd045'  => '[コンビニ]', 
		'd046'  => '[ガソリンスタンド]', 
		'd047'  => '[駐車場]', 
		'd048'  => '[信号]', 
		'd049'  => '[トイレ]', 
		'd050'  => '[レストラン]', 
		'd051'  => '[喫茶店]', 
		'd052'  => '[マティーニ]', 
		'd053'  => '[ビール]', 
		'd054'  => '[ハンバーガー]', 
		'd055'  => '[ブティック]', 
		'd056'  => '[鋏]', // 美容院
		'd057'  => '[マイク]', // カラオケ
		'd058'  => '[映画]', 
		'd059'  => '[右斜め上]', 
		'd060'  => '[木馬]', 
		'd061'  => '[ヘッドホン]', 
		'd062'  => '[アート]', 
		'd063'  => '[演劇]', 
		'd064'  => '[イベント]', 
		'd065'  => '[チケット]', 
		'd066'  => '[喫煙]', 
		'd067'  => '[禁煙]', 
		'd068'  => '[カメラ]', 
		'd069'  => '[カバン]', 
		'd070'  => '[本]', 
		'd071'  => '[リボン]', 
		'd072'  => '[プレゼント]', 
		'd073'  => '[バースデー]', 
		'd074'  => '[電話]', 
		'd075'  => '[携帯電話]', 
		'd076'  => '[メモ]', 
		'd077'  => '[TV]', 
		'd078'  => '[ゲーム]', 
		'd079'  => '[CD]', 
		'd080'  => '&hearts;', 
		'd081'  => '&spades;', 
		'd082'  => '&diams;', 
		'd083'  => '&clubs;', 
		'd084'  => '[目]', 
		'd085'  => '[耳]', 
		'd086'  => '[グー]', 
		'd087'  => '[チョキ]', 
		'd088'  => '[パー]', 
		'd089'  => '[右斜め下]', 
		'd090'  => '[左斜め上]', 
		'd091'  => '[足跡]', 
		'd092'  => '[くつ]', 
		'd093'  => '[眼鏡]', 
		'd094'  => '[車椅子]', 
		'd095'  => '●', 
		'd096'  => '[やや欠け月]', 
		'd097'  => '[半月]', 
		'd098'  => '[三日月]', 
		'd099'  => '○', 
		'd100'  => '[犬]', 
		'd101'  => '[猫]', 
		'd102'  => '[ヨット]', 
		'd103'  => '[クリスマス]', 
		'd104'  => '[左斜め下]', 
		'd105'  => '[phone]', 
		'd106'  => '[mail]', 
		'd107'  => '[fax]', 
		'd108'  => '[i]', 
		'd109'  => '[i]', 
		'd110'  => '[メール]', 
		'd111'  => '[ドコモ提供]', 
		'd112'  => '[ドコモポイント]', 
		'd113'  => '[有料]', 
		'd114'  => '[無料]', 
		'd115'  => '[ID]', 
		'd116'  => '[パスワード]', 
		'd117'  => '←┘', // 次項有
		'd118'  => '[CL]', 
		'd119'  => '[虫眼鏡]', 
		'd120'  => '[NEW]', 
		'd121'  => '[位置情報]', 
		'd122'  => '[FREE]', 
		'd123'  => '#', 
		'd124'  => 'Q', 
		'd125'  => '1', 
		'd126'  => '2', 
		'd127'  => '3', 
		'd128'  => '4', 
		'd129'  => '5', 
		'd130'  => '6', 
		'd131'  => '7', 
		'd132'  => '8', 
		'd133'  => '9', 
		'd134'  => '0', 
		'd135'  => '[OK]', 
		'd136'  => '&hearts;', // 黒ハート
		'd137'  => '&hearts;', // 揺れるハート
		'd138'  => '[失恋]', 
		'd139'  => '&hearts;&hearts;', // ハートたち (複数ハート)
		'd140'  => "(^_^)", // わーい (嬉しい顔)
		'd141'  => "(`_`)", // ちっ (怒った顔)
		'd142'  => "(v_v)", // がく〜 (落胆した顔)
		'd143'  => "(;_;)", // もうやだ〜 (悲しい顔)
		'd144'  => "(xox)", // ふらふら
		'd145'  => '↑',    // グッド (上向き矢印)
		'd146'  => '♪',    // るんるん (音符)
		'd147'  => '[温泉]', 
		'd148'  => '[花]', 
		'd149'  => '[キスマーク]', 
		'd150'  => '[NEW]', 
		'd151'  => '◇', // ぴかぴか 
		'd152'  => '[むかっ]', 
		'd153'  => '[パンチ]', 
		'd154'  => '●〜', // 爆弾
		'd155'  => '♪♪', // ムード
		'd156'  => '↓',   // バッド (下向き矢印)
		'd157'  => 'Zzz',  // 眠い (睡眠)
		'd158'  => '!', 
		'd159'  => '!?', 
		'd160'  => '!!', 
		'd161'  => 'Σ3', // どんっ 
		'd162'  => ';;', // あせあせ 
		'd163'  => '[たらーっ]', 
		'd164'  => '=3', // ダッシュ 
		'd165'  => '&#12336;', // 長音記号1
		'd166'  => '-o-', // 長音記号2
		'd167'  => '[カチンコ]', 
		'd168'  => '[ふくろ]', 
		'd169'  => '[ペン]', 
		'd170'  => '[人影]', 
		'd171'  => '[いす]', 
		'd172'  => '[夜]', 
		'd173'  => '→SOON', 
		'd174'  => '←ON→', 
		'd175'  => 'END←', 
		'd176'  => '[時計]', 
		'd201'  => 'α', 
		'd202'  => '[α]', 
		'd203'  => '[Tシャツ]', 
		'd204'  => '[がま口財布]', 
		'd205'  => '[化粧]', 
		'd206'  => '[ジーンズ]', 
		'd207'  => '[スノボ]', 
		'd208'  => '[チャペル]', 
		'd209'  => '[ドア]', 
		'd210'  => '($)', // ドル袋
		'd211'  => '[パソコン]', 
		'd212'  => '[ラブレター]', 
		'd213'  => '[レンチ]', 
		'd214'  => '[鉛筆]', 
		'd215'  => '[王冠]', 
		'd216'  => '[指輪]', 
		'd217'  => '[砂時計]', 
		'd218'  => '[自転車]', 
		'd219'  => '[湯のみ]', 
		'd220'  => '[腕時計]', 
		'd221'  => "(?_?)", // 考えてる顔
		'd222'  => "(-.-)", // ほっとした顔
		'd223'  => "(^_^;", // 冷や汗
		'd224'  => "('_';", // 冷や汗
		'd225'  => "(`^`)", // ぷっくっくな顔
		'd226'  => "(-_-)", // ボケーっとした顔
		'd227'  => "(*_*)", // 目がハート
		'd228'  => '[OK]',
		'd229'  => "(^j^)", // あっかんべー
		'd230'  => "('_-)", // ウィンク
		'd231'  => "(^o^)", // うれしい顔
		'd232'  => "(x_x)", // がまん顔
		'd233'  => "(=ω=)", // 猫顔
		'd234'  => "(T_T)", // 泣き顔
		'd235'  => '(;_;)', // 涙 
		'd236'  => '[NG]', 
		'd237'  => '[クリップ]', 
		'd238'  => '&copy;', 
		'd239'  => '&trade;', 
		'd240'  => '[走る人]', 
		'd241'  => '[秘]', 
		'd242'  => '[リサイクル]', 
		'd243'  => '&reg;', 
		'd244'  => '[!]', 
		'd245'  => '[禁止]', 
		'd246'  => '[空席]', 
		'd247'  => '[合格]', 
		'd248'  => '[満席]', 
		'd249'  => '⇔', 
		'd250'  => '↑↓', 
		'd251'  => '[学校]', 
		'd252'  => '[波]', 
		'd253'  => '[富士山]', 
		'd254'  => '[クローバー]', 
		'd255'  => '[さくらんぼ]', 
		'd256'  => '[チューリップ]', 
		'd257'  => '[バナナ]', 
		'd258'  => '[林檎]', 
		'd259'  => '[芽]', 
		'd260'  => '[もみじ]', 
		'd261'  => '[桜]', 
		'd262'  => '[おにぎり]', 
		'd263'  => '[ショートケーキ]', 
		'd264'  => '[とっくり]', 
		'd265'  => '[どんぶり]', 
		'd266'  => '[パン]', 
		'd267'  => '[かたつむり]', 
		'd268'  => '[ひよこ]', 
		'd269'  => '[ペンギン]', 
		'd270'  => '[魚]', 
		'd271'  => "(^+^)", // うまい! 
		'd272'  => "(^◇^)", //ウッシッシ 
		'd273'  => '[馬]', 
		'd274'  => '[豚]', 
		'd275'  => '[ワイングラス]', 
		'd276'  => ")@_@(", // げっそり
 		'e253'  => '[人差し指]', 
		'e254'  => '[カップル]', 
		'e255'  => '[初心者]', 
		'e256'  => '[ギター]', 
		'e257'  => '[株価]', 
		'e258'  => '[18歳]', 
		'e259'  => '[麻雀]', 
		'e260'  => '[コミュニティ]', 
		'e261'  => '[ヒット]', 
		'e262'  => '[新聞]', 
		'e263'  => '[サンタクロース]', 
		'e264'  => '[家族]', 
		'e265'  => '　', // [未使用]
		'e266'  => '[コイン]', 
		'e267'  => '　', // [未使用]
		'e268'  => '　', // [未使用]
		'e269'  => 'EM', 
		'e270'  => 'EM', 
		'e271'  => '　', // [未使用]
		'e272'  => '　', // [未使用]
		'e273'  => '　', // [未使用]
		'e274'  => '　', // [未使用]
		'e275'  => '　', // [未使用]
		'e276'  => '　', // [未使用]
		'e277'  => '　', // [未使用]
		'e278'  => '　', // [未使用]
		'wf040' => '&hearts;', 
		'wf041' => '[掛時計]', 
		'wf042' => '[電話]', 
		'wf043' => '[マグカップ]', 
		'wf044' => '*', // アスタリスク
		'wf045' => '↑↓', 
		'wf046' => '⇔', 
		'wf047' => '(((', 
		'wf048' => '[晴れ]', 
		'wf049' => '[雨]', 
		'wf04a' => '[曇り]', 
		'wf04b' => '[雫]', 
		'wf04c' => "(^_^)", // 笑顔 
		'wf04d' => '[キスマーク]', 
		'wf04e' => '&#9835;', // 16分音符
		'wf04f' => '[車]', 
		'wf050' => '[電車]', 
		'wf051' => '[飛行機]', 
		'wf052' => '[船]', 
		'wf053' => '[家]', 
		'wf054' => '[ビル]', 
		'wf055' => '[チョキ]', 
		'wf056' => '[レストラン]', 
		'wf057' => '[マティーニ]', 
		'wf058' => "(;_;)", // 涙顔
		'wf059' => '[チューリップ]', 
		'wf05a' => '[バット]', 
		'wf05b' => '[野球ボール]', 
		'wf05c' => '[グー]', 
		'wf05d' => '[雷]', 
		'wf05e' => "(`_`)", //怒り顔
		'wf05f' => '[ビール]', 
		'wf060' => '[ノート]', 
		'wf061' => '[鉛筆]', 
		'wf062' => '[ドクロ]', 
		'wf063' => '[メール]', 
		'wf064' => '[禁煙]', 
		'wf065' => '[ベル]', 
		'wf066' => '[花]', 
		'wf067' => '[温泉]', 
		'wf068' => '[二十六日月]', // 三日月の反対向き
		'wf069' => '[旗]', 
		'wf06a' => '[マスク顔]', 
		'wf06b' => '[音楽]', 
		'wf06c' => '[肉]', 
		'wf06d' => '[犬]', 
		'wf06e' => '[猫]', 
		'wf06f' => '[猿]', 
		'wf070' => '[象]', 
		'wf071' => '[蛸]', 
		'wf072' => '[ラーメン]', 
		'wf073' => '[マイク]', 
		'wf074' => '[むかっ]', 
		'wf075' => '[ひよこ]', 
		'wf076' => "(~_~)", // 眠り顔
		'wf077' => '[コーヒー]', 
		'wf078' => '[喫煙]', 
		'wf079' => ';;', // 飛び散る汗 
		'wf07a' => '[おにぎり]', 
		'wf07b' => '[バッグ]', 
		'wf07c' => '[ウンチ]', 
		'wf07d' => '[ネクタイ]', 
		'wf07e' => '[Tシャツ]', 
		'wf080' => '[メロン]', 
		'wf081' => '[かき氷]', 
		'wf082' => '[水着]', 
		'wf083' => '[鋏]', 
		'wf084' => '[注射器]', 
		'wf085' => '[錨]', 
		'wf086' => '[蛙]', 
		'wf087' => '[パー]', 
		'wf088' => '[失恋]', 
		'wf089' => '&diams;', 
		'wf08a' => '&clubs;', 
		'wf08b' => '&spades;', 
		'wf08c' => '[クリップ]', 
		'wf08d' => '[雪だるま]', 
		'wf08e' => '[バースデーケーキ]', 
		'wf08f' => '[林檎]', 
		'wf090' => '[プレゼント]', 
		'wf091' => '($)', //ドル袋 
		'wf092' => '[EXIT]', 
		'wf093' => '[ドア]', 
		'wf094' => '[おやじ]', 
		'wf095' => '[携帯電話]', 
		'wf096' => '☆', 
		'wf097' => '[チケット]', 
		'wf098' => '&hearts;&hearts;', 
		'wf099' => '[電球]', 
		'wf09a' => '[足跡]', 
		'wf09b' => "(^o^)", // 喜び顔
		'wf09c' => '[テニス]', 
		'wf09d' => '[映画カメラ]', 
		'wf09e' => '[スキー]', 
		'wf09f' => '!!', 
		'wf0a0' => '!?', 
		'wf0a1' => '?', 
		'wf0a2' => '↓', 
		'wf0a3' => '↑', 
		'wf0a4' => '[OK]', 
		'wf0a5' => '[力こぶ]', 
		'wf0a6' => '→&hearts;', 
		'wf0a7' => '[花丸]', 
		'wf0a8' => '[台風]', 
		'wf0a9' => '[海]', 
		'wf0aa' => '[サーフィン]', 
		'wf0ab' => '[山]', 
		'wf0ac' => '[富士山]', 
		'wf0ad' => '[キャンプ]', 
		'wf0ae' => '[落葉]', 
		'wf0af' => '[バス]', 
		'wf0b0' => '[サッカー]', 
		'wf0b1' => '[初心者]', 
		'wf0b2' => '≪',
		'wf0b3' => '≫', 
		'wf0b4' => '[重要]', 
		'wf0b5' => '[18禁]', 
		'wf0b6' => '[!]', 
		'wf0b7' => '[リサイクル]', 
		'wf0b8' => '[.i|]', // アンテナ 
		'wf0b9' => ')))', 
		'wf0ba' => '×', 
		'wf0bb' => '&copy;', 
		'wf0bc' => '&reg;', 
		'wf0bd' => '[777]', // スロット
		'wf0be' => '0', 
		'wf0bf' => '1', 
		'wf0c0' => '2', 
		'wf0c1' => '3', 
		'wf0c2' => '4', 
		'wf0c3' => '5', 
		'wf0c4' => '6', 
		'wf0c5' => '7', 
		'wf0c6' => '8', 
		'wf0c7' => '9', 
		'wf0c8' => '[牡羊座]', 
		'wf0c9' => '[牡牛座]', 
		'wf0ca' => '[双子座]', 
		'wf0cb' => '[蟹座]', 
		'wf0cc' => '[獅子座]', 
		'wf0cd' => '[乙女座]', 
		'wf0ce' => '[天秤座]', 
		'wf0cf' => '[蠍座]', 
		'wf0d0' => '[蛇遣座]', 
		'wf0d1' => '[射手座]', 
		'wf0d2' => '[山羊座]', 
		'wf0d3' => '[水瓶座]', 
		'wf0d4' => '[魚座]', 
		'wf0d5' => '[地蔵]', 
		'wf0d6' => '[マクドナルド]', 
		'wf0d7' => '[モスバーガー]', 
		'wf0d8' => '　', // [未使用]
		'wf0d9' => '[ロッテリア]', 
		'wf0da' => '　', // [未使用]
		'wf0db' => '[ドトールコーヒー]', 
		'wf0dc' => '　', // [未使用]
		'wf0dd' => '　', // [未使用]
		'wf0de' => '　', // [未使用]
		'wf0df' => '　', // [未使用]
		'wf0e0' => '[バーミヤン]', 
		'wf0e1' => '　', // [未使用]
		'wf0e2' => '　', // [未使用]
		'wf0e3' => '[びっくりドンキー]', 
		'wf0e4' => '　', // [未使用]
		'wf0e5' => '　', // [未使用]
		'wf0e6' => '　', // [未使用]
		'wf0e7' => '[ローソン]', 
		'wf0e8' => '　', // [未使用]
		'wf0e9' => '[am/pm]', 
		'wf0ea' => '　', // [未使用]
		'wf0eb' => '　', // [未使用]
		'wf0ec' => '　', // [未使用]
		'wf0ed' => '　', // [未使用]
		'wf0ee' => '　', // [未使用]
		'wf0ef' => '　', // [未使用]
		'wf0f0' => '[西武百貨店]', 
		'wf0f1' => '　', // [未使用]
		'wf0f2' => '　', // [未使用]
		'wf0f3' => '　', // [未使用]
		'wf0f4' => '　', // [未使用]
		'wf0f5' => '　', // [未使用]
		'wf0f6' => '　', // [未使用]
		'wf0f7' => '　', // [未使用]
		'wf0f8' => '　', // [未使用]
		'wf0f9' => '　', // [未使用]
		'wf0fa' => '　', // [未使用]
		'wf0fb' => '　', // [未使用]
		'wf0fc' => '[ハチ公]', 
		'wf140' => '[モヤイ像]', 
		'wf141' => '　', // [未使用]
		'wf142' => '　', // [未使用]
		'wf143' => '　', // [未使用]
		'wf144' => '　', // [未使用]
		'wf145' => '　', // [未使用]
		'wf146' => '　', // [未使用]
		'wf147' => '　', // [未使用]
		'wf148' => '[UFJ 銀行]', 
		'wf149' => '　', // [未使用]
		'wf14a' => '　', // [未使用]
		'wf14b' => '　', // [未使用]
		'wf14c' => '　', // [未使用]
		'wf14d' => '[EXIT]', 
		'wf14e' => '　', // [未使用]
		'wf14f' => '　', // [未使用]
		'wf150' => '(T_T)', // 泣き顔
		'wf151' => '　', // [未使用]
		'wf152' => '　', // [未使用]
		'wf153' => '　', // [未使用]
		'wf154' => '　', // [未使用]
		'wf155' => '　', // [未使用]
		'wf156' => '　', // [未使用]
		'wf157' => '　', // [未使用]
		'wf158' => '　', // [未使用]
		'wf159' => '　', // [未使用]
		'wf15a' => '　', // [未使用]
		'wf15b' => '　', // [未使用]
		'wf15c' => '　', // [未使用]
		'wf15d' => '　', // [未使用]
		'wf15e' => '　', // [未使用]
		'wf15f' => '　', // [未使用]
	);

/* ==================================================
 * @param	none
 * @return	object  $ktai
 */
static function factory($ua = NULL) {
	$ktai = NULL;
	$ua = $ua ? $ua : $_SERVER['HTTP_USER_AGENT'];
	if (preg_match('!^DoCoMo/1!', $ua)) {
		require_once dirname(__FILE__) . '/i-mode.php';
		$ktai = new Ktai_Service_imode_mova($ua);
	} elseif (preg_match('!^DoCoMo/2!', $ua)) {
		require_once dirname(__FILE__) . '/i-mode.php';
		$ktai = new Ktai_Service_imode_FOMA($ua);
	} elseif (preg_match('!^J-(PHONE|EMULATOR)/!', $ua)) {
		require_once dirname(__FILE__) . '/softbank.php';
		$ktai = new Ktai_Service_Softbank_PDC($ua);
	} elseif (preg_match('!^(Vodafone/|MOT(EMULATOR)?-[CV]|SoftBank/|Vemulator/|Semulator/)!', $ua)) {
		require_once dirname(__FILE__) . '/softbank.php';
		$ktai = new Ktai_Service_Softbank_3G($ua);
	} elseif (preg_match('/(DDIPOCKET|WILLCOM);/', $ua)) {
		require_once dirname(__FILE__) . '/willcom.php';
		$ktai = new Ktai_Service_WILLCOM($ua);
	} elseif (preg_match('|^emobile/|', $ua)) {
		require_once dirname(__FILE__) . '/emobile.php';
		$ktai = new Ktai_Service_EMOBILE($ua);
	} elseif (preg_match('/^KDDI-/',$ua)) {
		require_once dirname(__FILE__) . '/ezweb.php';
		$ktai = new Ktai_Service_EZweb_WAP2($ua);
	} elseif (preg_match('/^UP\.Browser/',$ua)) {
		require_once dirname(__FILE__) . '/ezweb.php';
		$ktai = new Ktai_Service_EZweb_HDML($ua);
	} elseif (preg_match('/(Nokia\\d+|Opera Mini|Windows CE;)/', $ua, $name)) {
		$ktai = new Ktai_Service_Other($ua);
		$ktai->term_name = $ktai->term_name ? $ktai->term_name : $name[1];
	} elseif (preg_match('/\(PSP \(PlayStation Portable\);/', $ua)) {
		$ktai = new Ktai_Service_Other($ua);
		$ktai->term_name = 'PlayStation Portable';
	} elseif (preg_match('/\bNitro\) Opera/', $ua)) {
		$ktai = new Ktai_Service_Other($ua);
		$ktai->term_name = 'Nintendo DS';
	}
	$ktai = apply_filters('detect_agent/ktai_style.php', $ktai, $ua);
	return $ktai;
}

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	require_once dirname(__FILE__) . '/kses.php';
	$this->allowedtags = apply_filters('allowedtags/ktai_style.php', Ktai_HTML_Filter::$allowedtags);
	if (empty($this->theme)) {
		$this->theme = ks_option('ks_theme');
	}
}

/* ==================================================
 * @param	string $key
 * @return	mix    $value
 */
public function get($key) {
	switch ($key) {
	case 'charset':
		return ($this ? $this->charset : KS_DEFAULT_CHARSET);
	case 'iana_charset':
		$charset = ($this ? $this->charset : KS_DEFAULT_CHARSET);
		$charset = preg_replace('/^SJIS(-win)?$/', 'Shift_JIS', $charset);
		$charset = preg_replace('/^eucJP(-win)?$/', 'EUC-JP', $charset);
		return $charset;
	case 'preamble':
		return str_replace('__CHARSET__', $this->get('iana_charset'), $this->preamble);
	case 'term_name':
		return ($this->term_name ? $this->term_name : 'Unknown');
	default:
		return isset($this->$key) ? $this->$key : NULL;
	}
}

/* ==================================================
 * @param	string  $key
 * @param	mix     $value
 * @return	mix     $value
 */
public function set($key, $value = NULL) {
	if (is_null($value)) {
		unset($this->$key);
	} else {
		$this->$key = $value;
	}
	return $value;
}

/* ==================================================
 * @param	array   $networks
 * @return	boolean $in_network
 */
public function in_network($networks = NULL) {
	if (! $networks) {
		return FALSE;
	}
	$in_network = FALSE;
	$ip = ip2long($_SERVER['REMOTE_ADDR']);
	foreach ( (array) $networks as $n) {
		list($network, $mask) = explode('/', $n);
		$net = ip2long($network);
		if (! $net || $mask < 8 || $mask > 32) {
			continue;
		}
		if ($ip >> (32 - $mask) == $net >> (32 - $mask)) {
			$in_network = TRUE;
			break;
		}
	}
	return $in_network;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_encode($buffer) {
	if (get_bloginfo('charset') == 'UTF-8' || get_bloginfo('charset') == 'utf-8') {
		mb_regex_encoding('UTF-8');
		$buffer = mb_ereg_replace("\xe2\x99\xa0", "&#9824;", $buffer); // spade
		$buffer = mb_ereg_replace("\xe2\x99\xa4", "&#9824;", $buffer); // white spade
		$buffer = mb_ereg_replace("\xe2\x99\xa3", "&#9827;", $buffer); // club
		$buffer = mb_ereg_replace("\xe2\x99\xa7", "&#9827;", $buffer); // white club
		$buffer = mb_ereg_replace("\xe2\x99\xa5", "&#9829;", $buffer); // heart
		$buffer = mb_ereg_replace("\xe2\x99\xa1", "&#9825;", $buffer); // white heart
		$buffer = mb_ereg_replace("\xe2\x99\xa6", "&#9830;", $buffer); // diamond
		$buffer = mb_ereg_replace("\xe2\x99\xa2", "&#9830;", $buffer); // white diamond
		$buffer = mb_ereg_replace("\xe3\x80\xb0", "&#12336;", $buffer); // wavy dash
	}
	$revert_cockney = array(
		'&#215;'  => 'x',
		'&#8211;' => '--', 
		'&#8212;' => '---', 
		'&#8217;' => "'", 
		'&#8220;' => '“',
		'&#8221;' => '”',
		'&#8230;' => '…',
		'&#8482;' => '(tm)',
	);
	$buffer = str_replace(array_keys($revert_cockney), $revert_cockney, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = str_replace("\r\n/", "\n", $buffer); // only LF is illegal for text/html, but useful for shrink packets
	$buffer = preg_replace('!<(p|div)( (id|class|align)=([\'"])[-_ a-zA-Z0-9]+\\4)*>\s*</\\1>\s*!', '', $buffer); //"syntax highlighting fix
	$buffer = preg_replace('!/>\s*!', '/>', $buffer);
	$buffer = preg_replace('!\s*</!', '</', $buffer);
	$buffer = preg_replace('!\s*<(ul|/li|/option)>\s*<(ul|li|option)!', '<$1><$2', $buffer);
	$buffer = preg_replace('!<(dl|/?dt|/?dd|select)([^>]*)>\s*<(dt|dd|option)!', '<$1$2><$3', $buffer);
/*	$buffer = preg_replace('!([^?])>\s*(\n)\s*<!', '$1>$2<', $buffer); // alternate code for upper 2 lines */
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer, $smiles = NULL) {
	if ($smiles && preg_match_all('!<img src=([\'"])([^>]*?/([-_.a-zA-Z0-9]+))\\1( alt=([\'"])[^\\\\>]*?(\\\\.[^\\\\>]*?)*\\5)? class=([\'"])([^\\\\>]*?(\\\\.[^\\\\>]*?)*)\\7 ?/?>!', $buffer, $images, PREG_SET_ORDER)) {
		foreach($images as $i) {
			if (preg_match('/(^| )wp-smiley( |$)/', $i[8])) {
				if (preg_match('/(^| )ktai( |$)/', $i[8])) {
					$buffer = str_replace($i[0], "<img src={$i[1]}{$i[2]}{$i[1]}{$i[4]} />", $buffer);
				} else {
					$buffer = str_replace($i[0], $smiles[$i[3]], $buffer);
				}
			}
		}
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_pict($buffer) {
	if (! isset(self::$trans)) {
		if (strtoupper(get_bloginfo('charset')) != 'UTF-8') {
			$code = create_function('$c', 'return mb_convert_encoding($c, get_bloginfo("charset"), "UTF-8");');
			self::$trans = array_map($code, self::$pics);
		} else {
			self::$trans = self::$pics;
		}
	}
	$buffer = preg_replace('!<img localsrc="([^"]+)"( alt="([^"\\\\]*?(\\\\.[^"\\\\]*)*)")? ?/?>!e', 
	'apply_filters("convert_pict_other/ktai_style.php", 
	(strlen("$2") ? 
		"$3" 
	: (isset(self::$trans["$1"]) ? self::$trans["$1"] : "〓")
	), "$1", (strlen("$2") ? "$3" : NULL), get_bloginfo("charset"))', $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function pickup_pics($buffer) {
	return $buffer;
}

/* ==================================================
 * @param	int     $num
 * @param	boolean $rest
 * @param	string  $post_password
 * @return	string  $output
 * @return	int     $page_num
 */
private function get_split_page_navi($num, $rest, $post_password) {
	$link = htmlspecialchars(remove_query_arg('kp', Ktai_Style::request_path()), ENT_QUOTES);
	$link .= (strpos($link, '?') === FALSE) ? '?kp=': '&amp;kp=';
	$del_accesskey = '';
	if ($num == 2) {
		$prev = _internal_link(preg_replace('/(\?|&(amp;)?)kp=/', '', $link), '*', '', __('*.Prev', 'ktai_style'), $post_password) . ' | ';
		$del_accesskey .= '*';
	} elseif ($num >= 3) {
		$prev = _internal_link($link . intval($num -1), '*', '', __('*.Prev', 'ktai_style'), $post_password) . ' | ';
		$del_accesskey .= '*';
	} else {
		$prev = '';
	}
	if ($rest) {
		$next = ' | ' . _internal_link($link . intval($num +1), '#', '', __('#.Next', 'ktai_style'), $post_password);
		$del_accesskey .= '#';
	} else {
		$next = '';
	}
	$output = mb_convert_encoding(sprintf(apply_filters('split_page_navi/ktai_style.php', __('<div align="center">Splitting the page for mobile: %spage %d%s</div>', 'ktai_style'), $prev, $num, $next), $prev, $num, $next), $this->get('charset'), get_bloginfo('charset')); 
	return array($output, $del_accesskey);
}

/* ==================================================
 * @param	string  $balanced
 * @param	string  $start_tags
 * @return	string  $start_tags
 */
private function detect_nesting_list($balanced, $start_tags) {
	preg_match_all('|</?[ou]l([^>]*)>|', $balanced, $lists, PREG_OFFSET_CAPTURE);
	$open[0] = '<ol>';
	do {
		$close = array_pop($lists[0]);
	} while (strpos($close, '</ol>') !== FALSE);
	$max_ol_level = preg_match_all('/<ol>/', $start_tags, $ol);
	for ($ol_level = 0 ; $ol_level < $max_ol_level ; $ol_level++) {
		$inside[$ol_level][0] = array('start' => strlen($close[0]), 'end' => $close[1]);
	}
	$level = 0;
	$ol_level = 0;
	$below_level[$ol_level] = $level +1;
	$entered[$ol_level] = 1; // to make sure
	foreach (array_reverse($lists[0]) as $l) {
		if (strpos($l[0], '</') !== FALSE) {
			$level++;
			if ($level == $below_level[$ol_level]) {
				$inside[$ol_level][0]['start'] = $l[1] + strlen($l[0]);
			}
			if (strpos($l[0], '</ol>') !== FALSE && $ol_level < $max_ol_level -1 && ! isset($entered[$ol_level +1])) {
				$ol_level++;
				$below_level[$ol_level] = $level +1;
				$inside[$ol_level][0]['end'] = $l[1];
				$entered[$ol_level] = 1;
			}
		} elseif ($level <= 0) {
			$open[0] = $l[0];
			$inside[$ol_level][0]['start'] = $l[1] + strlen($l[0]);
			break;
		} else {
			if (strpos($l[0], '<ol') !== FALSE && $level < $below_level[$ol_level] && @$entered[$ol_level] == 1) {
				$open[$ol_level] = $l[0];
				$inside[$ol_level][0]['start'] = $l[1] + strlen($l[0]);
				$entered[$ol_level] = 2;
				$ol_level--;
			}
			if ($level == $below_level[$ol_level]) {
				array_unshift($inside[$ol_level], array('end' => $l[1]));
			}
			$level--;
		}
	}
	for ($ol_level = 0 ; $ol_level < $max_ol_level ; $ol_level++) {
		if (preg_match('/start=[\'"](\d+)[\'"]/', $open[$ol_level], $start)) {
			$start_num = intval(@$start[1]);
		} else {
			$start_num = 1;
		}
		$inside_html = '';
		foreach ($inside[$ol_level] as $offset) {
			$inside_html .= substr($balanced, $offset['start'], $offset['end'] - $offset['start']);
		}
		$start_num += preg_match_all('/<li>/', $inside_html, $items);
		$ol_pos = strpos($start_tags, '<ol>'); // should be matched
		if (strpos($start_tags, '<li>', $ol_pos) == $ol_pos + 4) {
			$start_num -= 1; // use same number for splited item
		}
		if ($start_num > 1) {
			$start_html = ' start="' . $start_num . '"';
		} else {
			$start_html = ' start="1"';
		}
		preg_match('/ type=[\'"][^\'"]+[\'"]/', $open[$ol_level], $type);
		$start_tags = preg_replace('/<ol>/', '<ol' . $start_html . @$type[0] . '>', $start_tags, 1);
	}
	return str_replace(' start="1"', '', $start_tags);
}

/* ==================================================
 * @param	string  $buffer
 * @param	int     $page_num
 * @return	string  $paged_content
 */
public function split_page($buffer, $page_num) {
	if ($page_num > KS_MAX_PAGE_NUM) {
		$page_num = KS_MAX_PAGE_NUM;
	} elseif ($page_num < 1) {
		$page_num = 1;
	}

	if (strpos($buffer, KS_START_PAGING) === FALSE) {
		$buffer = preg_replace('/(<body[^>]*>)/', "\$1\n" . KS_START_PAGING, $buffer);
	}
	if (strpos($buffer, KS_END_PAGING) === FALSE) {
		if (preg_match('!<hr [^/>]*/>\s*<a name="tail"!', $buffer)) {
			$buffer = preg_replace('!(<hr [^/>]*/>\s*<a name="tail")!', KS_END_PAGING . "\n\$1", $buffer);
		} else {
			$buffer = preg_replace('!(</body>)!', KS_END_PAGING . "\n\$1", $buffer);
		}
	}

	list($header, $buffer) = preg_split('/' . preg_quote(KS_START_PAGING, '/') . '\n*/', $buffer, 2);
	list($buffer, $footer) = preg_split('/\n*' . preg_quote(KS_END_PAGING, '/') . '/', $buffer, 2);
	$buffer = preg_replace('/>[ \t]*\n+[ \t]*</', '><', $buffer);
	if (preg_match('/<input type="hidden" name="post_password" value="(.*?)"/', $buffer, $match)) {
		$post_password = $match[1];
	} else {
		$post_password = '';
	}
	list($navi, $del_accesskey) = $this->get_split_page_navi(101,TRUE, $post_password);
	$page_size = $this->page_size - strlen("$header$navi<hr /><hr />$navi$footer") - 32; // 32-byte is space for adding tags by force_balance_tags()
	if ($page_size < 256) { // too small
		$header = preg_replace('/(<body[^>]*>)/', '$1' . KS_START_PAGING, $header);
		list($header, $move2body) = explode(KS_START_PAGING, $header, 2);
		$buffer = $move2body . $buffer . $footer;
		$footer = '';
		$page_size = $this->page_size - strlen("$header$navi<hr /><hr />$navi$footer") - 32;
	}

	$start_tags = '';
	$terminator = '<!--KS_TERMINATOR_' . md5(uniqid()) . '-->';
	$marker = 0;
	$buffer_length = strlen($buffer);
	for ($count = 0 ; $count < $page_num ; $count++) {
		$fragment = _cut_html($buffer, $page_size, $marker, $this->charset);
		$fragment = preg_replace('/\x1b\$[GEFOPQ]?$/', '', $fragment);
		if (preg_match('/(\x1b\$[GEFOPQ])[!-z]+$/', $fragment, $pict_sequence)) {
			$complemention = "\x0f"; // complete softbank pictgram shift-in
		} else {
			$complemention = '';
		}
		$quoted = str_replace(array("<\x0f", ">\x0f"), array("&lt;\x0f", "&gt;\x0f"), $start_tags . $fragment . $terminator); // protect softbank pictograms
		$balanced = force_balance_tags($quoted);
		preg_match("/$terminator(.*)\$/", $balanced, $added_html);
		$complemented = preg_replace('/\x1b\$[GEFOPQ]?\x1b/', '', $start_tags . $fragment . $complemention . @$added_html[1]);
		if (preg_match_all('!</([^<>]*)>!', @$added_html[1], $added_tags)) {
			$start_tags = '<' . implode('><', array_reverse($added_tags[1])) . '>'; // store complemented tags to next fragment
			if (strpos($start_tags, '<ol>') !== FALSE) {
				$start_tags = $this->detect_nesting_list($balanced, $start_tags);
			}
			$start_tags .= (isset($pict_sequence[1]) ? $pict_sequence[1] : '');
		} else {
			$start_tags = (isset($pict_sequence[1]) ? $pict_sequence[1] : '');
		}
		$marker += strlen($fragment);
		if ($marker >= $buffer_length) {
			$count++;
			break;
		}
	}

	if (strlen($fragment) < $buffer_length && isset($added_html[1])) {
		list($navi, $del_accesskey) = $this->get_split_page_navi($count, ($marker +1 < $buffer_length), $post_password);
		if ($del_accesskey) { // delete redundant access keys
			$complemented = preg_replace('/(<(a|label) [^>]*?) accesskey="[' . $del_accesskey . ']">/', '$1>', $complemented);
		}
		return "$header$navi<hr />$complemented<hr />$navi$footer";
	} else {
		return "$header$buffer$footer";
	}
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function trim_images($content) {
	global $KS_Shrinkage;
	if ($this->get('cache_size') > 0) {
		$total_size = strlen($content);
		for ($offset = 0, $replace = 'X'; 
		     preg_match('!<img ([^>]*?)src=([\'"])([^\\\\>]*?(\\\\.[^\\\\>]*?)*)\\2([^>]*?) ?/?>!', $content, $i, PREG_OFFSET_CAPTURE, $offset); //"syntax highlighting fix
		     $offset += strlen($replace)) {
			$offset  = $i[0][1];
			$replace = $i[0][0];
			$src     = $i[3][0];
			$attr    = $i[1][0] . $i[5][0];
			if (preg_match($KS_Shrinkage->get('wpurl_pat'), $src)) {
				$imagesize = @filesize(preg_replace($KS_Shrinkage->get('wpurl_pat'), ABSPATH . '/', $src));
				if ($imagesize) {
					$total_size += $imagesize;
				}
				if ($total_size > $this->cache_size) {
					if (preg_match('/alt=([\'"])([^\\\\>]*?(\\\\.[^\\\\>]*?)*)\\1/', $attr, $a)) { //"syntax highlighting fix
						$replace = $a[2];
					} else {
						$replace = basename($src);
					}
					$content = substr_replace($content, $replace, $offset, strlen($i[0][0]));
				}
			}
		}
	}
	return $content;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	if ($this->get('mime_type') == 'application/xhtml+xml') {
		if (preg_match('!</head>\s*<body bgcolor="(.*?)" text="(.*?)" link="(.*)" vlink="(.*?)">!', $buffer, $colors)) {
			if ($colors[1] || $colors[2]) {
				$style = 'body {' . ($colors[2] ? 'color:' . $colors[2] . ';' : '') . ($colors[1] ? 'background-color:' . $colors[1] . ';' : '') . '} ';
			}
			if ($colors[3]) {
				$style .= 'a,a:link {color:' . $colors[3] . ';} ';
			}
			if ($colors[4]) {
				$style .= 'a:visited {color:' . $colors[4] . ';} ';
			}
			if ($style) {
				$buffer = str_replace($colors[0], '<style type="text/css">' . $style . '</style></head><body>', $buffer);
			}
		}
		$buffer = preg_replace('/<a name=/', '<a id=', $buffer);
		$buffer = preg_replace('/<(h[1-6]|div|p) align="(.*?)"/', '<$1 style="text-align:$2;"', $buffer);
		$buffer = $this->horizontal_rule_to_style($buffer);
		$buffer = $this->font_to_style($buffer);
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function horizontal_rule_to_style($buffer) {
	if (preg_match_all('|<hr ([^>]*?)/?>|', $buffer, $hr, PREG_SET_ORDER)) {
		foreach ($hr as $h) {
			$style = '';
			if (preg_match_all('/(\w+)=([\'"])([^\\\\>]*?(\\\\.[^\\\\>]*?)*)\\2/', $h[1], $attr, PREG_SET_ORDER)) { //"syntax highlighting fix
				foreach ($attr as $a) {
					$value = $a[3];
					switch ($a[1]) {
					case 'color':
						$style .= "background-color:$value;border-style:solid;border-color:$value;";
						break;
					case 'size':
						$style .= "height:$value;";
					case 'width':
						$style .= "width:$value;";
						break;
					case 'align':
						$style .= "float:" . str_replace('center','none', $value); 
						break;			
					}
				}
			}
			if ($style) {
				$style = ' style="' . $style . '"';
			}
			$buffer = preg_replace('!' . preg_quote($h[0], '!') . '!', "<hr$style />", $buffer, 1);
		}
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function font_to_style($buffer) {
	if (preg_match_all('!(<(b|i|u|em|strong)>)?<font([^<>]*)>(<(b|i|u|em|strong)>)?(.*?)(</\\5>)?</font>(</\\2>)?!', $buffer, $fonts, PREG_SET_ORDER)) {
		foreach ($fonts as $f) {
			$style = '';
			if (preg_match_all('/(\w+)=([\'"])([^\\\\>]*?(\\\\.[^\\\\>]*?)*)\\2/', $f[3], $attr, PREG_SET_ORDER)) { //"syntax highlighting fix
				foreach ($attr as $a) {
					$value = $a[3];
					switch ($a[1]) {
					case 'size':
						if ($value === '+1') {
							$style .= 'font-size:larger;';
						} else {
							switch ($value) {
							case '-1':
								$style .= 'font-size:smaller;';
								break;
							case '1':
								$style .= 'font-size:x-small;';
								break;
							case '2':
								$style .= 'font-size:small;';
								break;
							case '4':
								$style .= 'font-size:large;';
								break;
							case '5':
								$style .= 'font-size:x-large;';
								break;
							case '6':
							case '7':
								$style .= 'font-size:xx-large;';
								break;
							}
						}
						break;
					case 'face':
						$style .= "font-family:$value;";
						break; 
					default:
						$style .= "{$a[1]}:$value;";
					}
				}
			}
			$html = $f[6];
			if ($style) {
				$style = ' style="' . $style . '"';
				if ($f[4]) {
					$html = "{$f[1]}<{$f[5]}$style>{$f[6]}</{$f[5]}>{$f[8]}";
				} elseif ($f[1]) {
					$html = "<{$f[2]}$style>{$f[6]}</{$f[2]}>";
				} else {
					$html = "<span$style>{$f[6]}</span>";
				}
			}
			$buffer = preg_replace('!' . preg_quote($f[0], '!') . '!', $html, $buffer, 1);
		}
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $user_agent
 * @return	string  $user_agent
 */
public function add_term_id ($user_agent) {
	$id = array();
	if ($this->term_ID) {
		$id[] = "Term ID: {$this->term_ID}";
	}
	if ($this->usim_ID) {
		$id[] = "USIM ID: {$this->usim_ID}";
	}
	if ($this->sub_ID) {
		$id[] = "Sub ID: {$this->sub_ID}";
	}
	if ($id) {
		$user_agent .= ' (' . implode(' ', $id) . ')';
	}
	return $user_agent;
}

/* ==================================================
 * @param	object  $comment
 * @return	array   $id
 */
public function read_term_id($comment) {
	if (preg_match('/\((Term ID: ([^ ]*)( USIM ID: ([^ ]*))?)? ?(Sub ID: ([^)]*))?\)$/', $comment->comment_agent, $agent)) {
		return array(@$agent[2],@$agent[4],@$agent[6]);
	}
	return array();
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Other class
   ================================================== */

class Ktai_Service_Other extends Ktai_Services {
	static public $dcm_smartphones = array(
		'DCM06' => 'htcZ',
	);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	if (preg_match('!Windows CE; (.*)$!', $user_agent, $specs)) {
		if (preg_match('!^[^/]*/([^;]*)!', $specs[1], $term_name)) {
			$this->term_name = $term_name[1];
		} elseif (preg_match('/IEMobile [\d.]*\) (FOMA )?(\w+)/', $specs[1], $term_name)) {
			$this->term_name = $term_name[2];
		} elseif (preg_match('/DCM\d+/', $specs[1], $term_name)) {
			$this->term_name = self::$dcm_smartphones[$term_name[0]];
		}
	}
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_pict($buffer) {
	$buffer = preg_replace('!<img localsrc="([^"]+)"( alt="([^"\\\\]*?(\\\\.[^"\\\\]*)*)")? ?/?>!e', 
	'apply_filters("convert_pict_other/ktai_style.php", 
	(strlen("$2") ? 
		"$3" 
	: mb_convert_encoding((isset(parent::$pics["$1"]) ? parent::$pics["$1"] : "〓"), $this->charset, "UTF-8")
	), "$1", (strlen("$2") ? "$3" : NULL), $this->charset)', $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = $this->horizontal_rule_to_style($buffer);
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}
?>