<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_imode class
   ================================================== */

class Ktai_Service_imode extends Ktai_Services {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	$this->operator   = 'DoCoMo';
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	$this->require_id_msg = __('ERROR: Please send your mobile phone info to post a comment.', 'ktai_style');
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => "\xf9\x95",
		'icon_biggrin.gif'   => "\xf9\xcf",
		'icon_sad.gif'       => "\xf9\x98",
		'icon_surprised.gif' => "\xf9\xaa", // impact
		'icon_eek.gif'       => "\xf9\xfc", 
		'icon_confused.gif'  => "\xf9\xd0",
		'icon_cool.gif'      => "\xf9\xf7",
		'icon_mad.gif'       => "\xf9\x96",
		'icon_razz.gif'      => "\xf9\xcd",
		'icon_neutral.gif'   => "\xf9\xca",
		'icon_wink.gif'      => "\xf9\xce",
		'icon_lol.gif'       => "\xf9\xcd",
		'icon_redface.gif'   => "\xf9\xcb",
		'icon_cry.gif'       => "\xf9\xd2",
		'icon_evil.gif'      => "\xf9\xc9",
		'icon_twisted.gif'   => "\xf9\xc9",
		'icon_rolleyes.gif'  => "\xf9\xc5",
		'icon_exclaim.gif'   => "\xf9\xa7",
		'icon_question.gif'  => "\xf9\xa8",
		'icon_idea.gif'      => "\xf9\xa0",
		'icon_arrow.gif'     => "\xf9\x5b",
		'icon_mrgreen.gif'   => "\xf9\xf8",
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://www.nttdocomo.co.jp/service/imode/make/content/pictograph/basic/
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => "\xf9\xdc", // warning (!)
		'2'   => "\xf9\xa7", // exclamation (!)
		'3'   => '?',        // question (?)
		'4'   => "\xf9\x86", // question (Q)
		'5'   => '',       // left triangle
		'6'   => '',       // right triangle
		'7'   => '',       // double left triangle
		'8'   => '',       // double right triangle
		'15'  => "\xf9\x43", // moon (3days)
		'16'  => "\xf8\xa3", // thunder
		'25'  => "\xf9\xc4", // watch
		'29'  => '',       // up arrow
		'30'  => '',       // down arrow
		'32'  => '',       // down triangle
		'33'  => '',       // up triangle
		'34'  => '',       // double down triangle
		'35'  => '',       // double up triangle
		'42'  => "\xf8\xf8", // up-left arrow
		'43'  => "\xf8\xf7", // down-right arrow
		'44'  => "\xf8\x9f", // sun
		'45'  => "\xf8\xb4", // baseball
		'46'  => "\xf9\x5e", // clock
		'48'  => "\xf9\xb8", // bell (chapel)
		'50'  => "\xf9\x55", // face (female)
		'51'  => "\xf9\x91", // heart
		'52'  => "\xf8\xd2", // bar (martini)
		'53'  => "\xf9\xe6", // four-leaf clover
		'54'  => "\xf9\xd7", // trade mark (TM)
		'55'  => '~',       // multiply (cross)
		'56'  => "\xf8\xea", // note
		'61'  => '~',       // cross
		'63'  => '',       // right arrow
		'64'  => '',       // left arrow
		'65'  => "\xf8\xd1", // magcup (tea room)
		'68'  => "\xf9\x95", // smile
		'69'  => '',       // star
		'70'  => "\xf8\xd9", // up-right arrow
		'71'  => "\xf9\x49", // down-left arrow
		'72'  => "\xf9\xc0", // jewelry
		'74'  => "\xf9\x45", // dog
		'75'  => '',       // star
		'76'  => "\xf9\x9f", // spark
		'77'  => "\xf9\xa0", // lamp
		'80'  => "\xf9\x55", // face (male)
		'81'  => "\xf9\xd6", // copyright mark (C)
		'82'  => "\xf9\xdb", // registered mark
		'83'  => "\xf8\xe3", // briefcase
		'85'  => "\xf8\xe8", // telephone (fixed)
		'86'  => "\xf8\xea", // pop up memo
		'88'  => '',       // up triangle
		'89'  => '',       // down triangle
		'94'  => "\xf8\xe2", // camera
		'95'  => "\xf8\xa1", // rain
		'96'  => "\xf8\xb7", // american football??
		'97'  => "\xf8\xe4", // book
		'98'  => "\xf9\xd4", // keep out sign
		'99'  => "\xf8\xce", // traffic signal
		'100' => "\xf8\xe4", // book
		'101' => "\xf8\xe4", // book
		'102' => "\xf8\xe4", // book
		'103' => "\xf8\xea", // document
		'104' => "\xf8\xd6", // scissors
		'105' => "\xf8\xea", // daily calender
		'106' => "\xf8\xdf", // ticket
		'107' => "\xf8\xa0", // cloud
		'108' => "\xf9\x77", // mail envelope
		'109' => "\xf9\x7a", // money
		'110' => "\xf8\xd8", // movie/video camera
		'111' => "\xf8\xd8", // handheld video camera
		'112' => "\xf8\xc4", // home
		'113' => "\xf0\x59", // flower (tulip)
		'116' => "\xf8\xf2", // glasses / eye
		'118' => "\xf9\x7e", // next item /return mark
		'119' => "\xf9\x81", // magnifier (search)
		'120' => "\xf9\x7d", // key
		'124' => "\xf8\xd5", // shoe (high-heel)
		'125' => "\xf8\xbf", // sedan (car)
		'140' => '',       // leftside finger
		'141' => '',       // rightside finger
		'143' => "\xf9\xd5", // clip
		'144' => "\xf8\xe6", // present box
		'146' => "\xf8\xd0", // knife and fork
		'149' => "\xf9\xbe", // pencil
		'151' => "\xf9\x77", // envelope
		'152' => "\xf9\xbd", // spanner
		'155' => "\xf8\xe8", // telephone (handset)
		'156' => "\xf8\xc5", // factory
		'161' => "\xf8\xe9", // mobile phone
		'168' => "\xf8\xc3", // air plane
		'169' => "\xf9\x47", // boat (ship)
		'172' => "\xf8\xbc", // electric train
		'176' => "\xf8\xe0", // smoking
		'177' => "\xf8\xe1", // no smoking
		'178' => "\xf8\xfc", // wheel chair
		'179' => '[t}[N]', // beginner driver mark
		'180' => "\xf9\x87", // one
		'181' => "\xf9\x88", // two
		'182' => "\xf9\x89", // three
		'183' => "\xf9\x8a", // four
		'184' => "\xf9\x8b", // five
		'185' => "\xf9\x8c", // six
		'186' => "\xf9\x8d", // seven
		'187' => "\xf9\x8e", // eight
		'188' => "\xf9\x8f", // nine
		'190' => "\xf8\xa4", // storm
		'191' => "\xf8\xa2", // snowball
		'192' => "\xf8\xa7", // Aries (Ram)
		'193' => "\xf8\xa8", // Taurus (Bull)
		'194' => "\xf8\xa9", // Gemini (Twins)
		'195' => "\xf8\xaa", // Cancer (Crab)
		'196' => "\xf8\xab", // Leo (Lion)
		'197' => "\xf8\xac", // Virgo (Virgin)
		'198' => "\xf8\xad", // Libra (Scales)
		'199' => "\xf8\xae", // Scorpius (Scorpion)
		'200' => "\xf8\xaf", // Sagittarius (Archer)
		'201' => "\xf8\xb0", // Capricornus (Goat)
		'202' => "\xf8\xb1", // Aquarius (Water Bearer)
		'203' => "\xf8\xb2", // Pisces (Fishes)
		'204' => '[֎g]', // Ophiuchus (Serpent Bearer)
		'205' => "\xf8\xc9", // Automatic Teller Machine
		'206' => "\xf8\xcb", // convenience store
		'207' => "\xf8\xcf", // toilet
		'208' => "\xf8\xcd", // parking
		'209' => "\xf8\xc1", // bus stop
		'210' => "\xf9\x83", // location simble (parabola antenna)
		'211' => "\xf8\xc2", // anchor (port)
		'212' => "\xf8\xc8", // bank
		'213' => "\xf8\xcc", // gas station
		'215' => "\xf9\xc2", // bicycle
		'216' => "\xf8\xc1", // bus
		'217' => "\xf8\xbe", // shinkansen (bullet train)
		'218' => "\xf9\xd8", // marathon
		'219' => "\xf8\xb7", // football (soccer)
		'220' => "\xf8\xb6", // tennis
		'221' => "\xf9\xb7", // snow board
		'222' => "\xf8\xba", // checker flag
		'223' => "\xf8\xda", // amusement park
		'224' => "\xf9\x9c", // spa
		'226' => "\xf9\x50", // movie (clapper board)
		'227' => "\xf9\x57", // night scene
		'233' => "\xf9\xba", // doller bag
		'234' => "\xf9\x48", // christmas tree
		'235' => "\xf9\xed", // cherry blossom
		'239' => "\xf9\xef", // short cake
		'244' => "\xf9\xee", // onigiri (rise ball)
		'245' => "\xf8\xd3", // hamberger (fast food)
		'251' => "\xf9\x46", // cat
		'257' => "\xf9\x95", // laugh face
		'258' => "\xf9\x96", // angry face
		'259' => "\xf9\x98", // sad face
		'260' => "\xf9\x99", // tired face
		'261' => "\xf9\xa6", // Sleepy (Zzz)
		'262' => "\xf9\xa1", // angry
		'263' => "\xf9\xd3", // tear
		'264' => "\xf9\xcd", // bleah
		'265' => "\xf9\x93", // heart break
		'266' => "\xf9\x94", // double hearts
		'268' => "\xf9\xa3", // bomb
		'273' => "\xf9\x9e", // kiss mark
		'278' => "\xf8\xa4", // flower circle
		'279' => "\xf9\xd9", // secret
		'281' => "\xf9\xa2", // punch
		'282' => "\xf9\xad", // dashing
		'287' => "\xf9\xcc", // ok hand sign
		'288' => "\xf8\xeb", // TV set
		'289' => "\xf8\xd7", // microphone (kara-oke)
		'290' => "\xf9\xb4", // wallet
		'291' => '',       // musical note
		'294' => "\xf8\xdb", // music (headphone)
		'295' => "\xf9\xb5", // rouge
		'299' => "\xf9\x7b", // free
		'300' => "\xf8\xed", // CD/DVD
		'303' => "\xf9\x9f", // updated
		'305' => "\xf8\xa5", // fog
		'306' => "\xf8\xb5", // golf
		'307' => "\xf8\xb9", // basket ball
		'309' => "\xf8\xdc", // art
		'310' => "\xf8\xdd", // performance
		'311' => "\xf8\xde", // event (circus)
		'312' => "\xf8\xe5", // ribbon
		'313' => "\xf8\xe7", // birthday
		'314' => "\xf8\xef", // spade mark (cards)
		'315' => "\xf8\xf0", // diamond mark (cards)
		'316' => "\xf8\xf1", // pam mark (cards)
		'317' => "\xf8\xf2", // eyes
		'318' => "\xf8\xf3", // ear
		'319' => "\xf8\xf5", // scissors (hands)
		'320' => "\xf8\xf6", // paper (hands)
		'321' => "\xf9\x40", // new moon
		'322' => "\xf9\x41", // eclipsed moon
		'323' => "\xf9\x42", // half moon
		'324' => "\xf9\x80", // clear button
		'325' => "\xf9\x90", // zero
		'326' => "\xf9\xb0", // ok
		'327' => "\xf9\x99", // very tired face
		'333' => "\xf9\xf1", // ramen (donburi)
		'334' => "\xf9\x82", // new
		'337' => "\xf9\xbb", // personal computer
		'339' => "\xf9\xed", // rose
		'340' => "\xf9\xb8", // church
		'341' => "\xf8\xbd", // subway
		'342' => "\xf9\xe5", // Mt.Fuji
		'343' => "\xf8\xdb", // music
		'354' => "\xf9\xbf", // crown
		'358' => "\xf9\xec", // read leaves
		'375' => "\xf8\xc6", // post office
		'376' => "\xf8\xc7", // hospital
		'377' => "\xf9\xe3", // school
		'378' => "\xf8\xca", // hotel
		'379' => "\xf8\xc2", // ship
		'380' => "\xf9\xdd", // NG / prohibited for U-18
		'381' => '[|i.]',    // anntena mark
		'382' => '[cool]',   // cool
		'383' => '[]',     // discount mark
		'384' => '[T]',     // service mark
		'385' => "\xf9\x7c", // ID mark
		'386' => "\xf9\xe0", // full mark
		'387' => "\xf9\xde", // vacant mark
		'388' => '[w]',     // reserved mark
		'389' => '[c]',     // in-business mark
		'390' => '',       // upside finger
		'391' => '',       // downside finger
		'393' => "\xf8\xe9", // manner mode
		'394' => "\xf8\xe9", // power off
		'395' => "\xf8\xea", // make a memo
		'400' => "\xf9\xf0", // tokkkuri,ochoko
		'401' => "\xf8\xd3", // beer (cheers)
		'410' => "\xf8\xd6", // hair salon
		'414' => "\xf8\xee", // heart mark (cards)
		'421' => "\xf8\xb8", // ski
		'422' => '',       // oval
		'423' => "\xf9\xc3", // green tea
		'424' => "\xf9\xf2", // bread
		'434' => "\xf9\xea", // apple
		'508' => "\xf9\x52", // edit (pen)
		'715' => "\xf9\xf6", // fish
		'728' => "\xf8\xf9", // foot print
		'729' => "\xf8\xfa", // shoe
		'803' => "\xf9\x92", // swing heart
		'804' => "\xf9\xf4", // chick
		'805' => "\xf9\xb6", // jeans
		'806' => "\xf9\xbc", // love letter
		'810' => "\xf9\xe4", // tidal wave
		'811' => "\xf9\xeb", // twin leave
		'812' => "\xf9\xf3", // snail
		'817' => "\xf8\xf4", // rock (hands)
		'818' => "\xf9\x86", // number sign (#)
		'\\d+' => '',      // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="[^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	$entities = array(
		'&spades;' => "\xf8\xef", // spade mark
		'&#9824;'  => "\xf8\xef", // spade mark
		'&clubs;'  => "\xf8\xf1", // pam mark
		'&#9827;'  => "\xf8\xf1", // pam mark
		'&hearts;' => "\xf8\xee", // heart
		'&#9829;'  => "\xf8\xee", // heart
		'&#9825;'  => "\xf9\x91", // white heart
		'&diams;'  => "\xf8\xf0", // diamond mark
		'&#9830;'  => "\xf8\xf0", // diamond mark
	);
	$buffer = str_replace(array_keys($entities), $entities, $buffer);
	return parent::convert_char($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<img src="([^>]*?)\.png"!', '<img src="\\1.gif"', $buffer);
	$buffer = preg_replace('!<(b|i|u|em|strong)>(.*?)</\\1>!', '$2', $buffer);
	return parent::shrink_pre_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode_mova class
   ================================================== */

class Ktai_Service_imode_mova extends Ktai_Service_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_mova');
	$this->type       = 'mova';
	$this->flat_rate  = FALSE;
	preg_match('!1\.0/([-_.a-zA-Z0-9]+)(/c(\d+)(/\w+)*?(/ser(\w+))?)?!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[6];
	$this->page_size  = 5000;
	$this->cache_size = ($specs[3] > 0) ? intval($specs[3]) * 1024 : 5120;
	$this->preamble   = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = str_replace('&nbsp;', ' ', $buffer);
	$buffer = preg_replace('!\s*</(li|dt|dd|option)>\s*!', '', $buffer);
	$buffer = preg_replace('! ?/ ?>!', '>', $buffer);
	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>!', '<$1>', $buffer); //"
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_imode_FOMA class
   ================================================== */

class Ktai_Service_imode_FOMA extends Ktai_Service_imode {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->theme      = ks_option('ks_theme_foma');
	$this->type       = 'FOMA';
	$this->flat_rate  = TRUE;
	preg_match('!2\.\d ([-_.a-zA-Z0-9]+)\(c(\d+)(;\w+)*?(;ser(\w+);icc(\w+))?\)!', $user_agent, $specs);
	$this->term_name  = $specs[1];
	$this->term_ID    = @$specs[5];
	$this->sub_ID     = @$specs[6];; // use SIM ID for user ID
	$this->page_size  = 10000;
	$this->cache_size = ($specs[2] > 0) ? intval($specs[2]) * 1024 : 102400;
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//i-mode group (ja)//DTD XHTML i-XHTML(Locale/Ver.=ja/1.0) 1.0//EN" "i-xhtml_4ja_10.dtd">';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = str_replace('&nbsp;', ' ', $buffer);
	if ($this->mime_type == 'application/xhtml+xml') {
		$buffer = preg_replace('|<blink>(.*?)</blink>|', '<span style="text-decoration:blink;">$1</span>', $buffer);
	}
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}
?>
