<?php
/* ==================================================
 *   comments-post.php
 *   based on wp-comments-post.php of WP 2.2.3
   ================================================== */
   
if ($_SERVER["REQUEST_METHOD"] != "POST") {
    header('Allow: POST');
	header("HTTP/1.1 405 Method Not Allowed");
	header("Content-type: text/plain");
    exit;
}

require dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';

nocache_headers();

$comment_post_ID = (int) $_POST['comment_post_ID'];

$status = $wpdb->get_row("SELECT post_status, comment_status FROM $wpdb->posts WHERE ID = $comment_post_ID");

if ( empty($status->comment_status) ) {
	do_action('comment_id_not_found', $comment_post_ID);
	Ktai_Style::ks_die(__('No target for your post.', 'ktai_style'));
	exit;
} elseif ( 'closed' ==  $status->comment_status ) {
	do_action('comment_closed', $comment_post_ID);
	Ktai_Style::ks_die(__('Sorry, comments are closed for this item.'));
} elseif ( 'draft' == $status->post_status ) {
	do_action('comment_on_draft', $comment_post_ID);
	Ktai_Style::ks_die(__('No target for your post.', 'ktai_style'));
	exit;
}

$charset = Ktai_Style::detect_encoding(@$_POST['charset_detect']);
$comment_author       = trim(strip_tags(mb_convert_encoding($_POST['author'], get_bloginfo('charset'), $charset)));
$comment_author_email = trim($_POST['email']);
$comment_author_url   = trim($_POST['url']);
$comment_content      = trim(mb_convert_encoding($_POST['comment'], get_bloginfo('charset'), $charset));

// If the user is logged in
$user = wp_get_current_user();
if ( $user->ID ) {
	$comment_author       = $wpdb->escape($user->display_name);
	$comment_author_email = $wpdb->escape($user->user_email);
	$comment_author_url   = $wpdb->escape($user->user_url);
	if ( current_user_can('unfiltered_html') ) {
		if ( wp_create_nonce('unfiltered-html-comment_' . $comment_post_ID) != $_POST['_wp_unfiltered_html_comment'] ) {
			kses_remove_filters(); // start with a clean slate
			kses_init_filters(); // set up the filters
		}
	}
} else {
	if ( get_option('comment_registration') )
		Ktai_Style::ks_die( __('Sorry, you must be logged in to post a comment.') );
}

$comment_type = '';

if (! $user->ID && ks_option('ks_require_term_id') && is_ktai() != 'Unknown' && is_ktai() != 'WILLCOM') {
	global $Ktai_Style;
	if (! $Ktai_Style->get('term_ID') && ! $Ktai_Style->get('sub_ID')) {
		$message = $Ktai_Style->get('require_id_msg');
		if (empty($message)) {
			$message = __('Error: please configure to send your terminal ID (serial number, EZ number etc).', 'ktai_style');
		}
		_comment_form($message);
	}
}

if (get_option('require_name_email') && ! $user->ID) {
	if ( 6 > strlen($comment_author_email) || '' == $comment_author )
		_comment_form(__('Error: please fill the required fields (name, email).'));
	elseif (! is_email($comment_author_email))
		_comment_form(__('Error: please enter a valid email address.'));
}

if ( '' == $comment_content )
	_comment_form(__('Error: please type a comment.'));

$commentdata = compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_type', 'user_ID');

$comment_id = wp_new_comment($commentdata);

$comment = get_comment($comment_id);

$location = ( empty($_POST['redirect_to']) ? get_permalink($comment_post_ID) : $_POST['redirect_to'] );
$location = apply_filters('comment_post_redirect', $location, $comment);

if ( $user->ID && file_exists(dirname(__FILE__) . '/' . KS_ADMIN_DIR)) {
	require_once dirname(__FILE__) . '/' . KS_ADMIN_DIR . '/class.php';
	$admin = new Ktai_Style_Admin;
	$sid = $admin->get_sid();
	if ($sid) {
		$admin->unset_session($sid);
		$admin->unset_prev_session($sid);
		do_action('wp_logout');
	}
}

wp_redirect($location);
exit;

/* ==================================================
 * @param   string  $message
 * @return	none
 */
function _comment_form($message) {
	if (! isset($_POST['inline'])) {
		Ktai_Style::ks_die($message);
		exit();
	}
	global $Ktai_Style, $ks_commentdata, $withcomments, $comment_post_ID, $comment_author, $comment_author_email, $comment_author_url, $comment_content;
	$ks_commentdata['author']  = $comment_author;
	$ks_commentdata['email']   = $comment_author_email;
	$ks_commentdata['url']     = $comment_author_url;
	$ks_commentdata['content'] = $comment_content;
	$ks_commentdata['message'] = $message;
	unset($_POST['author']);
	unset($_POST['email']);
	unset($_POST['url']);
	unset($_POST['comment']);
	$_POST['view'] = 'co_post'; // force ks_is_comment_post() to true
	wp("p=$comment_post_ID");
	$withcomments = TRUE;
	$Ktai_Style->output();
	exit;
}
?>