<?php
/* ==================================================
 *   Redirect to external sites
   ================================================== */

if (defined('ABSPATH')) {
	require_once ABSPATH . 'wp-config.php';
} else {
	require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';
}
nocache_headers();

if (! isset($Ktai_Style) || ! $Ktai_Style->is_mobile()) {
	wp_redirect(get_bloginfo('url'));
	exit();
}

$Page = new Ktai_Style_Redir;
exit();

/* ==================================================
 *   Ktai_Style_Redir class
   ================================================== */

class Ktai_Style_Redir {

// ==================================================
public function __construct() {
	if (isset($_GET['url']) && ! empty($_GET['url'])) {
		$url = clean_url($_GET['url']);
		if ($url) {
			$this->redirect($url);
			exit();
		}
	}
	wp_redirect(get_bloginfo('url'));
}

// ==================================================
private function redirect($url) {
	global $Ktai_Style;
	$charset = $Ktai_Style->ktai->get('charset');
	$title = mb_convert_encoding(__('Confirm connecting to external sites', 'ktai_style'), $charset, get_bloginfo('charset'));;
	$html = __('You are about to visit a website for PC:', 'ktai_style') . "<br />\n" . '<a href="' . attribute_escape($url) . '">' . wp_specialchars($url) . "</a></p>\n<p>" . __('If you are sure, follow above link. If not, go to the previous page with browser\'s back button.', 'ktai_style') . '</p>';
	Ktai_Style::ks_die($html, $title, FALSE);
}

// ===== End of class ====================
}
?>