<?php

/* ==================================================
 * @param	string  $name
 * @return	mix     $value
 */
function ks_option($name) {
	return Ktai_Style_PrefPane::get_option($name);
}

/* ==================================================
 *   Ktai_Style_PrefPane class
   ================================================== */

class Ktai_Style_PrefPane {
	private $nonce = -1;

/* ==================================================
 * @param	string  $name
 * @return	mix     $value
 */
public function get_option($name, $return_default = FALSE) {
	if (! $return_default) {
		$value = get_option($name);
		if ($value) {
			return $value;
		}
		if ($name == 'ks_separate_comments') {
			return get_option('ks_separate_recent_comments');
		}
	}
	// default values 
	switch ($name) {
	case 'ks_date_color':
		return '#00aa33';
	case 'ks_author_color':
		return '#808080';
	case 'ks_comment_type_color':
		return '#808080';
	case 'ks_external_link_color':
		return '#660099';
	case 'ks_year_format':
		return 'Y-m-d';
	case 'ks_month_date_format':
		return 'n/j';
	case 'ks_time_format':
		return 'H:i';
	default:
		return NULL;
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function add_page() {
	add_options_page('Ktai Style Configuration', __('Mobile Output', 'ktai_style'), 'manage_options', basename(__FILE__), array($this, 'option_page'));
	if ( !function_exists('wp_nonce_field') ) {
		$this->nonce = -1;
	} else {
		$this->nonce = 'ktai-style-config';
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function option_page() {
	global $Ktai_Style;

	if (isset($_POST['update_option'])) {
		check_admin_referer($this->nonce);
		$this->upate_options();
	}
	if ($this->get_option('ks_title_only')) {
		$title_only[0] = '';
		$title_only[1] = ' checked="checked"';
	} else {
		$title_only[0] = ' checked="checked"';
		$title_only[1] = '';
	}
	if ($this->get_option('ks_separate_comments')) {
		$separate_comments[0] = '';
		$separate_comments[1] = ' checked="checked"';
	} else {
		$separate_comments[0] = ' checked="checked"';
		$separate_comments[1] = '';
	}
	if ($this->get_option('ks_external_link')) {
		$external_link[0] = '';
		$external_link[1] = ' checked="checked"';
	} else {
		$external_link[0] = ' checked="checked"';
		$external_link[1] = '';
	}
	$treat_as_internal   = $this->get_option('ks_treat_as_internal');
	$date_color          = $this->get_option('ks_date_color');
	$author_color        = $this->get_option('ks_author_color');
	$comment_type_color  = $this->get_option('ks_comment_type_color');
	$external_link_color = $this->get_option('ks_external_link_color');
	$year_format         = $this->get_option('ks_year_format');
	$month_date_format   = $this->get_option('ks_month_date_format');
	$time_format         = $this->get_option('ks_time_format');
?>
<div class="wrap">
<h2><?php _e('Ktai Style Options', 'ktai_style'); ?></h2>
<p><?php _e('Note: To revert values to default, just empty of the field.', 'ktai_style'); ?></p>
<form method="post">
<?php $this->make_nonce_field($this->nonce); ?>
<div class="submit">
<input type="hidden" name="action" value="update" />
<input type="submit" name="update_option" value="<?php _e('Update Options &raquo;'); ?> &raquo;" />
</div>
<fieldset name="design" class="options">
<legend><?php _e('Design', 'ktai_style'); ?></legend>
<dl>
<dt><label for="title_only"><?php _e('Front Page, Search Results', 'ktai_style'); ?></label></dt>
  <dd>
    <label><input type="radio" name="title_only" id="title_only" value="1"<?php echo $title_only[0]; ?> /> <?php _e('Display the content of the first post.', 'ktai_style'); ?></label>
    <label><input type="radio" name="title_only" id="title_only" value="2"<?php echo $title_only[1]; ?> /> <?php _e('Title only for all posts.', 'ktai_style'); ?></label>
  </dd>
<dt><label for="separate_comments"><?php _e('Comments and Trackbacks/Pingbacks', 'ktai_style'); ?></label></dt> 
  <dd>
    <label><input type="radio" name="separate_comments" id="separate_comments" value="1"<?php echo $separate_comments[0]; ?> /> <?php _e('Mix them at each posts and/or recent comments.', 'ktai_style'); ?></label><br />
    <label><input type="radio" name="separate_comments" id="separate_comments" value="2"<?php echo $separate_comments[1]; ?> /> <?php _e('Separate comments and trackbacks/pingbacks.', 'ktai_style'); ?></label>
  </dd>
<dt><label for="external_link"><?php _e('Hyperlinks for external websites', 'ktai_style'); ?></label></dt> 
  <dd>
    <label><input type="radio" name="external_link" id="external_link" value="1"<?php echo $external_link[0]; ?> /> <?php _e('Delete', 'ktai_style'); ?></label><br />
    <label><input type="radio" name="external_link" id="external_link" value="2"<?php echo $external_link[1]; ?> /> <?php _e('Convert links to view with full browsers (FOMA, au) / Convert links through a relay page (SoftBank 3G) / Leave (WILLCOM, Other) / Delete (move, SoftBank PDC)', 'ktai_style'); ?></label>
  </dd>
  <dd>
    <label for="treat_as_internal"><?php _e('Leave links for below websites (space separated)', 'ktai_style'); ?></label><br />
    <textarea name="treat_as_internal" id="treat_as_internal" cols="80%" rows="1"><?php echo $treat_as_internal; ?></textarea>
  </dd>
</dl>
</fieldset>
<fieldset name="colors" class="options">
<legend><?php _e('Text Color', 'ktai_style'); ?></legend>
<dl>
<dt><label for="date_color"><?php _e('Date/time after post titles', 'ktai_style'); ?></label></dt>
<dd><input type="text" value="<?php echo $date_color ?>" name="date_color" id="date_color" /> (<?php _e('#rrggbb as hex format', 'ktai_style'); ?>)</dd>
<dt><label for="author_color"><?php _e('Author, Date with a post content', 'ktai_style'); ?></label></dt>
<dd><input type="text" value="<?php echo $author_color ?>" name="author_color" id="author_color" /> (<?php _e('#rrggbb as hex format', 'ktai_style'); ?>)</dd>
<dt><label for="comment_type_color"><?php _e('Comment types (comment/trackback/pingback)', 'ktai_style'); ?></label></dt>
<dd><input type="text" value="<?php echo $comment_type_color ?>" name="comment_type_color" id="comment_type_color" /> (<?php _e('#rrggbb as hex format', 'ktai_style'); ?>)</dd>
<dt><label for="external_link_color"><?php _e('Hyperlinks for external websites (Available when \'Convert links to view with full browsers\' is enabled.)', 'ktai_style'); ?></label></dt>
<dd><input type="text" value="<?php echo $external_link_color ?>" name="external_link_color" id="external_link_color" /> (<?php _e('#rrggbb as hex format', 'ktai_style'); ?>)</dd>
</dl>
<p><?php _e('Note: To configure background color/normal text color/hyperlink color/visited link color, edit &lt;body&gt; element at templates/header.php', 'ktai_style'); ?> <a href="templates.php?file=<?php echo str_replace('%2F', '/', $Ktai_Style->get('plugin_dir') . '/templates/header.php'); ?>"><?php _e('&raquo; Edit', 'ktai_style'); ?></a></p>
</fieldset>
<fieldset name="date_format" class="options">
<legend><?php _e('Date format of posts/comments', 'ktai_style'); ?></legend>
<dl>
<dt><label for="year_format"><?php _e('In case of displaying year, month, date (for last year and before)', 'ktai_style'); ?></label></dt>
<dd><input type="text" value="<?php echo $year_format ?>" name="year_format" id="year_format" /></dd>
<dt><label for="month_date_format"><?php _e('In case of displaying month, date only (for this year)', 'ktai_style'); ?></label></dt>
<dd><input type="text" value="<?php echo $month_date_format ?>" name="month_date_format" id="month_date_format" /></dd>
<dt><label for="time_format"><?php _e('Time', 'ktai_style'); ?></label></dt>
<dd><input type="text" value="<?php echo $time_format ?>" name="time_format" id="time_format" /></dd>
</dl>
<p><?php _e('Note: About date format, refer to <a href="http://codex.wordpress.org/Formatting_Date_and_Time">Codex</a> or <a href="http://www.php.net/date">date() function manual</a> of PHP.', 'ktai_style'); ?></p>
</fieldset>
<div class="submit">
<input type="hidden" name="action" value="update" />
<input type="submit" name="update_option" value="<?php _e('Update Options &raquo;'); ?> &raquo;" />
</div>
</form>
</div>
<?php
} 

/* ==================================================
 * @param	mix   $action
 * @return	none
 */
private function make_nonce_field($action = -1) {
	if ( !function_exists('wp_nonce_field') ) {
		return;
	} else {
		return wp_nonce_field($action);
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
private function upate_options() {
	if (! empty($_POST['title_only'])) {
		if (is_numeric($_POST['title_only'])) {
			update_option('ks_title_only', ($_POST['title_only'] == 2));
		}
	} else {
		delete_option('ks_title_only');
	}

	if (! empty($_POST['separate_comments'])) {
		if (is_numeric($_POST['separate_comments'])) {
			update_option('ks_separate_comments', ($_POST['separate_comments'] == 2));
		}
		if (get_option('ks_separate_recent_comments')) {
			delete_option('ks_separate_recent_comments');
		}
	} else {
		delete_option('ks_separate_comments');
		delete_option('ks_separate_recent_comments');
	}

	if (! empty($_POST['external_link'])) {
		if (is_numeric($_POST['external_link'])) {
			update_option('ks_external_link', ($_POST['external_link'] == 2));
		}
	} else {
		delete_option('ks_external_link');
	}

	if (! empty($_POST['treat_as_internal'])) {
		$sites = preg_split('/\\s+/', $_POST['treat_as_internal'], -1, PREG_SPLIT_NO_EMPTY);
		$sites = array_map('clean_url', $sites);
		$sites = preg_replace('#/$#', '', $sites);
		$sites_join = implode(' ', $sites);
		if (! preg_match('/^\\s*$/', $sites_join)) {
			update_option('ks_treat_as_internal', $sites_join);
		} else {
			delete_option('ks_treat_as_internal');
		}
	} else {
		delete_option('ks_treat_as_internal');
	}

	if (! empty($_POST['author_color'])) {
		if (preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['author_color'])) {
			update_option('ks_author_color', $_POST['author_color']);
		}
	} else {
		delete_option('ks_author_color');
	}

	if (! empty($_POST['date_color'])) {
		if (preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['date_color'])) {
			update_option('ks_date_color', $_POST['date_color']);
		}
	} else {
		delete_option('ks_date_color');
	}

	if (! empty($_POST['comment_type_color'])) {
		if (preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['comment_type_color'])) {
			update_option('ks_comment_type_color', $_POST['comment_type_color']);
		}
	} else {
		delete_option('ks_comment_type_color');
	}

	if (! empty($_POST['external_link_color'])) {
		if (preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['external_link_color'])) {
			update_option('ks_external_link_color', $_POST['external_link_color']);
		}
	} else {
		delete_option('ks_external_link_color');
	}

	if (! empty($_POST['year_format'])) {
		if (preg_match('/[Yyo]/', $_POST['year_format']) && preg_match('/[mnMF]/', $_POST['year_format']) && preg_match('/[djz]/', $_POST['year_format'])) {
			update_option('ks_year_format', $_POST['year_format']);
		}
	} else {
		delete_option('ks_year_format');
	}

	if (! empty($_POST['month_date_format'])) {
		if (preg_match('/[mnMF]/', $_POST['month_date_format']) && preg_match('/[djz]/', $_POST['month_date_format'])) {
			update_option('ks_month_date_format', $_POST['month_date_format']);
		}
	} else {
		delete_option('ks_month_date_format');
	}

	if (! empty($_POST['time_format'])) {
		if (preg_match('/[BgGhH]/', $_POST['time_format'])) {
			update_option('ks_time_format', $_POST['time_format']);
		}
	} else {
		delete_option('ks_time_format');
	}
?>
<div class="updated fade"><p><strong><?php _e('Options saved.'); ?></strong></p></div>
<?php
	return;
}

// ===== End of class ====================
}
?>