<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_WILLCOM class
   ================================================== */

class Ktai_Service_WILLCOM extends Ktai_Services {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->operator   = 'WILLCOM';
	$this->type       = 'AIR-EDGE';
	$this->user_agent = $user_agent;
	preg_match('!\((DDIPOCKET|WILLCOM);[^/]+/([^/]+)/[^/]+/[\d.]+/[cC](\d+)\)!', $user_agent, $specs);
	$this->term_name  = $specs[2];
	$this->page_size  = 20000;
	$this->cache_size = $specs[3] ? $specs[3] * 1024 : 32768;
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	// use default preamble
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '&#63893;',
		'icon_biggrin.gif'   => '&#xE72A;',
		'icon_sad.gif'       => '&#63896;',
		'icon_surprised.gif' => '&#63914;', // impact
		'icon_eek.gif'       => '&#xE757;', 
		'icon_confused.gif'  => '&#xE72B;',
		'icon_cool.gif'      => '&#xE752;',
		'icon_mad.gif'       => '&#63894;',
		'icon_razz.gif'      => '&#xE728;',
		'icon_neutral.gif'   => '&#xE725;',
		'icon_wink.gif'      => '&#xE729;',
		'icon_lol.gif'       => '&#xE728;',
		'icon_redface.gif'   => '&#xE726;',
		'icon_cry.gif'       => '&#xE72D;',
		'icon_evil.gif'      => '&#xE724;',
		'icon_twisted.gif'   => '&#xE724;',
		'icon_rolleyes.gif'  => '&#xE720;',
		'icon_exclaim.gif'   => '&#63911;',
		'icon_question.gif'  => '&#63912;',
		'icon_idea.gif'      => '&#63904;',
		'icon_arrow.gif'     => '&#63835;',
		'icon_mrgreen.gif'   => '&#61574;',
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://www.willcom-inc.com/ja/service/contents_service/club_air_edge/for_phone/homepage/
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '&#61622;', // warning (!)
		'2'   => '&#61599;', // exclamation (!)
		'3'   => '&#61601;', // question (?)
		'4'   => 'Q',        // question (Q)
		'5'   => '',       // left triangle
		'6'   => '',       // right triangle
		'7'   => '&#61618;', // double left triangle
		'8'   => '&#61619;', // double right triangle
		'15'  => '&#61544;', // moon (3days)
		'16'  => '&#61533;', // thunder
		'25'  => '&#xE71F;', // watch
		'29'  => '',       // up arrow
		'30'  => '',       // down arrow
		'32'  => '',       // down triangle
		'33'  => '',       // up triangle
		'34'  => '',       // double down triangle
		'35'  => '',       // double up triangle
		'42'  => '&#63736;', // up-left arrow
		'43'  => '&#63735;', // down-right arrow
		'44'  => '&#61512;', // sun
		'45'  => '&#61531;', // baseball
		'46'  => '&#61505;', // clock
		'48'  => '&#xE713;', // bell (chapel)
		'50'  => '&#61516;', // face (female)
		'51'  => '&#61504;', // heart
		'52'  => '&#61527;', // bar (martini)
		'53'  => '&#xE741;', // four-leaf clover
		'54'  => '&#xE732;', // trade mark (TM)
		'55'  => '~',       // multiply (cross)
		'56'  => '&#61536;', // note
		'61'  => '&#61626;', // cross
		'63'  => '',       // right arrow
		'64'  => '',       // left arrow
		'65'  => '&#61559;', // magcup (tea room)
		'68'  => '&#61516;', // smile
		'69'  => '&#61590;', // star
		'70'  => '&#63705;', // up-right arrow
		'71'  => '&#63817;', // down-left arrow
		'72'  => '&#xE71B;', // jewelry
		'74'  => '&#61549;', // dog
		'75'  => '&#61590;', // star
		'76'  => '&#63903;', // spark
		'77'  => '&#61593;', // lamp
		'80'  => '&#61516;', // face (male)
		'81'  => '&#61627;', // copyright mark
		'82'  => '&#61628;', // registered mark
		'83'  => '&#61563;', // briefcase
		'85'  => '&#61506;', // telephone (fixed)
		'86'  => '&#63722;', // pop up memo
		'88'  => '',       // up triangle
		'89'  => '',       // down triangle
		'94'  => '&#63714;', // camera
		'95'  => '&#61513;', // rain
		'96'  => '&#63671;', // american football??
		'97'  => '&#61536;', // book
		'98'  => '&#xE72F;', // keep out sign
		'99'  => '&#63694;', // traffic signal
		'100' => '&#61536;', // book
		'101' => '&#61536;', // book
		'102' => '&#61536;', // book
		'103' => '&#61536;', // document
		'104' => '&#61571;', // scissors
		'105' => '&#63722;', // daily calender
		'106' => '&#61591;', // ticket
		'107' => '&#61514;', // cloud
		'108' => '&#61539;', // mail envelope
		'109' => '&#61585;', // money
		'110' => '&#61597;', // movie/video camera
		'111' => '&#61597;', // handheld video camera
		'112' => '&#61523;', // home
		'113' => '&#xE743;', // flower (tulip)
		'116' => '&#63730;', // glasses / eye
		'118' => '&#63870;', // next item /return mark
		'119' => '&#63873;', // magnifier (search)
		'120' => '&#63869;', // key
		'124' => '&#63701;', // shoe (high-heel)
		'125' => '&#61519;', // sedan (car)
		'140' => '',       // leftside finger
		'141' => '',       // rightside finger
		'143' => '&#61580;', // clip
		'144' => '&#61584;', // present box
		'146' => '&#61526;', // knife and fork
		'149' => '&#61537;', // pen
		'151' => '&#61539;', // envelope
		'152' => '&#xE718;', // spanner
		'155' => '&#61506;', // telephone (handset)
		'156' => '&#61524;', // factory
		'161' => '&#61589;', // mobile phone
		'168' => '&#61521;', // air plane
		'169' => '&#61522;', // boat (ship)
		'172' => '&#61520;', // electric train
		'176' => '&#61560;', // smoking
		'177' => '&#61540;', // no smoking
		'178' => '&#63740;', // wheel chair
		'179' => '&#61617;', // beginner driver mark
		'180' => '&#61631;', // one
		'181' => '&#61632;', // two
		'182' => '&#61633;', // three
		'183' => '&#61634;', // four
		'184' => '&#61635;', // five
		'185' => '&#61636;', // six
		'186' => '&#61637;', // seven
		'187' => '&#61638;', // eight
		'188' => '&#61639;', // nine
		'190' => '&#61608;', // storm
		'191' => '&#61581;', // snowball
		'192' => '&#61640;', // Aries (Ram)
		'193' => '&#61641;', // Taurus (Bull)
		'194' => '&#61642;', // Gemini (Twins)
		'195' => '&#61643;', // Cancer (Crab)
		'196' => '&#61644;', // Leo (Lion)
		'197' => '&#61645;', // Virgo (Virgin)
		'198' => '&#61646;', // Libra (Scales)
		'199' => '&#61647;', // Scorpius (Scorpion)
		'200' => '&#61648;', // Sagittarius (Archer)
		'201' => '&#61649;', // Capricornus (Goat)
		'202' => '&#61650;', // Aquarius (Water Bearer)
		'203' => '&#61651;', // Pisces (Fishes)
		'204' => '&#61652;', // Ophiuchus (Serpent Bearer)
		'205' => '&#63689;', // Automatic Teller Machine
		'206' => '&#63691;', // convenience store
		'207' => '&#63695;', // toilet
		'208' => '&#63693;', // parking
		'209' => '&#63681;', // bus stop
		'210' => '&#63875;', // location simble (parabola antenna)
		'211' => '&#61573;', // anchor (port)
		'212' => '&#63688;', // bank
		'213' => '&#63692;', // gas station
		'215' => '&#xE71D;', // bicycle
		'216' => '&#61615;', // bus
		'217' => '&#63678;', // shinkansen (bullet train)
		'218' => '&#xE733;', // marathon
		'219' => '&#61616;', // football (soccer)
		'220' => '&#61596;', // tennis
		'221' => '&#xE712;', // snow board
		'222' => '&#63674;', // checker flag
		'223' => '&#63706;', // amusement park
		'224' => '&#61543;', // spa
		'226' => '&#63824;', // movie (clapper board)
		'227' => '&#63831;', // night scene
		'233' => '&#61585;', // doller bag
		'234' => '&#63816;', // christmas tree
		'235' => '&#xE748;', // cherry blossom
		'239' => '&#xE74A;', // short cake
		'244' => '&#61562;', // onigiri (rise ball)
		'245' => '&#63699;', // hamberger (fast food)
		'251' => '&#61550;', // cat
		'257' => '&#61516;', // laugh face
		'258' => '&#61534;', // angry face
		'259' => '&#61528;', // sad face
		'260' => '&#61558;', // tired face
		'261' => '&#63910;', // Sleepy (Zzz)
		'262' => '&#61556;', // angry
		'263' => '&#61515;', // tear
		'264' => '&#xE728;', // bleah
		'265' => '&#61576;', // heart break
		'266' => '&#61592;', // double hearts
		'268' => '&#63907;', // bomb
		'273' => '&#61517;', // kiss mark
		'278' => '&#63652;', // flower circle
		'279' => '&#xE734;', // secret
		'281' => '&#63906;', // punch
		'282' => '&#63917;', // dashing
		'287' => '&#xE727;', // ok hand sign
		'288' => '&#63723;', // TV set
		'289' => '&#61555;', // microphone (kara-oke)
		'290' => '&#xE70F;', // wallet
		'291' => '', // musical note
		'294' => '&#63707;', // music
		'295' => '&#xE710;', // rouge
		'299' => '&#63867;', // free
		'300' => '&#63725;', // CD/DVD
		'303' => '&#63903;', // updated
		'305' => '&#63653;', // fog
		'306' => '&#63669;', // golf
		'307' => '&#63673;', // basket ball
		'309' => '&#63708;', // art
		'310' => '&#63709;', // performance
		'311' => '&#63710;', // event (circus)
		'312' => '&#63717;', // ribbon
		'313' => '&#61582;', // birthday
		'314' => '&#61579;', // spade mark (cards)
		'315' => '&#61577;', // diamond mark (cards)
		'316' => '&#61578;', // pam mark (cards)
		'317' => '&#63730;', // eyes
		'318' => '&#63731;', // ear
		'319' => '&#61525;', // scissors (hands)
		'320' => '&#61575;', // paper (hands)
		'321' => '&#63808;', // new moon
		'322' => '&#63809;', // eclipsed moon
		'323' => '&#63810;', // half moon
		'324' => '&#63872;', // clear button
		'325' => '&#61630;', // zero
		'326' => '&#63920;', // ok
		'327' => '&#61558;', // very tired face
		'333' => '&#61554;', // ramen (donburi)
		'334' => '&#63874;', // new
		'337' => '&#xE716;', // personal computer
		'339' => '&#xE748;', // rose
		'340' => '&#xE713;', // church
		'341' => '&#63677;', // subway
		'342' => '&#61612;', // Mt.Fuji
		'343' => '&#61518;', // music
		'354' => '&#xE71A;', // crown
		'358' => '&#xE747;', // read leaves
		'375' => '&#63686;', // post office
		'376' => '&#63687;', // hospital
		'377' => '&#xE73E;', // school
		'378' => '&#63690;', // hotel
		'379' => '&#61522;', // ship
		'380' => '&#61621;', // NG / prohibited for U-18
		'381' => '&#61624;', // anntena mark
		'382' => '[cool]',   // cool
		'383' => '[]',     // discount mark
		'384' => '[T]',     // service mark
		'385' => '&#63868;', // ID mark
		'386' => '&#xE73B;', // full mark
		'387' => '&#xE739;', // vacant mark
		'388' => '[w]',     // reserved mark
		'389' => '[c]',     // in-business mark
		'390' => '',       // upside finger
		'391' => '',       // downside finger
		'393' => '&#63721;', // manner mode
		'394' => '&#63721;', // power off
		'395' => '&#63722;', // make a memo
		'400' => '&#xE74B;', // tokkkuri,ochoko
		'401' => '&#61535;', // beer (cheers)
		'410' => '&#61571;', // hair salon
		'414' => '&#61504;', // heart mark (cards)
		'421' => '&#61598;', // ski
		'422' => '',       // oval
		'423' => '&#xE71E;', // green tea
		'424' => '&#xE74D;', // bread
		'434' => '&#61583;', // apple
		'715' => '&#xE751;', // fish
		'728' => '&#61594;', // foot print
		'729' => '&#63738;', // shoe
		'803' => '&#63890;', // swing heart
		'804' => '&#xE74F;', // chick
		'805' => '&#xE711;', // jeans
		'806' => '&#xE717;', // love letter
		'810' => '&#xE73F;', // tidal wave
		'811' => '&#xE746;', // twin leave
		'812' => '&#xE74E;', // snail
		'817' => '&#61532;', // rock (hands)
		'\\d+' => '',      // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="[^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

// ===== End of class ====================
}
?>
